/* rygel-media-object.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libxml/tree.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
typedef struct _RygelMediaObjectGetWritablesData RygelMediaObjectGetWritablesData;

#define TYPE_SERIALIZER_TYPE (serializer_type_get_type ())

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaObjectApplyFragmentsData RygelMediaObjectApplyFragmentsData;
typedef struct _RygelMediaObjectCheckWritableData RygelMediaObjectCheckWritableData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaObjectPrivate {
	gchar* _id;
	gchar* _ref_id;
	gchar* _upnp_class;
	guint64 _modified;
	guint _object_update_id;
	RygelMediaContainer* _parent_ref;
	gchar* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _uri_size;
	gint _uri_index;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	gchar* uri;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* file;
	GFile* _tmp13_;
	GCancellable* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GError * _inner_error_;
};

struct _RygelMediaObjectGetWritablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* writables;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _uri_size;
	gint _uri_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	gchar* uri;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* file;
	GFile* _tmp14_;
	GCancellable* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GeeArrayList* _tmp18_;
	GFile* _tmp19_;
	GError * _inner_error_;
};

typedef enum  {
	SERIALIZER_TYPE_GENERIC_DIDL,
	SERIALIZER_TYPE_DIDL_S,
	SERIALIZER_TYPE_M3UEXT
} SerializerType;

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaObjectApplyFragmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GeeLinkedList* current_fragments;
	GeeLinkedList* new_fragments;
	RygelHTTPServer* http_server;
	GUPnPDIDLLiteFragmentResult result;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelSerializer* _tmp0_;
	RygelSerializer* writer;
	RygelSerializer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	GUPnPDIDLLiteObject* didl_object;
	GUPnPDIDLLiteObject* _tmp4_;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_;
	GUPnPDIDLLiteObject* _tmp7_;
	void* _tmp8_;
	void* _tmp9_;
	GUPnPDIDLLiteObject* _tmp10_;
	GeeLinkedList* _tmp11_;
	gint _tmp12_;
	gpointer* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GeeLinkedList* _tmp15_;
	gint _tmp16_;
	gpointer* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GUPnPDIDLLiteFragmentResult _tmp19_;
	GUPnPDIDLLiteFragmentResult _tmp20_;
	GUPnPDIDLLiteObject* _tmp21_;
	GError* e;
	GError * _inner_error_;
};

struct _RygelMediaObjectCheckWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_;
	GFile* _tmp7_;
	GCancellable* _tmp8_;
	GFileInfo* _tmp9_;
	GFileInfo* info;
	GFileInfo* _tmp10_;
	gboolean _tmp11_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer rygel_media_object_parent_class = NULL;
static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectPrivate))
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY,
	RYGEL_MEDIA_OBJECT_ID,
	RYGEL_MEDIA_OBJECT_REF_ID,
	RYGEL_MEDIA_OBJECT_UPNP_CLASS,
	RYGEL_MEDIA_OBJECT_MODIFIED,
	RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_OBJECT_PARENT,
	RYGEL_MEDIA_OBJECT_PARENT_REF,
	RYGEL_MEDIA_OBJECT_TITLE,
	RYGEL_MEDIA_OBJECT_OCM_FLAGS,
	RYGEL_MEDIA_OBJECT_RESTRICTED
};
static void rygel_media_object_real_constructed (GObject* base);
static void rygel_media_object_get_writable_data_free (gpointer _data);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_);
static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_object_get_writables_data_free (gpointer _data);
void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_);
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
static void rygel_media_object_clean_node (RygelMediaObject* self, xmlNode* node, xmlNs* ns);
static void rygel_media_object_apply_fragments_data_free (gpointer _data);
void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_);
static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_);
GType serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (SerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, SerializerType type);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
void rygel_updatable_object_commit (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_updatable_object_commit_finish (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_apply_fragments_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
static GUPnPDIDLLiteResource* rygel_media_object_real_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
static void rygel_media_object_check_writable_data_free (gpointer _data);
static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_);
#define RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME "rygel-writable://"
static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
void rygel_media_object_set_ref_id (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
guint64 rygel_media_object_get_modified (RygelMediaObject* self);
void rygel_media_object_set_modified (RygelMediaObject* self, guint64 value);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value);
void rygel_media_object_set_parent (RygelMediaObject* self, RygelMediaContainer* value);
RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self);
void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_media_object_finalize (GObject* obj);
static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void rygel_media_object_real_constructed (GObject* base) {
	RygelMediaObject * self;
	GeeArrayList* _tmp0_;
	self = (RygelMediaObject*) base;
	G_OBJECT_CLASS (rygel_media_object_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->uris);
	self->uris = _tmp0_;
}


static void rygel_media_object_get_writable_data_free (gpointer _data) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectGetWritableData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_object_get_writable_co (_data_);
}


GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_get_writable_co (_data_);
}


static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->uris;
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
		_data_->_uri_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_uri_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_uri_size = _data_->_tmp4_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_tmp5_ = _data_->_uri_index;
			_data_->_uri_index = _data_->_tmp5_ + 1;
			_data_->_tmp6_ = _data_->_uri_index;
			_data_->_tmp7_ = _data_->_uri_size;
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
				break;
			}
			_data_->_tmp8_ = _data_->_uri_list;
			_data_->_tmp9_ = _data_->_uri_index;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp8_, _data_->_tmp9_);
			_data_->uri = (gchar*) _data_->_tmp10_;
			_data_->_tmp11_ = _data_->uri;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_file_new_for_uri (_data_->_tmp11_);
			_data_->file = _data_->_tmp12_;
			_data_->_tmp13_ = _data_->file;
			_data_->_tmp14_ = _data_->cancellable;
			_data_->_state_ = 1;
			rygel_media_object_check_writable (_data_->self, _data_->_tmp13_, _data_->_tmp14_, rygel_media_object_get_writable_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp15_ = FALSE;
			_data_->_tmp15_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp16_ = _data_->_tmp15_;
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->_tmp16_) {
				_data_->result = _data_->file;
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->uri);
		}
		_g_object_unref0 (_data_->_uri_list);
	}
	_data_->result = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_object_get_writables_data_free (gpointer _data) {
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectGetWritablesData, _data_);
}


void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritablesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writables);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writables_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_object_get_writables_co (_data_);
}


GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GeeArrayList* result;
	RygelMediaObjectGetWritablesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches File objects for all writable URIs available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_get_writables_co (_data_);
}


static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_data_->writables = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->uris;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_uri_list = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_uri_list;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_uri_size = _data_->_tmp5_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_uri_index;
			_data_->_uri_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = _data_->_uri_index;
			_data_->_tmp8_ = _data_->_uri_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->_uri_list;
			_data_->_tmp10_ = _data_->_uri_index;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->uri = (gchar*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->uri;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = g_file_new_for_uri (_data_->_tmp12_);
			_data_->file = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->file;
			_data_->_tmp15_ = _data_->cancellable;
			_data_->_state_ = 1;
			rygel_media_object_check_writable (_data_->self, _data_->_tmp14_, _data_->_tmp15_, rygel_media_object_get_writables_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp16_ = FALSE;
			_data_->_tmp16_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp17_ = _data_->_tmp16_;
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				_g_object_unref0 (_data_->writables);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->_tmp17_) {
				_data_->_tmp18_ = _data_->writables;
				_data_->_tmp19_ = _data_->file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp18_, _data_->_tmp19_);
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->uri);
		}
		_g_object_unref0 (_data_->_uri_list);
	}
	_data_->result = _data_->writables;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->writables);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->serialize (self, serializer, http_server, error);
}


static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object) {
	GUPnPDIDLLiteObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (didl_object != NULL);
	_tmp0_ = didl_object;
	_tmp1_ = gupnp_didl_lite_object_get_title (_tmp0_);
	_tmp2_ = _tmp1_;
	rygel_media_object_set_title (self, _tmp2_);
}


void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_OBJECT_GET_CLASS (self)->apply_didl_lite (self, didl_object);
}


static void rygel_media_object_clean_node (RygelMediaObject* self, xmlNode* node, xmlNs* ns) {
	GeeArrayList* _tmp0_;
	GeeArrayList* list;
	xmlNode* _tmp1_;
	xmlAttr* _tmp2_;
	xmlAttr* attr;
	xmlNode* _tmp26_;
	xmlNode* _tmp27_;
	xmlNode* child;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->properties;
	attr = _tmp2_;
	while (TRUE) {
		xmlAttr* _tmp3_;
		xmlAttr* _tmp4_;
		xmlNs* _tmp5_;
		xmlNs* _tmp6_;
		xmlAttr* _tmp10_;
		xmlAttr* _tmp11_;
		_tmp3_ = attr;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = attr;
		_tmp5_ = _tmp4_->ns;
		_tmp6_ = ns;
		if (_tmp5_ == _tmp6_) {
			GeeArrayList* _tmp7_;
			xmlAttr* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = list;
			_tmp8_ = attr;
			_tmp9_ = _tmp8_->name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
		}
		_tmp10_ = attr;
		_tmp11_ = _tmp10_->next;
		attr = _tmp11_;
	}
	{
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		GeeArrayList* _name_list;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _name_size;
		gint _name_index;
		_tmp12_ = list;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_name_list = _tmp13_;
		_tmp14_ = _name_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_name_size = _tmp16_;
		_name_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_ = NULL;
			gchar* name;
			xmlNode* _tmp23_;
			xmlNs* _tmp24_;
			const gchar* _tmp25_;
			_tmp17_ = _name_index;
			_name_index = _tmp17_ + 1;
			_tmp18_ = _name_index;
			_tmp19_ = _name_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _name_list;
			_tmp21_ = _name_index;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
			name = (gchar*) _tmp22_;
			_tmp23_ = node;
			_tmp24_ = ns;
			_tmp25_ = name;
			xmlUnsetNsProp (_tmp23_, _tmp24_, _tmp25_);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_list);
	}
	_tmp26_ = node;
	_tmp27_ = _tmp26_->children;
	child = _tmp27_;
	while (TRUE) {
		xmlNode* _tmp28_;
		xmlNode* _tmp29_;
		xmlNs* _tmp30_;
		xmlNode* _tmp31_;
		xmlNode* _tmp32_;
		_tmp28_ = child;
		if (!(_tmp28_ != NULL)) {
			break;
		}
		_tmp29_ = child;
		_tmp30_ = ns;
		rygel_media_object_clean_node (self, _tmp29_, _tmp30_);
		_tmp31_ = child;
		_tmp32_ = _tmp31_->next;
		child = _tmp32_;
	}
	_g_object_unref0 (list);
}


static void rygel_media_object_apply_fragments_data_free (gpointer _data) {
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->current_fragments);
	_g_object_unref0 (_data_->new_fragments);
	_g_object_unref0 (_data_->http_server);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectApplyFragmentsData, _data_);
}


void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectApplyFragmentsData* _data_;
	RygelMediaObject* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* _tmp3_;
	GeeLinkedList* _tmp4_;
	RygelHTTPServer* _tmp5_;
	RygelHTTPServer* _tmp6_;
	_data_ = g_slice_new0 (RygelMediaObjectApplyFragmentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_apply_fragments);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_apply_fragments_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = current_fragments;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->current_fragments);
	_data_->current_fragments = _tmp2_;
	_tmp3_ = new_fragments;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->new_fragments);
	_data_->new_fragments = _tmp4_;
	_tmp5_ = http_server;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->http_server);
	_data_->http_server = _tmp6_;
	rygel_media_object_apply_fragments_co (_data_);
}


GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_) {
	GUPnPDIDLLiteFragmentResult result;
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void rygel_media_object_apply_fragments_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_apply_fragments_co (_data_);
}


static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_result_ = GUPNP_DIDL_LITE_FRAGMENT_RESULT_UNKNOWN_ERROR;
	{
		_data_->_tmp0_ = rygel_serializer_new (SERIALIZER_TYPE_GENERIC_DIDL);
		_data_->writer = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->writer;
		_data_->_tmp2_ = _data_->http_server;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = rygel_media_object_serialize (_data_->self, _data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
		_data_->didl_object = _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->writer);
			goto __catch10_g_error;
		}
		_data_->_tmp4_ = _data_->didl_object;
		_data_->_tmp5_ = gupnp_didl_lite_object_get_xml_node (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->didl_object;
		_data_->_tmp8_ = gupnp_didl_lite_object_get_dlna_namespace (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		rygel_media_object_clean_node (_data_->self, _data_->_tmp6_, _data_->_tmp9_);
		_data_->_tmp10_ = _data_->didl_object;
		_data_->_tmp11_ = _data_->current_fragments;
		_data_->_tmp12_ = 0;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp11_, &_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp14__length1 = _data_->_tmp12_;
		_data_->_tmp15_ = _data_->new_fragments;
		_data_->_tmp16_ = 0;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp15_, &_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp18__length1 = _data_->_tmp16_;
		_data_->_tmp19_ = 0;
		_data_->_tmp19_ = gupnp_didl_lite_object_apply_fragments (_data_->_tmp10_, _data_->_tmp14_, _data_->_tmp12_, _data_->_tmp18_, _data_->_tmp16_);
		_data_->_result_ = _data_->_tmp19_;
		_data_->_tmp18_ = (_vala_array_free (_data_->_tmp18_, _data_->_tmp18__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp14_ = (_vala_array_free (_data_->_tmp14_, _data_->_tmp14__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp20_ = _data_->_result_;
		if (_data_->_tmp20_ == GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK) {
			_data_->_tmp21_ = _data_->didl_object;
			rygel_media_object_apply_didl_lite (_data_->self, _data_->_tmp21_);
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
				_data_->_state_ = 1;
				rygel_updatable_object_commit (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, rygel_media_object_apply_fragments_ready, _data_);
				return FALSE;
				_state_1:
				rygel_updatable_object_commit_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					_g_object_unref0 (_data_->didl_object);
					_g_object_unref0 (_data_->writer);
					goto __catch10_g_error;
				}
			}
		}
		_g_object_unref0 (_data_->didl_object);
		_g_object_unref0 (_data_->writer);
	}
	goto __finally10;
	__catch10_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	__finally10:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = property;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				RygelMediaObject* _tmp5_;
				const gchar* _tmp6_;
				gint _tmp7_ = 0;
				_tmp4_ = self->priv->_id;
				_tmp5_ = media_object;
				_tmp6_ = _tmp5_->priv->_id;
				_tmp7_ = rygel_media_object_compare_string_props (self, _tmp4_, _tmp6_);
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				RygelMediaContainer* _tmp8_;
				RygelMediaContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelMediaObject* _tmp11_;
				RygelMediaContainer* _tmp12_;
				RygelMediaContainer* _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_ = 0;
				_tmp8_ = rygel_media_object_get_parent (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = ((RygelMediaObject*) _tmp9_)->priv->_id;
				_tmp11_ = media_object;
				_tmp12_ = rygel_media_object_get_parent (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = ((RygelMediaObject*) _tmp13_)->priv->_id;
				_tmp15_ = rygel_media_object_compare_string_props (self, _tmp10_, _tmp14_);
				result = _tmp15_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				RygelMediaObject* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_ = 0;
				_tmp16_ = rygel_media_object_get_title (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = media_object;
				_tmp19_ = rygel_media_object_get_title (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = rygel_media_object_compare_string_props (self, _tmp17_, _tmp20_);
				result = _tmp21_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp22_;
				RygelMediaObject* _tmp23_;
				const gchar* _tmp24_;
				gint _tmp25_ = 0;
				_tmp22_ = self->priv->_upnp_class;
				_tmp23_ = media_object;
				_tmp24_ = _tmp23_->priv->_upnp_class;
				_tmp25_ = rygel_media_object_compare_string_props (self, _tmp22_, _tmp24_);
				result = _tmp25_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	}
}


gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->compare_by_property (self, media_object, property);
}


gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2) {
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (prop1 != NULL, 0);
	g_return_val_if_fail (prop2 != NULL, 0);
	_tmp0_ = prop1;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = prop2;
		if (_tmp1_ == NULL) {
			result = 1;
			return result;
		} else {
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gint _tmp4_ = 0;
			_tmp2_ = prop1;
			_tmp3_ = prop2;
			_tmp4_ = g_utf8_collate (_tmp2_, _tmp3_);
			result = _tmp4_;
			return result;
		}
	}
}


static GUPnPDIDLLiteResource* rygel_media_object_real_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteObject* _tmp0_;
	GUPnPDIDLLiteResource* _tmp1_ = NULL;
	GUPnPDIDLLiteResource* res;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = object;
	_tmp1_ = gupnp_didl_lite_object_add_resource (_tmp0_);
	res = _tmp1_;
	result = res;
	return result;
}


GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->add_resource (self, object, uri, protocol, import_uri, error);
}


gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = prop1;
	_tmp1_ = prop2;
	_tmp2_ = CLAMP (_tmp0_ - _tmp1_, -1, 1);
	result = _tmp2_;
	return result;
}


static void rygel_media_object_check_writable_data_free (gpointer _data) {
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectCheckWritableData, _data_);
}


static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
	RygelMediaObject* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (RygelMediaObjectCheckWritableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_check_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_check_writable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_media_object_check_writable_co (_data_);
}


static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	RygelMediaObjectCheckWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_object_check_writable_co (_data_);
}


static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->file;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_file_get_uri_scheme (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = g_str_has_prefix (RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME, _data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	if (_data_->_tmp4_) {
		_data_->result = TRUE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->file;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = g_file_is_native (_data_->_tmp5_);
	if (!_data_->_tmp6_) {
		_data_->result = FALSE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = _data_->file;
		_data_->_tmp8_ = _data_->cancellable;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp7_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp8_, rygel_media_object_check_writable_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_file_query_info_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp9_;
		if (_data_->_inner_error_ != NULL) {
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch11_g_io_error_not_found;
			}
			goto __finally11;
		}
		_data_->_tmp10_ = _data_->info;
		_data_->_tmp11_ = FALSE;
		_data_->_tmp11_ = g_file_info_get_attribute_boolean (_data_->_tmp10_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
		_data_->result = _data_->_tmp11_;
		_g_object_unref0 (_data_->info);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally11;
	__catch11_g_io_error_not_found:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->result = TRUE;
		_g_error_free0 (_data_->_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally11:
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
	g_error_free (_data_->_inner_error_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
	return self;
}


const gchar* rygel_media_object_get_id (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ref_id;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_ref_id (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_ref_id);
	self->priv->_ref_id = _tmp1_;
	g_object_notify ((GObject *) self, "ref-id");
}


const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_upnp_class;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_upnp_class);
	self->priv->_upnp_class = _tmp1_;
	g_object_notify ((GObject *) self, "upnp-class");
}


guint64 rygel_media_object_get_modified (RygelMediaObject* self) {
	guint64 result;
	guint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = self->priv->_modified;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_modified (RygelMediaObject* self, guint64 value) {
	guint64 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modified = _tmp0_;
	g_object_notify ((GObject *) self, "modified");
}


guint rygel_media_object_get_object_update_id (RygelMediaObject* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_object_update_id;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_object_update_id = _tmp0_;
	g_object_notify ((GObject *) self, "object-update-id");
}


RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent_ptr;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_parent (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->parent_ptr = _tmp0_;
	g_object_notify ((GObject *) self, "parent");
}


RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_ref;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	rygel_media_object_set_parent (self, _tmp0_);
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_parent_ref);
	self->priv->_parent_ref = _tmp2_;
	g_object_notify ((GObject *) self, "parent-ref");
}


const gchar* rygel_media_object_get_title (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GRegex* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GRegex* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp0_ = rygel_media_object_real_name_regex;
		_tmp1_ = value;
		_tmp2_ = g_get_real_name ();
		_tmp3_ = g_regex_replace_literal (_tmp0_, _tmp1_, (gssize) (-1), 0, _tmp2_, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp4_;
		_tmp5_ = rygel_media_object_user_name_regex;
		_tmp6_ = self->priv->_title;
		_tmp7_ = g_get_user_name ();
		_tmp8_ = g_regex_replace_literal (_tmp5_, _tmp6_, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp9_;
		_tmp10_ = rygel_media_object_host_name_regex;
		_tmp11_ = self->priv->_title;
		_tmp12_ = g_get_host_name ();
		_tmp13_ = g_regex_replace_literal (_tmp10_, _tmp11_, (gssize) (-1), 0, _tmp12_, 0, &_inner_error_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp14_;
	}
	goto __finally12;
	__catch12_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify ((GObject *) self, "title");
}


GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->get_ocm_flags (self);
}


static GUPnPOCMFlags rygel_media_object_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaObject* self;
	self = base;
	result = GUPNP_OCM_FLAGS_NONE;
	return result;
}


gboolean rygel_media_object_get_restricted (RygelMediaObject* self) {
	gboolean result;
	GUPnPOCMFlags _tmp0_;
	GUPnPOCMFlags _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_object_get_ocm_flags (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == GUPNP_OCM_FLAGS_NONE;
	return result;
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	GError * _inner_error_ = NULL;
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaObjectPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_media_object_real_constructed;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_object_real_serialize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->apply_didl_lite = rygel_media_object_real_apply_didl_lite;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_object_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->add_resource = rygel_media_object_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_object_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_REF_ID, g_param_spec_string ("ref-id", "ref-id", "ref-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_UPNP_CLASS, g_param_spec_string ("upnp-class", "upnp-class", "upnp-class", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_MODIFIED, g_param_spec_uint64 ("modified", "modified", "modified", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID, g_param_spec_uint ("object-update-id", "object-update-id", "object-update-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT, g_param_spec_object ("parent", "parent", "parent", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF, g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The human-readable title of this container or item.
	     * These variables will be substituted:
	     *
	     *  - @@REALNAME@ will be substituted by the user's real name.
	     *  - @@USERNAME@ will be substituted by the users's login ID.
	     *  - @@HOSTNAME@ will be substituted by the name of the machine.
	     *  - @@ADDRESS@ will be substituted by the IP address of network interface used for the UpNP communication.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_RESTRICTED, g_param_spec_boolean ("restricted", "restricted", "restricted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GRegex* _tmp12_;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		_tmp0_ = g_regex_escape_string ("@REALNAME@", -1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (rygel_media_object_real_name_regex);
		rygel_media_object_real_name_regex = _tmp4_;
		_tmp5_ = g_regex_escape_string ("@USERNAME@", -1);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_regex_new (_tmp6_, 0, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (rygel_media_object_user_name_regex);
		rygel_media_object_user_name_regex = _tmp9_;
		_tmp10_ = g_regex_escape_string ("@HOSTNAME@", -1);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_regex_new (_tmp11_, 0, 0, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (rygel_media_object_host_name_regex);
		rygel_media_object_host_name_regex = _tmp14_;
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->priv = RYGEL_MEDIA_OBJECT_GET_PRIVATE (self);
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_ref_id);
	_g_free0 (self->priv->_upnp_class);
	_g_object_unref0 (self->uris);
	_g_object_unref0 (self->priv->_parent_ref);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}


/**
 * Represents a media object (container or item).
 *
 * The derived RygelMediaContainer class represents a container,
 * and the derived RygelMediaItem classes (RygelAudioItem,
 * RygelImageItem and RygelVideoItem) represent media items.
 *
 * These objects correspond to items and containers in the UPnP ContentDirectory's DIDL-Lite XML.
 */
GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_ID:
		g_value_set_string (value, rygel_media_object_get_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_REF_ID:
		g_value_set_string (value, rygel_media_object_get_ref_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS:
		g_value_set_string (value, rygel_media_object_get_upnp_class (self));
		break;
		case RYGEL_MEDIA_OBJECT_MODIFIED:
		g_value_set_uint64 (value, rygel_media_object_get_modified (self));
		break;
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID:
		g_value_set_uint (value, rygel_media_object_get_object_update_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT:
		g_value_set_object (value, rygel_media_object_get_parent (self));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE:
		g_value_set_string (value, rygel_media_object_get_title (self));
		break;
		case RYGEL_MEDIA_OBJECT_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags (self));
		break;
		case RYGEL_MEDIA_OBJECT_RESTRICTED:
		g_value_set_boolean (value, rygel_media_object_get_restricted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_ID:
		rygel_media_object_set_id (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_REF_ID:
		rygel_media_object_set_ref_id (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS:
		rygel_media_object_set_upnp_class (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_MODIFIED:
		rygel_media_object_set_modified (self, g_value_get_uint64 (value));
		break;
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID:
		rygel_media_object_set_object_update_id (self, g_value_get_uint (value));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT:
		rygel_media_object_set_parent (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE:
		rygel_media_object_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



