// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "smap.h"
#include "head.h"

FitsSMap::FitsSMap()
{
  hmapdata_ = NULL;
  hmapsize_ = 0;

  mapdata_ = NULL;
  mapsize_ = 0;
}

FitsFitsSMap::FitsFitsSMap(FitsHead::Memory mem)
{
  if (!valid_)
    return;

  // simple check for fits file
  if (strncmp(hmapdata_,"SIMPLE  ",8) && strncmp(hmapdata_,"XTENSION",8)) {
    data_ = NULL;

    dataSize_ = 0;
    dataSkip_ = 0;

    valid_ = 0;
  }

  head_ = new FitsHead(hmapdata_, hmapsize_, mem);
  if (head_->isValid()) {
    data_ = mapdata_;

    dataSize_ = mapsize_;
    dataSkip_ = 0;

    inherit_ = head_->inherit();
    valid_ = 1;
    return;
  }
  else {
    if (manageHead_ && head_)
      delete head_;
    head_ = NULL;

    if (managePrimary_ && primary_)
      delete primary_;
    primary_ = NULL;

    data_ = NULL;

    dataSize_ = 0;
    dataSkip_ = 0;

    valid_ = 0;
  }
}

FitsFitsNextSMap::FitsFitsNextSMap(FitsFile* p)
{
  FitsSMap* prev = (FitsSMap*)p;

  primary_ = prev->primary();
  managePrimary_ = 0;

  head_ = prev->head();
  manageHead_ = 0;

  FitsImageHDU* hdu = (FitsImageHDU*)head_->hdu();
  data_ = (char*)prev->data() + hdu->imgbytes();
  dataSize_ = 0;
  dataSkip_ = 0;

  ext_ = prev->ext();
  inherit_ = prev->inherit();
  byteswap_ = prev->byteswap();
  orgFits_ = prev->orgFits();
  valid_ = 1;

  pWidth_ = prev->pWidth();
  pHeight_ = prev->pHeight();
  pDepth_ = prev->pDepth();
  pBitpix_ = prev->pBitpix();
  pSkip_ = prev->pSkip();
  pArch_ = prev->pArch();

  coord_ = prev->coord();
  xvalid_ = prev->xvalid();
  xmin_ = prev->xmin();
  xmax_ = prev->xmax();
  yvalid_ = prev->yvalid();
  ymin_ = prev->ymin();
  ymax_ = prev->ymax();
  zvalid_ = prev->zvalid();
  zmin_ = prev->zmin();
  zmax_ = prev->zmax();

  mapdata_ = prev->mapdata();
  mapsize_ = prev->mapsize();

  return;
}

