/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "scumm/ks_check.h"

namespace Scumm {

// Korean CP949 final consonant table
static byte jongsungTable[2350] = {
	 0,  1,  4,  7,  8,  9, 10, 16, 17, 18, 19, 20, 21, 22, 23, 25,
	26, 27,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  1,  4,  8, 19,
	21,  0,  4,  8,  0,  1,  4,  7,  8, 10, 16, 17, 19, 20, 21, 22,
	25, 26, 27,  0,  4,  8, 16, 17, 19, 20, 21,  0,  1,  2,  4,  7,
	 8, 16, 17, 19, 20, 21, 25,  0,  4,  8, 17, 19,  0,  1,  4,  7,
	 8, 10, 12, 15, 16, 17, 19, 21, 22,  0,  1,  4,  8, 10, 16, 17,
	19, 21,  0,  4,  8, 16, 20, 21,  0,  1,  4,  8, 16, 17, 19, 21,
	 0,  4,  8, 17, 19,  0,  1,  4,  7,  8,  9, 10, 15, 16, 17, 19,
	21, 22,  0,  1,  4,  8, 20, 21,  0, 19,  0,  1,  4,  8, 16, 17,
	19,  0,  4,  8,  0,  1,  4,  7,  8,  9, 16, 17, 19, 21,  0,  0,
	 1,  4,  7,  8, 10, 16, 17, 19, 21, 22, 26,  0,  1,  2,  4,  8,
	10, 16, 17, 19, 20, 21, 25,  0,  1,  4,  8, 16, 17, 19, 20, 21,
	 0,  1,  8,  0,  1,  2,  4,  8, 16, 17, 19, 20, 21,  0,  1,  4,
	16, 19, 21,  0,  4,  8, 19, 20, 25,  0,  0,  1,  4,  6,  8, 16,
	17, 19, 21, 22, 23,  0,  1,  8, 20, 21,  0,  1, 21,  0,  4,  8,
	16, 17, 21,  0,  0,  1,  4,  8, 15, 16, 17, 19, 21, 22,  0,  8,
	20, 21,  0,  1,  4,  8, 16, 17, 20,  0,  4,  8, 16, 17,  0,  0,
	 1,  4,  6,  8, 10, 15, 16, 17, 19, 21, 25,  0,  1,  4,  8, 16,
	17, 19, 21,  0,  1,  2,  4,  7,  8,  9, 10, 16, 17, 19, 20, 21,
	22, 23, 25, 27,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  1,  4,
	 8, 16, 21,  0,  1,  3,  4,  8, 10, 11, 16, 17, 19, 20, 21, 27,
	 0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  1,  4,  8, 16, 17, 20,
	21, 24,  0,  4,  0,  1,  4,  8, 10, 16, 17, 19, 21, 26, 27,  0,
	 4,  8, 20,  0,  4,  8, 16, 17, 19,  0,  1,  4,  8, 17, 19, 21,
	 0,  1,  4,  7,  8, 16, 17, 19, 21,  0, 20,  0,  0,  4,  8, 16,
	17,  0,  1,  8, 16, 17, 21,  0,  1,  4,  8,  9, 10, 16, 17, 19,
	21, 22, 26,  0,  4,  8,  0,  1,  4,  8, 14, 16, 17, 19, 21, 26,
	 0,  1,  2,  4,  7,  8,  9, 10, 11, 15, 16, 17, 19, 20, 21, 22,
	23, 27,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  0,  1,  2,  4,
	 7,  8, 10, 11, 16, 17, 19, 21, 23, 26,  0,  1,  4,  8, 16, 17,
	19, 20, 21,  0,  4,  8, 20, 21,  0,  4,  0,  1,  4,  7,  8, 10,
	12, 16, 17, 19, 21, 23, 25,  0,  4,  8,  0, 20,  0,  4,  8, 16,
	17, 19,  0,  0,  1,  4,  8, 16, 17, 19, 21,  0, 20,  0, 21,  0,
	 4,  8, 17, 19, 21,  0,  4,  8, 16, 21,  0,  1,  4,  7,  8, 10,
	16, 17, 19, 21,  0,  0,  1,  4,  7,  8, 16, 17, 19, 20, 21, 22,
	 0,  1,  4,  8, 16, 17, 19, 20, 21, 27,  0,  1,  4,  8, 16, 17,
	19, 20, 21,  0,  1,  4,  8, 10, 11, 16, 17, 19, 20, 21, 27,  0,
	 1,  4,  8, 16, 17, 19, 20, 21,  0, 20,  0,  1,  4,  8, 21,  0,
	 8,  0,  0,  4,  0,  1,  4,  8, 15, 16, 21,  0,  0,  4,  8, 16,
	17, 21,  0,  1,  4,  7,  8, 16, 17, 19,  0,  4,  8, 16, 17,  0,
	 4,  8, 16, 17, 19, 21,  0,  1,  4,  8, 16, 17, 19, 20, 21, 22,
	26, 27,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  1,  4, 19, 21,
	 0,  1,  4,  8, 16, 17, 19, 20, 21, 27,  0,  1,  4,  8, 16, 17,
	19, 21,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  4, 17, 19,  0,
	 1,  4,  8, 16, 17, 19, 21,  0,  4, 21, 20,  0,  4,  8, 16, 17,
	19, 21,  0,  4,  8, 17, 19, 21,  0,  1,  4,  8, 16, 17, 19, 21,
	 0, 20,  0,  0,  1,  4,  8, 16, 19, 21,  0,  1,  4,  8, 16, 17,
	19, 21,  0,  1,  4,  8, 16, 17, 19, 21, 22, 25, 26,  0,  1,  4,
	 8, 16, 17, 19, 21,  0,  1,  4,  6,  7,  8,  9, 10, 16, 17, 19,
	21, 22, 25, 27,  0,  1,  4,  8, 16, 17, 19, 20, 21, 22,  0,  1,
	 8, 21,  0,  1,  4,  8, 10, 16, 17, 19, 21, 22, 27,  0,  1,  4,
	 8, 16, 17, 19, 20, 21,  0,  1,  4,  8, 19, 20, 21, 23,  0,  0,
	 1,  3,  4,  8, 10, 16, 17, 19, 21,  0,  4, 20, 21,  0,  4,  8,
	17, 19, 21,  0,  4,  8, 17, 19,  0,  1,  2,  4,  7,  8,  9, 10,
	16, 17, 19, 21, 25, 27,  0,  4,  8, 17, 19,  0,  0,  4,  8,  0,
	 4,  8, 16, 19,  0,  4,  8, 16, 19,  0,  1,  4,  7,  8, 10, 16,
	17, 19, 20, 21, 23, 25,  0,  1,  2,  3,  4,  7,  8,  9, 10, 11,
	16, 17, 19, 21, 25,  0,  1,  4,  8, 16, 17, 19, 20, 21, 25,  0,
	 1,  4, 17,  0,  1,  4,  7,  8, 10, 16, 17, 19, 21, 22,  0,  1,
	 4,  7,  8, 16, 17, 19, 20, 21,  0,  1,  4,  8, 17, 19, 20, 21,
	25,  0,  4,  0,  1,  2,  4,  8, 16, 17, 19, 21,  0,  4, 20,  0,
	20,  0,  1,  4,  8, 16, 17,  0,  4,  0,  1,  4,  7,  8,  9, 10,
	16, 17, 19, 21, 25, 26,  0,  8, 20,  0,  0,  1,  4,  8, 21,  0,
	 4,  8, 16, 19, 21,  0,  1,  4,  8, 16, 17, 19,  0,  1,  4,  8,
	10, 16, 17, 19, 21, 22, 23,  0,  1,  4,  8, 10, 16, 17, 19, 20,
	21, 27,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  1, 16,  0,  1,
	 4,  7,  8, 16, 19, 20, 21,  0, 21,  0,  1, 16, 17, 19, 20, 21,
	 0,  1,  4,  8, 16, 17, 21,  0,  0, 21,  0,  1,  4,  8, 16, 19,
	21,  0, 21,  0,  4,  8, 16, 17,  0,  1,  4,  8, 16, 17, 19, 21,
	 0,  1,  3,  4,  7,  8,  9, 10, 16, 17, 19, 20, 21, 25,  0,  1,
	 4,  8, 16, 17, 19, 20, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,
	 4,  8, 16, 21,  0,  1,  2,  3,  4,  7,  8, 10, 11, 16, 17, 19,
	20, 21, 26,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  1,  4,  8,
	16, 17, 19, 20, 21,  0,  4,  8, 21,  0,  1,  2,  4,  8, 10, 16,
	17, 19, 21, 25,  0,  1,  4,  8, 21,  0,  4,  8, 16, 19, 20,  0,
	 4,  8, 16, 17, 19,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  4,
	 7,  8, 16, 17, 19, 21, 23, 25, 26,  0, 20,  0,  1,  4,  8, 16,
	21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  8, 16, 19, 21,  0,
	 1,  4,  8,  9, 16, 17, 19, 21,  0,  1,  4,  7,  8, 15, 16, 17,
	19, 21, 26,  0,  1,  3,  4,  8, 16, 17, 20, 21, 27,  0,  1,  4,
	 8, 16, 17, 20, 21, 21,  0,  1,  4,  8, 10, 16, 17, 20, 21,  0,
	 4,  8, 21,  0,  1,  4,  7,  8, 10, 16, 17, 21,  0,  1,  4, 20,
	 0, 20,  0,  4,  8, 16, 17,  0,  0,  1,  4,  8, 16, 17, 21,  0,
	20,  0,  0,  4, 21,  0,  1,  4,  8, 10, 15, 16, 17,  0,  4,  8,
	16,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  4,  5,  6,  8,  9,
	10, 15, 16, 17, 19, 20, 21, 25, 26,  0,  1,  4,  8, 16, 17, 19,
	20, 21,  0,  1,  4,  8, 11, 16, 17, 19, 21, 25, 27,  0,  4,  8,
	17,  0,  1,  4,  5,  7,  8,  9, 10, 16, 17, 18, 19, 20, 21, 22,
	24, 26,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  2,  4,  8, 10,
	11, 16, 17, 18, 19, 20, 21, 25, 26, 27,  0,  4,  8, 16, 17, 19,
	20,  0,  1,  4,  8,  9, 10, 12, 15, 16, 17, 19, 21, 23,  0,  1,
	 4,  8, 16, 17, 19, 20, 21,  0,  1,  4, 16, 19, 21,  0,  1,  4,
	 8, 16, 17, 19, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  4,
	 8,  9, 10, 16, 17, 19, 21,  0,  1,  4,  8, 16, 17, 20, 21,  0,
	 1,  4,  8, 16, 17, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,
	 4,  8, 16, 17, 19, 21, 23,  0,  1,  4,  8, 14, 16, 17, 19, 21,
	22, 23, 24, 25, 26, 27,  0,  4,  8, 16, 19,  0,  1,  4,  8,  9,
	10, 15, 16, 17, 19, 20, 21, 22, 26,  0,  1,  4,  6,  7,  8, 10,
	16, 17, 19, 20, 21, 22,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,
	 1,  4,  6,  8, 16, 21,  0,  4,  8,  0,  1,  4,  8, 10, 16, 17,
	19, 21, 22,  0,  1,  4,  8, 16, 17, 19, 21,  0,  4,  8, 16, 17,
	20, 21,  0,  0,  1,  4,  8, 10, 16, 17, 19, 21, 22, 23, 27,  0,
	 1,  8, 17, 19, 21,  0, 20, 21,  0,  4,  8, 16, 17, 19, 21,  0,
	 1,  4, 21,  0,  1,  4,  8,  9, 10, 16, 17, 19, 21,  0, 20,  0,
	 0,  1,  4,  8, 16, 17, 19,  0,  4,  8, 16,  0,  1,  4,  8, 16,
	17, 19, 21,  0,  1,  4,  7,  8, 10, 16, 17, 19, 21, 22, 25, 26,
	 0,  1,  4,  6,  8, 11, 16, 17, 19, 20, 21,  0,  1,  4,  8, 16,
	17, 19, 20, 21,  0,  4, 21,  0,  1,  4,  8, 16, 17, 19, 20, 21,
	 0, 21,  0, 20,  0,  1,  4,  8, 16, 17, 19, 21, 23,  0,  1,  8,
	20,  0, 20,  0,  4,  8, 16, 17, 21,  0,  1,  4,  8, 16, 17, 21,
	 0, 20, 21,  0,  0,  0, 16, 19, 21,  0,  1,  4,  8, 16, 17, 21,
	22, 27,  0,  1,  4,  6,  8, 16, 17, 19, 20, 21, 22,  0,  1,  4,
	 8, 16, 17, 19, 20, 21,  0,  4,  6,  8, 16, 21,  0,  1,  4,  8,
	16, 17, 19, 20, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  4, 20,
	 0,  4, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  4,  8, 21,  0,
	 4,  8, 16, 17, 19, 21,  0, 16,  0,  1,  4,  8, 16, 17, 19, 21,
	 0, 20,  0,  4,  0,  4,  8, 16, 17, 19, 21,  0,  4,  8, 16, 21,
	 0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  4,  7,  8,  9, 16, 17,
	19, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  4,  8, 16, 17,
	19, 20, 21,  0,  1, 21,  0,  1,  4,  7,  8, 16, 17, 19, 20, 21,
	 0,  1,  4,  8, 16, 17, 19, 21,  0,  4,  8, 16, 17, 19, 20, 21,
	 0,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  4,  8, 16, 21,  0,
	21,  0,  8,  0,  0,  1,  4,  8, 16, 17, 19, 21,  0,  4,  8, 21,
	 0, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  4,  8, 16,  0,  1,
	 4,  8, 16, 17, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  4,
	 8,  9, 16, 17, 19, 20, 21,  0,  1,  4,  8, 16, 17, 19, 20, 21,
	 0, 21,  0,  1,  4,  8, 10, 16, 17, 19, 20, 21,  0,  1,  4,  8,
	16, 17, 19, 21,  0,  4, 20,  0,  4,  0,  1,  4,  8, 16, 17, 19,
	21, 26,  0,  4,  0,  0,  4, 19, 21,  0,  0,  1,  4,  8, 16, 17,
	19, 21,  0, 20,  0,  0,  1,  4,  8, 16, 17, 21,  0,  4,  8, 16,
	21,  0,  1,  4,  7,  8, 10, 16, 17, 19,  0,  4,  8, 16, 17,  0,
	 1,  4,  8, 16, 17, 19, 21,  0,  1,  2,  4,  8, 10, 16, 17, 19,
	20, 21, 25,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  1,  0,  1,
	 4,  8, 16, 17, 19, 20, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,
	 4,  8, 16, 17, 20, 21,  0,  8, 17, 19,  0,  1,  4,  8, 16, 17,
	19, 21,  0, 21,  0,  4,  0,  4,  8, 17, 19,  0,  1,  4,  7,  8,
	10, 16, 17, 19, 21,  0, 21,  0,  4,  8, 16, 19,  0,  4,  8, 16,
	19, 21,  0,  4,  8, 16, 17, 19,  0,  1,  4,  8, 16, 17, 19, 21,
	 0,  1,  4,  8, 13, 16, 17, 19, 21,  0,  1,  4,  8, 16, 17, 19,
	20, 21,  0, 21,  0,  1,  4,  8, 10, 16, 17, 19, 21,  0,  1,  4,
	 8, 16, 17, 19, 21,  0,  1,  4,  8, 16, 17, 19, 20, 21,  0,  4,
	 8, 17,  0,  1,  4,  8, 13, 16, 17, 19, 21, 25,  0,  1,  4,  8,
	19, 21,  0,  1,  4, 19, 21,  0,  1,  4,  8, 17, 19, 21,  0,  4,
	 8, 17, 19,  0,  1,  4,  8, 13, 16, 19, 21,  0,  4,  8, 16, 21,
	 0,  1,  4,  8, 21,  0,  1,  4,  8, 16, 17, 19, 21,  0,  1,  4,
	 8, 16, 19, 21,  0,  1,  4,  6,  7,  8,  9, 16, 17, 19, 21, 25,
	 0,  4,  8, 16, 17, 21,  0,  1,  4,  8, 16, 17, 19, 21
};

// check for jongsung (final consonant)
byte checkJongsung(byte hi, byte lo) {
	uint16 index = ((hi - 0xb0) * 94 + lo - 0xa1);

	return jongsungTable[index];
}

} // End of namespace Scumm
