// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================

#ifndef SEQAN_HEADER_CHAINING_H
#define SEQAN_HEADER_CHAINING_H

#include <seqan/basic.h>
#include <seqan/score.h>
#include <seqan/sequence.h>
#include <seqan/seeds.h>

#include <seqan/misc/misc_random.h>

#ifdef SEQAN_SWITCH_USE_FORWARDS
#include <seqan/chaining/chaining_generated_forwards.h>
#endif

#include <seqan/chaining/score_chain.h>
#include <seqan/chaining/score_manhattan.h>
#include <seqan/chaining/score_zero.h>
#include <seqan/chaining/score_chain_sop.h>

#include <algorithm>
#include <vector>

#include <seqan/chaining/range_max_tree.h>
#include <seqan/chaining/chain_base.h>
#include <seqan/chaining/fragment.h>
#include <seqan/chaining/chain_point.h>
#include <seqan/chaining/chain_wrapper_point.h>
#include <seqan/chaining/chain_meta_fragment.h>
#include <seqan/chaining/tree_chain_utils.h>
#include <seqan/chaining/tree_chain.h>
#include <seqan/chaining/tree_chain_sop.h>


#include <seqan/chaining/chain_generic.h>



namespace seqan{

}

#endif

