8.3 スケール(音階)

# スケール(音階)

Sonic Piは広い範囲の音階を演奏できます。C3メジャースケールの再生はどのように行うのでしょうか？

```
play_pattern_timed scale(:c3, :major), 0.125, release: 0.1
```

さらに多くのオクターブを実行することができます。

```
play_pattern_timed scale(:c3, :major, num_octaves: 3), 0.125, release: 0.1
```

ペンタトニックスケール(オクターブに5つの音が含まれる音階のこと)のすべての音符はどうでしょう?

```
play_pattern_timed scale(:c3, :major_pentatonic, num_octaves: 3), 0.125, release: 0.1
```

## ランダム音階

コードとスケールは、ランダムな選択を強いるには素晴らしい制約です。コードE3マイナーからランダムに音符を取り出すにはこの例を実行してください。

```
use_synth :tb303
loop do
 play choose(chord(:E3, :minor)), release: 0.3, cutoff: rrand(60, 120)
 sleep 0.25
end
```

異なる和音名やカットオフする範囲を試してみましょう。

## コードとスケールの発見

Sonic Piによってサポートされているスケールやコードを検索するには、チュートリアルの左にある命令ボタンをクリックし、APIリストのスケールまたはコードを選びますメインパネルの情報に、スケールやコードの長いリストが現れるまで下にスクロールしてください（あなたがどれを見るかに依拠します）。

間違いではなく可能性でるということを思い出して、楽しんでください。
