7.1 Kontrolowanie Uruchomionych Syntezatorów

# Kontrolowanie Uruchomionych Syntezatorów

Do tej pory interesowaliśmy się tylko uruchamianiem nowych dźwięków 
i efektów. Jednakże, Sonic Pi daje nam możliwość manipulacji i kontroli 
aktualnie uruchomionych dźwięków. Dokonujemy tego używając zmiennych 
do przechwycenie referencji do syntezatora: 

```
s = play 60, release: 5
```

Mamy tutaj zmienną lokalną `s`, która reprezentuje syntezator 
grający nutę 60. Nuta, która jest *zmienną działającą lokalnnie* 
- nie masz do niej dostępu z innych uruchomień takich jak funkcje (?).

Gdy już mamy zmienną `s`, możemy zacząć kontrolować ją za pomoca 
funkcji `control`: 

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Rzeczą godną zauważenia jest tutaj to, że nie uruchamiamy 4 oddzielnych  
syntezatorów - uruchamiamy tylko jeden po czym zmieniamy wysokość tonu 
3 razy w trakcie gdy wciąż gra.

Możemy przekazywać dowolne ze standardowych parametrów do polecenia 
`control`, możesz więc kontrolować takie rzeczy jak `amp:`, `cutoff:` 
czy `pan:`.

## Parametry Nie Dające Się Kontrolować

Są pewne parametry, które nie mogą być kontrolowane gdy syntezator 
został już uruchomiony. Dotyczy to m.in. wszytkich parametrów obwiedni 
ADSR. Możesz samodzielnie sprawdzić, które z parametrów danego syntezatora 
mogą być kontrolowane zaglądając do systemu pomocy. Jeśli w dokumentacji 
jest napisane *can not be changed once set* (nie może być zmieniony gdy 
już raz został ustawiony), to już wiesz, że nie możesz kontrolować 
i zmienać danego parametru gdy syntezator już wystartuje.
