/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONFIGDATA_H
#define _SC_CONFIGDATA_H

// sc
#include "ConfigValue.h"
#include "util/String.h"
class Config;


class ConfigData
{
public:
  ConfigData( Config* );

  void load();
  void save();

  void getValues( const sc::String& key, ConfigValues& );
  /** Delete all values starting with @a key. */
  void delValues( const sc::String& key );
  void setValues( const sc::String& key, const ConfigValues& );

  ConfigValue getValue( const sc::String& key );
  /** Delete @a key. */
  void delValue( const sc::String& key );
  void setValue( const sc::String& key, const ConfigValue& );

  static void getValues( const sc::String& key, const ConfigValues&, ConfigValues&, bool all );
  static void delValues( const sc::String& key, ConfigValues&, bool all );

private:
  Config*      _cfg;
  ConfigValues _data;
};


#endif // _SC_CONFIGDATA_H
