/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import net.freeutils.charset.ByteLookupCharset;

public class GSMCharset
extends Charset {
    static final String NAME = "GSM-DEFAULT-ALPHABET";
    static final String[] ALIASES = new String[]{"GSM_0338", "GSM_DEFAULT", "GSM7", "GSM-7BIT"};
    static final byte ESCAPE = 27;
    static final int[] BYTE_TO_CHAR = new int[]{64, 163, 36, 165, 232, 233, 249, 236, 242, 231, 10, 216, 248, 13, 197, 229, 916, 95, 934, 915, 923, 937, 928, 936, 931, 920, 926, 160, 198, 230, 223, 201, 32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 161, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 209, 220, 167, 191, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 241, 252, 224, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final int[] BYTE_TO_CHAR_ESCAPED = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 125, -1, -1, -1, -1, -1, 92, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 91, 126, 93, -1, 124, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8364, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final int[][] CHAR_TO_BYTE = ByteLookupCharset.createInverseLookupTable(BYTE_TO_CHAR);
    static final int[][] CHAR_TO_BYTE_ESCAPED = ByteLookupCharset.createInverseLookupTable(BYTE_TO_CHAR_ESCAPED);

    public GSMCharset() {
        super(NAME, ALIASES);
    }

    public boolean contains(Charset cs) {
        return this.getClass().isInstance(cs);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Decoder
    extends CharsetDecoder {
        protected Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int remaining = in.remaining();
            while (remaining-- > 0) {
                int c;
                if (out.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                byte b = in.get();
                if (b == 27) {
                    if (remaining-- == 0) {
                        in.position(in.position() - 1);
                        return CoderResult.UNDERFLOW;
                    }
                    b = in.get();
                    c = BYTE_TO_CHAR_ESCAPED[b & 0xFF];
                } else {
                    c = BYTE_TO_CHAR[b & 0xFF];
                }
                if (c == -1) {
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                out.put((char)c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    protected static class Encoder
    extends CharsetEncoder {
        protected Encoder(Charset cs) {
            super(cs, 1.0f, 2.0f);
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int remaining = in.remaining();
            while (remaining-- > 0) {
                int b;
                if (out.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                int[] table = CHAR_TO_BYTE[c >> 8];
                int n = b = table == null ? -1 : table[c & 0xFF];
                if (b == -1) {
                    table = CHAR_TO_BYTE_ESCAPED[c >> 8];
                    int n2 = b = table == null ? -1 : table[c & 0xFF];
                    if (b == -1) {
                        in.position(in.position() - 1);
                        return CoderResult.unmappableForLength(1);
                    }
                    out.put((byte)27);
                }
                out.put((byte)(b & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

