C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LRASI3
C                       *****************
C
C      -----------------------------------------
     * (NDIM,NPOINR,NELRAY,NODRAY,NRFRAY,COORAY)
C      -----------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             LECTURE DU MAILLAGE ELEMENTS FINIS RAYONNEMENT           *
C                  STRUCTURE DE DONNEE ISSUE DE SIMAIL                 *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (3     )               !
C !  NPOINR   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE RAYONNEMENT     !
C !  NELRAY   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE RAYONNEMENT        !
C !  NODRAY   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE RAYONNEMENT !
C !  NRFRAY   ! TE ! R  ! TABLEAU DES REFERENCES ELTS MAILLAGE RAYT    !
C !  COORAY   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE RAYONNEMENT     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    !    !                                              !
C ! /DIVCT/   !    !    !                                              !
C ! /NLOFES/  !    !    !                                              !
C ! /NLOFCT/  !    !    !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELRAY,NPOINR,NDIM
      INTEGER NODRAY(NELRAY,NDIM),NRFRAY(NELRAY)
      DOUBLE PRECISION  COORAY(NPOINR,NDIM)
C
C.. Variables internes
      INTEGER I,J
      INTEGER LE,NT0,NT2,NT4,NT5,M(32),MM
      INTEGER NP,NCGE,NMAE,NNO,INING,NE,NN,NT3,NBEGM
      INTEGER NFAC(3), NARE(3), NSOM
      INTEGER NNMAE(0:20)
C
#ifdef HAVE_C_IO
      INTEGER   NBRLUS,NBRTOT,IERROR
      CHARACTER MSGIER*80
#endif /* HAVE_C_IO */
C
C***********************************************************************
C
C     1- INITIALISATION DES TABLEAUX D'INDICATEURS
C     ============================================
C
      NFAC(1) = 0
      NFAC(2) = 0
      NFAC(3) = 0
C
      IF (NDIM.EQ.3) THEN
        NARE(1) = 3
        NARE(2) = 3
        NARE(3) = 0
      ELSE
        NARE(1) = 0
        NARE(2) = 0
        NARE(3) = 0
      ENDIF
C
      NSOM = NDIM
C
      DO 5 I=0,20
         NNMAE(I) = 1
    5 CONTINUE
      NNMAE(0) = 0
C
C
C     2- LECTURE DU MAILLAGE
C     ======================
C
#ifdef HAVE_C_IO
      CALL REWDBF (NFSGRA, IERROR)
      IF (IERROR .NE. 0) GOTO 998
#else
      REWIND NFSGRA
#endif
C
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGRA, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGRA, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ (NFSGRA) LE, (M(I), I=1,LE) 
#endif
      NT0 = M(2)
      NT2 = M(4)
      NT3 = M(5)
      NT4 = M(6)
      NT5 = M(7)
C
C
C     Lecture du tableau 0
C     --------------------
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGRA, 4, NT0, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGRA, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ (NFSGRA) LE, (M(I), I=1,NT0)
#endif
C
C     Lecture du tableau 2
C     --------------------
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGRA, 4, NT2, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGRA, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFSGRA) LE,(M(I),I=1,NT2)
#endif
C
      NP = M(22)
      NN = M(15)
      NE = M(5)
      NBEGM=M(25)
C
#ifdef HAVE_C_IO
      IF (NT3.GT.0) THEN
ccc      IF (NBEGM.GT.0) THEN
         NBRLUS = 0
         CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
         IF (IERROR .NE. 0) GOTO 998
         IF (NBRLUS .LT. NBRTOT) THEN
            CALL READBF (NFSGRA, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
            IF (IERROR .NE. 0) GOTO 998
         ENDIF
      ENDIF
#else
      IF (NT3.GT.0) READ(NFSGRA,ERR=999) LE
ccc      IF (NBEGM.GT.0) READ(NFSGRA,ERR=999) LE
#endif
C       
C     lecture du tableau 4
C     --------------------
C
#ifdef CRAY
        READ(NFSGRA) LE,( (COORAY(I,J),J=1,NDIM) , I=1,NP)
#else
        CALL LCOODP(COORAY,COORAY,NP,NDIM,NPOINR,NFSGRA)
#endif
C
C     lecture du tableau 5
C     --------------------
C
#ifdef HAVE_C_IO
C
      NBRLUS = 0
      CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
C
      DO I = 1, NE
C
         CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, NCGE, IERROR)
         IF (IERROR .NE. 0) GOTO 998
         CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, NMAE, IERROR)
         IF (IERROR .NE. 0) GOTO 998
         CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, NRFRAY(I),
     &                IERROR)
         IF (IERROR .NE. 0) GOTO 998
         CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, NNO,  IERROR)
         IF (IERROR .NE. 0) GOTO 998
C
         DO J = 1, NNO
            CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, NODRAY(I,J),
     &                   IERROR)
            IF (IERROR .NE. 0) GOTO 998
         ENDDO
         IF (NMAE.NE.0) THEN
            CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, INING,
     &                   IERROR)
            IF (IERROR .NE. 0) GOTO 998
            IF (INING.EQ.1) THEN
               DO J = 1, NFAC(INING)
                  CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, MM,
     &                         IERROR)
                  IF (IERROR .NE. 0) GOTO 998
               ENDDO
            ENDIF
            IF (INING.LE.2) THEN
               DO J = 1, NARE(INING)
                  CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, MM,
     &                         IERROR)
                  IF (IERROR .NE. 0) GOTO 998
               ENDDO
            ENDIF
            DO J = 1, NSOM
               CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, MM,
     &                      IERROR)
               IF (IERROR .NE. 0) GOTO 998
            ENDDO
         ENDIF
C
      ENDDO
C
#else
      INING=1
      READ(NFSGRA) LE, 
     & (  NCGE,NMAE,
     &    NRFRAY(I),
     &    NNO, (NODRAY(I,J),J=1,NNO),
     &         (INING,      J=1,NNMAE(NMAE) ),
     &         (MM,       J=1,NFAC(INING)*NNMAE(NMAE) ), 
     &         (MM,       J=1,NARE(INING)*NNMAE(NMAE) ),
     &         (MM,       J=1,NSOM*NNMAE(NMAE) )
     &    , I=1,NE )   
#endif
C
C
C     4- IMPRESSION SUR LISTING
C     =========================
C
      IF (NBLBLR.GT.0) THEN
        WRITE(NFECRA,4000)
        WRITE(NFECRA,4010) NDIM,NN,NE
      ENDIF
C
C
C     6- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLR.GE.2) THEN
C
      WRITE(NFECRA,5000) 
      WRITE(NFECRA,5010)
      DO 100 I=1,10
        WRITE(NFECRA,5011) I,(COORAY(I,J),J=1,NDIM)
  100 CONTINUE
C
      WRITE(NFECRA,5020)
      DO 110 I=1,10
        WRITE(NFECRA,5012)I,(NODRAY(I,J),J=1,NDIM)
 110  CONTINUE
C
      WRITE(NFECRA,5030)
      DO 120 I=1,10
        WRITE(NFECRA,5013)I,NRFRAY(I)
 120  CONTINUE
C
      ENDIF  
C
      RETURN
C
#ifdef HAVE_C_IO
 998  CONTINUE
      CALL STREBF (MSGIER, LEN(MSGIER), IERROR)
      WRITE(NFECRA,9998) MSGIER
      STOP
#else
 999  CONTINUE
      WRITE(NFECRA,9999)
      STOP
#endif /* HAVE_C_IO */
C
C--------
C FORMATS
C--------
C
 4000 FORMAT(//,' *** LRASI3 : MAILLAGE POUR LE RAYONNEMENT :')
 4010 FORMAT(8X,'- Dimension du maillage : ',I6,/
     &       8X,'- Nombre de noeuds      : ',I6,/
     &       8X,'- Nombre d''elements     : ',I6)
C
 5000 FORMAT(/,' *** LRASI3 : Verification du maillage rayonnement',/)
 5010 FORMAT(/,14X,'Coordonnees des 10 premiers noeuds :',/)
 5020 FORMAT(/,14X,'Table des 10 premiers elements :',/)
 5030 FORMAT(/,14X,'References des 10 premiers elements :',/)
 5011 FORMAT(14X,'N=',I2,'   COORDS : ',3E12.5)
 5012 FORMAT(14X,'N=',I2,'   NOEUDS : ',10I6)
 5013 FORMAT(14X,'N=',I2,'   REFERENCE : ',I3)
#ifdef HAVE_C_IO
 9998 FORMAT(' %% ERREUR LRASI3 : erreur de lecture du maillage ',
     *       'de rayonnement',/,'    de type : ',A)
#endif
C
 9999 FORMAT(' %% ERREUR LRASI3 : erreur de lecture du maillage ',
     *       'de rayonnement')
      END
