// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allocates a Dedicated Host to your account. At a minimum, specify the supported
// instance type or instance family, the Availability Zone in which to allocate the
// host, and the number of hosts to allocate.
func (c *Client) AllocateHosts(ctx context.Context, params *AllocateHostsInput, optFns ...func(*Options)) (*AllocateHostsOutput, error) {
	if params == nil {
		params = &AllocateHostsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AllocateHosts", params, optFns, addOperationAllocateHostsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AllocateHostsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AllocateHostsInput struct {

	// The Availability Zone in which to allocate the Dedicated Host.
	//
	// This member is required.
	AvailabilityZone *string

	// The number of Dedicated Hosts to allocate to your account with these parameters.
	//
	// This member is required.
	Quantity int32

	// Indicates whether the host accepts any untargeted instance launches that match
	// its instance type configuration, or if it only accepts Host tenancy instance
	// launches that specify its unique host ID. For more information, see
	// Understanding auto-placement and affinity
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding)
	// in the Amazon EC2 User Guide. Default: on
	AutoPlacement types.AutoPlacement

	// Unique, case-sensitive identifier that you provide to ensure the idempotency of
	// the request. For more information, see Ensuring Idempotency
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string

	// Indicates whether to enable or disable host recovery for the Dedicated Host.
	// Host recovery is disabled by default. For more information, see  Host recovery
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html)
	// in the Amazon EC2 User Guide. Default: off
	HostRecovery types.HostRecovery

	// Specifies the instance family to be supported by the Dedicated Hosts. If you
	// specify an instance family, the Dedicated Hosts support multiple instance types
	// within that instance family. If you want the Dedicated Hosts to support a
	// specific instance type only, omit this parameter and specify InstanceType
	// instead. You cannot specify InstanceFamily and InstanceType in the same request.
	InstanceFamily *string

	// Specifies the instance type to be supported by the Dedicated Hosts. If you
	// specify an instance type, the Dedicated Hosts support instances of the specified
	// instance type only. If you want the Dedicated Hosts to support multiple instance
	// types in a specific instance family, omit this parameter and specify
	// InstanceFamily instead. You cannot specify InstanceType and InstanceFamily in
	// the same request.
	InstanceType *string

	// The tags to apply to the Dedicated Host during creation.
	TagSpecifications []types.TagSpecification
}

// Contains the output of AllocateHosts.
type AllocateHostsOutput struct {

	// The ID of the allocated Dedicated Host. This is used to launch an instance onto
	// a specific host.
	HostIds []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationAllocateHostsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpAllocateHosts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpAllocateHosts{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpAllocateHostsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAllocateHosts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAllocateHosts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "AllocateHosts",
	}
}
