#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
TAR=../turpial_$2+dfsg.orig.tar.gz
DIR=turpial-$2+dfsg.orig
UPSTREAM_DIR="$(tar tzf $3 | head -1)"

# clean up the upstream tarball
tar zxf $3
mv $UPSTREAM_DIR $DIR
rm -rf $DIR/turpial/data/fonts
find $DIR -type f -exec chmod 0644 {} \;
GZIP=--best tar -c -z -f $TAR $DIR --numeric-owner --owner 0 --group 0
rm -rf $3 $DIR
