import parser
import os

_TEST_DATA_FILES = [
    "./tests/data/source-gen-data-1"
]

def _get_callback_typedefs (parsed_data):
    return [parsed_datum for parsed_datum in parsed_data if parsed_datum['type'] == 'func_typedef' and parsed_datum['name'][1].endswith('Callback')]

def _get_function_defs (parsed_data):
    return [parsed_datum for parsed_datum in parsed_data if parsed_datum['type'] == 'func_decl']

import source_generator

for testdata in _TEST_DATA_FILES:
    parsed_data = parser.parse (open(testdata).read())
    callback_decls = _get_callback_typedefs (parsed_data)
    func_decls = _get_function_defs (parsed_data)

    result = source_generator.generate_sources_for (func_decls, callback_decls)

    open(testdata + ".result", "w+").write (result)


