/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};


static gpointer vala_member_access_parent_class = NULL;

#define VALA_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessPrivate))
static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);


/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}


ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_tmp9_ = _type_arg_index;
			_type_arg_index = _tmp9_ + 1;
			_tmp10_ = _type_arg_index;
			_tmp11_ = _type_arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _type_arg_list;
			_tmp13_ = _type_arg_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}


static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}


static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}


static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->type_argument_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->type_argument_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->type_argument_list;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}


static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}


static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp20_;
	gboolean _tmp604_ = FALSE;
	gboolean _tmp605_ = FALSE;
	ValaSymbol* _tmp606_;
	ValaSymbol* _tmp607_;
	ValaSymbol* _tmp635_;
	ValaSymbol* _tmp636_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp665_;
	ValaSymbol* _tmp666_;
	ValaSymbol* _tmp667_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp668_;
	ValaSymbol* _tmp669_;
	ValaSymbol* _tmp1096_;
	ValaSymbol* _tmp1097_;
	ValaVersionAttribute* _tmp1098_;
	ValaVersionAttribute* _tmp1099_;
	ValaSourceReference* _tmp1100_;
	ValaSourceReference* _tmp1101_;
	gboolean _tmp1102_ = FALSE;
	ValaSymbolAccessibility _tmp1103_;
	gboolean _tmp1164_ = FALSE;
	gboolean _tmp1165_;
	gboolean _tmp1204_ = FALSE;
	gboolean _tmp1205_ = FALSE;
	gboolean _tmp1206_;
	gboolean _tmp1476_;
	gboolean _tmp1477_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_tmp13_ = _type_arg_index;
			_type_arg_index = _tmp13_ + 1;
			_tmp14_ = _type_arg_index;
			_tmp15_ = _type_arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _type_arg_list;
			_tmp17_ = _type_arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp20_ = self->priv->_qualified;
	if (_tmp20_) {
		ValaNamespace* _tmp21_;
		ValaNamespace* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaScope* _tmp25_;
		ValaScope* _tmp26_;
		const gchar* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaSymbol* _tmp29_;
		_tmp21_ = vala_code_context_get_root (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp22_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp23_;
		_tmp24_ = base_symbol;
		_tmp25_ = vala_symbol_get_scope (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_member_name;
		_tmp28_ = vala_scope_lookup (_tmp26_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
	} else {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		if (_tmp31_ == NULL) {
			const gchar* _tmp32_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			ValaSymbol* _tmp46_;
			gboolean _tmp158_ = FALSE;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			_tmp32_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp32_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp33_;
				ValaSemanticAnalyzer* _tmp34_;
				_tmp33_ = vala_code_context_get_analyzer (context);
				_tmp34_ = _tmp33_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp34_)) {
					ValaSourceReference* _tmp35_;
					ValaSourceReference* _tmp36_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp36_ = _tmp35_;
					vala_report_error (_tmp36_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp37_ = vala_code_context_get_analyzer (context);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_semantic_analyzer_get_current_symbol (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = _vala_code_node_ref0 (_tmp40_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = _vala_code_node_ref0 (_tmp45_);
			sym = _tmp46_;
			while (TRUE) {
				gboolean _tmp47_ = FALSE;
				ValaSymbol* _tmp48_;
				gboolean _tmp51_;
				ValaSymbol* _tmp105_;
				const gchar* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp108_;
				gboolean _tmp109_ = FALSE;
				gboolean _tmp110_ = FALSE;
				ValaSymbol* _tmp111_;
				ValaSymbol* _tmp112_;
				ValaSymbol* _tmp151_;
				ValaSymbol* _tmp152_;
				ValaSymbol* _tmp154_;
				ValaSymbol* _tmp155_;
				ValaSymbol* _tmp156_;
				ValaSymbol* _tmp157_;
				_tmp48_ = sym;
				if (_tmp48_ != NULL) {
					ValaSymbol* _tmp49_;
					ValaSymbol* _tmp50_;
					_tmp49_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp50_ = _tmp49_;
					_tmp47_ = _tmp50_ == NULL;
				} else {
					_tmp47_ = FALSE;
				}
				if (!_tmp47_) {
					break;
				}
				_tmp51_ = method_found;
				if (!_tmp51_) {
					ValaSymbol* _tmp52_;
					_tmp52_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp52_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp53_;
						ValaCreationMethod* _tmp54_;
						ValaCreationMethod* _tmp55_;
						ValaParameter* _tmp56_;
						ValaParameter* _tmp57_;
						ValaParameter* _tmp58_;
						_tmp53_ = sym;
						_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp54_;
						_tmp55_ = cm;
						_tmp56_ = vala_method_get_this_parameter ((ValaMethod*) _tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp58_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp59_;
						_tmp59_ = sym;
						if (VALA_IS_PROPERTY (_tmp59_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp60_;
							ValaProperty* _tmp61_;
							ValaProperty* _tmp62_;
							ValaParameter* _tmp63_;
							ValaParameter* _tmp64_;
							ValaParameter* _tmp65_;
							ValaProperty* _tmp66_;
							ValaMemberBinding _tmp67_;
							ValaMemberBinding _tmp68_;
							ValaProperty* _tmp69_;
							ValaMemberBinding _tmp70_;
							ValaMemberBinding _tmp71_;
							_tmp60_ = sym;
							_tmp61_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp61_;
							_tmp62_ = prop;
							_tmp63_ = vala_property_get_this_parameter (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = _vala_code_node_ref0 (_tmp64_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp65_;
							_tmp66_ = prop;
							_tmp67_ = vala_property_get_binding (_tmp66_);
							_tmp68_ = _tmp67_;
							may_access_instance_members = _tmp68_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp69_ = prop;
							_tmp70_ = vala_property_get_binding (_tmp69_);
							_tmp71_ = _tmp70_;
							may_access_klass_members = _tmp71_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp72_;
							_tmp72_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp72_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaConstructor* _tmp75_;
								ValaParameter* _tmp76_;
								ValaParameter* _tmp77_;
								ValaParameter* _tmp78_;
								ValaConstructor* _tmp79_;
								ValaMemberBinding _tmp80_;
								ValaMemberBinding _tmp81_;
								_tmp73_ = sym;
								_tmp74_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp74_;
								_tmp75_ = c;
								_tmp76_ = vala_constructor_get_this_parameter (_tmp75_);
								_tmp77_ = _tmp76_;
								_tmp78_ = _vala_code_node_ref0 (_tmp77_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp78_;
								_tmp79_ = c;
								_tmp80_ = vala_constructor_get_binding (_tmp79_);
								_tmp81_ = _tmp80_;
								may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp82_;
								_tmp82_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp82_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaDestructor* _tmp85_;
									ValaParameter* _tmp86_;
									ValaParameter* _tmp87_;
									ValaParameter* _tmp88_;
									ValaDestructor* _tmp89_;
									ValaMemberBinding _tmp90_;
									ValaMemberBinding _tmp91_;
									_tmp83_ = sym;
									_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp84_;
									_tmp85_ = d;
									_tmp86_ = vala_destructor_get_this_parameter (_tmp85_);
									_tmp87_ = _tmp86_;
									_tmp88_ = _vala_code_node_ref0 (_tmp87_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp88_;
									_tmp89_ = d;
									_tmp90_ = vala_destructor_get_binding (_tmp89_);
									_tmp91_ = _tmp90_;
									may_access_instance_members = _tmp91_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp92_;
									_tmp92_ = sym;
									if (VALA_IS_METHOD (_tmp92_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMethod* _tmp95_;
										ValaParameter* _tmp96_;
										ValaParameter* _tmp97_;
										ValaParameter* _tmp98_;
										ValaMethod* _tmp99_;
										ValaMemberBinding _tmp100_;
										ValaMemberBinding _tmp101_;
										ValaMethod* _tmp102_;
										ValaMemberBinding _tmp103_;
										ValaMemberBinding _tmp104_;
										_tmp93_ = sym;
										_tmp94_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp94_;
										_tmp95_ = m;
										_tmp96_ = vala_method_get_this_parameter (_tmp95_);
										_tmp97_ = _tmp96_;
										_tmp98_ = _vala_code_node_ref0 (_tmp97_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp98_;
										_tmp99_ = m;
										_tmp100_ = vala_method_get_binding (_tmp99_);
										_tmp101_ = _tmp100_;
										may_access_instance_members = _tmp101_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp102_ = m;
										_tmp103_ = vala_method_get_binding (_tmp102_);
										_tmp104_ = _tmp103_;
										may_access_klass_members = _tmp104_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp105_ = sym;
				_tmp106_ = self->priv->_member_name;
				_tmp107_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp105_, _tmp106_);
				_tmp108_ = _tmp107_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp108_);
				_vala_code_node_unref0 (_tmp108_);
				_tmp111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp112_ = _tmp111_;
				if (_tmp112_ == NULL) {
					ValaSymbol* _tmp113_;
					_tmp113_ = sym;
					_tmp110_ = VALA_IS_TYPESYMBOL (_tmp113_);
				} else {
					_tmp110_ = FALSE;
				}
				if (_tmp110_) {
					gboolean _tmp114_;
					_tmp114_ = may_access_instance_members;
					_tmp109_ = _tmp114_;
				} else {
					_tmp109_ = FALSE;
				}
				if (_tmp109_) {
					ValaParameter* _tmp115_;
					ValaDataType* _tmp116_;
					ValaDataType* _tmp117_;
					const gchar* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					gboolean _tmp121_ = FALSE;
					ValaSymbol* _tmp122_;
					ValaSymbol* _tmp123_;
					_tmp115_ = this_parameter;
					_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = self->priv->_member_name;
					_tmp119_ = vala_data_type_get_member (_tmp117_, _tmp118_);
					_tmp120_ = _tmp119_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp120_);
					_vala_code_node_unref0 (_tmp120_);
					_tmp122_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp123_ = _tmp122_;
					if (_tmp123_ != NULL) {
						ValaSymbol* _tmp124_;
						ValaSymbol* _tmp125_;
						_tmp124_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp125_ = _tmp124_;
						_tmp121_ = vala_member_access_is_instance_symbol (_tmp125_);
					} else {
						_tmp121_ = FALSE;
					}
					if (_tmp121_) {
						ValaSourceReference* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaMemberAccess* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						ValaParameter* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaDataType* _tmp135_;
						ValaDataType* _tmp136_;
						ValaExpression* _tmp137_;
						ValaExpression* _tmp138_;
						ValaDataType* _tmp139_;
						ValaDataType* _tmp140_;
						ValaExpression* _tmp141_;
						ValaExpression* _tmp142_;
						ValaParameter* _tmp143_;
						ValaExpression* _tmp144_;
						ValaExpression* _tmp145_;
						ValaDataType* _tmp146_;
						ValaDataType* _tmp147_;
						const gchar* _tmp148_;
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp127_ = _tmp126_;
						_tmp128_ = vala_member_access_new (NULL, "this", _tmp127_);
						_tmp129_ = _tmp128_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp129_);
						_vala_code_node_unref0 (_tmp129_);
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						_tmp132_ = this_parameter;
						_tmp133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp132_);
						_tmp134_ = _tmp133_;
						_tmp135_ = vala_data_type_copy (_tmp134_);
						_tmp136_ = _tmp135_;
						vala_expression_set_value_type (_tmp131_, _tmp136_);
						_vala_code_node_unref0 (_tmp136_);
						_tmp137_ = vala_member_access_get_inner (self);
						_tmp138_ = _tmp137_;
						_tmp139_ = vala_expression_get_value_type (_tmp138_);
						_tmp140_ = _tmp139_;
						vala_data_type_set_value_owned (_tmp140_, FALSE);
						_tmp141_ = vala_member_access_get_inner (self);
						_tmp142_ = _tmp141_;
						_tmp143_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp142_, (ValaSymbol*) _tmp143_);
						_tmp144_ = vala_member_access_get_inner (self);
						_tmp145_ = _tmp144_;
						_tmp146_ = vala_expression_get_value_type (_tmp145_);
						_tmp147_ = _tmp146_;
						_tmp148_ = self->priv->_member_name;
						_tmp149_ = vala_data_type_get_member (_tmp147_, _tmp148_);
						_tmp150_ = _tmp149_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp150_);
						_vala_code_node_unref0 (_tmp150_);
					}
				}
				_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp152_ = _tmp151_;
				if (_tmp152_ == NULL) {
					ValaSymbol* _tmp153_;
					_tmp153_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp153_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp154_ = sym;
				_tmp155_ = vala_symbol_get_parent_symbol (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = _vala_code_node_ref0 (_tmp156_);
				_vala_code_node_unref0 (sym);
				sym = _tmp157_;
			}
			_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp160_ = _tmp159_;
			if (_tmp160_ == NULL) {
				ValaSourceReference* _tmp161_;
				ValaSourceReference* _tmp162_;
				_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp162_ = _tmp161_;
				_tmp158_ = _tmp162_ != NULL;
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp163_;
					ValaSourceReference* _tmp164_;
					ValaList* _tmp165_;
					ValaList* _tmp166_;
					ValaList* _tmp167_;
					gint _ns_size = 0;
					ValaList* _tmp168_;
					gint _tmp169_;
					gint _tmp170_;
					gint _ns_index = 0;
					_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_source_reference_get_using_directives (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = _vala_iterable_ref0 (_tmp166_);
					_ns_list = _tmp167_;
					_tmp168_ = _ns_list;
					_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
					_tmp170_ = _tmp169_;
					_ns_size = _tmp170_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp171_;
						gint _tmp172_;
						gint _tmp173_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp174_;
						gint _tmp175_;
						gpointer _tmp176_;
						ValaUsingDirective* _tmp177_;
						gboolean _tmp178_;
						gboolean _tmp179_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp180_;
						ValaSymbol* _tmp181_;
						ValaSymbol* _tmp182_;
						ValaScope* _tmp183_;
						ValaScope* _tmp184_;
						const gchar* _tmp185_;
						ValaSymbol* _tmp186_;
						ValaSymbol* _tmp187_;
						_tmp171_ = _ns_index;
						_ns_index = _tmp171_ + 1;
						_tmp172_ = _ns_index;
						_tmp173_ = _ns_size;
						if (!(_tmp172_ < _tmp173_)) {
							break;
						}
						_tmp174_ = _ns_list;
						_tmp175_ = _ns_index;
						_tmp176_ = vala_list_get (_tmp174_, _tmp175_);
						ns = (ValaUsingDirective*) _tmp176_;
						_tmp177_ = ns;
						_tmp178_ = vala_code_node_get_error ((ValaCodeNode*) _tmp177_);
						_tmp179_ = _tmp178_;
						if (_tmp179_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp180_ = ns;
						_tmp181_ = vala_using_directive_get_namespace_symbol (_tmp180_);
						_tmp182_ = _tmp181_;
						_tmp183_ = vala_symbol_get_scope (_tmp182_);
						_tmp184_ = _tmp183_;
						_tmp185_ = self->priv->_member_name;
						_tmp186_ = vala_scope_lookup (_tmp184_, _tmp185_);
						local_sym = _tmp186_;
						_tmp187_ = local_sym;
						if (_tmp187_ != NULL) {
							gboolean _tmp188_ = FALSE;
							ValaSymbol* _tmp189_;
							ValaSymbol* _tmp190_;
							ValaSymbol* _tmp206_;
							_tmp189_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp190_ = _tmp189_;
							if (_tmp190_ != NULL) {
								ValaSymbol* _tmp191_;
								ValaSymbol* _tmp192_;
								ValaSymbol* _tmp193_;
								_tmp191_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp192_ = _tmp191_;
								_tmp193_ = local_sym;
								_tmp188_ = _tmp192_ != _tmp193_;
							} else {
								_tmp188_ = FALSE;
							}
							if (_tmp188_) {
								ValaSourceReference* _tmp194_;
								ValaSourceReference* _tmp195_;
								const gchar* _tmp196_;
								ValaSymbol* _tmp197_;
								ValaSymbol* _tmp198_;
								gchar* _tmp199_;
								gchar* _tmp200_;
								ValaSymbol* _tmp201_;
								gchar* _tmp202_;
								gchar* _tmp203_;
								gchar* _tmp204_;
								gchar* _tmp205_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp195_ = _tmp194_;
								_tmp196_ = self->priv->_member_name;
								_tmp197_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp198_ = _tmp197_;
								_tmp199_ = vala_symbol_get_full_name (_tmp198_);
								_tmp200_ = _tmp199_;
								_tmp201_ = local_sym;
								_tmp202_ = vala_symbol_get_full_name (_tmp201_);
								_tmp203_ = _tmp202_;
								_tmp204_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp196_, _tmp200_, _tmp203_);
								_tmp205_ = _tmp204_;
								vala_report_error (_tmp195_, _tmp205_);
								_g_free0 (_tmp205_);
								_g_free0 (_tmp203_);
								_g_free0 (_tmp200_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp206_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp206_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp207_;
			ValaExpression* _tmp208_;
			gboolean _tmp209_;
			gboolean _tmp210_;
			ValaExpression* _tmp211_;
			ValaExpression* _tmp212_;
			ValaDataType* _tmp213_;
			ValaDataType* _tmp214_;
			ValaExpression* _tmp233_;
			ValaExpression* _tmp234_;
			gboolean _tmp250_ = FALSE;
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp274_ = FALSE;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			gboolean _tmp311_ = FALSE;
			gboolean _tmp312_ = FALSE;
			ValaSymbol* _tmp313_;
			ValaSymbol* _tmp314_;
			gboolean _tmp586_ = FALSE;
			ValaSymbol* _tmp587_;
			ValaSymbol* _tmp588_;
			_tmp207_ = vala_member_access_get_inner (self);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_code_node_get_error ((ValaCodeNode*) _tmp208_);
			_tmp210_ = _tmp209_;
			if (_tmp210_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp211_ = vala_member_access_get_inner (self);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_expression_get_value_type (_tmp212_);
			_tmp214_ = _tmp213_;
			if (VALA_IS_POINTER_TYPE (_tmp214_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp215_;
				ValaExpression* _tmp216_;
				ValaDataType* _tmp217_;
				ValaDataType* _tmp218_;
				ValaPointerType* _tmp219_;
				gboolean _tmp220_ = FALSE;
				ValaPointerType* _tmp221_;
				_tmp215_ = vala_member_access_get_inner (self);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_expression_get_value_type (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp218_) ? ((ValaPointerType*) _tmp218_) : NULL);
				pointer_type = _tmp219_;
				_tmp221_ = pointer_type;
				if (_tmp221_ != NULL) {
					ValaPointerType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					_tmp222_ = pointer_type;
					_tmp223_ = vala_pointer_type_get_base_type (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp220_ = VALA_IS_VALUE_TYPE (_tmp224_);
				} else {
					_tmp220_ = FALSE;
				}
				if (_tmp220_) {
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaPointerIndirection* _tmp229_;
					ValaPointerIndirection* _tmp230_;
					ValaExpression* _tmp231_;
					ValaExpression* _tmp232_;
					_tmp225_ = vala_member_access_get_inner (self);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_pointer_indirection_new (_tmp226_, _tmp228_);
					_tmp230_ = _tmp229_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp230_);
					_vala_code_node_unref0 (_tmp230_);
					_tmp231_ = vala_member_access_get_inner (self);
					_tmp232_ = _tmp231_;
					vala_code_node_check ((ValaCodeNode*) _tmp232_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp233_ = vala_member_access_get_inner (self);
			_tmp234_ = _tmp233_;
			if (VALA_IS_MEMBER_ACCESS (_tmp234_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp235_;
				ValaExpression* _tmp236_;
				ValaMemberAccess* _tmp237_;
				ValaMemberAccess* _tmp238_;
				gboolean _tmp239_;
				_tmp235_ = vala_member_access_get_inner (self);
				_tmp236_ = _tmp235_;
				_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp237_;
				_tmp238_ = ma;
				_tmp239_ = _tmp238_->priv->_prototype_access;
				if (_tmp239_) {
					ValaSourceReference* _tmp240_;
					ValaSourceReference* _tmp241_;
					ValaExpression* _tmp242_;
					ValaExpression* _tmp243_;
					ValaSymbol* _tmp244_;
					ValaSymbol* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					gchar* _tmp249_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp241_ = _tmp240_;
					_tmp242_ = vala_member_access_get_inner (self);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_symbol_get_full_name (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp247_);
					_tmp249_ = _tmp248_;
					vala_report_error (_tmp241_, _tmp249_);
					_g_free0 (_tmp249_);
					_g_free0 (_tmp247_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			if (VALA_IS_MEMBER_ACCESS (_tmp252_)) {
				_tmp250_ = TRUE;
			} else {
				ValaExpression* _tmp253_;
				ValaExpression* _tmp254_;
				_tmp253_ = vala_member_access_get_inner (self);
				_tmp254_ = _tmp253_;
				_tmp250_ = VALA_IS_BASE_ACCESS (_tmp254_);
			}
			if (_tmp250_) {
				ValaExpression* _tmp255_;
				ValaExpression* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaSymbol* _tmp258_;
				ValaSymbol* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				_tmp255_ = vala_member_access_get_inner (self);
				_tmp256_ = _tmp255_;
				_tmp257_ = vala_expression_get_symbol_reference (_tmp256_);
				_tmp258_ = _tmp257_;
				_tmp259_ = _vala_code_node_ref0 (_tmp258_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp262_ = _tmp261_;
				if (_tmp262_ == NULL) {
					gboolean _tmp263_ = FALSE;
					ValaSymbol* _tmp264_;
					_tmp264_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp264_)) {
						_tmp263_ = TRUE;
					} else {
						ValaSymbol* _tmp265_;
						_tmp265_ = base_symbol;
						_tmp263_ = VALA_IS_TYPESYMBOL (_tmp265_);
					}
					_tmp260_ = _tmp263_;
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaSymbol* _tmp266_;
					ValaScope* _tmp267_;
					ValaScope* _tmp268_;
					const gchar* _tmp269_;
					ValaSymbol* _tmp270_;
					ValaSymbol* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					_tmp266_ = base_symbol;
					_tmp267_ = vala_symbol_get_scope (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp269_ = self->priv->_member_name;
					_tmp270_ = vala_scope_lookup (_tmp268_, _tmp269_);
					_tmp271_ = _tmp270_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp271_);
					_vala_code_node_unref0 (_tmp271_);
					_tmp272_ = vala_member_access_get_inner (self);
					_tmp273_ = _tmp272_;
					if (VALA_IS_BASE_ACCESS (_tmp273_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp276_ = _tmp275_;
			if (_tmp276_ == NULL) {
				ValaExpression* _tmp277_;
				ValaExpression* _tmp278_;
				ValaDataType* _tmp279_;
				ValaDataType* _tmp280_;
				_tmp277_ = vala_member_access_get_inner (self);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_expression_get_value_type (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp274_ = _tmp280_ != NULL;
			} else {
				_tmp274_ = FALSE;
			}
			if (_tmp274_) {
				gboolean _tmp281_;
				ValaSymbol* _tmp309_;
				ValaSymbol* _tmp310_;
				_tmp281_ = self->priv->_pointer_member_access;
				if (_tmp281_) {
					ValaExpression* _tmp282_;
					ValaExpression* _tmp283_;
					ValaDataType* _tmp284_;
					ValaDataType* _tmp285_;
					const gchar* _tmp286_;
					ValaSymbol* _tmp287_;
					ValaSymbol* _tmp288_;
					_tmp282_ = vala_member_access_get_inner (self);
					_tmp283_ = _tmp282_;
					_tmp284_ = vala_expression_get_value_type (_tmp283_);
					_tmp285_ = _tmp284_;
					_tmp286_ = self->priv->_member_name;
					_tmp287_ = vala_data_type_get_pointer_member (_tmp285_, _tmp286_);
					_tmp288_ = _tmp287_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp288_);
					_vala_code_node_unref0 (_tmp288_);
				} else {
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					ValaTypeSymbol* _tmp293_;
					ValaTypeSymbol* _tmp294_;
					ValaExpression* _tmp302_;
					ValaExpression* _tmp303_;
					ValaDataType* _tmp304_;
					ValaDataType* _tmp305_;
					const gchar* _tmp306_;
					ValaSymbol* _tmp307_;
					ValaSymbol* _tmp308_;
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = vala_data_type_get_data_type (_tmp292_);
					_tmp294_ = _tmp293_;
					if (_tmp294_ != NULL) {
						ValaExpression* _tmp295_;
						ValaExpression* _tmp296_;
						ValaDataType* _tmp297_;
						ValaDataType* _tmp298_;
						ValaTypeSymbol* _tmp299_;
						ValaTypeSymbol* _tmp300_;
						ValaSymbol* _tmp301_;
						_tmp295_ = vala_member_access_get_inner (self);
						_tmp296_ = _tmp295_;
						_tmp297_ = vala_expression_get_value_type (_tmp296_);
						_tmp298_ = _tmp297_;
						_tmp299_ = vala_data_type_get_data_type (_tmp298_);
						_tmp300_ = _tmp299_;
						_tmp301_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp300_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp301_;
					}
					_tmp302_ = vala_member_access_get_inner (self);
					_tmp303_ = _tmp302_;
					_tmp304_ = vala_expression_get_value_type (_tmp303_);
					_tmp305_ = _tmp304_;
					_tmp306_ = self->priv->_member_name;
					_tmp307_ = vala_data_type_get_member (_tmp305_, _tmp306_);
					_tmp308_ = _tmp307_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp308_);
					_vala_code_node_unref0 (_tmp308_);
				}
				_tmp309_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp310_ = _tmp309_;
				if (_tmp310_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp313_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp314_ = _tmp313_;
			if (_tmp314_ == NULL) {
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				_tmp315_ = vala_member_access_get_inner (self);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_expression_get_value_type (_tmp316_);
				_tmp318_ = _tmp317_;
				_tmp312_ = _tmp318_ != NULL;
			} else {
				_tmp312_ = FALSE;
			}
			if (_tmp312_) {
				ValaExpression* _tmp319_;
				ValaExpression* _tmp320_;
				ValaDataType* _tmp321_;
				ValaDataType* _tmp322_;
				gboolean _tmp323_;
				gboolean _tmp324_;
				_tmp319_ = vala_member_access_get_inner (self);
				_tmp320_ = _tmp319_;
				_tmp321_ = vala_expression_get_value_type (_tmp320_);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_data_type_get_is_dynamic (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp311_ = _tmp324_;
			} else {
				_tmp311_ = FALSE;
			}
			if (_tmp311_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				ValaDataType* _tmp327_;
				ValaDataType* _tmp328_;
				ValaObjectType* _tmp329_;
				ValaCodeNode* _tmp330_;
				ValaCodeNode* _tmp331_;
				ValaSymbol* _tmp534_;
				ValaSymbol* _tmp535_;
				ValaSymbol* _tmp584_;
				ValaSymbol* _tmp585_;
				_tmp325_ = vala_member_access_get_inner (self);
				_tmp326_ = _tmp325_;
				_tmp327_ = vala_expression_get_value_type (_tmp326_);
				_tmp328_ = _tmp327_;
				_tmp329_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp328_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp329_;
				_tmp330_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp331_ = _tmp330_;
				if (VALA_IS_METHOD_CALL (_tmp331_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp332_;
					ValaCodeNode* _tmp333_;
					ValaMethodCall* _tmp334_;
					ValaMethodCall* _tmp335_;
					ValaExpression* _tmp336_;
					ValaExpression* _tmp337_;
					_tmp332_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp333_ = _tmp332_;
					_tmp334_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp333_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp334_;
					_tmp335_ = invoc;
					_tmp336_ = vala_method_call_get_call (_tmp335_);
					_tmp337_ = _tmp336_;
					if (_tmp337_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp338_;
						ValaDataType* _tmp339_;
						ValaDataType* _tmp340_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp355_;
						ValaExpression* _tmp356_;
						ValaDataType* _tmp357_;
						ValaDataType* _tmp358_;
						const gchar* _tmp359_;
						ValaDataType* _tmp360_;
						ValaSourceReference* _tmp361_;
						ValaSourceReference* _tmp362_;
						ValaDynamicMethod* _tmp363_;
						ValaDynamicMethod* _tmp364_;
						ValaMethodCall* _tmp365_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp366_;
						ValaErrorType* _tmp367_;
						ValaDynamicMethod* _tmp368_;
						ValaErrorType* _tmp369_;
						ValaDynamicMethod* _tmp370_;
						ValaDynamicMethod* _tmp371_;
						ValaParameter* _tmp372_;
						ValaParameter* _tmp373_;
						ValaDynamicMethod* _tmp374_;
						ValaObjectType* _tmp375_;
						ValaDataType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaParameter* _tmp378_;
						ValaParameter* _tmp379_;
						ValaObjectType* _tmp380_;
						ValaObjectTypeSymbol* _tmp381_;
						ValaObjectTypeSymbol* _tmp382_;
						ValaScope* _tmp383_;
						ValaScope* _tmp384_;
						ValaDynamicMethod* _tmp385_;
						ValaDynamicMethod* _tmp386_;
						_tmp338_ = invoc;
						_tmp339_ = vala_expression_get_target_type ((ValaExpression*) _tmp338_);
						_tmp340_ = _tmp339_;
						if (_tmp340_ != NULL) {
							ValaMethodCall* _tmp341_;
							ValaDataType* _tmp342_;
							ValaDataType* _tmp343_;
							ValaDataType* _tmp344_;
							ValaDataType* _tmp345_;
							_tmp341_ = invoc;
							_tmp342_ = vala_expression_get_target_type ((ValaExpression*) _tmp341_);
							_tmp343_ = _tmp342_;
							_tmp344_ = vala_data_type_copy (_tmp343_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp344_;
							_tmp345_ = ret_type;
							vala_data_type_set_value_owned (_tmp345_, TRUE);
						} else {
							ValaMethodCall* _tmp346_;
							ValaCodeNode* _tmp347_;
							ValaCodeNode* _tmp348_;
							_tmp346_ = invoc;
							_tmp347_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp346_);
							_tmp348_ = _tmp347_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp348_)) {
								ValaVoidType* _tmp349_;
								_tmp349_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp349_;
							} else {
								ValaExpression* _tmp350_;
								ValaExpression* _tmp351_;
								ValaDataType* _tmp352_;
								ValaDataType* _tmp353_;
								ValaDataType* _tmp354_;
								_tmp350_ = vala_member_access_get_inner (self);
								_tmp351_ = _tmp350_;
								_tmp352_ = vala_expression_get_value_type (_tmp351_);
								_tmp353_ = _tmp352_;
								_tmp354_ = vala_data_type_copy (_tmp353_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp354_;
							}
						}
						_tmp355_ = vala_member_access_get_inner (self);
						_tmp356_ = _tmp355_;
						_tmp357_ = vala_expression_get_value_type (_tmp356_);
						_tmp358_ = _tmp357_;
						_tmp359_ = self->priv->_member_name;
						_tmp360_ = ret_type;
						_tmp361_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp362_ = _tmp361_;
						_tmp363_ = vala_dynamic_method_new (_tmp358_, _tmp359_, _tmp360_, _tmp362_, NULL);
						m = _tmp363_;
						_tmp364_ = m;
						_tmp365_ = invoc;
						vala_dynamic_method_set_invocation (_tmp364_, _tmp365_);
						_tmp366_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp366_;
						_tmp367_ = err;
						vala_error_type_set_dynamic_error (_tmp367_, TRUE);
						_tmp368_ = m;
						_tmp369_ = err;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp368_, (ValaDataType*) _tmp369_);
						_tmp370_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp370_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp371_ = m;
						_tmp372_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp373_ = _tmp372_;
						vala_callable_add_parameter ((ValaCallable*) _tmp371_, _tmp373_);
						_vala_code_node_unref0 (_tmp373_);
						_tmp374_ = m;
						_tmp375_ = dynamic_object_type;
						_tmp376_ = vala_data_type_copy ((ValaDataType*) _tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_parameter_new ("this", _tmp377_, NULL);
						_tmp379_ = _tmp378_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp374_, _tmp379_);
						_vala_code_node_unref0 (_tmp379_);
						_vala_code_node_unref0 (_tmp377_);
						_tmp380_ = dynamic_object_type;
						_tmp381_ = vala_object_type_get_type_symbol (_tmp380_);
						_tmp382_ = _tmp381_;
						_tmp383_ = vala_symbol_get_scope ((ValaSymbol*) _tmp382_);
						_tmp384_ = _tmp383_;
						_tmp385_ = m;
						vala_scope_add (_tmp384_, NULL, (ValaSymbol*) _tmp385_);
						_tmp386_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp386_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp387_;
					ValaCodeNode* _tmp388_;
					_tmp387_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp388_ = _tmp387_;
					if (VALA_IS_ASSIGNMENT (_tmp388_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp389_;
						ValaCodeNode* _tmp390_;
						ValaAssignment* _tmp391_;
						gboolean _tmp392_ = FALSE;
						ValaAssignment* _tmp393_;
						ValaExpression* _tmp394_;
						ValaExpression* _tmp395_;
						_tmp389_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp390_ = _tmp389_;
						_tmp391_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp390_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp391_;
						_tmp393_ = a;
						_tmp394_ = vala_assignment_get_left (_tmp393_);
						_tmp395_ = _tmp394_;
						if (_tmp395_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							gboolean _tmp396_ = FALSE;
							ValaAssignment* _tmp397_;
							ValaAssignmentOperator _tmp398_;
							ValaAssignmentOperator _tmp399_;
							_tmp397_ = a;
							_tmp398_ = vala_assignment_get_operator (_tmp397_);
							_tmp399_ = _tmp398_;
							if (_tmp399_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
								_tmp396_ = TRUE;
							} else {
								ValaAssignment* _tmp400_;
								ValaAssignmentOperator _tmp401_;
								ValaAssignmentOperator _tmp402_;
								_tmp400_ = a;
								_tmp401_ = vala_assignment_get_operator (_tmp400_);
								_tmp402_ = _tmp401_;
								_tmp396_ = _tmp402_ == VALA_ASSIGNMENT_OPERATOR_SUB;
							}
							_tmp392_ = _tmp396_;
						} else {
							_tmp392_ = FALSE;
						}
						if (_tmp392_) {
							ValaDynamicSignal* s = NULL;
							ValaExpression* _tmp403_;
							ValaExpression* _tmp404_;
							ValaDataType* _tmp405_;
							ValaDataType* _tmp406_;
							const gchar* _tmp407_;
							ValaVoidType* _tmp408_;
							ValaVoidType* _tmp409_;
							ValaSourceReference* _tmp410_;
							ValaSourceReference* _tmp411_;
							ValaDynamicSignal* _tmp412_;
							ValaDynamicSignal* _tmp413_;
							ValaDynamicSignal* _tmp414_;
							ValaAssignment* _tmp415_;
							ValaExpression* _tmp416_;
							ValaExpression* _tmp417_;
							ValaDynamicSignal* _tmp418_;
							ValaObjectType* _tmp419_;
							ValaObjectTypeSymbol* _tmp420_;
							ValaObjectTypeSymbol* _tmp421_;
							ValaScope* _tmp422_;
							ValaScope* _tmp423_;
							ValaDynamicSignal* _tmp424_;
							ValaDynamicSignal* _tmp425_;
							_tmp403_ = vala_member_access_get_inner (self);
							_tmp404_ = _tmp403_;
							_tmp405_ = vala_expression_get_value_type (_tmp404_);
							_tmp406_ = _tmp405_;
							_tmp407_ = self->priv->_member_name;
							_tmp408_ = vala_void_type_new (NULL);
							_tmp409_ = _tmp408_;
							_tmp410_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp411_ = _tmp410_;
							_tmp412_ = vala_dynamic_signal_new (_tmp406_, _tmp407_, (ValaDataType*) _tmp409_, _tmp411_, NULL);
							_tmp413_ = _tmp412_;
							_vala_code_node_unref0 (_tmp409_);
							s = _tmp413_;
							_tmp414_ = s;
							_tmp415_ = a;
							_tmp416_ = vala_assignment_get_right (_tmp415_);
							_tmp417_ = _tmp416_;
							vala_dynamic_signal_set_handler (_tmp414_, _tmp417_);
							_tmp418_ = s;
							vala_symbol_set_access ((ValaSymbol*) _tmp418_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp419_ = dynamic_object_type;
							_tmp420_ = vala_object_type_get_type_symbol (_tmp419_);
							_tmp421_ = _tmp420_;
							_tmp422_ = vala_symbol_get_scope ((ValaSymbol*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = s;
							vala_scope_add (_tmp423_, NULL, (ValaSymbol*) _tmp424_);
							_tmp425_ = s;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp425_);
							_vala_code_node_unref0 (s);
						} else {
							ValaAssignment* _tmp426_;
							ValaExpression* _tmp427_;
							ValaExpression* _tmp428_;
							_tmp426_ = a;
							_tmp427_ = vala_assignment_get_left (_tmp426_);
							_tmp428_ = _tmp427_;
							if (_tmp428_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
								ValaDynamicProperty* prop = NULL;
								ValaExpression* _tmp429_;
								ValaExpression* _tmp430_;
								ValaDataType* _tmp431_;
								ValaDataType* _tmp432_;
								const gchar* _tmp433_;
								ValaSourceReference* _tmp434_;
								ValaSourceReference* _tmp435_;
								ValaDynamicProperty* _tmp436_;
								ValaDynamicProperty* _tmp437_;
								ValaDynamicProperty* _tmp438_;
								ValaDynamicProperty* _tmp439_;
								ValaSourceReference* _tmp440_;
								ValaSourceReference* _tmp441_;
								ValaPropertyAccessor* _tmp442_;
								ValaPropertyAccessor* _tmp443_;
								ValaDynamicProperty* _tmp444_;
								ValaExpression* _tmp445_;
								ValaExpression* _tmp446_;
								ValaDataType* _tmp447_;
								ValaDataType* _tmp448_;
								ValaTypeSymbol* _tmp449_;
								ValaTypeSymbol* _tmp450_;
								ValaScope* _tmp451_;
								ValaScope* _tmp452_;
								ValaObjectType* _tmp453_;
								ValaObjectTypeSymbol* _tmp454_;
								ValaObjectTypeSymbol* _tmp455_;
								ValaScope* _tmp456_;
								ValaScope* _tmp457_;
								ValaDynamicProperty* _tmp458_;
								ValaDynamicProperty* _tmp459_;
								_tmp429_ = vala_member_access_get_inner (self);
								_tmp430_ = _tmp429_;
								_tmp431_ = vala_expression_get_value_type (_tmp430_);
								_tmp432_ = _tmp431_;
								_tmp433_ = self->priv->_member_name;
								_tmp434_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp435_ = _tmp434_;
								_tmp436_ = vala_dynamic_property_new (_tmp432_, _tmp433_, _tmp435_, NULL);
								prop = _tmp436_;
								_tmp437_ = prop;
								vala_symbol_set_access ((ValaSymbol*) _tmp437_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp438_ = prop;
								_tmp439_ = prop;
								_tmp440_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp439_);
								_tmp441_ = _tmp440_;
								_tmp442_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp441_, NULL);
								_tmp443_ = _tmp442_;
								vala_property_set_set_accessor ((ValaProperty*) _tmp438_, _tmp443_);
								_vala_code_node_unref0 (_tmp443_);
								_tmp444_ = prop;
								_tmp445_ = vala_member_access_get_inner (self);
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_expression_get_value_type (_tmp446_);
								_tmp448_ = _tmp447_;
								_tmp449_ = vala_data_type_get_data_type (_tmp448_);
								_tmp450_ = _tmp449_;
								_tmp451_ = vala_symbol_get_scope ((ValaSymbol*) _tmp450_);
								_tmp452_ = _tmp451_;
								vala_symbol_set_owner ((ValaSymbol*) _tmp444_, _tmp452_);
								_tmp453_ = dynamic_object_type;
								_tmp454_ = vala_object_type_get_type_symbol (_tmp453_);
								_tmp455_ = _tmp454_;
								_tmp456_ = vala_symbol_get_scope ((ValaSymbol*) _tmp455_);
								_tmp457_ = _tmp456_;
								_tmp458_ = prop;
								vala_scope_add (_tmp457_, NULL, (ValaSymbol*) _tmp458_);
								_tmp459_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp459_);
								_vala_code_node_unref0 (prop);
							}
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp460_ = FALSE;
						gboolean _tmp461_ = FALSE;
						ValaCodeNode* _tmp462_;
						ValaCodeNode* _tmp463_;
						_tmp462_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp463_ = _tmp462_;
						if (VALA_IS_MEMBER_ACCESS (_tmp463_)) {
							ValaExpression* _tmp464_;
							ValaExpression* _tmp465_;
							_tmp464_ = vala_member_access_get_inner (self);
							_tmp465_ = _tmp464_;
							_tmp461_ = VALA_IS_MEMBER_ACCESS (_tmp465_);
						} else {
							_tmp461_ = FALSE;
						}
						if (_tmp461_) {
							ValaCodeNode* _tmp466_;
							ValaCodeNode* _tmp467_;
							ValaCodeNode* _tmp468_;
							ValaCodeNode* _tmp469_;
							_tmp466_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp467_ = _tmp466_;
							_tmp468_ = vala_code_node_get_parent_node (_tmp467_);
							_tmp469_ = _tmp468_;
							_tmp460_ = VALA_IS_METHOD_CALL (_tmp469_);
						} else {
							_tmp460_ = FALSE;
						}
						if (_tmp460_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp470_;
							ValaCodeNode* _tmp471_;
							ValaMemberAccess* _tmp472_;
							gboolean _tmp473_ = FALSE;
							ValaMemberAccess* _tmp474_;
							const gchar* _tmp475_;
							_tmp470_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp471_ = _tmp470_;
							_tmp472_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp471_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp472_;
							_tmp474_ = ma;
							_tmp475_ = _tmp474_->priv->_member_name;
							if (g_strcmp0 (_tmp475_, "connect") == 0) {
								_tmp473_ = TRUE;
							} else {
								ValaMemberAccess* _tmp476_;
								const gchar* _tmp477_;
								_tmp476_ = ma;
								_tmp477_ = _tmp476_->priv->_member_name;
								_tmp473_ = g_strcmp0 (_tmp477_, "connect_after") == 0;
							}
							if (_tmp473_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp478_;
								ValaExpression* _tmp479_;
								ValaDataType* _tmp480_;
								ValaDataType* _tmp481_;
								const gchar* _tmp482_;
								ValaVoidType* _tmp483_;
								ValaVoidType* _tmp484_;
								ValaSourceReference* _tmp485_;
								ValaSourceReference* _tmp486_;
								ValaDynamicSignal* _tmp487_;
								ValaDynamicSignal* _tmp488_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp489_;
								ValaCodeNode* _tmp490_;
								ValaCodeNode* _tmp491_;
								ValaCodeNode* _tmp492_;
								ValaMethodCall* _tmp493_;
								ValaMethodCall* _tmp494_;
								ValaList* _tmp495_;
								ValaList* _tmp496_;
								gint _tmp497_;
								gint _tmp498_;
								gboolean _tmp499_;
								ValaDynamicSignal* _tmp526_;
								ValaObjectType* _tmp527_;
								ValaObjectTypeSymbol* _tmp528_;
								ValaObjectTypeSymbol* _tmp529_;
								ValaScope* _tmp530_;
								ValaScope* _tmp531_;
								ValaDynamicSignal* _tmp532_;
								ValaDynamicSignal* _tmp533_;
								_tmp478_ = vala_member_access_get_inner (self);
								_tmp479_ = _tmp478_;
								_tmp480_ = vala_expression_get_value_type (_tmp479_);
								_tmp481_ = _tmp480_;
								_tmp482_ = self->priv->_member_name;
								_tmp483_ = vala_void_type_new (NULL);
								_tmp484_ = _tmp483_;
								_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp486_ = _tmp485_;
								_tmp487_ = vala_dynamic_signal_new (_tmp481_, _tmp482_, (ValaDataType*) _tmp484_, _tmp486_, NULL);
								_tmp488_ = _tmp487_;
								_vala_code_node_unref0 (_tmp484_);
								s = _tmp488_;
								_tmp489_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp490_ = _tmp489_;
								_tmp491_ = vala_code_node_get_parent_node (_tmp490_);
								_tmp492_ = _tmp491_;
								_tmp493_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp492_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp493_;
								_tmp494_ = mcall;
								_tmp495_ = vala_method_call_get_argument_list (_tmp494_);
								_tmp496_ = _tmp495_;
								_tmp497_ = vala_collection_get_size ((ValaCollection*) _tmp496_);
								_tmp498_ = _tmp497_;
								_tmp499_ = _tmp498_ > 0;
								_vala_iterable_unref0 (_tmp496_);
								if (_tmp499_) {
									ValaDynamicSignal* _tmp500_;
									ValaMethodCall* _tmp501_;
									ValaList* _tmp502_;
									ValaList* _tmp503_;
									gpointer _tmp504_;
									ValaExpression* _tmp505_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp506_;
									ValaExpression* _tmp507_;
									ValaExpression* _tmp508_;
									gboolean _tmp509_ = FALSE;
									gboolean _tmp510_ = FALSE;
									ValaMemberAccess* _tmp511_;
									_tmp500_ = s;
									_tmp501_ = mcall;
									_tmp502_ = vala_method_call_get_argument_list (_tmp501_);
									_tmp503_ = _tmp502_;
									_tmp504_ = vala_list_get (_tmp503_, 0);
									_tmp505_ = (ValaExpression*) _tmp504_;
									vala_dynamic_signal_set_handler (_tmp500_, _tmp505_);
									_vala_code_node_unref0 (_tmp505_);
									_vala_iterable_unref0 (_tmp503_);
									_tmp506_ = s;
									_tmp507_ = vala_dynamic_signal_get_handler (_tmp506_);
									_tmp508_ = _tmp507_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp508_) ? ((ValaMemberAccess*) _tmp508_) : NULL;
									_tmp511_ = arg;
									if (_tmp511_ == NULL) {
										_tmp510_ = TRUE;
									} else {
										ValaMemberAccess* _tmp512_;
										_tmp512_ = arg;
										_tmp510_ = !vala_code_node_check ((ValaCodeNode*) _tmp512_, context);
									}
									if (_tmp510_) {
										_tmp509_ = TRUE;
									} else {
										ValaMemberAccess* _tmp513_;
										ValaSymbol* _tmp514_;
										ValaSymbol* _tmp515_;
										_tmp513_ = arg;
										_tmp514_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp513_);
										_tmp515_ = _tmp514_;
										_tmp509_ = !VALA_IS_METHOD (_tmp515_);
									}
									if (_tmp509_) {
										ValaDynamicSignal* _tmp516_;
										ValaExpression* _tmp517_;
										ValaExpression* _tmp518_;
										ValaSourceReference* _tmp519_;
										ValaSourceReference* _tmp520_;
										ValaDynamicSignal* _tmp521_;
										gchar* _tmp522_;
										gchar* _tmp523_;
										gchar* _tmp524_;
										gchar* _tmp525_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp516_ = s;
										_tmp517_ = vala_dynamic_signal_get_handler (_tmp516_);
										_tmp518_ = _tmp517_;
										_tmp519_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp518_);
										_tmp520_ = _tmp519_;
										_tmp521_ = s;
										_tmp522_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp521_);
										_tmp523_ = _tmp522_;
										_tmp524_ = g_strdup_printf ("Invalid handler for `%s'", _tmp523_);
										_tmp525_ = _tmp524_;
										vala_report_error (_tmp520_, _tmp525_);
										_g_free0 (_tmp525_);
										_g_free0 (_tmp523_);
									}
								}
								_tmp526_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp526_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp527_ = dynamic_object_type;
								_tmp528_ = vala_object_type_get_type_symbol (_tmp527_);
								_tmp529_ = _tmp528_;
								_tmp530_ = vala_symbol_get_scope ((ValaSymbol*) _tmp529_);
								_tmp531_ = _tmp530_;
								_tmp532_ = s;
								vala_scope_add (_tmp531_, NULL, (ValaSymbol*) _tmp532_);
								_tmp533_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp533_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp534_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp535_ = _tmp534_;
				if (_tmp535_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp536_;
					ValaExpression* _tmp537_;
					ValaDataType* _tmp538_;
					ValaDataType* _tmp539_;
					const gchar* _tmp540_;
					ValaSourceReference* _tmp541_;
					ValaSourceReference* _tmp542_;
					ValaDynamicProperty* _tmp543_;
					ValaDataType* _tmp544_;
					ValaDataType* _tmp545_;
					ValaDynamicProperty* _tmp556_;
					ValaDynamicProperty* _tmp557_;
					ValaDynamicProperty* _tmp558_;
					ValaDataType* _tmp559_;
					ValaDataType* _tmp560_;
					ValaDataType* _tmp561_;
					ValaDataType* _tmp562_;
					ValaDynamicProperty* _tmp563_;
					ValaSourceReference* _tmp564_;
					ValaSourceReference* _tmp565_;
					ValaPropertyAccessor* _tmp566_;
					ValaPropertyAccessor* _tmp567_;
					ValaDynamicProperty* _tmp568_;
					ValaExpression* _tmp569_;
					ValaExpression* _tmp570_;
					ValaDataType* _tmp571_;
					ValaDataType* _tmp572_;
					ValaTypeSymbol* _tmp573_;
					ValaTypeSymbol* _tmp574_;
					ValaScope* _tmp575_;
					ValaScope* _tmp576_;
					ValaObjectType* _tmp577_;
					ValaObjectTypeSymbol* _tmp578_;
					ValaObjectTypeSymbol* _tmp579_;
					ValaScope* _tmp580_;
					ValaScope* _tmp581_;
					ValaDynamicProperty* _tmp582_;
					ValaDynamicProperty* _tmp583_;
					_tmp536_ = vala_member_access_get_inner (self);
					_tmp537_ = _tmp536_;
					_tmp538_ = vala_expression_get_value_type (_tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = self->priv->_member_name;
					_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp542_ = _tmp541_;
					_tmp543_ = vala_dynamic_property_new (_tmp539_, _tmp540_, _tmp542_, NULL);
					prop = _tmp543_;
					_tmp544_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp545_ = _tmp544_;
					if (_tmp545_ != NULL) {
						ValaDynamicProperty* _tmp546_;
						ValaDataType* _tmp547_;
						ValaDataType* _tmp548_;
						_tmp546_ = prop;
						_tmp547_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp548_ = _tmp547_;
						vala_property_set_property_type ((ValaProperty*) _tmp546_, _tmp548_);
					} else {
						ValaDynamicProperty* _tmp549_;
						ValaExpression* _tmp550_;
						ValaExpression* _tmp551_;
						ValaDataType* _tmp552_;
						ValaDataType* _tmp553_;
						ValaDataType* _tmp554_;
						ValaDataType* _tmp555_;
						_tmp549_ = prop;
						_tmp550_ = vala_member_access_get_inner (self);
						_tmp551_ = _tmp550_;
						_tmp552_ = vala_expression_get_value_type (_tmp551_);
						_tmp553_ = _tmp552_;
						_tmp554_ = vala_data_type_copy (_tmp553_);
						_tmp555_ = _tmp554_;
						vala_property_set_property_type ((ValaProperty*) _tmp549_, _tmp555_);
						_vala_code_node_unref0 (_tmp555_);
					}
					_tmp556_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp556_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp557_ = prop;
					_tmp558_ = prop;
					_tmp559_ = vala_property_get_property_type ((ValaProperty*) _tmp558_);
					_tmp560_ = _tmp559_;
					_tmp561_ = vala_data_type_copy (_tmp560_);
					_tmp562_ = _tmp561_;
					_tmp563_ = prop;
					_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp563_);
					_tmp565_ = _tmp564_;
					_tmp566_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp562_, NULL, _tmp565_, NULL);
					_tmp567_ = _tmp566_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp557_, _tmp567_);
					_vala_code_node_unref0 (_tmp567_);
					_vala_code_node_unref0 (_tmp562_);
					_tmp568_ = prop;
					_tmp569_ = vala_member_access_get_inner (self);
					_tmp570_ = _tmp569_;
					_tmp571_ = vala_expression_get_value_type (_tmp570_);
					_tmp572_ = _tmp571_;
					_tmp573_ = vala_data_type_get_data_type (_tmp572_);
					_tmp574_ = _tmp573_;
					_tmp575_ = vala_symbol_get_scope ((ValaSymbol*) _tmp574_);
					_tmp576_ = _tmp575_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp568_, _tmp576_);
					_tmp577_ = dynamic_object_type;
					_tmp578_ = vala_object_type_get_type_symbol (_tmp577_);
					_tmp579_ = _tmp578_;
					_tmp580_ = vala_symbol_get_scope ((ValaSymbol*) _tmp579_);
					_tmp581_ = _tmp580_;
					_tmp582_ = prop;
					vala_scope_add (_tmp581_, NULL, (ValaSymbol*) _tmp582_);
					_tmp583_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp583_);
					_vala_code_node_unref0 (prop);
				}
				_tmp584_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp585_ = _tmp584_;
				if (_tmp585_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp587_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp588_ = _tmp587_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp588_)) {
				ValaExpression* _tmp589_;
				ValaExpression* _tmp590_;
				ValaDataType* _tmp591_;
				ValaDataType* _tmp592_;
				_tmp589_ = vala_member_access_get_inner (self);
				_tmp590_ = _tmp589_;
				_tmp591_ = vala_expression_get_value_type (_tmp590_);
				_tmp592_ = _tmp591_;
				_tmp586_ = VALA_IS_ARRAY_TYPE (_tmp592_);
			} else {
				_tmp586_ = FALSE;
			}
			if (_tmp586_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp593_;
				ValaExpression* _tmp594_;
				ValaDataType* _tmp595_;
				ValaDataType* _tmp596_;
				gboolean _tmp597_ = FALSE;
				ValaArrayType* _tmp598_;
				_tmp593_ = vala_member_access_get_inner (self);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_expression_get_value_type (_tmp594_);
				_tmp596_ = _tmp595_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp596_) ? ((ValaArrayType*) _tmp596_) : NULL;
				_tmp598_ = value_array_type;
				if (_tmp598_ != NULL) {
					ValaArrayType* _tmp599_;
					gboolean _tmp600_;
					gboolean _tmp601_;
					_tmp599_ = value_array_type;
					_tmp600_ = vala_array_type_get_inline_allocated (_tmp599_);
					_tmp601_ = _tmp600_;
					_tmp597_ = _tmp601_;
				} else {
					_tmp597_ = FALSE;
				}
				if (_tmp597_) {
					ValaSourceReference* _tmp602_;
					ValaSourceReference* _tmp603_;
					_tmp602_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp603_ = _tmp602_;
					vala_report_error (_tmp603_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp606_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp607_ = _tmp606_;
	if (_tmp607_ == NULL) {
		ValaDataType* _tmp608_;
		ValaDataType* _tmp609_;
		_tmp608_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp609_ = _tmp608_;
		_tmp605_ = _tmp609_ != NULL;
	} else {
		_tmp605_ = FALSE;
	}
	if (_tmp605_) {
		ValaDataType* _tmp610_;
		ValaDataType* _tmp611_;
		ValaTypeSymbol* _tmp612_;
		ValaTypeSymbol* _tmp613_;
		_tmp610_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp611_ = _tmp610_;
		_tmp612_ = vala_data_type_get_data_type (_tmp611_);
		_tmp613_ = _tmp612_;
		_tmp604_ = VALA_IS_ENUM (_tmp613_);
	} else {
		_tmp604_ = FALSE;
	}
	if (_tmp604_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp614_;
		ValaDataType* _tmp615_;
		ValaTypeSymbol* _tmp616_;
		ValaTypeSymbol* _tmp617_;
		ValaEnum* _tmp618_;
		_tmp614_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp615_ = _tmp614_;
		_tmp616_ = vala_data_type_get_data_type (_tmp615_);
		_tmp617_ = _tmp616_;
		_tmp618_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp617_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp618_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp619_;
			ValaList* _tmp620_;
			gint _val_size = 0;
			ValaList* _tmp621_;
			gint _tmp622_;
			gint _tmp623_;
			gint _val_index = 0;
			_tmp619_ = enum_type;
			_tmp620_ = vala_enum_get_values (_tmp619_);
			_val_list = _tmp620_;
			_tmp621_ = _val_list;
			_tmp622_ = vala_collection_get_size ((ValaCollection*) _tmp621_);
			_tmp623_ = _tmp622_;
			_val_size = _tmp623_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp624_;
				gint _tmp625_;
				gint _tmp626_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp627_;
				gint _tmp628_;
				gpointer _tmp629_;
				const gchar* _tmp630_;
				ValaEnumValue* _tmp631_;
				const gchar* _tmp632_;
				const gchar* _tmp633_;
				_tmp624_ = _val_index;
				_val_index = _tmp624_ + 1;
				_tmp625_ = _val_index;
				_tmp626_ = _val_size;
				if (!(_tmp625_ < _tmp626_)) {
					break;
				}
				_tmp627_ = _val_list;
				_tmp628_ = _val_index;
				_tmp629_ = vala_list_get (_tmp627_, _tmp628_);
				val = (ValaEnumValue*) _tmp629_;
				_tmp630_ = self->priv->_member_name;
				_tmp631_ = val;
				_tmp632_ = vala_symbol_get_name ((ValaSymbol*) _tmp631_);
				_tmp633_ = _tmp632_;
				if (g_strcmp0 (_tmp630_, _tmp633_) == 0) {
					ValaEnumValue* _tmp634_;
					_tmp634_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp634_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp635_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp636_ = _tmp635_;
	if (_tmp636_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp637_;
		gboolean _tmp638_ = FALSE;
		ValaExpression* _tmp639_;
		ValaExpression* _tmp640_;
		ValaSourceReference* _tmp653_;
		ValaSourceReference* _tmp654_;
		const gchar* _tmp655_;
		const gchar* _tmp656_;
		gchar* _tmp657_;
		gchar* _tmp658_;
		ValaInvalidType* _tmp659_;
		ValaInvalidType* _tmp660_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp637_ = g_strdup ("(null)");
		base_type_name = _tmp637_;
		_tmp639_ = vala_member_access_get_inner (self);
		_tmp640_ = _tmp639_;
		if (_tmp640_ != NULL) {
			ValaExpression* _tmp641_;
			ValaExpression* _tmp642_;
			ValaDataType* _tmp643_;
			ValaDataType* _tmp644_;
			_tmp641_ = vala_member_access_get_inner (self);
			_tmp642_ = _tmp641_;
			_tmp643_ = vala_expression_get_value_type (_tmp642_);
			_tmp644_ = _tmp643_;
			_tmp638_ = _tmp644_ != NULL;
		} else {
			_tmp638_ = FALSE;
		}
		if (_tmp638_) {
			ValaExpression* _tmp645_;
			ValaExpression* _tmp646_;
			ValaDataType* _tmp647_;
			ValaDataType* _tmp648_;
			gchar* _tmp649_;
			_tmp645_ = vala_member_access_get_inner (self);
			_tmp646_ = _tmp645_;
			_tmp647_ = vala_expression_get_value_type (_tmp646_);
			_tmp648_ = _tmp647_;
			_tmp649_ = vala_code_node_to_string ((ValaCodeNode*) _tmp648_);
			_g_free0 (base_type_name);
			base_type_name = _tmp649_;
		} else {
			ValaSymbol* _tmp650_;
			_tmp650_ = base_symbol;
			if (_tmp650_ != NULL) {
				ValaSymbol* _tmp651_;
				gchar* _tmp652_;
				_tmp651_ = base_symbol;
				_tmp652_ = vala_symbol_get_full_name (_tmp651_);
				_g_free0 (base_type_name);
				base_type_name = _tmp652_;
			}
		}
		_tmp653_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp654_ = _tmp653_;
		_tmp655_ = self->priv->_member_name;
		_tmp656_ = base_type_name;
		_tmp657_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp655_, _tmp656_);
		_tmp658_ = _tmp657_;
		vala_report_error (_tmp654_, _tmp658_);
		_g_free0 (_tmp658_);
		_tmp659_ = vala_invalid_type_new ();
		_tmp660_ = _tmp659_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp660_);
		_vala_code_node_unref0 (_tmp660_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	} else {
		ValaSymbol* _tmp661_;
		ValaSymbol* _tmp662_;
		gboolean _tmp663_;
		gboolean _tmp664_;
		_tmp661_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp662_ = _tmp661_;
		_tmp663_ = vala_code_node_get_error ((ValaCodeNode*) _tmp662_);
		_tmp664_ = _tmp663_;
		if (_tmp664_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
	}
	_tmp665_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp666_ = _tmp665_;
	_tmp667_ = _vala_code_node_ref0 (_tmp666_);
	member = _tmp667_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp668_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp668_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp669_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp669_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp670_;
		ValaLocalVariable* _tmp671_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp672_;
		ValaSymbol* _tmp673_;
		ValaSymbol* _tmp674_;
		ValaBlock* _tmp675_;
		gboolean _tmp676_ = FALSE;
		ValaBlock* _tmp677_;
		_tmp670_ = member;
		_tmp671_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp670_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp671_;
		_tmp672_ = local;
		_tmp673_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp672_);
		_tmp674_ = _tmp673_;
		_tmp675_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp674_) ? ((ValaBlock*) _tmp674_) : NULL);
		block = _tmp675_;
		_tmp677_ = block;
		if (_tmp677_ != NULL) {
			ValaSemanticAnalyzer* _tmp678_;
			ValaSemanticAnalyzer* _tmp679_;
			ValaBlock* _tmp680_;
			ValaSymbol* _tmp681_;
			ValaSymbol* _tmp682_;
			ValaSemanticAnalyzer* _tmp683_;
			ValaSemanticAnalyzer* _tmp684_;
			ValaSymbol* _tmp685_;
			ValaSymbol* _tmp686_;
			_tmp678_ = vala_code_context_get_analyzer (context);
			_tmp679_ = _tmp678_;
			_tmp680_ = block;
			_tmp681_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp679_, (ValaSymbol*) _tmp680_);
			_tmp682_ = _tmp681_;
			_tmp683_ = vala_code_context_get_analyzer (context);
			_tmp684_ = _tmp683_;
			_tmp685_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp684_);
			_tmp686_ = _tmp685_;
			_tmp676_ = _tmp682_ != _tmp686_;
			_vala_code_node_unref0 (_tmp682_);
		} else {
			_tmp676_ = FALSE;
		}
		if (_tmp676_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp687_;
			ValaSemanticAnalyzer* _tmp688_;
			ValaSymbol* _tmp689_;
			ValaSymbol* _tmp690_;
			ValaSymbol* _tmp691_;
			ValaLocalVariable* _tmp704_;
			ValaBlock* _tmp705_;
			_tmp687_ = vala_code_context_get_analyzer (context);
			_tmp688_ = _tmp687_;
			_tmp689_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp688_);
			_tmp690_ = _tmp689_;
			_tmp691_ = _vala_code_node_ref0 (_tmp690_);
			sym = _tmp691_;
			while (TRUE) {
				ValaSymbol* _tmp692_;
				ValaBlock* _tmp693_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp694_;
				ValaMethod* _tmp695_;
				ValaMethod* _tmp696_;
				ValaSymbol* _tmp700_;
				ValaSymbol* _tmp701_;
				ValaSymbol* _tmp702_;
				ValaSymbol* _tmp703_;
				_tmp692_ = sym;
				_tmp693_ = block;
				if (!(_tmp692_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp693_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp694_ = sym;
				_tmp695_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp694_) ? ((ValaMethod*) _tmp694_) : NULL);
				method = _tmp695_;
				_tmp696_ = method;
				if (_tmp696_ != NULL) {
					ValaMethod* _tmp697_;
					ValaMethod* _tmp698_;
					ValaLocalVariable* _tmp699_;
					_tmp697_ = method;
					vala_method_set_closure (_tmp697_, TRUE);
					_tmp698_ = method;
					_tmp699_ = local;
					vala_method_add_captured_variable (_tmp698_, _tmp699_);
				}
				_tmp700_ = sym;
				_tmp701_ = vala_symbol_get_parent_symbol (_tmp700_);
				_tmp702_ = _tmp701_;
				_tmp703_ = _vala_code_node_ref0 (_tmp702_);
				_vala_code_node_unref0 (sym);
				sym = _tmp703_;
				_vala_code_node_unref0 (method);
			}
			_tmp704_ = local;
			vala_local_variable_set_captured (_tmp704_, TRUE);
			_tmp705_ = block;
			vala_block_set_captured (_tmp705_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp706_;
		_tmp706_ = member;
		if (VALA_IS_PARAMETER (_tmp706_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp707_;
			ValaParameter* _tmp708_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp709_;
			ValaSymbol* _tmp710_;
			ValaSymbol* _tmp711_;
			ValaMethod* _tmp712_;
			gboolean _tmp713_ = FALSE;
			gboolean _tmp714_ = FALSE;
			ValaMethod* _tmp715_;
			_tmp707_ = member;
			_tmp708_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp707_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp708_;
			_tmp709_ = param;
			_tmp710_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp711_) ? ((ValaMethod*) _tmp711_) : NULL);
			m = _tmp712_;
			_tmp715_ = m;
			if (_tmp715_ != NULL) {
				ValaMethod* _tmp716_;
				ValaSemanticAnalyzer* _tmp717_;
				ValaSemanticAnalyzer* _tmp718_;
				ValaSymbol* _tmp719_;
				ValaSymbol* _tmp720_;
				_tmp716_ = m;
				_tmp717_ = vala_code_context_get_analyzer (context);
				_tmp718_ = _tmp717_;
				_tmp719_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp718_);
				_tmp720_ = _tmp719_;
				_tmp714_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp716_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp720_;
			} else {
				_tmp714_ = FALSE;
			}
			if (_tmp714_) {
				ValaParameter* _tmp721_;
				ValaMethod* _tmp722_;
				ValaParameter* _tmp723_;
				ValaParameter* _tmp724_;
				_tmp721_ = param;
				_tmp722_ = m;
				_tmp723_ = vala_method_get_this_parameter (_tmp722_);
				_tmp724_ = _tmp723_;
				_tmp713_ = _tmp721_ != _tmp724_;
			} else {
				_tmp713_ = FALSE;
			}
			if (_tmp713_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp725_;
				ValaSemanticAnalyzer* _tmp726_;
				ValaSymbol* _tmp727_;
				ValaSymbol* _tmp728_;
				ValaSymbol* _tmp729_;
				ValaParameter* _tmp740_;
				ValaMethod* _tmp741_;
				ValaBlock* _tmp742_;
				ValaBlock* _tmp743_;
				ValaParameter* _tmp744_;
				ValaParameterDirection _tmp745_;
				ValaParameterDirection _tmp746_;
				_tmp725_ = vala_code_context_get_analyzer (context);
				_tmp726_ = _tmp725_;
				_tmp727_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp726_);
				_tmp728_ = _tmp727_;
				_tmp729_ = _vala_code_node_ref0 (_tmp728_);
				sym = _tmp729_;
				while (TRUE) {
					ValaSymbol* _tmp730_;
					ValaMethod* _tmp731_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp732_;
					ValaMethod* _tmp733_;
					ValaMethod* _tmp734_;
					ValaSymbol* _tmp736_;
					ValaSymbol* _tmp737_;
					ValaSymbol* _tmp738_;
					ValaSymbol* _tmp739_;
					_tmp730_ = sym;
					_tmp731_ = m;
					if (!(_tmp730_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp731_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp732_ = sym;
					_tmp733_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp732_) ? ((ValaMethod*) _tmp732_) : NULL);
					method = _tmp733_;
					_tmp734_ = method;
					if (_tmp734_ != NULL) {
						ValaMethod* _tmp735_;
						_tmp735_ = method;
						vala_method_set_closure (_tmp735_, TRUE);
					}
					_tmp736_ = sym;
					_tmp737_ = vala_symbol_get_parent_symbol (_tmp736_);
					_tmp738_ = _tmp737_;
					_tmp739_ = _vala_code_node_ref0 (_tmp738_);
					_vala_code_node_unref0 (sym);
					sym = _tmp739_;
					_vala_code_node_unref0 (method);
				}
				_tmp740_ = param;
				vala_parameter_set_captured (_tmp740_, TRUE);
				_tmp741_ = m;
				_tmp742_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp741_);
				_tmp743_ = _tmp742_;
				vala_block_set_captured (_tmp743_, TRUE);
				_tmp744_ = param;
				_tmp745_ = vala_parameter_get_direction (_tmp744_);
				_tmp746_ = _tmp745_;
				if (_tmp746_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp747_;
					ValaSourceReference* _tmp748_;
					ValaParameter* _tmp749_;
					gchar* _tmp750_;
					gchar* _tmp751_;
					gchar* _tmp752_;
					gchar* _tmp753_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp747_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp748_ = _tmp747_;
					_tmp749_ = param;
					_tmp750_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp749_);
					_tmp751_ = _tmp750_;
					_tmp752_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp751_);
					_tmp753_ = _tmp752_;
					vala_report_error (_tmp748_, _tmp753_);
					_g_free0 (_tmp753_);
					_g_free0 (_tmp751_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp754_;
				ValaSymbol* _tmp755_;
				ValaSymbol* _tmp756_;
				ValaSymbol* _tmp757_;
				ValaSymbol* _tmp758_;
				ValaPropertyAccessor* _tmp759_;
				gboolean _tmp760_ = FALSE;
				gboolean _tmp761_ = FALSE;
				ValaPropertyAccessor* _tmp762_;
				_tmp754_ = param;
				_tmp755_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp754_);
				_tmp756_ = _tmp755_;
				_tmp757_ = vala_symbol_get_parent_symbol (_tmp756_);
				_tmp758_ = _tmp757_;
				_tmp759_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp758_) ? ((ValaPropertyAccessor*) _tmp758_) : NULL);
				acc = _tmp759_;
				_tmp762_ = acc;
				if (_tmp762_ != NULL) {
					ValaPropertyAccessor* _tmp763_;
					ValaSemanticAnalyzer* _tmp764_;
					ValaSemanticAnalyzer* _tmp765_;
					ValaSymbol* _tmp766_;
					ValaSymbol* _tmp767_;
					_tmp763_ = acc;
					_tmp764_ = vala_code_context_get_analyzer (context);
					_tmp765_ = _tmp764_;
					_tmp766_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp765_);
					_tmp767_ = _tmp766_;
					_tmp761_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp763_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp767_;
				} else {
					_tmp761_ = FALSE;
				}
				if (_tmp761_) {
					ValaParameter* _tmp768_;
					ValaPropertyAccessor* _tmp769_;
					ValaProperty* _tmp770_;
					ValaProperty* _tmp771_;
					ValaParameter* _tmp772_;
					ValaParameter* _tmp773_;
					_tmp768_ = param;
					_tmp769_ = acc;
					_tmp770_ = vala_property_accessor_get_prop (_tmp769_);
					_tmp771_ = _tmp770_;
					_tmp772_ = vala_property_get_this_parameter (_tmp771_);
					_tmp773_ = _tmp772_;
					_tmp760_ = _tmp768_ != _tmp773_;
				} else {
					_tmp760_ = FALSE;
				}
				if (_tmp760_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp774_;
					ValaSemanticAnalyzer* _tmp775_;
					ValaSymbol* _tmp776_;
					ValaSymbol* _tmp777_;
					ValaSymbol* _tmp778_;
					ValaParameter* _tmp789_;
					ValaPropertyAccessor* _tmp790_;
					ValaBlock* _tmp791_;
					ValaBlock* _tmp792_;
					_tmp774_ = vala_code_context_get_analyzer (context);
					_tmp775_ = _tmp774_;
					_tmp776_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp775_);
					_tmp777_ = _tmp776_;
					_tmp778_ = _vala_code_node_ref0 (_tmp777_);
					sym = _tmp778_;
					while (TRUE) {
						ValaSymbol* _tmp779_;
						ValaMethod* _tmp780_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp781_;
						ValaMethod* _tmp782_;
						ValaMethod* _tmp783_;
						ValaSymbol* _tmp785_;
						ValaSymbol* _tmp786_;
						ValaSymbol* _tmp787_;
						ValaSymbol* _tmp788_;
						_tmp779_ = sym;
						_tmp780_ = m;
						if (!(_tmp779_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp780_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp781_ = sym;
						_tmp782_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp781_) ? ((ValaMethod*) _tmp781_) : NULL);
						method = _tmp782_;
						_tmp783_ = method;
						if (_tmp783_ != NULL) {
							ValaMethod* _tmp784_;
							_tmp784_ = method;
							vala_method_set_closure (_tmp784_, TRUE);
						}
						_tmp785_ = sym;
						_tmp786_ = vala_symbol_get_parent_symbol (_tmp785_);
						_tmp787_ = _tmp786_;
						_tmp788_ = _vala_code_node_ref0 (_tmp787_);
						_vala_code_node_unref0 (sym);
						sym = _tmp788_;
						_vala_code_node_unref0 (method);
					}
					_tmp789_ = param;
					vala_parameter_set_captured (_tmp789_, TRUE);
					_tmp790_ = acc;
					_tmp791_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp790_);
					_tmp792_ = _tmp791_;
					vala_block_set_captured (_tmp792_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp793_;
			_tmp793_ = member;
			if (VALA_IS_FIELD (_tmp793_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp794_;
				ValaField* _tmp795_;
				ValaField* _tmp796_;
				ValaSymbolAccessibility _tmp797_;
				ValaSymbolAccessibility _tmp798_;
				ValaField* _tmp799_;
				ValaMemberBinding _tmp800_;
				ValaMemberBinding _tmp801_;
				ValaField* _tmp802_;
				ValaMemberBinding _tmp803_;
				ValaMemberBinding _tmp804_;
				ValaField* _tmp805_;
				ValaDataType* _tmp806_;
				ValaDataType* _tmp807_;
				_tmp794_ = member;
				_tmp795_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp794_, VALA_TYPE_FIELD, ValaField));
				f = _tmp795_;
				_tmp796_ = f;
				_tmp797_ = vala_symbol_get_access ((ValaSymbol*) _tmp796_);
				_tmp798_ = _tmp797_;
				access = _tmp798_;
				_tmp799_ = f;
				_tmp800_ = vala_field_get_binding (_tmp799_);
				_tmp801_ = _tmp800_;
				instance = _tmp801_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp802_ = f;
				_tmp803_ = vala_field_get_binding (_tmp802_);
				_tmp804_ = _tmp803_;
				klass = _tmp804_ == VALA_MEMBER_BINDING_CLASS;
				_tmp805_ = f;
				_tmp806_ = vala_variable_get_variable_type ((ValaVariable*) _tmp805_);
				_tmp807_ = _tmp806_;
				if (VALA_IS_GENERIC_TYPE (_tmp807_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp808_;
				_tmp808_ = member;
				if (VALA_IS_CONSTANT (_tmp808_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp809_;
					ValaConstant* _tmp810_;
					ValaConstant* _tmp811_;
					ValaSymbolAccessibility _tmp812_;
					ValaSymbolAccessibility _tmp813_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp814_;
					ValaSymbol* _tmp815_;
					ValaSymbol* _tmp816_;
					ValaBlock* _tmp817_;
					gboolean _tmp818_ = FALSE;
					ValaBlock* _tmp819_;
					_tmp809_ = member;
					_tmp810_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp809_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp810_;
					_tmp811_ = c;
					_tmp812_ = vala_symbol_get_access ((ValaSymbol*) _tmp811_);
					_tmp813_ = _tmp812_;
					access = _tmp813_;
					_tmp814_ = c;
					_tmp815_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp814_);
					_tmp816_ = _tmp815_;
					_tmp817_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp816_) ? ((ValaBlock*) _tmp816_) : NULL);
					block = _tmp817_;
					_tmp819_ = block;
					if (_tmp819_ != NULL) {
						ValaSemanticAnalyzer* _tmp820_;
						ValaSemanticAnalyzer* _tmp821_;
						ValaBlock* _tmp822_;
						ValaSymbol* _tmp823_;
						ValaSymbol* _tmp824_;
						ValaSemanticAnalyzer* _tmp825_;
						ValaSemanticAnalyzer* _tmp826_;
						ValaSymbol* _tmp827_;
						ValaSymbol* _tmp828_;
						_tmp820_ = vala_code_context_get_analyzer (context);
						_tmp821_ = _tmp820_;
						_tmp822_ = block;
						_tmp823_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp821_, (ValaSymbol*) _tmp822_);
						_tmp824_ = _tmp823_;
						_tmp825_ = vala_code_context_get_analyzer (context);
						_tmp826_ = _tmp825_;
						_tmp827_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp826_);
						_tmp828_ = _tmp827_;
						_tmp818_ = _tmp824_ != _tmp828_;
						_vala_code_node_unref0 (_tmp824_);
					} else {
						_tmp818_ = FALSE;
					}
					if (_tmp818_) {
						ValaSourceReference* _tmp829_;
						ValaSourceReference* _tmp830_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp829_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp830_ = _tmp829_;
						vala_report_error (_tmp830_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp831_;
					_tmp831_ = member;
					if (VALA_IS_METHOD (_tmp831_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp832_;
						ValaMethod* _tmp833_;
						ValaMethod* _tmp834_;
						gboolean _tmp835_;
						gboolean _tmp836_;
						ValaMethod* _tmp939_;
						ValaSymbolAccessibility _tmp940_;
						ValaSymbolAccessibility _tmp941_;
						ValaMethod* _tmp942_;
						ValaMethod* _tmp946_;
						ValaMemberBinding _tmp947_;
						ValaMemberBinding _tmp948_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp971_;
						ValaDataType* _tmp972_;
						ValaDataType* _tmp973_;
						ValaGenericType* _tmp974_;
						gboolean _tmp975_ = FALSE;
						ValaGenericType* _tmp976_;
						_tmp832_ = member;
						_tmp833_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp832_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp833_;
						_tmp834_ = m;
						_tmp835_ = vala_method_get_is_async_callback (_tmp834_);
						_tmp836_ = _tmp835_;
						if (_tmp836_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp837_;
							ValaSemanticAnalyzer* _tmp838_;
							ValaMethod* _tmp839_;
							ValaMethod* _tmp840_;
							ValaMethod* _tmp841_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp842_;
							gboolean _tmp868_;
							ValaMethod* _tmp876_;
							ValaSemanticAnalyzer* _tmp877_;
							ValaSemanticAnalyzer* _tmp878_;
							ValaMethod* _tmp879_;
							ValaMethod* _tmp880_;
							ValaMethod* _tmp899_;
							ValaMethod* _tmp900_;
							ValaMethod* _tmp901_;
							ValaSymbol* _tmp902_;
							ValaSymbol* _tmp903_;
							ValaSymbol* _tmp904_;
							_tmp837_ = vala_code_context_get_analyzer (context);
							_tmp838_ = _tmp837_;
							_tmp839_ = vala_semantic_analyzer_get_current_async_method (_tmp838_);
							_tmp840_ = _tmp839_;
							_tmp841_ = _vala_code_node_ref0 (_tmp840_);
							async_method = _tmp841_;
							is_valid_access = FALSE;
							_tmp842_ = async_method;
							if (_tmp842_ != NULL) {
								ValaMethod* _tmp843_;
								ValaMethod* _tmp844_;
								ValaMethod* _tmp845_;
								ValaMethod* _tmp846_;
								gboolean _tmp847_;
								_tmp843_ = m;
								_tmp844_ = async_method;
								_tmp845_ = vala_method_get_callback_method (_tmp844_);
								_tmp846_ = _tmp845_;
								_tmp847_ = _tmp843_ == _tmp846_;
								_vala_code_node_unref0 (_tmp846_);
								if (_tmp847_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp848_ = FALSE;
									ValaMethod* _tmp849_;
									ValaMethod* _tmp850_;
									ValaMethod* _tmp851_;
									_tmp849_ = async_method;
									_tmp850_ = vala_method_get_base_method (_tmp849_);
									_tmp851_ = _tmp850_;
									if (_tmp851_ != NULL) {
										ValaMethod* _tmp852_;
										ValaMethod* _tmp853_;
										ValaMethod* _tmp854_;
										ValaMethod* _tmp855_;
										ValaMethod* _tmp856_;
										ValaMethod* _tmp857_;
										_tmp852_ = m;
										_tmp853_ = async_method;
										_tmp854_ = vala_method_get_base_method (_tmp853_);
										_tmp855_ = _tmp854_;
										_tmp856_ = vala_method_get_callback_method (_tmp855_);
										_tmp857_ = _tmp856_;
										_tmp848_ = _tmp852_ == _tmp857_;
										_vala_code_node_unref0 (_tmp857_);
									} else {
										_tmp848_ = FALSE;
									}
									if (_tmp848_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp858_ = FALSE;
										ValaMethod* _tmp859_;
										ValaMethod* _tmp860_;
										ValaMethod* _tmp861_;
										_tmp859_ = async_method;
										_tmp860_ = vala_method_get_base_interface_method (_tmp859_);
										_tmp861_ = _tmp860_;
										if (_tmp861_ != NULL) {
											ValaMethod* _tmp862_;
											ValaMethod* _tmp863_;
											ValaMethod* _tmp864_;
											ValaMethod* _tmp865_;
											ValaMethod* _tmp866_;
											ValaMethod* _tmp867_;
											_tmp862_ = m;
											_tmp863_ = async_method;
											_tmp864_ = vala_method_get_base_interface_method (_tmp863_);
											_tmp865_ = _tmp864_;
											_tmp866_ = vala_method_get_callback_method (_tmp865_);
											_tmp867_ = _tmp866_;
											_tmp858_ = _tmp862_ == _tmp867_;
											_vala_code_node_unref0 (_tmp867_);
										} else {
											_tmp858_ = FALSE;
										}
										if (_tmp858_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							_tmp868_ = is_valid_access;
							if (!_tmp868_) {
								ValaSourceReference* _tmp869_;
								ValaSourceReference* _tmp870_;
								ValaMethod* _tmp871_;
								gchar* _tmp872_;
								gchar* _tmp873_;
								gchar* _tmp874_;
								gchar* _tmp875_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp869_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp870_ = _tmp869_;
								_tmp871_ = m;
								_tmp872_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp871_);
								_tmp873_ = _tmp872_;
								_tmp874_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp873_);
								_tmp875_ = _tmp874_;
								vala_report_error (_tmp870_, _tmp875_);
								_g_free0 (_tmp875_);
								_g_free0 (_tmp873_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp876_ = async_method;
							_tmp877_ = vala_code_context_get_analyzer (context);
							_tmp878_ = _tmp877_;
							_tmp879_ = vala_semantic_analyzer_get_current_method (_tmp878_);
							_tmp880_ = _tmp879_;
							if (_tmp876_ != _tmp880_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp881_;
								ValaSemanticAnalyzer* _tmp882_;
								ValaMethod* _tmp883_;
								ValaMethod* _tmp884_;
								ValaSymbol* _tmp885_;
								ValaMethod* _tmp896_;
								ValaBlock* _tmp897_;
								ValaBlock* _tmp898_;
								_tmp881_ = vala_code_context_get_analyzer (context);
								_tmp882_ = _tmp881_;
								_tmp883_ = vala_semantic_analyzer_get_current_method (_tmp882_);
								_tmp884_ = _tmp883_;
								_tmp885_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp884_);
								sym = _tmp885_;
								while (TRUE) {
									ValaSymbol* _tmp886_;
									ValaMethod* _tmp887_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp888_;
									ValaMethod* _tmp889_;
									ValaMethod* _tmp890_;
									ValaSymbol* _tmp892_;
									ValaSymbol* _tmp893_;
									ValaSymbol* _tmp894_;
									ValaSymbol* _tmp895_;
									_tmp886_ = sym;
									_tmp887_ = async_method;
									if (!(_tmp886_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp887_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp888_ = sym;
									_tmp889_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp888_) ? ((ValaMethod*) _tmp888_) : NULL);
									method = _tmp889_;
									_tmp890_ = method;
									if (_tmp890_ != NULL) {
										ValaMethod* _tmp891_;
										_tmp891_ = method;
										vala_method_set_closure (_tmp891_, TRUE);
									}
									_tmp892_ = sym;
									_tmp893_ = vala_symbol_get_parent_symbol (_tmp892_);
									_tmp894_ = _tmp893_;
									_tmp895_ = _vala_code_node_ref0 (_tmp894_);
									_vala_code_node_unref0 (sym);
									sym = _tmp895_;
									_vala_code_node_unref0 (method);
								}
								_tmp896_ = async_method;
								_tmp897_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp896_);
								_tmp898_ = _tmp897_;
								vala_block_set_captured (_tmp898_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp899_ = async_method;
							_tmp900_ = vala_method_get_callback_method (_tmp899_);
							_vala_code_node_unref0 (m);
							m = _tmp900_;
							_tmp901_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp901_);
							_tmp902_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp903_ = _tmp902_;
							_tmp904_ = _vala_code_node_ref0 (_tmp903_);
							_vala_code_node_unref0 (member);
							member = _tmp904_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp905_;
							ValaMethod* _tmp906_;
							ValaMethod* _tmp907_;
							_tmp905_ = m;
							_tmp906_ = vala_method_get_base_method (_tmp905_);
							_tmp907_ = _tmp906_;
							if (_tmp907_ != NULL) {
								ValaMethod* _tmp908_;
								ValaMethod* _tmp909_;
								ValaMethod* _tmp910_;
								ValaMethod* _tmp911_;
								ValaMethod* _tmp912_;
								ValaSignal* _tmp913_;
								ValaSignal* _tmp914_;
								ValaSymbol* _tmp919_;
								ValaSymbol* _tmp920_;
								ValaSymbol* _tmp921_;
								_tmp908_ = m;
								_tmp909_ = vala_method_get_base_method (_tmp908_);
								_tmp910_ = _tmp909_;
								_tmp911_ = _vala_code_node_ref0 (_tmp910_);
								_vala_code_node_unref0 (m);
								m = _tmp911_;
								_tmp912_ = m;
								_tmp913_ = vala_method_get_signal_reference (_tmp912_);
								_tmp914_ = _tmp913_;
								if (_tmp914_ != NULL) {
									ValaMethod* _tmp915_;
									ValaSignal* _tmp916_;
									ValaSignal* _tmp917_;
									_tmp915_ = m;
									_tmp916_ = vala_method_get_signal_reference (_tmp915_);
									_tmp917_ = _tmp916_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp917_);
								} else {
									ValaMethod* _tmp918_;
									_tmp918_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp918_);
								}
								_tmp919_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp920_ = _tmp919_;
								_tmp921_ = _vala_code_node_ref0 (_tmp920_);
								_vala_code_node_unref0 (member);
								member = _tmp921_;
							} else {
								ValaMethod* _tmp922_;
								ValaMethod* _tmp923_;
								ValaMethod* _tmp924_;
								_tmp922_ = m;
								_tmp923_ = vala_method_get_base_interface_method (_tmp922_);
								_tmp924_ = _tmp923_;
								if (_tmp924_ != NULL) {
									ValaMethod* _tmp925_;
									ValaMethod* _tmp926_;
									ValaMethod* _tmp927_;
									ValaMethod* _tmp928_;
									ValaMethod* _tmp929_;
									ValaSignal* _tmp930_;
									ValaSignal* _tmp931_;
									ValaSymbol* _tmp936_;
									ValaSymbol* _tmp937_;
									ValaSymbol* _tmp938_;
									_tmp925_ = m;
									_tmp926_ = vala_method_get_base_interface_method (_tmp925_);
									_tmp927_ = _tmp926_;
									_tmp928_ = _vala_code_node_ref0 (_tmp927_);
									_vala_code_node_unref0 (m);
									m = _tmp928_;
									_tmp929_ = m;
									_tmp930_ = vala_method_get_signal_reference (_tmp929_);
									_tmp931_ = _tmp930_;
									if (_tmp931_ != NULL) {
										ValaMethod* _tmp932_;
										ValaSignal* _tmp933_;
										ValaSignal* _tmp934_;
										_tmp932_ = m;
										_tmp933_ = vala_method_get_signal_reference (_tmp932_);
										_tmp934_ = _tmp933_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp934_);
									} else {
										ValaMethod* _tmp935_;
										_tmp935_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp935_);
									}
									_tmp936_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp937_ = _tmp936_;
									_tmp938_ = _vala_code_node_ref0 (_tmp937_);
									_vala_code_node_unref0 (member);
									member = _tmp938_;
								}
							}
						}
						_tmp939_ = m;
						_tmp940_ = vala_symbol_get_access ((ValaSymbol*) _tmp939_);
						_tmp941_ = _tmp940_;
						access = _tmp941_;
						_tmp942_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp942_)) {
							ValaMethod* _tmp943_;
							ValaMemberBinding _tmp944_;
							ValaMemberBinding _tmp945_;
							_tmp943_ = m;
							_tmp944_ = vala_method_get_binding (_tmp943_);
							_tmp945_ = _tmp944_;
							instance = _tmp945_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp946_ = m;
						_tmp947_ = vala_method_get_binding (_tmp946_);
						_tmp948_ = _tmp947_;
						klass = _tmp948_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp949_;
							ValaList* _tmp950_;
							gint _param_size = 0;
							ValaList* _tmp951_;
							gint _tmp952_;
							gint _tmp953_;
							gint _param_index = 0;
							_tmp949_ = m;
							_tmp950_ = vala_callable_get_parameters ((ValaCallable*) _tmp949_);
							_param_list = _tmp950_;
							_tmp951_ = _param_list;
							_tmp952_ = vala_collection_get_size ((ValaCollection*) _tmp951_);
							_tmp953_ = _tmp952_;
							_param_size = _tmp953_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp954_;
								gint _tmp955_;
								gint _tmp956_;
								ValaParameter* param = NULL;
								ValaList* _tmp957_;
								gint _tmp958_;
								gpointer _tmp959_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp960_;
								ValaDataType* _tmp961_;
								ValaDataType* _tmp962_;
								ValaGenericType* _tmp963_;
								gboolean _tmp964_ = FALSE;
								ValaGenericType* _tmp965_;
								_tmp954_ = _param_index;
								_param_index = _tmp954_ + 1;
								_tmp955_ = _param_index;
								_tmp956_ = _param_size;
								if (!(_tmp955_ < _tmp956_)) {
									break;
								}
								_tmp957_ = _param_list;
								_tmp958_ = _param_index;
								_tmp959_ = vala_list_get (_tmp957_, _tmp958_);
								param = (ValaParameter*) _tmp959_;
								_tmp960_ = param;
								_tmp961_ = vala_variable_get_variable_type ((ValaVariable*) _tmp960_);
								_tmp962_ = _tmp961_;
								_tmp963_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp962_) ? ((ValaGenericType*) _tmp962_) : NULL);
								generic_type = _tmp963_;
								_tmp965_ = generic_type;
								if (_tmp965_ != NULL) {
									ValaGenericType* _tmp966_;
									ValaTypeParameter* _tmp967_;
									ValaTypeParameter* _tmp968_;
									ValaSymbol* _tmp969_;
									ValaSymbol* _tmp970_;
									_tmp966_ = generic_type;
									_tmp967_ = vala_generic_type_get_type_parameter (_tmp966_);
									_tmp968_ = _tmp967_;
									_tmp969_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp968_);
									_tmp970_ = _tmp969_;
									_tmp964_ = VALA_IS_TYPESYMBOL (_tmp970_);
								} else {
									_tmp964_ = FALSE;
								}
								if (_tmp964_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp971_ = m;
						_tmp972_ = vala_callable_get_return_type ((ValaCallable*) _tmp971_);
						_tmp973_ = _tmp972_;
						_tmp974_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp973_) ? ((ValaGenericType*) _tmp973_) : NULL);
						generic_type = _tmp974_;
						_tmp976_ = generic_type;
						if (_tmp976_ != NULL) {
							ValaGenericType* _tmp977_;
							ValaTypeParameter* _tmp978_;
							ValaTypeParameter* _tmp979_;
							ValaSymbol* _tmp980_;
							ValaSymbol* _tmp981_;
							_tmp977_ = generic_type;
							_tmp978_ = vala_generic_type_get_type_parameter (_tmp977_);
							_tmp979_ = _tmp978_;
							_tmp980_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp979_);
							_tmp981_ = _tmp980_;
							_tmp975_ = VALA_IS_TYPESYMBOL (_tmp981_);
						} else {
							_tmp975_ = FALSE;
						}
						if (_tmp975_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp982_;
						_tmp982_ = member;
						if (VALA_IS_PROPERTY (_tmp982_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp983_;
							ValaProperty* _tmp984_;
							ValaProperty* _tmp985_;
							ValaProperty* _tmp986_;
							ValaProperty* _tmp987_;
							ValaProperty* _tmp988_;
							ValaProperty* _tmp1008_;
							ValaSymbolAccessibility _tmp1009_;
							ValaSymbolAccessibility _tmp1010_;
							gboolean _tmp1011_;
							gboolean _tmp1012_;
							ValaProperty* _tmp1077_;
							ValaMemberBinding _tmp1078_;
							ValaMemberBinding _tmp1079_;
							ValaProperty* _tmp1080_;
							ValaDataType* _tmp1081_;
							ValaDataType* _tmp1082_;
							_tmp983_ = member;
							_tmp984_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp983_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp984_;
							_tmp985_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp985_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp986_ = prop;
							_tmp987_ = vala_property_get_base_property (_tmp986_);
							_tmp988_ = _tmp987_;
							if (_tmp988_ != NULL) {
								ValaProperty* _tmp989_;
								ValaProperty* _tmp990_;
								ValaProperty* _tmp991_;
								ValaProperty* _tmp992_;
								ValaProperty* _tmp993_;
								ValaSymbol* _tmp994_;
								ValaSymbol* _tmp995_;
								ValaSymbol* _tmp996_;
								_tmp989_ = prop;
								_tmp990_ = vala_property_get_base_property (_tmp989_);
								_tmp991_ = _tmp990_;
								_tmp992_ = _vala_code_node_ref0 (_tmp991_);
								_vala_code_node_unref0 (prop);
								prop = _tmp992_;
								_tmp993_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp993_);
								_tmp994_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp995_ = _tmp994_;
								_tmp996_ = _vala_code_node_ref0 (_tmp995_);
								_vala_code_node_unref0 (member);
								member = _tmp996_;
							} else {
								ValaProperty* _tmp997_;
								ValaProperty* _tmp998_;
								ValaProperty* _tmp999_;
								_tmp997_ = prop;
								_tmp998_ = vala_property_get_base_interface_property (_tmp997_);
								_tmp999_ = _tmp998_;
								if (_tmp999_ != NULL) {
									ValaProperty* _tmp1000_;
									ValaProperty* _tmp1001_;
									ValaProperty* _tmp1002_;
									ValaProperty* _tmp1003_;
									ValaProperty* _tmp1004_;
									ValaSymbol* _tmp1005_;
									ValaSymbol* _tmp1006_;
									ValaSymbol* _tmp1007_;
									_tmp1000_ = prop;
									_tmp1001_ = vala_property_get_base_interface_property (_tmp1000_);
									_tmp1002_ = _tmp1001_;
									_tmp1003_ = _vala_code_node_ref0 (_tmp1002_);
									_vala_code_node_unref0 (prop);
									prop = _tmp1003_;
									_tmp1004_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1004_);
									_tmp1005_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1006_ = _tmp1005_;
									_tmp1007_ = _vala_code_node_ref0 (_tmp1006_);
									_vala_code_node_unref0 (member);
									member = _tmp1007_;
								}
							}
							_tmp1008_ = prop;
							_tmp1009_ = vala_symbol_get_access ((ValaSymbol*) _tmp1008_);
							_tmp1010_ = _tmp1009_;
							access = _tmp1010_;
							_tmp1011_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1012_ = _tmp1011_;
							if (_tmp1012_) {
								ValaProperty* _tmp1013_;
								ValaPropertyAccessor* _tmp1014_;
								ValaPropertyAccessor* _tmp1015_;
								ValaProperty* _tmp1023_;
								ValaSymbolAccessibility _tmp1024_;
								ValaSymbolAccessibility _tmp1025_;
								_tmp1013_ = prop;
								_tmp1014_ = vala_property_get_set_accessor (_tmp1013_);
								_tmp1015_ = _tmp1014_;
								if (_tmp1015_ == NULL) {
									ValaSourceReference* _tmp1016_;
									ValaSourceReference* _tmp1017_;
									ValaProperty* _tmp1018_;
									gchar* _tmp1019_;
									gchar* _tmp1020_;
									gchar* _tmp1021_;
									gchar* _tmp1022_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1016_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1017_ = _tmp1016_;
									_tmp1018_ = prop;
									_tmp1019_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1018_);
									_tmp1020_ = _tmp1019_;
									_tmp1021_ = g_strdup_printf ("Property `%s' is read-only", _tmp1020_);
									_tmp1022_ = _tmp1021_;
									vala_report_error (_tmp1017_, _tmp1022_);
									_g_free0 (_tmp1022_);
									_g_free0 (_tmp1020_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1023_ = prop;
								_tmp1024_ = vala_symbol_get_access ((ValaSymbol*) _tmp1023_);
								_tmp1025_ = _tmp1024_;
								if (_tmp1025_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1026_;
									ValaPropertyAccessor* _tmp1027_;
									ValaPropertyAccessor* _tmp1028_;
									ValaSymbolAccessibility _tmp1029_;
									ValaSymbolAccessibility _tmp1030_;
									_tmp1026_ = prop;
									_tmp1027_ = vala_property_get_set_accessor (_tmp1026_);
									_tmp1028_ = _tmp1027_;
									_tmp1029_ = vala_symbol_get_access ((ValaSymbol*) _tmp1028_);
									_tmp1030_ = _tmp1029_;
									access = _tmp1030_;
								} else {
									gboolean _tmp1031_ = FALSE;
									ValaProperty* _tmp1032_;
									ValaSymbolAccessibility _tmp1033_;
									ValaSymbolAccessibility _tmp1034_;
									_tmp1032_ = prop;
									_tmp1033_ = vala_symbol_get_access ((ValaSymbol*) _tmp1032_);
									_tmp1034_ = _tmp1033_;
									if (_tmp1034_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1035_;
										ValaPropertyAccessor* _tmp1036_;
										ValaPropertyAccessor* _tmp1037_;
										ValaSymbolAccessibility _tmp1038_;
										ValaSymbolAccessibility _tmp1039_;
										_tmp1035_ = prop;
										_tmp1036_ = vala_property_get_set_accessor (_tmp1035_);
										_tmp1037_ = _tmp1036_;
										_tmp1038_ = vala_symbol_get_access ((ValaSymbol*) _tmp1037_);
										_tmp1039_ = _tmp1038_;
										_tmp1031_ = _tmp1039_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1031_ = FALSE;
									}
									if (_tmp1031_) {
										ValaProperty* _tmp1040_;
										ValaPropertyAccessor* _tmp1041_;
										ValaPropertyAccessor* _tmp1042_;
										ValaSymbolAccessibility _tmp1043_;
										ValaSymbolAccessibility _tmp1044_;
										_tmp1040_ = prop;
										_tmp1041_ = vala_property_get_set_accessor (_tmp1040_);
										_tmp1042_ = _tmp1041_;
										_tmp1043_ = vala_symbol_get_access ((ValaSymbol*) _tmp1042_);
										_tmp1044_ = _tmp1043_;
										access = _tmp1044_;
									}
								}
							} else {
								ValaProperty* _tmp1045_;
								ValaPropertyAccessor* _tmp1046_;
								ValaPropertyAccessor* _tmp1047_;
								ValaProperty* _tmp1055_;
								ValaSymbolAccessibility _tmp1056_;
								ValaSymbolAccessibility _tmp1057_;
								_tmp1045_ = prop;
								_tmp1046_ = vala_property_get_get_accessor (_tmp1045_);
								_tmp1047_ = _tmp1046_;
								if (_tmp1047_ == NULL) {
									ValaSourceReference* _tmp1048_;
									ValaSourceReference* _tmp1049_;
									ValaProperty* _tmp1050_;
									gchar* _tmp1051_;
									gchar* _tmp1052_;
									gchar* _tmp1053_;
									gchar* _tmp1054_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1048_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1049_ = _tmp1048_;
									_tmp1050_ = prop;
									_tmp1051_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1050_);
									_tmp1052_ = _tmp1051_;
									_tmp1053_ = g_strdup_printf ("Property `%s' is write-only", _tmp1052_);
									_tmp1054_ = _tmp1053_;
									vala_report_error (_tmp1049_, _tmp1054_);
									_g_free0 (_tmp1054_);
									_g_free0 (_tmp1052_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1055_ = prop;
								_tmp1056_ = vala_symbol_get_access ((ValaSymbol*) _tmp1055_);
								_tmp1057_ = _tmp1056_;
								if (_tmp1057_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1058_;
									ValaPropertyAccessor* _tmp1059_;
									ValaPropertyAccessor* _tmp1060_;
									ValaSymbolAccessibility _tmp1061_;
									ValaSymbolAccessibility _tmp1062_;
									_tmp1058_ = prop;
									_tmp1059_ = vala_property_get_get_accessor (_tmp1058_);
									_tmp1060_ = _tmp1059_;
									_tmp1061_ = vala_symbol_get_access ((ValaSymbol*) _tmp1060_);
									_tmp1062_ = _tmp1061_;
									access = _tmp1062_;
								} else {
									gboolean _tmp1063_ = FALSE;
									ValaProperty* _tmp1064_;
									ValaSymbolAccessibility _tmp1065_;
									ValaSymbolAccessibility _tmp1066_;
									_tmp1064_ = prop;
									_tmp1065_ = vala_symbol_get_access ((ValaSymbol*) _tmp1064_);
									_tmp1066_ = _tmp1065_;
									if (_tmp1066_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1067_;
										ValaPropertyAccessor* _tmp1068_;
										ValaPropertyAccessor* _tmp1069_;
										ValaSymbolAccessibility _tmp1070_;
										ValaSymbolAccessibility _tmp1071_;
										_tmp1067_ = prop;
										_tmp1068_ = vala_property_get_get_accessor (_tmp1067_);
										_tmp1069_ = _tmp1068_;
										_tmp1070_ = vala_symbol_get_access ((ValaSymbol*) _tmp1069_);
										_tmp1071_ = _tmp1070_;
										_tmp1063_ = _tmp1071_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1063_ = FALSE;
									}
									if (_tmp1063_) {
										ValaProperty* _tmp1072_;
										ValaPropertyAccessor* _tmp1073_;
										ValaPropertyAccessor* _tmp1074_;
										ValaSymbolAccessibility _tmp1075_;
										ValaSymbolAccessibility _tmp1076_;
										_tmp1072_ = prop;
										_tmp1073_ = vala_property_get_get_accessor (_tmp1072_);
										_tmp1074_ = _tmp1073_;
										_tmp1075_ = vala_symbol_get_access ((ValaSymbol*) _tmp1074_);
										_tmp1076_ = _tmp1075_;
										access = _tmp1076_;
									}
								}
							}
							_tmp1077_ = prop;
							_tmp1078_ = vala_property_get_binding (_tmp1077_);
							_tmp1079_ = _tmp1078_;
							instance = _tmp1079_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1080_ = prop;
							_tmp1081_ = vala_property_get_property_type (_tmp1080_);
							_tmp1082_ = _tmp1081_;
							if (VALA_IS_GENERIC_TYPE (_tmp1082_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1083_;
							_tmp1083_ = member;
							if (VALA_IS_SIGNAL (_tmp1083_)) {
								ValaSymbol* _tmp1084_;
								ValaSymbolAccessibility _tmp1085_;
								ValaSymbolAccessibility _tmp1086_;
								instance = TRUE;
								_tmp1084_ = member;
								_tmp1085_ = vala_symbol_get_access (_tmp1084_);
								_tmp1086_ = _tmp1085_;
								access = _tmp1086_;
							} else {
								gboolean _tmp1087_ = FALSE;
								gboolean _tmp1088_;
								_tmp1088_ = self->priv->_creation_member;
								if (!_tmp1088_) {
									ValaSymbol* _tmp1089_;
									_tmp1089_ = member;
									_tmp1087_ = VALA_IS_ERROR_CODE (_tmp1089_);
								} else {
									_tmp1087_ = FALSE;
								}
								if (_tmp1087_) {
									ValaSymbol* _tmp1090_;
									ValaConstant* _tmp1091_;
									ValaConstant* _tmp1092_;
									ValaSymbol* _tmp1093_;
									ValaSymbol* _tmp1094_;
									ValaSymbol* _tmp1095_;
									_tmp1090_ = member;
									_tmp1091_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1090_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1092_ = _tmp1091_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1092_);
									_tmp1093_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1094_ = _tmp1093_;
									_tmp1095_ = _vala_code_node_ref0 (_tmp1094_);
									_vala_code_node_unref0 (member);
									member = _tmp1095_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1096_ = member;
	vala_symbol_set_used (_tmp1096_, TRUE);
	_tmp1097_ = member;
	_tmp1098_ = vala_symbol_get_version (_tmp1097_);
	_tmp1099_ = _tmp1098_;
	_tmp1100_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1101_ = _tmp1100_;
	vala_version_attribute_check (_tmp1099_, _tmp1101_);
	_tmp1103_ = access;
	if (_tmp1103_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1104_;
		ValaSymbol* _tmp1105_;
		ValaSymbol* _tmp1106_;
		_tmp1104_ = member;
		_tmp1105_ = vala_symbol_get_parent_symbol (_tmp1104_);
		_tmp1106_ = _tmp1105_;
		_tmp1102_ = VALA_IS_TYPESYMBOL (_tmp1106_);
	} else {
		_tmp1102_ = FALSE;
	}
	if (_tmp1102_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1107_;
		ValaSymbol* _tmp1108_;
		ValaSymbol* _tmp1109_;
		ValaTypeSymbol* _tmp1110_;
		gboolean in_subtype = FALSE;
		gboolean _tmp1130_;
		_tmp1107_ = member;
		_tmp1108_ = vala_symbol_get_parent_symbol (_tmp1107_);
		_tmp1109_ = _tmp1108_;
		_tmp1110_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1109_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1110_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1111_;
			ValaSemanticAnalyzer* _tmp1112_;
			ValaSymbol* _tmp1113_;
			ValaSymbol* _tmp1114_;
			ValaSymbol* _tmp1115_;
			_tmp1111_ = vala_code_context_get_analyzer (context);
			_tmp1112_ = _tmp1111_;
			_tmp1113_ = vala_semantic_analyzer_get_current_symbol (_tmp1112_);
			_tmp1114_ = _tmp1113_;
			_tmp1115_ = _vala_code_node_ref0 (_tmp1114_);
			this_symbol = _tmp1115_;
			{
				gboolean _tmp1116_ = FALSE;
				_tmp1116_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1121_;
					ValaSymbol* _tmp1122_;
					ValaTypeSymbol* _tmp1123_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1124_;
					ValaClass* _tmp1125_;
					gboolean _tmp1126_ = FALSE;
					ValaClass* _tmp1127_;
					if (!_tmp1116_) {
						ValaSymbol* _tmp1117_;
						ValaSymbol* _tmp1118_;
						ValaSymbol* _tmp1119_;
						ValaSymbol* _tmp1120_;
						_tmp1117_ = this_symbol;
						_tmp1118_ = vala_symbol_get_parent_symbol (_tmp1117_);
						_tmp1119_ = _tmp1118_;
						_tmp1120_ = _vala_code_node_ref0 (_tmp1119_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1120_;
					}
					_tmp1116_ = FALSE;
					_tmp1121_ = this_symbol;
					if (!(_tmp1121_ != NULL)) {
						break;
					}
					_tmp1122_ = this_symbol;
					_tmp1123_ = target_type;
					if (_tmp1122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1123_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1124_ = this_symbol;
					_tmp1125_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1124_) ? ((ValaClass*) _tmp1124_) : NULL);
					cl = _tmp1125_;
					_tmp1127_ = cl;
					if (_tmp1127_ != NULL) {
						ValaClass* _tmp1128_;
						ValaTypeSymbol* _tmp1129_;
						_tmp1128_ = cl;
						_tmp1129_ = target_type;
						_tmp1126_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1128_, _tmp1129_);
					} else {
						_tmp1126_ = FALSE;
					}
					if (_tmp1126_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		_tmp1130_ = in_subtype;
		if (!_tmp1130_) {
			ValaSourceReference* _tmp1131_;
			ValaSourceReference* _tmp1132_;
			ValaSymbol* _tmp1133_;
			gchar* _tmp1134_;
			gchar* _tmp1135_;
			gchar* _tmp1136_;
			gchar* _tmp1137_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1132_ = _tmp1131_;
			_tmp1133_ = member;
			_tmp1134_ = vala_symbol_get_full_name (_tmp1133_);
			_tmp1135_ = _tmp1134_;
			_tmp1136_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1135_);
			_tmp1137_ = _tmp1136_;
			vala_report_error (_tmp1132_, _tmp1137_);
			_g_free0 (_tmp1137_);
			_g_free0 (_tmp1135_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1138_;
		_tmp1138_ = access;
		if (_tmp1138_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1139_;
			ValaSymbol* _tmp1140_;
			ValaSymbol* _tmp1141_;
			ValaSymbol* _tmp1142_;
			gboolean in_target_type = FALSE;
			gboolean _tmp1156_;
			_tmp1139_ = member;
			_tmp1140_ = vala_symbol_get_parent_symbol (_tmp1139_);
			_tmp1141_ = _tmp1140_;
			_tmp1142_ = _vala_code_node_ref0 (_tmp1141_);
			target_type = _tmp1142_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1143_;
				ValaSemanticAnalyzer* _tmp1144_;
				ValaSymbol* _tmp1145_;
				ValaSymbol* _tmp1146_;
				ValaSymbol* _tmp1147_;
				_tmp1143_ = vala_code_context_get_analyzer (context);
				_tmp1144_ = _tmp1143_;
				_tmp1145_ = vala_semantic_analyzer_get_current_symbol (_tmp1144_);
				_tmp1146_ = _tmp1145_;
				_tmp1147_ = _vala_code_node_ref0 (_tmp1146_);
				this_symbol = _tmp1147_;
				{
					gboolean _tmp1148_ = FALSE;
					_tmp1148_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1153_;
						ValaSymbol* _tmp1154_;
						ValaSymbol* _tmp1155_;
						if (!_tmp1148_) {
							ValaSymbol* _tmp1149_;
							ValaSymbol* _tmp1150_;
							ValaSymbol* _tmp1151_;
							ValaSymbol* _tmp1152_;
							_tmp1149_ = this_symbol;
							_tmp1150_ = vala_symbol_get_parent_symbol (_tmp1149_);
							_tmp1151_ = _tmp1150_;
							_tmp1152_ = _vala_code_node_ref0 (_tmp1151_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1152_;
						}
						_tmp1148_ = FALSE;
						_tmp1153_ = this_symbol;
						if (!(_tmp1153_ != NULL)) {
							break;
						}
						_tmp1154_ = target_type;
						_tmp1155_ = this_symbol;
						if (_tmp1154_ == _tmp1155_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp1156_ = in_target_type;
			if (!_tmp1156_) {
				ValaSourceReference* _tmp1157_;
				ValaSourceReference* _tmp1158_;
				ValaSymbol* _tmp1159_;
				gchar* _tmp1160_;
				gchar* _tmp1161_;
				gchar* _tmp1162_;
				gchar* _tmp1163_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1158_ = _tmp1157_;
				_tmp1159_ = member;
				_tmp1160_ = vala_symbol_get_full_name (_tmp1159_);
				_tmp1161_ = _tmp1160_;
				_tmp1162_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1161_);
				_tmp1163_ = _tmp1162_;
				vala_report_error (_tmp1158_, _tmp1163_);
				_g_free0 (_tmp1163_);
				_g_free0 (_tmp1161_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	_tmp1165_ = generics;
	if (_tmp1165_) {
		ValaExpression* _tmp1166_;
		ValaExpression* _tmp1167_;
		_tmp1166_ = vala_member_access_get_inner (self);
		_tmp1167_ = _tmp1166_;
		_tmp1164_ = _tmp1167_ != NULL;
	} else {
		_tmp1164_ = FALSE;
	}
	if (_tmp1164_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1168_;
		ValaExpression* _tmp1169_;
		ValaDataType* _tmp1170_;
		ValaDataType* _tmp1171_;
		ValaDataType* _tmp1172_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1173_;
		ValaExpression* _tmp1174_;
		ValaDataType* _tmp1175_;
		ValaDataType* _tmp1176_;
		ValaPointerType* _tmp1177_;
		ValaPointerType* _tmp1178_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1183_;
		ValaObjectType* _tmp1184_;
		gboolean _tmp1185_ = FALSE;
		gboolean _tmp1186_ = FALSE;
		ValaObjectType* _tmp1187_;
		_tmp1168_ = vala_member_access_get_inner (self);
		_tmp1169_ = _tmp1168_;
		_tmp1170_ = vala_expression_get_value_type (_tmp1169_);
		_tmp1171_ = _tmp1170_;
		_tmp1172_ = _vala_code_node_ref0 (_tmp1171_);
		instance_type = _tmp1172_;
		_tmp1173_ = vala_member_access_get_inner (self);
		_tmp1174_ = _tmp1173_;
		_tmp1175_ = vala_expression_get_value_type (_tmp1174_);
		_tmp1176_ = _tmp1175_;
		_tmp1177_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1176_) ? ((ValaPointerType*) _tmp1176_) : NULL);
		pointer_type = _tmp1177_;
		_tmp1178_ = pointer_type;
		if (_tmp1178_ != NULL) {
			ValaPointerType* _tmp1179_;
			ValaDataType* _tmp1180_;
			ValaDataType* _tmp1181_;
			ValaDataType* _tmp1182_;
			_tmp1179_ = pointer_type;
			_tmp1180_ = vala_pointer_type_get_base_type (_tmp1179_);
			_tmp1181_ = _tmp1180_;
			_tmp1182_ = _vala_code_node_ref0 (_tmp1181_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1182_;
		}
		_tmp1183_ = instance_type;
		_tmp1184_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1183_) ? ((ValaObjectType*) _tmp1183_) : NULL);
		object_type = _tmp1184_;
		_tmp1187_ = object_type;
		if (_tmp1187_ != NULL) {
			ValaObjectType* _tmp1188_;
			ValaObjectTypeSymbol* _tmp1189_;
			ValaObjectTypeSymbol* _tmp1190_;
			ValaList* _tmp1191_;
			ValaList* _tmp1192_;
			gint _tmp1193_;
			gint _tmp1194_;
			_tmp1188_ = object_type;
			_tmp1189_ = vala_object_type_get_type_symbol (_tmp1188_);
			_tmp1190_ = _tmp1189_;
			_tmp1191_ = vala_object_type_symbol_get_type_parameters (_tmp1190_);
			_tmp1192_ = _tmp1191_;
			_tmp1193_ = vala_collection_get_size ((ValaCollection*) _tmp1192_);
			_tmp1194_ = _tmp1193_;
			_tmp1186_ = _tmp1194_ > 0;
			_vala_iterable_unref0 (_tmp1192_);
		} else {
			_tmp1186_ = FALSE;
		}
		if (_tmp1186_) {
			ValaDataType* _tmp1195_;
			ValaList* _tmp1196_;
			ValaList* _tmp1197_;
			gint _tmp1198_;
			gint _tmp1199_;
			_tmp1195_ = instance_type;
			_tmp1196_ = vala_data_type_get_type_arguments (_tmp1195_);
			_tmp1197_ = _tmp1196_;
			_tmp1198_ = vala_collection_get_size ((ValaCollection*) _tmp1197_);
			_tmp1199_ = _tmp1198_;
			_tmp1185_ = _tmp1199_ == 0;
			_vala_iterable_unref0 (_tmp1197_);
		} else {
			_tmp1185_ = FALSE;
		}
		if (_tmp1185_) {
			ValaExpression* _tmp1200_;
			ValaExpression* _tmp1201_;
			ValaSourceReference* _tmp1202_;
			ValaSourceReference* _tmp1203_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1200_ = vala_member_access_get_inner (self);
			_tmp1201_ = _tmp1200_;
			_tmp1202_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1201_);
			_tmp1203_ = _tmp1202_;
			vala_report_error (_tmp1203_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	_tmp1206_ = instance;
	if (_tmp1206_) {
		gboolean _tmp1207_;
		_tmp1207_ = may_access_instance_members;
		_tmp1205_ = !_tmp1207_;
	} else {
		_tmp1205_ = FALSE;
	}
	if (_tmp1205_) {
		_tmp1204_ = TRUE;
	} else {
		gboolean _tmp1208_ = FALSE;
		gboolean _tmp1209_;
		_tmp1209_ = klass;
		if (_tmp1209_) {
			gboolean _tmp1210_;
			_tmp1210_ = may_access_klass_members;
			_tmp1208_ = !_tmp1210_;
		} else {
			_tmp1208_ = FALSE;
		}
		_tmp1204_ = _tmp1208_;
	}
	if (_tmp1204_) {
		ValaSymbol* _tmp1211_;
		ValaSymbol* _tmp1212_;
		ValaDataType* _tmp1235_;
		ValaDataType* _tmp1236_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1211_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1212_ = _tmp1211_;
		if (VALA_IS_METHOD (_tmp1212_)) {
			ValaSemanticAnalyzer* _tmp1213_;
			ValaSemanticAnalyzer* _tmp1214_;
			ValaSymbol* _tmp1215_;
			ValaSymbol* _tmp1216_;
			gboolean _tmp1217_;
			gboolean _tmp1218_;
			ValaDataType* _tmp1219_;
			ValaDataType* _tmp1220_;
			_tmp1213_ = vala_code_context_get_analyzer (context);
			_tmp1214_ = _tmp1213_;
			_tmp1215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1216_ = _tmp1215_;
			_tmp1217_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1218_ = _tmp1217_;
			_tmp1219_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1214_, _tmp1216_, _tmp1218_);
			_tmp1220_ = _tmp1219_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1220_);
			_vala_code_node_unref0 (_tmp1220_);
		} else {
			ValaSymbol* _tmp1221_;
			ValaSymbol* _tmp1222_;
			_tmp1221_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1222_ = _tmp1221_;
			if (VALA_IS_FIELD (_tmp1222_)) {
				ValaSymbol* _tmp1223_;
				ValaSymbol* _tmp1224_;
				ValaFieldPrototype* _tmp1225_;
				ValaFieldPrototype* _tmp1226_;
				_tmp1223_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1224_ = _tmp1223_;
				_tmp1225_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1224_, VALA_TYPE_FIELD, ValaField));
				_tmp1226_ = _tmp1225_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1226_);
				_vala_code_node_unref0 (_tmp1226_);
			} else {
				ValaSymbol* _tmp1227_;
				ValaSymbol* _tmp1228_;
				_tmp1227_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1228_ = _tmp1227_;
				if (VALA_IS_PROPERTY (_tmp1228_)) {
					ValaSymbol* _tmp1229_;
					ValaSymbol* _tmp1230_;
					ValaPropertyPrototype* _tmp1231_;
					ValaPropertyPrototype* _tmp1232_;
					_tmp1229_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1230_ = _tmp1229_;
					_tmp1231_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1230_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1232_ = _tmp1231_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1232_);
					_vala_code_node_unref0 (_tmp1232_);
				} else {
					ValaInvalidType* _tmp1233_;
					ValaInvalidType* _tmp1234_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1233_ = vala_invalid_type_new ();
					_tmp1234_ = _tmp1233_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1234_);
					_vala_code_node_unref0 (_tmp1234_);
				}
			}
		}
		_tmp1235_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1236_ = _tmp1235_;
		if (_tmp1236_ != NULL) {
			ValaDataType* _tmp1237_;
			ValaDataType* _tmp1238_;
			ValaDataType* _tmp1239_;
			ValaDataType* _tmp1240_;
			gboolean _tmp1241_;
			gboolean _tmp1242_;
			_tmp1237_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1238_ = _tmp1237_;
			_tmp1239_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1240_ = _tmp1239_;
			_tmp1241_ = vala_data_type_get_value_owned (_tmp1240_);
			_tmp1242_ = _tmp1241_;
			vala_data_type_set_value_owned (_tmp1238_, _tmp1242_);
		}
	} else {
		gboolean _tmp1243_ = FALSE;
		gboolean _tmp1244_;
		gboolean _tmp1265_ = FALSE;
		gboolean _tmp1266_ = FALSE;
		gboolean _tmp1267_ = FALSE;
		gboolean _tmp1268_ = FALSE;
		gboolean _tmp1269_;
		gboolean _tmp1288_ = FALSE;
		gboolean _tmp1289_ = FALSE;
		gboolean _tmp1290_ = FALSE;
		gboolean _tmp1291_ = FALSE;
		gboolean _tmp1292_ = FALSE;
		gboolean _tmp1293_;
		gboolean _tmp1294_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1322_;
		ValaSymbol* _tmp1323_;
		ValaMethod* _tmp1324_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1325_;
		ValaExpression* _tmp1326_;
		ValaMemberAccess* _tmp1327_;
		gboolean _tmp1328_ = FALSE;
		gboolean _tmp1329_ = FALSE;
		gboolean _tmp1330_ = FALSE;
		gboolean _tmp1331_ = FALSE;
		gboolean _tmp1332_ = FALSE;
		ValaMethod* _tmp1333_;
		ValaSemanticAnalyzer* _tmp1374_;
		ValaSemanticAnalyzer* _tmp1375_;
		ValaSymbol* _tmp1376_;
		ValaSymbol* _tmp1377_;
		gboolean _tmp1378_;
		gboolean _tmp1379_;
		ValaDataType* _tmp1380_;
		ValaDataType* _tmp1381_;
		gboolean _tmp1382_ = FALSE;
		ValaExpression* _tmp1383_;
		ValaExpression* _tmp1384_;
		ValaSymbol* _tmp1397_;
		ValaSymbol* _tmp1398_;
		_tmp1244_ = instance;
		if (_tmp1244_) {
			ValaExpression* _tmp1245_;
			ValaExpression* _tmp1246_;
			_tmp1245_ = vala_member_access_get_inner (self);
			_tmp1246_ = _tmp1245_;
			_tmp1243_ = _tmp1246_ == NULL;
		} else {
			_tmp1243_ = FALSE;
		}
		if (_tmp1243_) {
			ValaSourceReference* _tmp1247_;
			ValaSourceReference* _tmp1248_;
			ValaMemberAccess* _tmp1249_;
			ValaMemberAccess* _tmp1250_;
			ValaExpression* _tmp1251_;
			ValaExpression* _tmp1252_;
			ValaParameter* _tmp1253_;
			ValaDataType* _tmp1254_;
			ValaDataType* _tmp1255_;
			ValaDataType* _tmp1256_;
			ValaDataType* _tmp1257_;
			ValaExpression* _tmp1258_;
			ValaExpression* _tmp1259_;
			ValaDataType* _tmp1260_;
			ValaDataType* _tmp1261_;
			ValaExpression* _tmp1262_;
			ValaExpression* _tmp1263_;
			ValaParameter* _tmp1264_;
			_tmp1247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1248_ = _tmp1247_;
			_tmp1249_ = vala_member_access_new (NULL, "this", _tmp1248_);
			_tmp1250_ = _tmp1249_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1250_);
			_vala_code_node_unref0 (_tmp1250_);
			_tmp1251_ = vala_member_access_get_inner (self);
			_tmp1252_ = _tmp1251_;
			_tmp1253_ = this_parameter;
			_tmp1254_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1253_);
			_tmp1255_ = _tmp1254_;
			_tmp1256_ = vala_data_type_copy (_tmp1255_);
			_tmp1257_ = _tmp1256_;
			vala_expression_set_value_type (_tmp1252_, _tmp1257_);
			_vala_code_node_unref0 (_tmp1257_);
			_tmp1258_ = vala_member_access_get_inner (self);
			_tmp1259_ = _tmp1258_;
			_tmp1260_ = vala_expression_get_value_type (_tmp1259_);
			_tmp1261_ = _tmp1260_;
			vala_data_type_set_value_owned (_tmp1261_, FALSE);
			_tmp1262_ = vala_member_access_get_inner (self);
			_tmp1263_ = _tmp1262_;
			_tmp1264_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1263_, (ValaSymbol*) _tmp1264_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		_tmp1269_ = instance;
		if (!_tmp1269_) {
			gboolean _tmp1270_;
			_tmp1270_ = klass;
			_tmp1268_ = !_tmp1270_;
		} else {
			_tmp1268_ = FALSE;
		}
		if (_tmp1268_) {
			ValaSymbol* _tmp1271_;
			ValaSymbol* _tmp1272_;
			_tmp1271_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1272_ = _tmp1271_;
			_tmp1267_ = !VALA_IS_CREATION_METHOD (_tmp1272_);
		} else {
			_tmp1267_ = FALSE;
		}
		if (_tmp1267_) {
			gboolean _tmp1273_;
			_tmp1273_ = may_access_instance_members;
			_tmp1266_ = _tmp1273_;
		} else {
			_tmp1266_ = FALSE;
		}
		if (_tmp1266_) {
			ValaExpression* _tmp1274_;
			ValaExpression* _tmp1275_;
			_tmp1274_ = vala_member_access_get_inner (self);
			_tmp1275_ = _tmp1274_;
			_tmp1265_ = _tmp1275_ != NULL;
		} else {
			_tmp1265_ = FALSE;
		}
		if (_tmp1265_) {
			ValaExpression* _tmp1276_;
			ValaExpression* _tmp1277_;
			ValaSymbol* _tmp1278_;
			ValaSymbol* _tmp1279_;
			_tmp1276_ = vala_member_access_get_inner (self);
			_tmp1277_ = _tmp1276_;
			_tmp1278_ = vala_expression_get_symbol_reference (_tmp1277_);
			_tmp1279_ = _tmp1278_;
			if (VALA_IS_METHOD (_tmp1279_)) {
			} else {
				ValaSourceReference* _tmp1280_;
				ValaSourceReference* _tmp1281_;
				ValaSymbol* _tmp1282_;
				ValaSymbol* _tmp1283_;
				gchar* _tmp1284_;
				gchar* _tmp1285_;
				gchar* _tmp1286_;
				gchar* _tmp1287_;
				_tmp1280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1281_ = _tmp1280_;
				_tmp1282_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1283_ = _tmp1282_;
				_tmp1284_ = vala_symbol_get_full_name (_tmp1283_);
				_tmp1285_ = _tmp1284_;
				_tmp1286_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1285_);
				_tmp1287_ = _tmp1286_;
				vala_report_warning (_tmp1281_, _tmp1287_);
				_g_free0 (_tmp1287_);
				_g_free0 (_tmp1285_);
			}
		}
		_tmp1293_ = vala_code_context_get_experimental_non_null (context);
		_tmp1294_ = _tmp1293_;
		if (_tmp1294_) {
			gboolean _tmp1295_;
			_tmp1295_ = instance;
			_tmp1292_ = _tmp1295_;
		} else {
			_tmp1292_ = FALSE;
		}
		if (_tmp1292_) {
			ValaExpression* _tmp1296_;
			ValaExpression* _tmp1297_;
			ValaDataType* _tmp1298_;
			ValaDataType* _tmp1299_;
			gboolean _tmp1300_;
			gboolean _tmp1301_;
			_tmp1296_ = vala_member_access_get_inner (self);
			_tmp1297_ = _tmp1296_;
			_tmp1298_ = vala_expression_get_value_type (_tmp1297_);
			_tmp1299_ = _tmp1298_;
			_tmp1300_ = vala_data_type_get_nullable (_tmp1299_);
			_tmp1301_ = _tmp1300_;
			_tmp1291_ = _tmp1301_;
		} else {
			_tmp1291_ = FALSE;
		}
		if (_tmp1291_) {
			ValaExpression* _tmp1302_;
			ValaExpression* _tmp1303_;
			ValaDataType* _tmp1304_;
			ValaDataType* _tmp1305_;
			_tmp1302_ = vala_member_access_get_inner (self);
			_tmp1303_ = _tmp1302_;
			_tmp1304_ = vala_expression_get_value_type (_tmp1303_);
			_tmp1305_ = _tmp1304_;
			_tmp1290_ = !VALA_IS_POINTER_TYPE (_tmp1305_);
		} else {
			_tmp1290_ = FALSE;
		}
		if (_tmp1290_) {
			ValaExpression* _tmp1306_;
			ValaExpression* _tmp1307_;
			ValaDataType* _tmp1308_;
			ValaDataType* _tmp1309_;
			_tmp1306_ = vala_member_access_get_inner (self);
			_tmp1307_ = _tmp1306_;
			_tmp1308_ = vala_expression_get_value_type (_tmp1307_);
			_tmp1309_ = _tmp1308_;
			_tmp1289_ = !VALA_IS_GENERIC_TYPE (_tmp1309_);
		} else {
			_tmp1289_ = FALSE;
		}
		if (_tmp1289_) {
			ValaExpression* _tmp1310_;
			ValaExpression* _tmp1311_;
			ValaDataType* _tmp1312_;
			ValaDataType* _tmp1313_;
			_tmp1310_ = vala_member_access_get_inner (self);
			_tmp1311_ = _tmp1310_;
			_tmp1312_ = vala_expression_get_value_type (_tmp1311_);
			_tmp1313_ = _tmp1312_;
			_tmp1288_ = !VALA_IS_ARRAY_TYPE (_tmp1313_);
		} else {
			_tmp1288_ = FALSE;
		}
		if (_tmp1288_) {
			ValaSourceReference* _tmp1314_;
			ValaSourceReference* _tmp1315_;
			ValaSymbol* _tmp1316_;
			ValaSymbol* _tmp1317_;
			gchar* _tmp1318_;
			gchar* _tmp1319_;
			gchar* _tmp1320_;
			gchar* _tmp1321_;
			_tmp1314_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1315_ = _tmp1314_;
			_tmp1316_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1317_ = _tmp1316_;
			_tmp1318_ = vala_symbol_get_full_name (_tmp1317_);
			_tmp1319_ = _tmp1318_;
			_tmp1320_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1319_);
			_tmp1321_ = _tmp1320_;
			vala_report_error (_tmp1315_, _tmp1321_);
			_g_free0 (_tmp1321_);
			_g_free0 (_tmp1319_);
		}
		_tmp1322_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1323_ = _tmp1322_;
		_tmp1324_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1323_) ? ((ValaMethod*) _tmp1323_) : NULL);
		m = _tmp1324_;
		_tmp1325_ = vala_member_access_get_inner (self);
		_tmp1326_ = _tmp1325_;
		_tmp1327_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1326_) ? ((ValaMemberAccess*) _tmp1326_) : NULL);
		inner_ma = _tmp1327_;
		_tmp1333_ = m;
		if (_tmp1333_ != NULL) {
			ValaMethod* _tmp1334_;
			ValaMemberBinding _tmp1335_;
			ValaMemberBinding _tmp1336_;
			_tmp1334_ = m;
			_tmp1335_ = vala_method_get_binding (_tmp1334_);
			_tmp1336_ = _tmp1335_;
			_tmp1332_ = _tmp1336_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1332_ = FALSE;
		}
		if (_tmp1332_) {
			ValaMethod* _tmp1337_;
			ValaSymbol* _tmp1338_;
			ValaSymbol* _tmp1339_;
			_tmp1337_ = m;
			_tmp1338_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1337_);
			_tmp1339_ = _tmp1338_;
			_tmp1331_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1339_);
		} else {
			_tmp1331_ = FALSE;
		}
		if (_tmp1331_) {
			ValaExpression* _tmp1340_;
			ValaExpression* _tmp1341_;
			_tmp1340_ = vala_member_access_get_inner (self);
			_tmp1341_ = _tmp1340_;
			_tmp1330_ = _tmp1341_ != NULL;
		} else {
			_tmp1330_ = FALSE;
		}
		if (_tmp1330_) {
			ValaExpression* _tmp1342_;
			ValaExpression* _tmp1343_;
			ValaDataType* _tmp1344_;
			ValaDataType* _tmp1345_;
			_tmp1342_ = vala_member_access_get_inner (self);
			_tmp1343_ = _tmp1342_;
			_tmp1344_ = vala_expression_get_value_type (_tmp1343_);
			_tmp1345_ = _tmp1344_;
			_tmp1329_ = _tmp1345_ == NULL;
		} else {
			_tmp1329_ = FALSE;
		}
		if (_tmp1329_) {
			ValaMemberAccess* _tmp1346_;
			ValaList* _tmp1347_;
			gint _tmp1348_;
			gint _tmp1349_;
			_tmp1346_ = inner_ma;
			_tmp1347_ = _tmp1346_->priv->type_argument_list;
			_tmp1348_ = vala_collection_get_size ((ValaCollection*) _tmp1347_);
			_tmp1349_ = _tmp1348_;
			_tmp1328_ = _tmp1349_ > 0;
		} else {
			_tmp1328_ = FALSE;
		}
		if (_tmp1328_) {
			ValaExpression* _tmp1350_;
			ValaExpression* _tmp1351_;
			ValaMethod* _tmp1352_;
			ValaSymbol* _tmp1353_;
			ValaSymbol* _tmp1354_;
			ValaObjectType* _tmp1355_;
			ValaObjectType* _tmp1356_;
			_tmp1350_ = vala_member_access_get_inner (self);
			_tmp1351_ = _tmp1350_;
			_tmp1352_ = m;
			_tmp1353_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1352_);
			_tmp1354_ = _tmp1353_;
			_tmp1355_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1354_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1356_ = _tmp1355_;
			vala_expression_set_value_type (_tmp1351_, (ValaDataType*) _tmp1356_);
			_vala_code_node_unref0 (_tmp1356_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1357_;
				ValaList* _tmp1358_;
				ValaList* _tmp1359_;
				gint _type_argument_size = 0;
				ValaList* _tmp1360_;
				gint _tmp1361_;
				gint _tmp1362_;
				gint _type_argument_index = 0;
				_tmp1357_ = inner_ma;
				_tmp1358_ = _tmp1357_->priv->type_argument_list;
				_tmp1359_ = _vala_iterable_ref0 (_tmp1358_);
				_type_argument_list = _tmp1359_;
				_tmp1360_ = _type_argument_list;
				_tmp1361_ = vala_collection_get_size ((ValaCollection*) _tmp1360_);
				_tmp1362_ = _tmp1361_;
				_type_argument_size = _tmp1362_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1363_;
					gint _tmp1364_;
					gint _tmp1365_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1366_;
					gint _tmp1367_;
					gpointer _tmp1368_;
					ValaExpression* _tmp1369_;
					ValaExpression* _tmp1370_;
					ValaDataType* _tmp1371_;
					ValaDataType* _tmp1372_;
					ValaDataType* _tmp1373_;
					_tmp1363_ = _type_argument_index;
					_type_argument_index = _tmp1363_ + 1;
					_tmp1364_ = _type_argument_index;
					_tmp1365_ = _type_argument_size;
					if (!(_tmp1364_ < _tmp1365_)) {
						break;
					}
					_tmp1366_ = _type_argument_list;
					_tmp1367_ = _type_argument_index;
					_tmp1368_ = vala_list_get (_tmp1366_, _tmp1367_);
					type_argument = (ValaDataType*) _tmp1368_;
					_tmp1369_ = vala_member_access_get_inner (self);
					_tmp1370_ = _tmp1369_;
					_tmp1371_ = vala_expression_get_value_type (_tmp1370_);
					_tmp1372_ = _tmp1371_;
					_tmp1373_ = type_argument;
					vala_data_type_add_type_argument (_tmp1372_, _tmp1373_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1374_ = vala_code_context_get_analyzer (context);
		_tmp1375_ = _tmp1374_;
		_tmp1376_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1377_ = _tmp1376_;
		_tmp1378_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1379_ = _tmp1378_;
		_tmp1380_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1375_, _tmp1377_, _tmp1379_);
		_tmp1381_ = _tmp1380_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1381_);
		_vala_code_node_unref0 (_tmp1381_);
		_tmp1383_ = vala_member_access_get_inner (self);
		_tmp1384_ = _tmp1383_;
		if (_tmp1384_ != NULL) {
			ValaDataType* _tmp1385_;
			ValaDataType* _tmp1386_;
			_tmp1385_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1386_ = _tmp1385_;
			_tmp1382_ = _tmp1386_ != NULL;
		} else {
			_tmp1382_ = FALSE;
		}
		if (_tmp1382_) {
			ValaDataType* _tmp1387_;
			ValaDataType* _tmp1388_;
			ValaExpression* _tmp1389_;
			ValaExpression* _tmp1390_;
			ValaDataType* _tmp1391_;
			ValaDataType* _tmp1392_;
			ValaDataType* _tmp1393_;
			ValaDataType* _tmp1394_;
			_tmp1387_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1388_ = _tmp1387_;
			_tmp1389_ = vala_member_access_get_inner (self);
			_tmp1390_ = _tmp1389_;
			_tmp1391_ = vala_expression_get_value_type (_tmp1390_);
			_tmp1392_ = _tmp1391_;
			_tmp1393_ = vala_data_type_get_actual_type (_tmp1388_, _tmp1392_, NULL, (ValaCodeNode*) self);
			_tmp1394_ = _tmp1393_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1394_);
			_vala_code_node_unref0 (_tmp1394_);
		} else {
			ValaDataType* _tmp1395_;
			ValaDataType* _tmp1396_;
			_tmp1395_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1396_ = _tmp1395_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1396_);
		}
		_tmp1397_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1398_ = _tmp1397_;
		if (VALA_IS_METHOD (_tmp1398_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1399_;
			ValaSymbol* _tmp1400_;
			ValaMethod* _tmp1401_;
			ValaDataType* _tmp1402_;
			ValaDataType* _tmp1403_;
			gboolean _tmp1410_ = FALSE;
			gboolean _tmp1411_;
			_tmp1399_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1400_ = _tmp1399_;
			_tmp1401_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1400_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1401_;
			_tmp1402_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1403_ = _tmp1402_;
			if (_tmp1403_ != NULL) {
				ValaDataType* _tmp1404_;
				ValaDataType* _tmp1405_;
				ValaDataType* _tmp1406_;
				ValaDataType* _tmp1407_;
				gboolean _tmp1408_;
				gboolean _tmp1409_;
				_tmp1404_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1405_ = _tmp1404_;
				_tmp1406_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1407_ = _tmp1406_;
				_tmp1408_ = vala_data_type_get_value_owned (_tmp1407_);
				_tmp1409_ = _tmp1408_;
				vala_data_type_set_value_owned (_tmp1405_, _tmp1409_);
			}
			_tmp1411_ = instance;
			if (_tmp1411_) {
				ValaMethod* _tmp1412_;
				ValaSymbol* _tmp1413_;
				ValaSymbol* _tmp1414_;
				_tmp1412_ = method;
				_tmp1413_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1412_);
				_tmp1414_ = _tmp1413_;
				_tmp1410_ = VALA_IS_TYPESYMBOL (_tmp1414_);
			} else {
				_tmp1410_ = FALSE;
			}
			if (_tmp1410_) {
				ValaExpression* _tmp1415_;
				ValaExpression* _tmp1416_;
				ValaMethod* _tmp1417_;
				ValaSymbol* _tmp1418_;
				ValaSymbol* _tmp1419_;
				ValaDataType* _tmp1420_;
				ValaDataType* _tmp1421_;
				ValaExpression* _tmp1422_;
				ValaExpression* _tmp1423_;
				ValaDataType* _tmp1424_;
				ValaDataType* _tmp1425_;
				ValaMethod* _tmp1426_;
				ValaParameter* _tmp1427_;
				ValaParameter* _tmp1428_;
				ValaDataType* _tmp1429_;
				ValaDataType* _tmp1430_;
				gboolean _tmp1431_;
				gboolean _tmp1432_;
				_tmp1415_ = vala_member_access_get_inner (self);
				_tmp1416_ = _tmp1415_;
				_tmp1417_ = method;
				_tmp1418_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1417_);
				_tmp1419_ = _tmp1418_;
				_tmp1420_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1419_);
				_tmp1421_ = _tmp1420_;
				vala_expression_set_target_type (_tmp1416_, _tmp1421_);
				_vala_code_node_unref0 (_tmp1421_);
				_tmp1422_ = vala_member_access_get_inner (self);
				_tmp1423_ = _tmp1422_;
				_tmp1424_ = vala_expression_get_target_type (_tmp1423_);
				_tmp1425_ = _tmp1424_;
				_tmp1426_ = method;
				_tmp1427_ = vala_method_get_this_parameter (_tmp1426_);
				_tmp1428_ = _tmp1427_;
				_tmp1429_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1428_);
				_tmp1430_ = _tmp1429_;
				_tmp1431_ = vala_data_type_get_value_owned (_tmp1430_);
				_tmp1432_ = _tmp1431_;
				vala_data_type_set_value_owned (_tmp1425_, _tmp1432_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1433_;
			ValaSymbol* _tmp1434_;
			_tmp1433_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1434_ = _tmp1433_;
			if (VALA_IS_PROPERTY (_tmp1434_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1435_;
				ValaSymbol* _tmp1436_;
				ValaProperty* _tmp1437_;
				gboolean _tmp1438_ = FALSE;
				gboolean _tmp1439_;
				_tmp1435_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1436_ = _tmp1435_;
				_tmp1437_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1436_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1437_;
				_tmp1439_ = instance;
				if (_tmp1439_) {
					ValaProperty* _tmp1440_;
					ValaSymbol* _tmp1441_;
					ValaSymbol* _tmp1442_;
					_tmp1440_ = prop;
					_tmp1441_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1440_);
					_tmp1442_ = _tmp1441_;
					_tmp1438_ = _tmp1442_ != NULL;
				} else {
					_tmp1438_ = FALSE;
				}
				if (_tmp1438_) {
					ValaExpression* _tmp1443_;
					ValaExpression* _tmp1444_;
					ValaProperty* _tmp1445_;
					ValaSymbol* _tmp1446_;
					ValaSymbol* _tmp1447_;
					ValaDataType* _tmp1448_;
					ValaDataType* _tmp1449_;
					_tmp1443_ = vala_member_access_get_inner (self);
					_tmp1444_ = _tmp1443_;
					_tmp1445_ = prop;
					_tmp1446_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1445_);
					_tmp1447_ = _tmp1446_;
					_tmp1448_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1447_);
					_tmp1449_ = _tmp1448_;
					vala_expression_set_target_type (_tmp1444_, _tmp1449_);
					_vala_code_node_unref0 (_tmp1449_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1450_ = FALSE;
				gboolean _tmp1451_ = FALSE;
				gboolean _tmp1452_ = FALSE;
				ValaSymbol* _tmp1453_;
				ValaSymbol* _tmp1454_;
				_tmp1453_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1454_ = _tmp1453_;
				if (VALA_IS_FIELD (_tmp1454_)) {
					_tmp1452_ = TRUE;
				} else {
					ValaSymbol* _tmp1455_;
					ValaSymbol* _tmp1456_;
					_tmp1455_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1456_ = _tmp1455_;
					_tmp1452_ = VALA_IS_SIGNAL (_tmp1456_);
				}
				if (_tmp1452_) {
					gboolean _tmp1457_;
					_tmp1457_ = instance;
					_tmp1451_ = _tmp1457_;
				} else {
					_tmp1451_ = FALSE;
				}
				if (_tmp1451_) {
					ValaSymbol* _tmp1458_;
					ValaSymbol* _tmp1459_;
					ValaSymbol* _tmp1460_;
					ValaSymbol* _tmp1461_;
					_tmp1458_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1459_ = _tmp1458_;
					_tmp1460_ = vala_symbol_get_parent_symbol (_tmp1459_);
					_tmp1461_ = _tmp1460_;
					_tmp1450_ = _tmp1461_ != NULL;
				} else {
					_tmp1450_ = FALSE;
				}
				if (_tmp1450_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1462_;
					ValaSymbol* _tmp1463_;
					ValaSymbol* _tmp1464_;
					ValaSymbol* _tmp1465_;
					ValaDataType* _tmp1466_;
					ValaExpression* _tmp1467_;
					ValaExpression* _tmp1468_;
					ValaDataType* _tmp1469_;
					ValaExpression* _tmp1470_;
					ValaExpression* _tmp1471_;
					ValaDataType* _tmp1472_;
					ValaDataType* _tmp1473_;
					ValaDataType* _tmp1474_;
					ValaDataType* _tmp1475_;
					_tmp1462_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1463_ = _tmp1462_;
					_tmp1464_ = vala_symbol_get_parent_symbol (_tmp1463_);
					_tmp1465_ = _tmp1464_;
					_tmp1466_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1465_);
					parent_type = _tmp1466_;
					_tmp1467_ = vala_member_access_get_inner (self);
					_tmp1468_ = _tmp1467_;
					_tmp1469_ = parent_type;
					_tmp1470_ = vala_member_access_get_inner (self);
					_tmp1471_ = _tmp1470_;
					_tmp1472_ = vala_expression_get_value_type (_tmp1471_);
					_tmp1473_ = _tmp1472_;
					_tmp1474_ = vala_data_type_get_actual_type (_tmp1469_, _tmp1473_, NULL, (ValaCodeNode*) self);
					_tmp1475_ = _tmp1474_;
					vala_expression_set_target_type (_tmp1468_, _tmp1475_);
					_vala_code_node_unref0 (_tmp1475_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1476_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1477_ = _tmp1476_;
	result = !_tmp1477_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}


static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}


void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp9_;
	gboolean _tmp17_;
	gboolean _tmp25_ = FALSE;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaSymbol* _tmp29_;
	gboolean this_access = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp52_;
	ValaExpression* _tmp53_;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	ValaMemberAccess* _tmp57_;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	_tmp9_ = instance;
	if (!_tmp9_) {
		gboolean _tmp10_ = FALSE;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_METHOD (_tmp12_)) {
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaMemberBinding _tmp16_;
			_tmp13_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_METHOD, ValaMethod));
			_tmp16_ = _tmp15_;
			_tmp10_ = _tmp16_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp10_ = FALSE;
		}
		instance = _tmp10_;
	}
	_tmp17_ = instance;
	if (!_tmp17_) {
		gboolean _tmp18_ = FALSE;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp20_ = _tmp19_;
		if (VALA_IS_PROPERTY (_tmp20_)) {
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp18_ = FALSE;
		}
		instance = _tmp18_;
	}
	_tmp26_ = vala_member_access_get_inner (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_expression_get_symbol_reference (_tmp27_);
	_tmp29_ = _tmp28_;
	if (VALA_IS_PARAMETER (_tmp29_)) {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_expression_get_symbol_reference (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp25_ = g_strcmp0 (_tmp35_, "this") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	this_access = _tmp25_;
	_tmp38_ = vala_member_access_get_inner (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_expression_get_value_type (_tmp39_);
	_tmp41_ = _tmp40_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp41_)) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		_tmp42_ = vala_member_access_get_inner (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_expression_get_value_type (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_data_type_get_nullable (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp37_ = !_tmp47_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		_tmp48_ = vala_member_access_get_inner (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_expression_get_value_type (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp36_ = VALA_IS_ARRAY_TYPE (_tmp51_);
	}
	struct_or_array = _tmp36_;
	_tmp52_ = vala_member_access_get_inner (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp53_) ? ((ValaMemberAccess*) _tmp53_) : NULL);
	ma = _tmp54_;
	_tmp57_ = ma;
	if (_tmp57_ == NULL) {
		gboolean _tmp58_;
		_tmp58_ = struct_or_array;
		_tmp56_ = _tmp58_;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp59_ = vala_member_access_get_inner (self);
		_tmp60_ = _tmp59_;
		_tmp55_ = VALA_IS_POINTER_INDIRECTION (_tmp60_);
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaMemberAccess* _tmp65_;
		_tmp61_ = vala_member_access_get_inner (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp64_ = _tmp63_;
		_tmp65_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp64_) ? ((ValaMemberAccess*) _tmp64_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp65_;
	}
	_tmp70_ = instance;
	if (_tmp70_) {
		gboolean _tmp71_;
		_tmp71_ = struct_or_array;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		gboolean _tmp72_ = FALSE;
		ValaSymbol* _tmp73_;
		ValaSymbol* _tmp74_;
		_tmp73_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp74_ = _tmp73_;
		if (VALA_IS_METHOD (_tmp74_)) {
			_tmp72_ = TRUE;
		} else {
			gboolean _tmp75_;
			gboolean _tmp76_;
			_tmp75_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp76_ = _tmp75_;
			_tmp72_ = _tmp76_;
		}
		_tmp68_ = _tmp72_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		ValaMemberAccess* _tmp79_;
		_tmp79_ = ma;
		if (_tmp79_ != NULL) {
			ValaMemberAccess* _tmp80_;
			ValaSymbol* _tmp81_;
			ValaSymbol* _tmp82_;
			_tmp80_ = ma;
			_tmp81_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp78_ = VALA_IS_VARIABLE (_tmp82_);
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			_tmp83_ = vala_member_access_get_inner (self);
			_tmp84_ = _tmp83_;
			_tmp77_ = VALA_IS_ELEMENT_ACCESS (_tmp84_);
		}
		_tmp67_ = _tmp77_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		gboolean _tmp85_;
		_tmp85_ = this_access;
		_tmp66_ = !_tmp85_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		ValaAttribute* _tmp97_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp97_ = _tmp96_;
		_tmp91_ = _tmp97_ != NULL;
		_vala_code_node_unref0 (_tmp97_);
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaClass* _tmp104_;
		_tmp98_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_METHOD, ValaMethod));
		_tmp101_ = _tmp100_;
		cl = VALA_IS_CLASS (_tmp101_) ? ((ValaClass*) _tmp101_) : NULL;
		_tmp104_ = cl;
		if (_tmp104_ != NULL) {
			ValaClass* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp105_ = cl;
			_tmp106_ = vala_class_get_is_compact (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp103_ = _tmp107_;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp108_;
			_tmp108_ = ma;
			_tmp102_ = _tmp108_ != NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp109_;
			ValaMemberAccess* _tmp110_;
			_tmp109_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp109_, TRUE);
			_tmp110_ = ma;
			vala_member_access_check_lvalue_access (_tmp110_);
		}
	}
	_vala_code_node_unref0 (ma);
}


static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}


static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}


gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pointer_member_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}


gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_prototype_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}


gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_creation_member;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}


gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_qualified;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}


static void
vala_member_access_class_init (ValaMemberAccessClass * klass)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaMemberAccessPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}


static void
vala_member_access_instance_init (ValaMemberAccess * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_MEMBER_ACCESS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}


static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}


/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}



