/***************************************************************************
                          dcconnectionmanager.h  -  description
                             -------------------
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCONNECTIONMANAGER_H
#define DCCONNECTIONMANAGER_H

/**
  *@author Mathias Küster
  */

#include <qobject.h>
#include <qtimer.h>

//Added by qt3to4:
#include <QEvent>
#include <QList>

#include <dclib/cconnectionmanager.h>

class QMdiArea;
class QMdiSubWindow;
class QToolBar;
class QTabBar;
class DCClient;
class CDCMessage;

class DCConnectionManager : public QObject, public CConnectionManager {
Q_OBJECT

public:
	/** construtor */
	DCConnectionManager( QObject * parent = 0 );
	/** destructor */
	virtual ~DCConnectionManager();

	/** */
	void InitDocument();
	
	/** */
	void AutoConnect();
	/** */
	void Connect( CString hubname, CString server, bool sslconnect = false );

	/** */
	void OPKick( QString hubname, QString hubhost, QString nick, QString message );
	/** */
	void OPForceMove( QString hubname, QString hubhost, QString nick, QString message, QString host );

	/** */
	void OpenPrivateChat( QString hubname, QString hubhost, QString nick );
	/** */
	void CloseAllChats( bool onlyOffline );
	/** */
	void DisconnectAllClients();
	/** */
	void CloseDisconnectedHubs();

	/** */
	void InitTabBar( QToolBar * toolbar );
	
	/** callback function */
	virtual int DC_CallBack( CDCMessage * );
	
	/** */
	void HubEvent( DCClient * client );
	/** */
	void CaptionChanged( DCClient * client );
	/** */
	void HubClosing( DCClient * client );
	
	/**
	 * Finds the DCClient for a hub.
	 * Needed for User Commands in Filelist browser, transfer list
	 * and search.
	 */
	DCClient * GetClientForHub( CString hubname, CString hubhost );
	
	/**
	 * Just to stop every window having it's own pointer.
	 */
	QMdiArea * GetMdiArea() { return m_pMdiArea; };

private:
	/** */
	QTimer m_Timer;
	/** */
	QTabBar * m_pTabBar;
	/** */
	QList<CDCMessage*> * m_pMessageList;
	/** */
	QMdiArea * m_pMdiArea;
	/** */
	int m_nSelectedTab;
	/** */
	QList<DCClient*> m_ClientsInTabOrder;
	
private slots:
	/** */
	void timerDone();
	/** */
	void slotTabSelected( int );
	/** widget from mdi area activated */
	void slotMdiSubWindowActivated( QMdiSubWindow * w );
};

/** */
extern DCConnectionManager * g_pConnectionManager;

#endif
