if(CMAKE_SYSTEM_NAME MATCHES "Linux")
    set(LINUX TRUE)
endif(CMAKE_SYSTEM_NAME MATCHES "Linux")

if(CMAKE_SYSTEM_NAME MATCHES "FreeBSD")
    set(FREEBSD true)
endif(CMAKE_SYSTEM_NAME MATCHES "FreeBSD")

option(FAT_RUNTIME "Build a library that supports multiple microarchitectures" OFF)
message("Checking Fat Runtime Requirements...")
if (FAT_RUNTIME AND NOT LINUX)
    message(FATAL_ERROR "Fat runtime is only supported on Linux OS")
endif()

if (USE_CPU_NATIVE AND FAT_RUNTIME)
    message(FATAL_ERROR "Fat runtime is not compatible with Native CPU detection")
endif()

if (FAT_RUNTIME AND LINUX)
    if (NOT (ARCH_IA32 OR ARCH_X86_64 OR ARCH_AARCH64))
        message(FATAL_ERROR "Fat runtime is only supported on Intel and Aarch64 architectures")
    else()
        message(STATUS "Building Fat runtime for multiple microarchitectures")
	message(STATUS "generator is ${CMAKE_GENERATOR}")
        if (NOT (CMAKE_GENERATOR MATCHES "Unix Makefiles" OR
            (CMAKE_VERSION VERSION_GREATER "3.0" AND CMAKE_GENERATOR MATCHES "Ninja")))
	    message (FATAL_ERROR "Building the fat runtime requires the Unix Makefiles generator, or Ninja with CMake v3.0 or higher")
        else()
            include (${CMAKE_MODULE_PATH}/attrib.cmake)
            if (NOT HAS_C_ATTR_IFUNC)
                message(FATAL_ERROR "Compiler does not support ifunc attribute, cannot build fat runtime")
            endif()
        endif()
    endif()
    if (NOT RELEASE_BUILD)
        message(FATAL_ERROR "Fat runtime is only built on Release builds")
    endif()
endif ()


