"""
Plugin modules must be registered here by importing them

Many modules are imported by default which works most of the times.

Some features might be too special so consider this file to be subject
of local configuration and tweak it to your needs.
"""

#---------------------------------------------------------------------------
# Standard enforcement quirks
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.quirks

#---------------------------------------------------------------------------
# X.500 DSAs
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.x500dsa

#---------------------------------------------------------------------------
# Subentries (see RFC 3672)
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.subentries

#---------------------------------------------------------------------------
# NIS (see RFC 2307) and NSS
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.nis
import w2lapp.schema.plugins.ldapns

#---------------------------------------------------------------------------
# Extended plugin classes for NIS attributes with auto-generated
# input values (experimental)
#---------------------------------------------------------------------------

#import w2lapp.schema.plugins.posixautogen
#w2lapp.schema.plugins.posixautogen.HomeDirectory.homeDirectoryTemplate = u'/home/%(uid)s'
#w2lapp.schema.plugins.posixautogen.AutogenUIDNumber.minNewValue = 10000L
#w2lapp.schema.plugins.posixautogen.AutogenUIDNumber.maxNewValue = 19999L
#w2lapp.schema.plugins.posixautogen.AutogenGIDNumber.minNewValue = 10000L
#w2lapp.schema.plugins.posixautogen.AutogenGIDNumber.maxNewValue = 19999L

#---------------------------------------------------------------------------
# sudo-ldap
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.sudoers

# If you solely want to reference groups in 'sudoUser' uncomment following lines
#w2lapp.schema.syntaxes.syntax_registry.registerAttrType(
#  w2lapp.schema.plugins.sudoers.SudoUserGroup.oid,[
#    '1.3.6.1.4.1.15953.9.1.1', # sudoUser
#  ]
#)

#---------------------------------------------------------------------------
# pilotPerson
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.pilotperson

#---------------------------------------------------------------------------
# Just an example for person's schema of stroeder.com
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.msperson

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for OpenLDAP
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.openldap

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for OpenDS
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.opends

#---------------------------------------------------------------------------
# Various syntaxes and work-arounds for MS Active Directory and Exchange 5.5
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.activedirectory
import w2lapp.schema.plugins.exchange
#import w2lapp.schema.plugins.mssfu30

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for Entrust PKI
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.entrust

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for Novell eDirectory
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.edirectory

#---------------------------------------------------------------------------
# Various syntaxes and work-arounds for Domino/LDAP
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.lotusdomino

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for IBM Tivoliy Directory Server
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.ibmds

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for Siemens DirX
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.dirx

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for Samba
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.samba

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for VPIM
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.vpim

#---------------------------------------------------------------------------
# For attributes defined in draft-behera-ldap-password-policy
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.ppolicy

#---------------------------------------------------------------------------
# For attributes defined in draft-vchu-ldap-pwd-policy
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.vchupwdpolicy

#---------------------------------------------------------------------------
# Various syntaxes and attribute types for Kerberos V
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.krb5

#---------------------------------------------------------------------------
# Various attribute types for PGP key server
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.pgpkeysrv

#---------------------------------------------------------------------------
# Various attribute types for DHCP server
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.dhcp

#---------------------------------------------------------------------------
# Various attribute types for eduPerson
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.eduperson

#---------------------------------------------------------------------------
# Various attribute types for SCHAC
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.schac

#---------------------------------------------------------------------------
# Various attribute types for DE-Mail
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.demail

#---------------------------------------------------------------------------
# Various ASN.1 data objects
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.asn1objects

#---------------------------------------------------------------------------
# X.509-related LDAP syntaxes defined in RFC 4523
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.x509

#---------------------------------------------------------------------------
# X.509 cert/CRL schema
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.pkcschema

#---------------------------------------------------------------------------
# Attribute types for OpenSSL-LPK
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.opensshlpk

#---------------------------------------------------------------------------
# Syntaxes, attribute types for ACP-133
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.acp133

#---------------------------------------------------------------------------
# Syntaxes, attribute types for OpenDirectory for Mac OS X
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.apple

#---------------------------------------------------------------------------
# Syntaxes, attribute types for Dynamic Groups
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.dyngroup

#---------------------------------------------------------------------------
# Syntaxes, attribute types for Dynamic Entries
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.dds

#---------------------------------------------------------------------------
# Attribute types for FreeRADIUS/LDAP
#---------------------------------------------------------------------------

import w2lapp.schema.plugins.freeradius

#---------------------------------------------------------------------------
# Add more local or experimental plugins from
# etc/web2ldap/web2ldapcnf/plugins/ here
#---------------------------------------------------------------------------

