/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMNodeList
implements NodeList {
    private List sequence;

    public DOMNodeList(List extent) {
        this.sequence = extent;
    }

    public static DOMNodeList checkAndMake(SequenceExtent extent) throws XPathException {
        Item next;
        SequenceIterator it = extent.iterate();
        ArrayList<Item> list = new ArrayList<Item>(extent.getLength());
        while ((next = it.next()) != null) {
            Object o = next;
            if (!(o instanceof NodeInfo)) {
                throw new XPathException("Supplied sequence contains an item that is not a Saxon NodeInfo");
            }
            if (!(o instanceof VirtualNode)) continue;
            if (!((o = ((VirtualNode)o).getUnderlyingNode()) instanceof Node)) {
                throw new XPathException("Supplied sequence contains an item that is not a wrapper around a DOM Node");
            }
            list.add((Item)o);
        }
        return new DOMNodeList(list);
    }

    public int getLength() {
        return this.sequence.size();
    }

    public Node item(int index) {
        return (Node)this.sequence.get(index);
    }
}

