/*******************************************************************************
 * Copyright (C) 2004-2008 Intel Corp. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       Utils.h
//
//----------------------------------------------------------------------------
#ifndef _UTILS_H
#define _UTILS_H

#include "Types.h"

/*
* Constants
*/
#define MAX_LINE_LEN                   300
#define UNIT8 unsigned char


typedef struct _PARAMS_STRING {
	UINT16  Length;
	UINT8   String[MAX_LINE_LEN];
} PARAMS_STRING;

typedef struct _LOCAL_AGENT_PARAMS {
	PARAMS_STRING	OneTimePassword;
	PARAMS_STRING	DnsSuffix;
	bool		Verbose;
	bool		Activate;
} LOCAL_AGENT_PARAMS;

/*
* Function prototypes
*/
VOID	DisplayErrorMessage(UINT32 errorCode);
VOID	DisplayMessage(UINT32 messageId);
VOID	DisplayString(UINT32 StringId);
VOID	DisplayStatusString(UINT32 statusStringID);
UINT32	Parse(int argc, char *argv[], LOCAL_AGENT_PARAMS *Params);
VOID	PrintHelp();

#endif

