// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/context.proto

package dialogflow

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf4 "github.com/golang/protobuf/ptypes/struct"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Represents a context.
type Context struct {
	// Required. The unique identifier of the context. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`,
	// or
	// `projects/<Project ID>/agent/runtimes/<Runtime ID>/sessions/<Session
	// ID>/contexts/<Context ID>`.
	// Note: Runtimes are under construction and will be available soon.
	// The Context ID is always converted to lowercase.
	// If <Runtime ID> is not specified, we assume default 'sandbox' runtime.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. The number of conversational query requests after which the
	// context expires. If set to `0` (the default) the context expires
	// immediately. Contexts expire automatically after 10 minutes even if there
	// are no matching queries.
	LifespanCount int32 `protobuf:"varint,2,opt,name=lifespan_count,json=lifespanCount" json:"lifespan_count,omitempty"`
	// Optional. The collection of parameters associated with this context.
	// Refer to [this doc](https://dialogflow.com/docs/actions-and-parameters) for
	// syntax.
	Parameters *google_protobuf4.Struct `protobuf:"bytes,3,opt,name=parameters" json:"parameters,omitempty"`
}

func (m *Context) Reset()                    { *m = Context{} }
func (m *Context) String() string            { return proto.CompactTextString(m) }
func (*Context) ProtoMessage()               {}
func (*Context) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Context) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Context) GetLifespanCount() int32 {
	if m != nil {
		return m.LifespanCount
	}
	return 0
}

func (m *Context) GetParameters() *google_protobuf4.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

// The request message for [Contexts.ListContexts][google.cloud.dialogflow.v2beta1.Contexts.ListContexts].
type ListContextsRequest struct {
	// Required. The session to list all contexts from.
	// Format: `projects/<Project ID>/agent/sessions/<Session ID>` or
	// `projects/<Project ID>/agent/runtimes/<Runtime ID>/sessions/<Session ID>`.
	// Note: Runtimes are under construction and will be available soon.
	// If <Runtime ID> is not specified, we assume default 'sandbox' runtime.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListContextsRequest) Reset()                    { *m = ListContextsRequest{} }
func (m *ListContextsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListContextsRequest) ProtoMessage()               {}
func (*ListContextsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ListContextsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListContextsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListContextsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Contexts.ListContexts][google.cloud.dialogflow.v2beta1.Contexts.ListContexts].
type ListContextsResponse struct {
	// The list of contexts. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Contexts []*Context `protobuf:"bytes,1,rep,name=contexts" json:"contexts,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListContextsResponse) Reset()                    { *m = ListContextsResponse{} }
func (m *ListContextsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListContextsResponse) ProtoMessage()               {}
func (*ListContextsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *ListContextsResponse) GetContexts() []*Context {
	if m != nil {
		return m.Contexts
	}
	return nil
}

func (m *ListContextsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [Contexts.GetContext][google.cloud.dialogflow.v2beta1.Contexts.GetContext].
type GetContextRequest struct {
	// Required. The name of the context. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`
	// or `projects/<Project ID>/agent/runtimes/<Runtime ID>/sessions/<Session
	// ID>/contexts/<Context ID>`. Note: Runtimes are under construction and will
	// be available soon. If <Runtime ID> is not specified, we assume default
	// 'sandbox' runtime.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetContextRequest) Reset()                    { *m = GetContextRequest{} }
func (m *GetContextRequest) String() string            { return proto.CompactTextString(m) }
func (*GetContextRequest) ProtoMessage()               {}
func (*GetContextRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *GetContextRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Contexts.CreateContext][google.cloud.dialogflow.v2beta1.Contexts.CreateContext].
type CreateContextRequest struct {
	// Required. The session to create a context for.
	// Format: `projects/<Project ID>/agent/sessions/<Session ID>` or
	// `projects/<Project ID>/agent/runtimes/<Runtime ID>/sessions/<Session ID>`.
	// Note: Runtimes are under construction and will be available soon.
	// If <Runtime ID> is not specified, we assume default 'sandbox' runtime.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The context to create.
	Context *Context `protobuf:"bytes,2,opt,name=context" json:"context,omitempty"`
}

func (m *CreateContextRequest) Reset()                    { *m = CreateContextRequest{} }
func (m *CreateContextRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateContextRequest) ProtoMessage()               {}
func (*CreateContextRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *CreateContextRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateContextRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

// The request message for [Contexts.UpdateContext][google.cloud.dialogflow.v2beta1.Contexts.UpdateContext].
type UpdateContextRequest struct {
	// Required. The context to update.
	Context *Context `protobuf:"bytes,1,opt,name=context" json:"context,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *google_protobuf3.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateContextRequest) Reset()                    { *m = UpdateContextRequest{} }
func (m *UpdateContextRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateContextRequest) ProtoMessage()               {}
func (*UpdateContextRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *UpdateContextRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *UpdateContextRequest) GetUpdateMask() *google_protobuf3.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [Contexts.DeleteContext][google.cloud.dialogflow.v2beta1.Contexts.DeleteContext].
type DeleteContextRequest struct {
	// Required. The name of the context to delete. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`
	// or `projects/<Project ID>/agent/runtimes/<Runtime ID>/sessions/<Session
	// ID>/contexts/<Context ID>`. Note: Runtimes are under construction and will
	// be available soon. If <Runtime ID> is not specified, we assume default
	// 'sandbox' runtime.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteContextRequest) Reset()                    { *m = DeleteContextRequest{} }
func (m *DeleteContextRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteContextRequest) ProtoMessage()               {}
func (*DeleteContextRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *DeleteContextRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Contexts.DeleteAllContexts][google.cloud.dialogflow.v2beta1.Contexts.DeleteAllContexts].
type DeleteAllContextsRequest struct {
	// Required. The name of the session to delete all contexts from. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>` or `projects/<Project
	// ID>/agent/runtimes/<Runtime ID>/sessions/<Session ID>`. Note: Runtimes are
	// under construction and will be available soon. If <Runtime ID> is not
	// specified we assume default 'sandbox' runtime.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
}

func (m *DeleteAllContextsRequest) Reset()                    { *m = DeleteAllContextsRequest{} }
func (m *DeleteAllContextsRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteAllContextsRequest) ProtoMessage()               {}
func (*DeleteAllContextsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *DeleteAllContextsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func init() {
	proto.RegisterType((*Context)(nil), "google.cloud.dialogflow.v2beta1.Context")
	proto.RegisterType((*ListContextsRequest)(nil), "google.cloud.dialogflow.v2beta1.ListContextsRequest")
	proto.RegisterType((*ListContextsResponse)(nil), "google.cloud.dialogflow.v2beta1.ListContextsResponse")
	proto.RegisterType((*GetContextRequest)(nil), "google.cloud.dialogflow.v2beta1.GetContextRequest")
	proto.RegisterType((*CreateContextRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateContextRequest")
	proto.RegisterType((*UpdateContextRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateContextRequest")
	proto.RegisterType((*DeleteContextRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteContextRequest")
	proto.RegisterType((*DeleteAllContextsRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteAllContextsRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Contexts service

type ContextsClient interface {
	// Returns the list of all contexts in the specified session.
	ListContexts(ctx context.Context, in *ListContextsRequest, opts ...grpc.CallOption) (*ListContextsResponse, error)
	// Retrieves the specified context.
	GetContext(ctx context.Context, in *GetContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Creates a context.
	CreateContext(ctx context.Context, in *CreateContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Updates the specified context.
	UpdateContext(ctx context.Context, in *UpdateContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Deletes the specified context.
	DeleteContext(ctx context.Context, in *DeleteContextRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Deletes all active contexts in the specified session.
	DeleteAllContexts(ctx context.Context, in *DeleteAllContextsRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type contextsClient struct {
	cc *grpc.ClientConn
}

func NewContextsClient(cc *grpc.ClientConn) ContextsClient {
	return &contextsClient{cc}
}

func (c *contextsClient) ListContexts(ctx context.Context, in *ListContextsRequest, opts ...grpc.CallOption) (*ListContextsResponse, error) {
	out := new(ListContextsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Contexts/ListContexts", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) GetContext(ctx context.Context, in *GetContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Contexts/GetContext", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) CreateContext(ctx context.Context, in *CreateContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Contexts/CreateContext", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) UpdateContext(ctx context.Context, in *UpdateContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Contexts/UpdateContext", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) DeleteContext(ctx context.Context, in *DeleteContextRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Contexts/DeleteContext", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) DeleteAllContexts(ctx context.Context, in *DeleteAllContextsRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Contexts/DeleteAllContexts", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Contexts service

type ContextsServer interface {
	// Returns the list of all contexts in the specified session.
	ListContexts(context.Context, *ListContextsRequest) (*ListContextsResponse, error)
	// Retrieves the specified context.
	GetContext(context.Context, *GetContextRequest) (*Context, error)
	// Creates a context.
	CreateContext(context.Context, *CreateContextRequest) (*Context, error)
	// Updates the specified context.
	UpdateContext(context.Context, *UpdateContextRequest) (*Context, error)
	// Deletes the specified context.
	DeleteContext(context.Context, *DeleteContextRequest) (*google_protobuf2.Empty, error)
	// Deletes all active contexts in the specified session.
	DeleteAllContexts(context.Context, *DeleteAllContextsRequest) (*google_protobuf2.Empty, error)
}

func RegisterContextsServer(s *grpc.Server, srv ContextsServer) {
	s.RegisterService(&_Contexts_serviceDesc, srv)
}

func _Contexts_ListContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).ListContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Contexts/ListContexts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).ListContexts(ctx, req.(*ListContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_GetContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).GetContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Contexts/GetContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).GetContext(ctx, req.(*GetContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_CreateContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).CreateContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Contexts/CreateContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).CreateContext(ctx, req.(*CreateContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_UpdateContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).UpdateContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Contexts/UpdateContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).UpdateContext(ctx, req.(*UpdateContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_DeleteContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).DeleteContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Contexts/DeleteContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).DeleteContext(ctx, req.(*DeleteContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_DeleteAllContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAllContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).DeleteAllContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Contexts/DeleteAllContexts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).DeleteAllContexts(ctx, req.(*DeleteAllContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Contexts_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Contexts",
	HandlerType: (*ContextsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListContexts",
			Handler:    _Contexts_ListContexts_Handler,
		},
		{
			MethodName: "GetContext",
			Handler:    _Contexts_GetContext_Handler,
		},
		{
			MethodName: "CreateContext",
			Handler:    _Contexts_CreateContext_Handler,
		},
		{
			MethodName: "UpdateContext",
			Handler:    _Contexts_UpdateContext_Handler,
		},
		{
			MethodName: "DeleteContext",
			Handler:    _Contexts_DeleteContext_Handler,
		},
		{
			MethodName: "DeleteAllContexts",
			Handler:    _Contexts_DeleteAllContexts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/context.proto",
}

func init() { proto.RegisterFile("google/cloud/dialogflow/v2beta1/context.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 793 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcd, 0x6f, 0xd3, 0x48,
	0x14, 0xd7, 0xb8, 0xbb, 0xfd, 0x98, 0x34, 0xbb, 0xea, 0x6c, 0xd4, 0x8d, 0xd2, 0xae, 0x1a, 0x79,
	0xb5, 0x4b, 0x14, 0x09, 0x5b, 0x98, 0x2f, 0x41, 0x05, 0x52, 0x9b, 0xd0, 0xaa, 0x52, 0x91, 0xaa,
	0xb4, 0x70, 0xe8, 0x25, 0x9a, 0x26, 0x2f, 0x96, 0xa9, 0x33, 0x63, 0x3c, 0x13, 0x28, 0x45, 0x39,
	0xf0, 0x71, 0xe1, 0xc4, 0x01, 0x09, 0xc4, 0x09, 0x89, 0x03, 0x87, 0xfe, 0x3b, 0xfc, 0x0b, 0x3d,
	0x72, 0xe0, 0xc8, 0x0d, 0x64, 0x7b, 0x9c, 0x8f, 0xc6, 0x25, 0x49, 0xcb, 0xcd, 0x7e, 0xf3, 0x7b,
	0x6f, 0x7e, 0xbf, 0x37, 0xbf, 0x79, 0x36, 0xbe, 0x68, 0x73, 0x6e, 0xbb, 0x60, 0xd6, 0x5c, 0xde,
	0xaa, 0x9b, 0x75, 0x87, 0xba, 0xdc, 0x6e, 0xb8, 0xfc, 0xb1, 0xf9, 0xc8, 0xda, 0x03, 0x49, 0x2f,
	0x99, 0x35, 0xce, 0x24, 0x1c, 0x48, 0xc3, 0xf3, 0xb9, 0xe4, 0x64, 0x29, 0x82, 0x1b, 0x21, 0xdc,
	0xe8, 0xc2, 0x0d, 0x05, 0xcf, 0x2d, 0xaa, 0x7a, 0xd4, 0x73, 0x4c, 0xca, 0x18, 0x97, 0x54, 0x3a,
	0x9c, 0x89, 0x28, 0x3d, 0xb7, 0xa0, 0x56, 0xc3, 0xb7, 0xbd, 0x56, 0xc3, 0x84, 0xa6, 0x27, 0x9f,
	0xa8, 0xc5, 0xfc, 0xc9, 0xc5, 0x86, 0x03, 0x6e, 0xbd, 0xda, 0xa4, 0x62, 0x5f, 0x21, 0x16, 0x4f,
	0x22, 0x84, 0xf4, 0x5b, 0x35, 0xc5, 0x4d, 0x6f, 0xe3, 0xa9, 0x52, 0x44, 0x96, 0x10, 0xfc, 0x1b,
	0xa3, 0x4d, 0xc8, 0xa2, 0x3c, 0x2a, 0xcc, 0x54, 0xc2, 0x67, 0xf2, 0x1f, 0xfe, 0xc3, 0x75, 0x1a,
	0x20, 0x3c, 0xca, 0xaa, 0x35, 0xde, 0x62, 0x32, 0xab, 0xe5, 0x51, 0xe1, 0xf7, 0x4a, 0x3a, 0x8e,
	0x96, 0x82, 0x20, 0xb9, 0x8e, 0xb1, 0x47, 0x7d, 0xda, 0x04, 0x09, 0xbe, 0xc8, 0x4e, 0xe4, 0x51,
	0x21, 0x65, 0xfd, 0x6d, 0x28, 0xd9, 0xf1, 0xc6, 0xc6, 0x76, 0xb8, 0x71, 0xa5, 0x07, 0xaa, 0x3b,
	0xf8, 0xaf, 0x4d, 0x47, 0x48, 0x45, 0x41, 0x54, 0xe0, 0x61, 0x0b, 0x84, 0x24, 0xf3, 0x78, 0xd2,
	0xa3, 0x3e, 0x30, 0xa9, 0xc8, 0xa8, 0x37, 0xb2, 0x80, 0x67, 0x3c, 0x6a, 0x43, 0x55, 0x38, 0x87,
	0xa0, 0x98, 0x4c, 0x07, 0x81, 0x6d, 0xe7, 0x10, 0xc8, 0x3f, 0x01, 0x09, 0x1b, 0xaa, 0x92, 0xef,
	0x03, 0x0b, 0x49, 0xcc, 0x54, 0x42, 0xf8, 0x4e, 0x10, 0xd0, 0x5f, 0x22, 0x9c, 0xe9, 0xdf, 0x4b,
	0x78, 0x9c, 0x09, 0x20, 0x65, 0x3c, 0xad, 0xce, 0x4b, 0x64, 0x51, 0x7e, 0xa2, 0x90, 0xb2, 0x0a,
	0xc6, 0x90, 0x13, 0x33, 0x54, 0x91, 0x4a, 0x27, 0x93, 0xfc, 0x8f, 0xff, 0x64, 0x70, 0x20, 0xab,
	0x3d, 0x14, 0xb4, 0x90, 0x42, 0x3a, 0x08, 0x6f, 0x75, 0x68, 0x5c, 0xc0, 0x73, 0xeb, 0x10, 0x93,
	0x88, 0xf5, 0x26, 0xb4, 0x5e, 0xf7, 0x71, 0xa6, 0xe4, 0x03, 0x95, 0x70, 0x02, 0x7b, 0x5a, 0x6f,
	0x56, 0xf1, 0x94, 0x22, 0x13, 0x6e, 0x3c, 0x8e, 0x8a, 0x38, 0x51, 0x7f, 0x87, 0x70, 0xe6, 0x9e,
	0x57, 0x1f, 0xdc, 0xb4, 0xa7, 0x38, 0x3a, 0x63, 0x71, 0xb2, 0x8c, 0x53, 0xad, 0xb0, 0x76, 0xe8,
	0x4e, 0x45, 0x32, 0x37, 0xe0, 0x92, 0xb5, 0xc0, 0xc0, 0x77, 0xa9, 0xd8, 0xaf, 0xe0, 0x08, 0x1e,
	0x3c, 0xeb, 0x45, 0x9c, 0x29, 0x83, 0x0b, 0x03, 0xc4, 0x92, 0x3a, 0x67, 0xe1, 0x6c, 0x84, 0x5d,
	0x71, 0xdd, 0x11, 0x9d, 0x65, 0x7d, 0x4f, 0xe1, 0xe9, 0x18, 0x4b, 0x9e, 0x69, 0x78, 0xb6, 0xd7,
	0x2a, 0xe4, 0xca, 0x50, 0xb5, 0x09, 0x2e, 0xce, 0x5d, 0x1d, 0x33, 0x2b, 0xf2, 0xa3, 0xfe, 0x02,
	0x3d, 0xff, 0x7c, 0xfc, 0x46, 0x6b, 0x93, 0x6b, 0x9d, 0x79, 0xf2, 0x34, 0x62, 0x79, 0xcb, 0xf3,
	0xf9, 0x03, 0xa8, 0x49, 0x61, 0x16, 0x4d, 0x6a, 0x03, 0x93, 0xa6, 0x00, 0x21, 0x82, 0x51, 0x61,
	0x16, 0xdb, 0xf1, 0xd0, 0x11, 0xbb, 0x25, 0xb2, 0x32, 0x3c, 0xd3, 0x6f, 0x31, 0xe9, 0x34, 0x21,
	0x08, 0x24, 0x15, 0x21, 0x5f, 0x11, 0xc6, 0x5d, 0xa3, 0x12, 0x6b, 0xa8, 0x96, 0x01, 0x57, 0xe7,
	0x46, 0xf6, 0x48, 0xa2, 0xe4, 0xe0, 0x28, 0x7f, 0x26, 0xb8, 0x43, 0xd5, 0x2c, 0xb6, 0xfb, 0x25,
	0x27, 0x67, 0x26, 0x0a, 0xee, 0x2d, 0x42, 0x5e, 0x69, 0x38, 0xdd, 0x77, 0xe5, 0xc8, 0xf0, 0x13,
	0x4c, 0xba, 0xa2, 0x63, 0x08, 0x7f, 0x1b, 0x09, 0x7f, 0x8d, 0xf4, 0x33, 0x1e, 0xf6, 0xcd, 0xf8,
	0x7a, 0xed, 0x6e, 0xea, 0xe7, 0x3f, 0xf5, 0x4e, 0x35, 0xf2, 0x5e, 0xc3, 0xe9, 0xbe, 0x49, 0x30,
	0x42, 0x2f, 0x92, 0x26, 0xc7, 0x18, 0xbd, 0xf8, 0x14, 0xf5, 0xe2, 0x03, 0xb2, 0x6e, 0x77, 0x85,
	0xc4, 0x5f, 0xd2, 0x71, 0xdc, 0xd0, 0xed, 0xc9, 0x8e, 0xb5, 0x31, 0x6a, 0xa9, 0xa1, 0xf6, 0xe8,
	0xf6, 0xe6, 0x18, 0xe1, 0x74, 0xdf, 0x30, 0x1a, 0xa1, 0x37, 0x49, 0xc3, 0x2b, 0x37, 0x3f, 0x30,
	0xfc, 0xee, 0x04, 0x9f, 0xf6, 0xce, 0x75, 0x28, 0x9e, 0xf9, 0x3a, 0x14, 0x7f, 0xc1, 0x75, 0xf8,
	0x82, 0xf0, 0xdc, 0xc0, 0x1c, 0x25, 0x37, 0x46, 0x94, 0x3a, 0x38, 0x7b, 0xc7, 0x92, 0x3b, 0xde,
	0xc0, 0x2b, 0x9e, 0xdf, 0xfa, 0xab, 0x47, 0x08, 0xff, 0x5b, 0xe3, 0xcd, 0x61, 0xf2, 0x56, 0x67,
	0x95, 0xac, 0xad, 0x40, 0xc4, 0x16, 0xda, 0xdd, 0x50, 0x09, 0x36, 0x77, 0x29, 0xb3, 0x0d, 0xee,
	0xdb, 0xa6, 0x0d, 0x2c, 0x94, 0x68, 0x46, 0x4b, 0xd4, 0x73, 0xc4, 0xa9, 0xff, 0x8a, 0xcb, 0xdd,
	0xd0, 0x37, 0x84, 0x3e, 0x6a, 0x5a, 0x79, 0xed, 0x48, 0x5b, 0x5a, 0x8f, 0x6a, 0x96, 0x42, 0x12,
	0xe5, 0x2e, 0x89, 0xfb, 0x51, 0xd2, 0xde, 0x64, 0x58, 0xff, 0xf2, 0x8f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x61, 0xec, 0x01, 0x66, 0x8a, 0x0a, 0x00, 0x00,
}
