/* listiterator.c generated by valac 0.54.6, the Vala compiler
 * generated from listiterator.vala, do not modify */

/* listiterator.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>

static GType gee_list_iterator_get_type_once (void);

/**
 * Sets the current item in the iteration to the specified new item.
 */
void
gee_list_iterator_set (GeeListIterator* self,
                       gconstpointer item)
{
	GeeListIteratorIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_LIST_ITERATOR_GET_INTERFACE (self);
	if (_iface_->set) {
		_iface_->set (self, item);
	}
}

/**
 * Adds the specified item after the current item in the iteration. The
 * iterator is moved to the point of the new added item.
 *
 * Please note that if iterator points in-between elements the element
 * is added after the current element and iterator point on it.
 */
void
gee_list_iterator_add (GeeListIterator* self,
                       gconstpointer item)
{
	GeeListIteratorIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_LIST_ITERATOR_GET_INTERFACE (self);
	if (_iface_->add) {
		_iface_->add (self, item);
	}
}

/**
 * Returns the current index in the iteration.
 *
 * @return the current index
 */
gint
gee_list_iterator_index (GeeListIterator* self)
{
	GeeListIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GEE_LIST_ITERATOR_GET_INTERFACE (self);
	if (_iface_->index) {
		return _iface_->index (self);
	}
	return -1;
}

static void
gee_list_iterator_default_init (GeeListIteratorIface * iface,
                                gpointer iface_data)
{
}

/**
 * A list iterator. This supports bi-directionnal and index-based iteration.
 */
static GType
gee_list_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeListIteratorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_list_iterator_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_list_iterator_type_id;
	gee_list_iterator_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeListIterator", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_list_iterator_type_id, GEE_TYPE_ITERATOR);
	return gee_list_iterator_type_id;
}

GType
gee_list_iterator_get_type (void)
{
	static volatile gsize gee_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_list_iterator_type_id__volatile)) {
		GType gee_list_iterator_type_id;
		gee_list_iterator_type_id = gee_list_iterator_get_type_once ();
		g_once_init_leave (&gee_list_iterator_type_id__volatile, gee_list_iterator_type_id);
	}
	return gee_list_iterator_type_id__volatile;
}

