/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
/*****************************************************************************************
 ******************** This file was generated by sksllex. Do not edit. *******************
 *****************************************************************************************/
#include "src/sksl/SkSLLexer.h"

namespace SkSL {

using State = uint16_t;
static constexpr uint8_t kInvalidChar = 18;
static constexpr int8_t kMappings[118] = {
        1,  2,  3,  3,  1,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
        3,  3,  3,  1,  4,  3,  5,  6,  7,  8,  3,  9,  10, 11, 12, 13, 14, 15, 16, 17,
        18, 19, 20, 21, 22, 22, 22, 23, 23, 24, 25, 26, 27, 28, 29, 3,  30, 30, 31, 32,
        33, 30, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 35, 36, 34, 37, 34, 34, 38,
        34, 34, 39, 3,  40, 41, 42, 3,  43, 44, 45, 46, 47, 48, 49, 50, 51, 34, 52, 53,
        54, 55, 56, 57, 34, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
using IndexEntry = int16_t;
struct FullEntry {
    State data[71];
};
struct CompactEntry {
    uint32_t values;
    uint8_t data[18];
};
static constexpr FullEntry kFull[] = {
        {
                0,   2,   3,   4,   5,   7,   9,   23,  25,  28,  29,  30,  32,  35,  36,
                39,  44,  50,  69,  69,  69,  69,  69,  69,  71,  72,  73,  77,  79,  83,
                84,  84,  84,  84,  84,  84,  84,  84,  84,  86,  87,  88,  84,  91,  104,
                114, 130, 150, 162, 178, 183, 191, 84,  215, 225, 232, 258, 263, 279, 291,
                345, 362, 378, 390, 84,  84,  84,  411, 412, 415, 416,
        },
        {
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  0,  51, 0,  59, 59, 59, 59, 59, 59, 60,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 66, 67, 0,  0,  0,  0,  0,  0,  0,  0,  61,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 66, 0,  0,  67, 0,  0,  0,  0,  0,  0,
        },
        {
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  0, 51, 0, 59, 59, 59, 59, 59, 59, 60,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 65, 0, 0,  0, 0,  0,  0,  0,  0,  0,  61,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 65, 0, 0,  0, 0,  0,  0,  0,  0,  0,
        },
        {
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  0, 51, 0, 60, 60, 60, 60, 60, 60, 60,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 64, 0, 0,  0, 0,  0,  0,  0,  0,  0,  61,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 64, 0, 0,  0, 0,  0,  0,  0,  0,  0,
        },
        {
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  0, 51, 0, 70, 70, 70, 70, 70, 70, 70,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 66, 0, 0,  0, 0,  0,  0,  0,  0,  0,  61,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 66, 0, 0,  0, 0,  0,  0,  0,  0,  0,
        },
        {
                0,  0,  0,   0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  85,
                85, 85, 85,  85, 85, 85, 0,  0,   0,  0,  0,  0,  85, 85, 85, 85, 85, 85,
                85, 85, 85,  0,  0,  0,  85, 115, 85, 85, 85, 85, 85, 85, 85, 85, 85, 118,
                85, 85, 121, 85, 85, 85, 85, 85,  85, 85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,   0,  0,  0,  0,  0,  0,   0,  0,  0,   0,  0,  0,  0,   0,  85,
                85, 85, 85,  85, 85, 85, 0,  0,  0,   0,  0,  0,   85, 85, 85, 85,  85, 85,
                85, 85, 85,  0,  0,  0,  85, 85, 85,  85, 85, 131, 85, 85, 85, 137, 85, 85,
                85, 85, 143, 85, 85, 85, 85, 85, 147, 85, 85, 85,  85, 0,  0,  0,   0,
        },
        {
                0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  85,
                85, 85,  85, 85, 85, 85, 0,  0,  0,  0,  0,   0,  85, 85, 85, 85, 85, 85,
                85, 85,  85, 0,  0,  0,  85, 85, 85, 85, 85,  85, 85, 85, 85, 85, 85, 151,
                85, 154, 85, 85, 85, 85, 85, 85, 85, 85, 156, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,   0,  0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   0,  85,
                85, 85, 85,  85, 85, 85, 0,  0,   0,   0,  0,  0,  85, 85, 85, 85,  85, 85,
                85, 85, 85,  0,  0,  0,  85, 163, 85,  85, 85, 85, 85, 85, 85, 167, 85, 170,
                85, 85, 173, 85, 85, 85, 85, 85,  175, 85, 85, 85, 85, 0,  0,  0,   0,
        },
        {
                0,  0,  0,   0,   0,  0,  0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  85,
                85, 85, 85,  85,  85, 85, 0,   0,  0,   0,  0,  0,  85, 85, 85, 85, 85, 85,
                85, 85, 85,  0,   0,  0,  85,  85, 85,  85, 85, 85, 85, 85, 85, 85, 85, 194,
                85, 85, 198, 201, 85, 85, 203, 85, 209, 85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  85,
                85, 85, 85, 85, 85,  85, 0,  0,   0,  0,  0,  0,  85, 85, 85, 85, 85, 85,
                85, 85, 85, 0,  0,   0,  85, 264, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
                85, 85, 85, 85, 268, 85, 85, 275, 85, 85, 85, 85, 85, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,   0,  85,
                85, 85, 85, 85, 85, 85, 0,   0,   0,  0,   0,  0,  85, 85, 85, 85,  85, 85,
                85, 85, 85, 0,  0,  0,  85,  292, 85, 85,  85, 85, 85, 85, 85, 324, 85, 85,
                85, 85, 85, 85, 85, 85, 328, 336, 85, 340, 85, 85, 85, 0,  0,  0,   0,
        },
        {
                0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  85,
                298, 305, 316, 85, 85, 85, 0,  0,  0,  0,  0,  0,  85, 321, 85, 85, 85, 85,
                85,  85,  85,  0,  0,  0,  85, 85, 85, 85, 85, 85, 85, 85,  85, 85, 85, 85,
                85,  85,  85,  85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 0,   0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,   0,  0,  0,   0,  0,  85,
                85, 85, 85, 85, 85,  85, 0,  0,  0,  0,  0,  0,   85, 85, 85,  85, 85, 85,
                85, 85, 85, 0,  0,   0,  85, 85, 85, 85, 85, 346, 85, 85, 352, 85, 85, 85,
                85, 85, 85, 85, 354, 85, 85, 85, 85, 85, 85, 357, 85, 0,  0,   0,  0,
        },
        {
                0,  0,  0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  85,
                85, 85, 85,  85, 85,  85, 0,  0,  0,  0,  0,  0,  85, 85, 85,  85, 85, 85,
                85, 85, 85,  0,  0,   0,  85, 85, 85, 85, 85, 85, 85, 85, 391, 85, 85, 85,
                85, 85, 395, 85, 403, 85, 85, 85, 85, 85, 85, 85, 85, 0,  0,   0,  0,
        },
};
static constexpr CompactEntry kCompact[] = {
        {0,
         {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {3,
         {195, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {6,
         {255, 255, 255, 255, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {8, {255, 255, 255, 255, 255, 255, 255, 15, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {8, {255, 255, 255, 255, 3, 0, 255, 15, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {19 | (11 << 9) | (10 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 106, 170, 170, 162, 170, 234, 63}},
        {10, {255, 255, 255, 255, 3, 0, 255, 15, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {14 | (12 << 9) | (10 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 170, 170, 106, 170, 232, 63}},
        {13 | (10 << 9),
         {255, 255, 255, 255, 87, 84, 255, 95, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {15 | (10 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {16 | (10 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {17 | (10 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {18 | (10 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {20 | (10 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {21 | (10 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {22 | (10 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {24,
         {255, 255, 255, 255, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {27 | (26 << 9),
         {255, 255, 253, 255, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {31,
         {255, 255, 255, 255, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {34 | (33 << 9),
         {255, 255, 255, 253, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {38 | (37 << 9),
         {255, 255, 255, 223, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {40, {255, 255, 255, 255, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {41 | (40 << 9),
         {255, 255, 255, 255, 87, 85, 255, 255, 243, 255, 255, 63, 255, 255, 255, 255, 255, 63}},
        {43 | (42 << 9),
         {255, 255, 255, 221, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {43, {255, 255, 255, 255, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {49 | (48 << 9) | (45 << 18),
         {255, 255, 191, 255, 253, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {46 | (45 << 9), {87, 85, 21, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 21}},
        {47 | (45 << 9), {87, 85, 85, 85, 84, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 21}},
        {48, {51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
        {56 | (52 << 9),
         {255, 255, 255, 255, 87, 85, 255, 255, 243, 255, 255, 63, 255, 255, 255, 255, 255, 63}},
        {53 | (52 << 9),
         {255, 255, 255, 255, 87, 85, 255, 255, 243, 255, 255, 63, 255, 255, 255, 255, 255, 63}},
        {55 | (54 << 9),
         {255, 255, 255, 221, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {55, {255, 255, 255, 255, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {58 | (57 << 9),
         {255, 255, 255, 221, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {58, {255, 255, 255, 255, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {63 | (62 << 9),
         {255, 255, 255, 221, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {63, {255, 255, 255, 255, 3, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {68, {255, 255, 255, 255, 3, 0, 255, 15, 240, 255, 63, 0, 252, 255, 255, 255, 255, 63}},
        {68 | (66 << 9),
         {255, 255, 255, 255, 3, 0, 255, 15, 240, 247, 63, 0, 252, 255, 255, 247, 255, 63}},
        {76 | (74 << 9),
         {255, 255, 255, 255, 255, 255, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {75,
         {255, 255, 255, 255, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {78,
         {255, 255, 255, 255, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {81 | (80 << 9),
         {255, 255, 255, 255, 255, 255, 127, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {82,
         {255, 255, 255, 255, 255, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63}},
        {85, {255, 255, 255, 255, 3, 0, 255, 15, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {90 | (89 << 9),
         {255, 255, 255, 255, 255, 255, 127, 255, 255, 255, 243, 255, 255, 255, 255, 255, 255, 63}},
        {94 | (92 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 170, 170, 106, 168, 234, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {98 | (95 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 170, 170, 169, 168, 234, 63}},
        {96 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {97 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {99 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {100 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {101 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {102 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {103 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {109 | (105 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 170, 170, 154, 162, 234, 63}},
        {106 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {107 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {108 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 84, 85, 85, 213, 63}},
        {110 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {111 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {112 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {113 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {116 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {117 | (93 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 42, 170, 170, 170, 169, 234, 63}},
        {119 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {120 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {122 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {125 | (123 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 170, 170, 106, 168, 234, 63}},
        {124 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {126 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {127 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {128 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {129 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {132 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {133 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {134 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {135 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {136 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {138 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {139 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {140 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {141 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {142 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {144 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {145 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {146 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {148 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {149 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 23, 80, 255, 95, 85, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {152 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {153 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {155 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {157 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {158 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {159 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {160 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {161 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {164 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {165 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {166 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {168 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 85, 212, 63}},
        {169 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {171 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {172 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {174 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {176 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {177 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {181 | (179 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 170, 166, 168, 170, 234, 63}},
        {180 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 79, 85, 85, 85, 85, 85, 213, 63}},
        {180, {255, 255, 255, 255, 3, 0, 255, 15, 0, 192, 15, 0, 0, 0, 0, 0, 192, 63}},
        {182 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {188 | (184 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 106, 170, 170, 138, 234, 63}},
        {185 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {186 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {187 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {189 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {190 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {193 | (192 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 169, 42, 170, 170, 234, 63}},
        {195 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {196 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {197 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {199 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {200 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {202 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {204 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {205 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {206 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {207 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {208 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {210 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {211 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {212 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {213 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {214 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {221 | (216 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 111, 170, 170, 170, 168, 170, 234, 63}},
        {217 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {218 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {219 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {220 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {223 | (222 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 170, 106, 170, 42, 234, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {224 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {226 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {227 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {228 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {229 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {230 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {231 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {240 | (233 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 111, 170, 170, 170, 168, 170, 234, 63}},
        {234 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {235 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {236 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {237 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {238 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {239 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {247 | (241 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 106, 170, 162, 170, 234, 63}},
        {242 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {243 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {244 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {245 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {246 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {248 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {249 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {250 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {251 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {252 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {253 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {254 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {255 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {256 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 69, 213, 63}},
        {257 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {259 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {260 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {261 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {262 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {265 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {266 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 84, 85, 85, 213, 63}},
        {267 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {269 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {270 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {271 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {272 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 21, 85, 213, 63}},
        {273 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {274 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {276 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {277 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {278 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {280 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {287 | (281 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 111, 170, 170, 170, 170, 168, 234, 63}},
        {282 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {283 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {284 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {285 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {286 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {288 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {289 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {290 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {293 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {294 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {295 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {296 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {297 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {299 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 84, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {300 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {301 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {302 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {303 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {304 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 21, 213, 63}},
        {306 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 84, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {307 | (300 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 42, 233, 175, 170, 170, 170, 170, 170, 234, 63}},
        {308 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {309 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {310 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {311 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 212, 95, 85, 85, 85, 85, 85, 213, 63}},
        {312 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {313 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {314 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {315 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {317 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 84, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {318 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 21, 213, 95, 85, 85, 85, 85, 85, 213, 63}},
        {319 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {320 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {322 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {323 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 84, 85, 85, 85, 85, 213, 63}},
        {325 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 85, 197, 63}},
        {326 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {327 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 84, 85, 85, 85, 213, 63}},
        {332 | (329 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 111, 170, 170, 170, 138, 170, 234, 63}},
        {330 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {331 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {333 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {334 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {335 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {337 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {338 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {339 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {93 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {341 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {342 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {343 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 81, 85, 85, 85, 85, 213, 63}},
        {344 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 69, 85, 85, 85, 213, 63}},
        {347 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {348 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {349 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {350 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {351 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {353 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {355 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {356 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {358 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {359 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {360 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 69, 85, 85, 85, 85, 213, 63}},
        {361 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {375 | (363 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 170, 106, 42, 170, 234, 63}},
        {370 | (364 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 106, 170, 42, 170, 234, 63}},
        {369 | (365 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 175, 170, 169, 170, 168, 170, 234, 63}},
        {366 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {367 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {368 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 69, 85, 85, 213, 63}},
        {371 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {372 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {373 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {374 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {376 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {377 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {384 | (379 << 9) | (85 << 18),
         {255, 255, 255, 255, 171, 170, 255, 175, 170, 234, 111, 170, 170, 170, 168, 170, 234, 63}},
        {380 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {381 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {382 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {383 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {385 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {386 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 31, 85, 85, 85, 85, 85, 213, 63}},
        {387 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {388 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {389 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {392 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {393 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {394 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {396 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {397 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 84, 85, 85, 213, 63}},
        {398 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 81, 85, 85, 85, 213, 63}},
        {399 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 69, 85, 213, 63}},
        {400 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {401 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 81, 213, 63}},
        {402 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 81, 85, 213, 63}},
        {404 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 21, 85, 85, 85, 213, 63}},
        {405 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 84, 213, 63}},
        {406 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 21, 85, 85, 85, 85, 213, 63}},
        {407 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 84, 85, 213, 63}},
        {408 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 21, 85, 85, 213, 63}},
        {409 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 81, 85, 85, 213, 63}},
        {410 | (85 << 9),
         {255, 255, 255, 255, 87, 85, 255, 95, 85, 213, 95, 85, 85, 85, 85, 85, 209, 63}},
        {414 | (413 << 9),
         {255, 255, 255, 255, 255, 255, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 60}},
};
static constexpr IndexEntry kIndices[] = {
        0,   -1,  1,   1,   0,   2,   0,   3,   4,   5,   6,   7,   8,   6,   9,   10,  11,  12,
        6,   13,  14,  15,  6,   16,  0,   17,  0,   0,   0,   0,   18,  0,   19,  0,   0,   0,
        20,  0,   0,   21,  22,  23,  24,  24,  25,  26,  27,  0,   28,  0,   -2,  29,  30,  31,
        32,  32,  33,  34,  34,  -3,  -4,  35,  36,  36,  0,   0,   0,   37,  38,  -5,  -5,  0,
        0,   39,  40,  0,   0,   41,  0,   42,  0,   43,  0,   0,   44,  44,  0,   0,   45,  0,
        0,   46,  47,  44,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,
        44,  62,  63,  64,  65,  44,  -6,  66,  67,  44,  68,  69,  70,  71,  72,  73,  44,  74,
        75,  76,  77,  44,  -7,  78,  79,  80,  81,  82,  44,  83,  84,  85,  86,  87,  44,  88,
        89,  90,  57,  91,  92,  93,  -8,  94,  95,  44,  96,  47,  97,  98,  99,  100, 101, 102,
        -9,  103, 104, 105, 44,  106, 107, 108, 109, 110, 44,  111, 44,  112, 113, 93,  114, 115,
        116, 117, 118, 119, 120, 121, 122, 44,  123, 124, 93,  125, 44,  -10, 126, 127, 128, 44,
        129, 130, 44,  131, 132, 133, 134, 135, 136, 137, 57,  138, 139, 140, 141, 142, 132, 143,
        144, 145, 146, 147, 44,  148, 149, 150, 44,  151, 152, 153, 154, 155, 156, 44,  157, 158,
        159, 160, 161, 162, 163, 57,  164, 165, 166, 167, 168, 169, 44,  170, 171, 172, 173, 174,
        175, 176, 177, 178, 179, 44,  180, 181, 182, 183, 132, -11, 184, 185, 186, 108, 187, 188,
        189, 190, 191, 192, 193, 194, 195, 196, 51,  197, 198, 199, 200, 201, 202, 203, 44,  204,
        205, 206, 44,  -12, 207, 208, 209, 210, 211, -13, 212, 213, 214, 215, 216, 217, 218, 219,
        220, 221, 222, 223, 224, 225, 226, 227, 228, 218, 229, 230, 231, 232, 132, 233, 234, 57,
        235, 236, 237, 238, 239, 240, 241, 51,  242, 243, 244, 44,  245, 246, 247, 248, 249, 250,
        251, 252, 44,  -14, 253, 254, 255, 256, 257, 57,  258, 70,  259, 260, 44,  261, 262, 263,
        264, 238, 265, 266, 267, 268, 269, 270, 44,  193, 271, 272, 273, 274, 108, 275, 276, 149,
        277, 278, 279, 280, 281, 149, 282, 283, 284, 285, 286, 57,  -15, 287, 288, 289, 44,  290,
        291, 292, 293, 294, 295, 296, 44,  297, 298, 299, 300, 301, 302, 303, 44,  0,   304, 0,
        0,   0,   0,
};
State get_transition(int transition, int state) {
    IndexEntry index = kIndices[state];
    if (index < 0) {
        return kFull[~index].data[transition];
    }
    const CompactEntry& entry = kCompact[index];
    int v = entry.data[transition >> 2];
    v >>= 2 * (transition & 3);
    v &= 3;
    v *= 9;
    return (entry.values >> v) & 511;
}
static const int8_t kAccepts[417] = {
        -1, -1, 88, 88, 91, 67, 72, 91, 42, 40, 40, 40, 40, 36, 40, 40, 40, 40, 37, 40, 40, 40,
        27, 57, 81, 62, 66, 86, 43, 44, 55, 79, 53, 51, 77, 50, 54, 52, 78, 49, 1,  -1, -1, 1,
        56, -1, -1, 90, 89, 80, 2,  1,  1,  -1, -1, 1,  -1, -1, 1,  2,  3,  -1, -1, 1,  3,  2,
        2,  -1, 2,  2,  2,  69, 87, 74, 58, 82, 76, 70, 71, 73, 75, 59, 83, 68, 41, 41, 47, 48,
        61, 85, 65, 41, 41, 39, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 14, 41,
        41, 41, 41, 30, 41, 41, 41, 12, 41, 41, 41, 41, 41, 41, 22, 41, 41, 41, 41, 15, 41, 41,
        41, 41, 41, 41, 13, 41, 41, 41, 41, 41, 16, 10, 41, 41, 41, 41, 41, 41, 41, 41, 41, 7,
        41, 41, 41, 41, 41, 41, 39, 41, 41, 41, 41, 41, 5,  41, 41, 41, 41, 41, 23, 41, 8,  41,
        41, 41, 41, 41, 39, 41, 41, 41, 41, 41, 41, 33, 41, 41, 41, 41, 6,  18, 41, 41, 41, 25,
        41, 41, 20, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
        32, 41, 41, 41, 35, 41, 41, 41, 41, 41, 41, 34, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
        41, 41, 41, 41, 26, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 24, 41, 41, 19, 41, 41, 41,
        41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
        28, 41, 41, 41, 17, 41, 41, 41, 41, 41, 41, 41, 41, 39, 41, 41, 41, 41, 41, 41, 41, 41,
        41, 41, 41, 41, 41, 41, 41, 41, 41, 39, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
        41, 41, 41, 41, 41, 31, 41, 41, 41, 41, 41, 41, 41, 41, 11, 41, 41, 41, 41, 41, 41, 41,
        41, 41, 41, 41, 4,  41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 21, 41, 41, 41, 41, 41,
        41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 9,  41,
        41, 41, 41, 41, 41, 41, 38, 41, 41, 41, 41, 41, 41, 41, 29, 45, 60, 84, 64, 46, 63,
};

Token Lexer::next() {
    // note that we cheat here: normally a lexer needs to worry about the case
    // where a token has a prefix which is not itself a valid token - for instance,
    // maybe we have a valid token 'while', but 'w', 'wh', etc. are not valid
    // tokens. Our grammar doesn't have this property, so we can simplify the logic
    // a bit.
    int32_t startOffset = fOffset;
    State state = 1;
    for (;;) {
        if (fOffset >= (int32_t)fText.length()) {
            if (startOffset == (int32_t)fText.length() || kAccepts[state] == -1) {
                return Token(Token::Kind::TK_END_OF_FILE, startOffset, 0);
            }
            break;
        }
        uint8_t c = (uint8_t)(fText[fOffset] - 9);
        if (c >= 118) {
            c = kInvalidChar;
        }
        State newState = get_transition(kMappings[c], state);
        if (!newState) {
            break;
        }
        state = newState;
        ++fOffset;
    }
    Token::Kind kind = (Token::Kind)kAccepts[state];
    return Token(kind, startOffset, fOffset - startOffset);
}

}  // namespace SkSL
