/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.AttributesImpl;

public class OOXMLTarget {
    static Logger logger = Logger.getLogger(OOXMLTarget.class);
    public static final String NS_PACKAGE_RELATIONSHIPS = "http://schemas.openxmlformats.org/package/2006/relationships";
    String hostPartEntryName;
    String type;
    String mimeType;
    String name;

    public OOXMLTarget(String string, AttributesImpl attributesImpl) {
        this.hostPartEntryName = string;
        this.type = attributesImpl.getValue("Type");
        this.name = attributesImpl.getValue("Target");
        logger.debug("Created new OOXMLTarget " + this);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        String[] stringArray = this.name.split("\\.");
        return stringArray[stringArray.length - 1];
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getHostPartEntryName() {
        return this.hostPartEntryName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getHostFolder() {
        String string = this.hostPartEntryName.replaceFirst("_rels/.*$", "");
        return string;
    }

    public String getFilename() {
        String string = this.name.replaceFirst("^.*/", "");
        return string;
    }

    public String getTargetFolder() {
        String string = this.getTargetAsPartName();
        return string.replaceFirst("[^/]+$", "");
    }

    public String getTargetAsPartName() {
        String string = this.getName();
        if (string.startsWith("/")) {
            return string;
        }
        String string2 = this.hostPartEntryName.replaceFirst("_rels/.*$", "");
        String string3 = null;
        try {
            URI uRI = new URI(string2);
            URI uRI2 = uRI.resolve(new URI(this.getName()));
            string3 = uRI2.toString();
            if (!string3.startsWith("/") && string3.indexOf("//:") == -1) {
                string3 = "/" + string3;
            }
            logger.debug("Target " + this.getName() + " is resolved to Part Name " + string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return string3;
    }

    public String toString() {
        return "type=" + this.type + "; target=" + this.name + "; host=" + this.hostPartEntryName;
    }
}

