# Copyright 2016 Cloudbase Solutions Srl
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from oslo_policy import policy

from nova.policies import base


BASE_POLICY_NAME = 'os_compute_api:os-instance-usage-audit-log:%s'

DEPRECATED_REASON = """
Nova API policies are introducing new default roles with scope_type
capabilities. Old policies are deprecated and silently going to be ignored
in nova 23.0.0 release.
"""

DEPRECATED_POLICY = policy.DeprecatedRule(
    'os_compute_api:os-instance-usage-audit-log',
    base.RULE_ADMIN_API,
    deprecated_reason=DEPRECATED_REASON,
    deprecated_since='21.0.0'
)

instance_usage_audit_log_policies = [
    policy.DocumentedRuleDefault(
        name=BASE_POLICY_NAME % 'list',
        check_str=base.ADMIN,
        description="List all usage audits.",
        operations=[
            {
                'method': 'GET',
                'path': '/os-instance_usage_audit_log'
            },
        ],
        scope_types=['system'],
        deprecated_rule=DEPRECATED_POLICY),
    policy.DocumentedRuleDefault(
        name=BASE_POLICY_NAME % 'show',
        check_str=base.ADMIN,
        description="List all usage audits occurred before "
        "a specified time for all servers on all compute hosts where "
        "usage auditing is configured",
        operations=[

            {
                'method': 'GET',
                'path': '/os-instance_usage_audit_log/{before_timestamp}'
            }
        ],
        scope_types=['system'],
        deprecated_rule=DEPRECATED_POLICY),
]


def list_rules():
    return instance_usage_audit_log_policies
