# PySNMP SMI module. Autogenerated from smidump -f python DOCS-IETF-BPI2-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:51 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, MacAddress, RowStatus, StorageType, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "MacAddress", "RowStatus", "StorageType", "TextualConvention", "TruthValue")

# Types

class DocsBpkmDataAuthentAlg(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(0,1,)
    namedValues = NamedValues(("none", 0), ("hmacSha196", 1), )
    
class DocsBpkmDataEncryptAlg(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(0,1,5,4,2,3,)
    namedValues = NamedValues(("none", 0), ("des56CbcMode", 1), ("des40CbcMode", 2), ("t3Des128CbcMode", 3), ("aes128CbcMode", 4), ("aes256CbcMode", 5), )
    
class DocsBpkmSAType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(0,2,3,1,)
    namedValues = NamedValues(("none", 0), ("primary", 1), ("static", 2), ("dynamic", 3), )
    
class DocsSAId(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,16383)
    
class DocsSAIdOrZero(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,16383)
    
class DocsX509ASN1DEREncodedCertificate(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,4096)
    

# Objects

docsBpi2MIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 126)).setRevisions(("2005-07-20 00:00",))
if mibBuilder.loadTexts: docsBpi2MIB.setOrganization("IETF IP over Cable Data Network (IPCDN)\nWorking Group")
if mibBuilder.loadTexts: docsBpi2MIB.setContactInfo("---------------------------------------\nStuart M. Green\nE-mail: rubbersoul3@yahoo.com\n---------------------------------------\nKaz Ozawa\nAutomotive Systems Development Center\nTOSHIBA CORPORATION\n1-1, Shibaura 1-Chome\nMinato-ku, Tokyo 105-8001\nJapan\nPhone: +81-3-3457-8569\nFax: +81-3-5444-9325\nE-mail: Kazuyoshi.Ozawa@toshiba.co.jp\n---------------------------------------\nAlexander Katsnelson\nPostal:\nTel:    +1-303-680-3924\nE-mail: katsnelson6@peoplepc.com\n---------------------------------------\nEduardo Cardona\nPostal:\nCable Television Laboratories, Inc.\n858 Coal Creek Circle\nLouisville, CO 80027- 9750\nU.S.A.\nTel:    +1 303 661 9100\nFax:    +1 303 661 9199\nE-mail: e.cardona@cablelabs.com\n---------------------------------------\n\nIETF IPCDN Working Group\nGeneral Discussion: ipcdn@ietf.org\nSubscribe: http://www.ietf.org/mailman/listinfo/ipcdn.\nArchive: ftp://ftp.ietf.org/ietf-mail-archive/ipcdn.\nCo-chairs: Richard Woundy, rwoundy@cisco.com\n   Jean-Francois Mule, jfm@cablelabs.com")
if mibBuilder.loadTexts: docsBpi2MIB.setDescription("This is the MIB module for the DOCSIS Baseline\nPrivacy Plus Interface (BPI+) at cable modems (CMs)\nand cable modem termination systems (CMTSs).\n\nCopyright (C) The Internet Society (2005).  This\n\n\n\nversion of this MIB module is part of RFC 4131; see\nthe RFC itself for full legal notices.")
docsBpi2Notification = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 0))
docsBpi2MIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 1))
docsBpi2CmObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 1, 1))
docsBpi2CmBaseTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 1, 1))
if mibBuilder.loadTexts: docsBpi2CmBaseTable.setDescription("This table describes the basic and authorization-\nrelated Baseline Privacy Plus attributes of each CM MAC\ninterface.")
docsBpi2CmBaseEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsBpi2CmBaseEntry.setDescription("Each entry contains objects describing attributes of\none CM MAC interface.  An entry in this table exists for\neach ifEntry with an ifType of docsCableMaclayer(127).")
docsBpi2CmPrivacyEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmPrivacyEnable.setDescription("This object identifies whether this CM is\nprovisioned to run Baseline Privacy Plus.")
docsBpi2CmPublicKey = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 524))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmPublicKey.setDescription("The value of this object is a DER-encoded\nRSAPublicKey ASN.1 type string, as defined in the RSA\nEncryption Standard (PKCS #1), corresponding to the\npublic key of the CM.")
docsBpi2CmAuthState = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(4,6,5,2,1,3,)).subtype(namedValues=NamedValues(("start", 1), ("authWait", 2), ("authorized", 3), ("reauthWait", 4), ("authRejectWait", 5), ("silent", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthState.setDescription("The value of this object is the state of the CM\nauthorization FSM.  The start state indicates that FSM is\nin its initial state.")
docsBpi2CmAuthKeySequenceNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthKeySequenceNumber.setDescription("The value of this object is the most recent\nauthorization key sequence number for this FSM.")
docsBpi2CmAuthExpiresOld = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthExpiresOld.setDescription("The value of this object is the actual clock time for\nexpiration of the immediate predecessor of the most recent\nauthorization key for this FSM.  If this FSM has only one\nauthorization key, then the value is the time of activation\nof this FSM.")
docsBpi2CmAuthExpiresNew = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthExpiresNew.setDescription("The value of this object is the actual clock time for\nexpiration of the most recent authorization key for this\nFSM.")
docsBpi2CmAuthReset = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 7), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmAuthReset.setDescription("Setting this object to 'true' generates a Reauthorize\nevent in the authorization FSM.  Reading this object always\nreturns FALSE.\n\nThis object is for testing purposes only, and therefore it\nis not required to be associated with a last reset\nobject.")
docsBpi2CmAuthGraceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 6047999))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthGraceTime.setDescription("The value of this object is the grace time for an\nauthorization key in seconds.  A CM is expected to start\ntrying to get a new authorization key beginning\nAuthGraceTime seconds before the most recent authorization\nkey actually expires.")
docsBpi2CmTEKGraceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 302399))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKGraceTime.setDescription("The value of this object is the grace time for\nthe TEK in seconds.  The CM is expected to start trying to\nacquire a new TEK beginning TEK GraceTime seconds before\nthe expiration of the most recent TEK.")
docsBpi2CmAuthWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 30))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthWaitTimeout.setDescription("The value of this object is the Authorize Wait\nTimeout in seconds.")
docsBpi2CmReauthWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 30))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmReauthWaitTimeout.setDescription("The value of this object is the Reauthorize Wait\nTimeout in seconds.")
docsBpi2CmOpWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmOpWaitTimeout.setDescription("The value of this object is the Operational Wait\nTimeout in seconds.")
docsBpi2CmRekeyWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmRekeyWaitTimeout.setDescription("The value of this object is the Rekey Wait Timeout\nin seconds.")
docsBpi2CmAuthRejectWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 600))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthRejectWaitTimeout.setDescription("The value of this object is the Authorization Reject\nWait Timeout in seconds.")
docsBpi2CmSAMapWaitTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmSAMapWaitTimeout.setDescription("The value of this object is the retransmission\ninterval, in seconds, of SA Map Requests from the MAP Wait\nstate.")
docsBpi2CmSAMapMaxRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmSAMapMaxRetries.setDescription("The value of this object is the maximum number of\nMap Request retries allowed.")
docsBpi2CmAuthentInfos = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthentInfos.setDescription("The value of this object is the number of times\nthe CM has transmitted an Authentication Information\nmessage.  Discontinuities in the value of this counter can\noccur at re-initialization of the management system, and at\nother times as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmAuthRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthRequests.setDescription("The value of this object is the number of times the CM\nhas transmitted an Authorization Request message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmAuthReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthReplies.setDescription("The value of this object is the number of times the CM\nhas received an Authorization Reply message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmAuthRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthRejects.setDescription("The value of this object is the number of times the CM\nhas received an Authorization Reject message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmAuthInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthInvalids.setDescription("The value of this object is the count of times the CM\nhas received an Authorization Invalid message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmAuthRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 22), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,2,11,8,3,)).subtype(namedValues=NamedValues(("none", 1), ("timeOfDayNotAcquired", 11), ("unknown", 2), ("unauthorizedCm", 3), ("unauthorizedSaid", 4), ("permanentAuthorizationFailure", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthRejectErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent\nAuthorization Reject message received by the CM.  This has\nthe value unknown(2) if the last Error-Code value was 0 and\nnone(1) if no Authorization Reject message has been received\nsince reboot.")
docsBpi2CmAuthRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 23), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthRejectErrorString.setDescription("The value of this object is the text string in the\nmost recent Authorization Reject message received by the\nCM.  This is a zero length string if no Authorization\nReject message has been received since reboot.")
docsBpi2CmAuthInvalidErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 24), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,6,5,3,7,)).subtype(namedValues=NamedValues(("none", 1), ("unknown", 2), ("unauthorizedCm", 3), ("unsolicited", 5), ("invalidKeySequence", 6), ("keyRequestAuthenticationFailure", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthInvalidErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent\nAuthorization Invalid message received by the CM.  This has\nthe value unknown(2) if the last Error-Code value was 0 and\nnone(1) if no Authorization Invalid message has been received\nsince reboot.")
docsBpi2CmAuthInvalidErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 1, 1, 25), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmAuthInvalidErrorString.setDescription("The value of this object is the text string in the\nmost recent Authorization Invalid message received by the\nCM.  This is a zero length string if no Authorization\n\n\n\nInvalid message has been received since reboot.")
docsBpi2CmTEKTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 1, 2))
if mibBuilder.loadTexts: docsBpi2CmTEKTable.setDescription("This table describes the attributes of each CM\nTraffic Encryption Key (TEK) association.  The CM maintains\n(no more than) one TEK association per SAID per CM MAC\ninterface.")
docsBpi2CmTEKEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKSAId"))
if mibBuilder.loadTexts: docsBpi2CmTEKEntry.setDescription("Each entry contains objects describing the TEK\nassociation attributes of one SAID.  The CM MUST create one\nentry per SAID, regardless of whether the SAID was obtained\nfrom a Registration Response message, from an Authorization\nReply message, or from any dynamic SAID establishment\nmechanisms.")
docsBpi2CmTEKSAId = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 1), DocsSAId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmTEKSAId.setDescription("The value of this object is the DOCSIS Security\nAssociation ID (SAID).")
docsBpi2CmTEKSAType = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 2), DocsBpkmSAType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKSAType.setDescription("The value of this object is the type of security\nassociation.")
docsBpi2CmTEKDataEncryptAlg = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 3), DocsBpkmDataEncryptAlg()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKDataEncryptAlg.setDescription("The value of this object is the data encryption\nalgorithm for this SAID.")
docsBpi2CmTEKDataAuthentAlg = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 4), DocsBpkmDataAuthentAlg()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKDataAuthentAlg.setDescription("The value of this object is the data authentication\nalgorithm for this SAID.")
docsBpi2CmTEKState = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(6,2,4,1,5,3,)).subtype(namedValues=NamedValues(("start", 1), ("opWait", 2), ("opReauthWait", 3), ("operational", 4), ("rekeyWait", 5), ("rekeyReauthWait", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKState.setDescription("The value of this object is the state of the\nindicated TEK FSM.  The start(1) state indicates that the\nFSM is in its initial state.")
docsBpi2CmTEKKeySequenceNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKKeySequenceNumber.setDescription("The value of this object is the most recent TEK\nkey sequence number for this TEK FSM.")
docsBpi2CmTEKExpiresOld = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 7), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKExpiresOld.setDescription("The value of this object is the actual clock time for\nexpiration of the immediate predecessor of the most recent\nTEK for this FSM.  If this FSM has only one TEK, then the\nvalue is the time of activation of this FSM.")
docsBpi2CmTEKExpiresNew = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 8), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKExpiresNew.setDescription("The value of this object is the actual clock time for\nexpiration of the most recent TEK for this FSM.")
docsBpi2CmTEKKeyRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKKeyRequests.setDescription("The value of this object is the number of times the CM\nhas transmitted a Key Request message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmTEKKeyReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKKeyReplies.setDescription("The value of this object is the number of times the CM\nhas received a Key Reply message, including a message whose\nauthentication failed.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmTEKKeyRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKKeyRejects.setDescription("The value of this object is the number of times the CM\nhas received a Key Reject message, including a message\nwhose authentication failed.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmTEKInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKInvalids.setDescription("The value of this object is the number of times the CM\nhas received a TEK Invalid message, including a message\nwhose authentication failed.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmTEKAuthPends = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKAuthPends.setDescription("The value of this object is the count of times an\nAuthorization Pending (Auth Pend) event occurred in this\nFSM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\n\n\n\nifCounterDiscontinuityTime.")
docsBpi2CmTEKKeyRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,4,)).subtype(namedValues=NamedValues(("none", 1), ("unknown", 2), ("unauthorizedSaid", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKKeyRejectErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent Key Reject\nmessage received by the CM.  This has the value unknown(2) if\nthe last Error-Code value was 0 and none(1) if no Key\nReject message has been received since registration.")
docsBpi2CmTEKKeyRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 15), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKKeyRejectErrorString.setDescription("The value of this object is the text string in the\nmost recent Key Reject message received by the CM.  This is\na zero length string if no Key Reject message has been\nreceived since registration.")
docsBpi2CmTEKInvalidErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 16), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,6,)).subtype(namedValues=NamedValues(("none", 1), ("unknown", 2), ("invalidKeySequence", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKInvalidErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent TEK Invalid\nmessage received by the CM.  This has the value unknown(2) if\nthe last Error-Code value was 0 and none(1) if no TEK\nInvalid message has been received since registration.")
docsBpi2CmTEKInvalidErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 2, 1, 17), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmTEKInvalidErrorString.setDescription("The value of this object is the text string in the\nmost recent TEK Invalid message received by the CM.  This is\na zero length string if no TEK Invalid message has been\nreceived since registration.")
docsBpi2CmMulticastObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 1, 1, 3))
docsBpi2CmIpMulticastMapTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1))
if mibBuilder.loadTexts: docsBpi2CmIpMulticastMapTable.setDescription("This table maps multicast IP addresses to SAIDs per\nCM MAC Interface.\nIt is intended to map multicast IP addresses associated\nwith SA MAP Request messages.")
docsBpi2CmIpMulticastMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastIndex"))
if mibBuilder.loadTexts: docsBpi2CmIpMulticastMapEntry.setDescription("Each entry contains objects describing the mapping of\none multicast IP address to one SAID, as well as\nassociated state, message counters, and error information.\n\nAn entry may be removed from this table upon the reception\nof an SA Map Reject.")
docsBpi2CmIpMulticastIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastIndex.setDescription("The index of this row.")
docsBpi2CmIpMulticastAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 2), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastAddressType.setDescription("The type of Internet address for\ndocsBpi2CmIpMulticastAddress.")
docsBpi2CmIpMulticastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 3), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastAddress.setDescription("This object represents the IP multicast address\nto be mapped.  The type of this address is determined by\nthe value of the docsBpi2CmIpMulticastAddressType object.")
docsBpi2CmIpMulticastSAId = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 4), DocsSAIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastSAId.setDescription("This object represents the SAID to which the IP\nmulticast address has been mapped.  If no SA Map Reply has\nbeen received for the IP address, this object should have\nthe value 0.")
docsBpi2CmIpMulticastSAMapState = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("start", 1), ("mapWait", 2), ("mapped", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastSAMapState.setDescription("The value of this object is the state of the SA\nMapping FSM for this IP.")
docsBpi2CmIpMulticastSAMapRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastSAMapRequests.setDescription("The value of this object is the number of times the\nCM has transmitted an SA Map Request message for this IP.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\n\n\n\nifCounterDiscontinuityTime.")
docsBpi2CmIpMulticastSAMapReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastSAMapReplies.setDescription("The value of this object is the number of times the\nCM has received an SA Map Reply message for this IP.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmIpMulticastSAMapRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastSAMapRejects.setDescription("The value of this object is the number of times the\nCM has received an SA MAP Reject message for this IP.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmIpMulticastSAMapRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,9,10,)).subtype(namedValues=NamedValues(("none", 1), ("dsFlowNotMappedToSA", 10), ("unknown", 2), ("noAuthForRequestedDSFlow", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastSAMapRejectErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent SA Map\nReject message sent in response to an SA Map Request for\nThis IP.  It has the value none(1) if no SA MAP Reject\nmessage has been received since entry creation.")
docsBpi2CmIpMulticastSAMapRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 3, 1, 1, 10), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmIpMulticastSAMapRejectErrorString.setDescription("The value of this object is the text string in\nthe most recent SA Map Reject message sent in response to\nan SA Map Request for this IP.  It is a zero length string\nif no SA Map Reject message has been received since entry\ncreation.")
docsBpi2CmCertObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 1, 1, 4))
docsBpi2CmDeviceCertTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 1, 4, 1))
if mibBuilder.loadTexts: docsBpi2CmDeviceCertTable.setDescription("This table describes the Baseline Privacy Plus\ndevice certificates for each CM MAC interface.")
docsBpi2CmDeviceCertEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 1, 4, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsBpi2CmDeviceCertEntry.setDescription("Each entry contains the device certificates of\none CM MAC interface.  An entry in this table exists for\neach ifEntry with an ifType of docsCableMaclayer(127).")
docsBpi2CmDeviceCmCert = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 4, 1, 1, 1), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmDeviceCmCert.setDescription("The X509 DER-encoded cable modem certificate.\nNote:  This object can be set only when the value is the\nzero-length OCTET STRING; otherwise, an error of\n'inconsistentValue' is returned.  Once the object\ncontains the certificate, its access MUST be read-only\nand persists after re-initialization of the\nmanaged system.")
docsBpi2CmDeviceManufCert = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 4, 1, 1, 2), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmDeviceManufCert.setDescription("The X509 DER-encoded manufacturer certificate that\nsigned the cable modem certificate.")
docsBpi2CmCryptoSuiteTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 1, 5))
if mibBuilder.loadTexts: docsBpi2CmCryptoSuiteTable.setDescription("This table describes the Baseline Privacy Plus\ncryptographic suite capabilities for each CM MAC\ninterface.")
docsBpi2CmCryptoSuiteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 1, 5, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmCryptoSuiteIndex"))
if mibBuilder.loadTexts: docsBpi2CmCryptoSuiteEntry.setDescription("Each entry contains a cryptographic suite pair\nthat this CM MAC supports.")
docsBpi2CmCryptoSuiteIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 1000))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmCryptoSuiteIndex.setDescription("The index for a cryptographic suite row.")
docsBpi2CmCryptoSuiteDataEncryptAlg = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 5, 1, 2), DocsBpkmDataEncryptAlg()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmCryptoSuiteDataEncryptAlg.setDescription("The value of this object is the data encryption\nalgorithm for this cryptographic suite capability.")
docsBpi2CmCryptoSuiteDataAuthentAlg = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 1, 5, 1, 3), DocsBpkmDataAuthentAlg()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmCryptoSuiteDataAuthentAlg.setDescription("The value of this object is the data authentication\nalgorithm for this cryptographic suite capability.")
docsBpi2CmtsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 1, 2))
docsBpi2CmtsBaseTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 2, 1))
if mibBuilder.loadTexts: docsBpi2CmtsBaseTable.setDescription("This table describes the basic Baseline Privacy\nattributes of each CMTS MAC interface.")
docsBpi2CmtsBaseEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsBpi2CmtsBaseEntry.setDescription("Each entry contains objects describing attributes of\none CMTS MAC interface.  An entry in this table exists for\neach ifEntry with an ifType of docsCableMaclayer(127).")
docsBpi2CmtsDefaultAuthLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 6048000)).clone(604800)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmtsDefaultAuthLifetime.setDescription("The value of this object is the default lifetime, in\nseconds, that the CMTS assigns to a new authorization key.\nThis object value persists after re-initialization of the\nmanaged system.")
docsBpi2CmtsDefaultTEKLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 604800)).clone(43200)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmtsDefaultTEKLifetime.setDescription("The value of this object is the default lifetime, in\nseconds, that the CMTS assigns to a new Traffic Encryption\nKey (TEK).\nThis object value persists after re-initialization of the\nmanaged system.")
docsBpi2CmtsDefaultSelfSignedManufCertTrust = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("trusted", 1), ("untrusted", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmtsDefaultSelfSignedManufCertTrust.setDescription("This object determines the default trust of\nself-signed manufacturer certificate entries, contained\nin docsBpi2CmtsCACertTable, and created after this\nobject is set.\nThis object need not persist after re-initialization\nof the managed system.")
docsBpi2CmtsCheckCertValidityPeriods = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 4), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmtsCheckCertValidityPeriods.setDescription("Setting this object to 'true' causes all chained and\nroot certificates in the chain to have their validity\nperiods checked against the current time of day, when\nthe CMTS receives an Authorization Request from the\nCM.\nA 'false' setting causes all certificates in the chain\nnot to have their validity periods checked against the\ncurrent time of day.\nThis object need not persist after re-initialization\nof the managed system.")
docsBpi2CmtsAuthentInfos = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthentInfos.setDescription("The value of this object is the number of times the\nCMTS has received an Authentication Information message\nfrom any CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\n\n\n\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthRequests.setDescription("The value of this object is the number of times the\nCMTS has received an Authorization Request message from any\nCM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthReplies.setDescription("The value of this object is the number of times the\nCMTS has transmitted an Authorization Reply message to any\nCM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthRejects.setDescription("The value of this object is the number of times the\nCMTS has transmitted an Authorization Reject message to any\n\n\n\nCM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthInvalids.setDescription("The value of this object is the number of times\nthe CMTS has transmitted an Authorization Invalid message\nto any CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsSAMapRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsSAMapRequests.setDescription("The value of this object is the number of times the\nCMTS has received an SA Map Request message from any CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsSAMapReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsSAMapReplies.setDescription("The value of this object is the number of times the\nCMTS has transmitted an SA Map Reply message to any CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsSAMapRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsSAMapRejects.setDescription("The value of this object is the number of times the\nCMTS has transmitted an SA Map Reject message to any CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 2, 2))
if mibBuilder.loadTexts: docsBpi2CmtsAuthTable.setDescription("This table describes the attributes of each CM\nauthorization association.  The CMTS maintains one\nauthorization association with each Baseline Privacy-\nenabled CM, registered on each CMTS MAC interface,\nregardless of whether the CM is authorized or rejected.")
docsBpi2CmtsAuthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmMacAddress"))
if mibBuilder.loadTexts: docsBpi2CmtsAuthEntry.setDescription("Each entry contains objects describing attributes of\none authorization association.  The CMTS MUST create one\nentry per CM per MAC interface, based on the receipt of an\nAuthorization Request message, and MUST not delete the\nentry until the CM loses registration.")
docsBpi2CmtsAuthCmMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 1), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmMacAddress.setDescription("The value of this object is the physical address of\nthe CM to which the authorization association applies.")
docsBpi2CmtsAuthCmBpiVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(0,1,)).subtype(namedValues=NamedValues(("bpi", 0), ("bpiPlus", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmBpiVersion.setDescription("The value of this object is the version of Baseline\nPrivacy for which this CM has registered.  The value\n'bpiplus' represents the value of BPI-Version Attribute of\nthe Baseline Privacy Key Management BPKM attribute\nBPI-Version (1).  The value 'bpi' is used to represent the\nCM registered using DOCSIS 1.0 Baseline Privacy.")
docsBpi2CmtsAuthCmPublicKey = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 524))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmPublicKey.setDescription("The value of this object is a DER-encoded\nRSAPublicKey ASN.1 type string, as defined in the RSA\nEncryption Standard (PKCS #1), corresponding to the\npublic key of the CM.  This is the zero-length OCTET\nSTRING if the CMTS does not retain the public key.")
docsBpi2CmtsAuthCmKeySequenceNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmKeySequenceNumber.setDescription("The value of this object is the most recent\nauthorization key sequence number for this CM.")
docsBpi2CmtsAuthCmExpiresOld = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmExpiresOld.setDescription("The value of this object is the actual clock time\nfor expiration of the immediate predecessor of the most\nrecent authorization key for this FSM.  If this FSM has only\none authorization key, then the value is the time of\nactivation of this FSM.\nNote: This object has no meaning for CMs running in BPI\nmode; therefore, this object is not instantiated for entries\nassociated to those CMs.")
docsBpi2CmtsAuthCmExpiresNew = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmExpiresNew.setDescription("The value of this object is the actual clock\ntime for expiration of the most recent authorization key\nfor this FSM.")
docsBpi2CmtsAuthCmLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 6048000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmLifetime.setDescription("The value of this object is the lifetime, in seconds,\nthat the CMTS assigns to an authorization key for this CM.")
docsBpi2CmtsAuthCmReset = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,4,1,)).subtype(namedValues=NamedValues(("noResetRequested", 1), ("invalidateAuth", 2), ("sendAuthInvalid", 3), ("invalidateTeks", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmReset.setDescription("Setting this object to invalidateAuth(2) causes the\nCMTS to invalidate the current CM authorization key(s), but\nnot to transmit an Authorization Invalid message nor to\ninvalidate the primary SAID's TEKs.  Setting this object to\nsendAuthInvalid(3) causes the CMTS to invalidate the\ncurrent CM authorization key(s), and to transmit an\nAuthorization Invalid message to the CM, but not to\ninvalidate the primary SAID's TEKs.  Setting this object to\ninvalidateTeks(4) causes the CMTS to invalidate the current\nCM authorization key(s), to transmit an Authorization\nInvalid message to the CM, and to invalidate the TEKs\nassociated with this CM's primary SAID.\nFor BPI mode, substitute all of the CM's unicast\nTEKs for the primary SAID's TEKs in the previous\nparagraph.\nReading this object returns the most recently set\nvalue of this object or, if the object has not been set\nsince entry creation, returns noResetRequested(1).")
docsBpi2CmtsAuthCmInfos = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmInfos.setDescription("The value of this object is the number of times the\nCMTS has received an Authentication Information message\nfrom this CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthCmRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmRequests.setDescription("The value of this object is the number of times the\nCMTS has received an Authorization Request message from\n\n\n\nthis CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthCmReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmReplies.setDescription("The value of this object is the number of times the\nCMTS has transmitted an Authorization Reply message to this\nCM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthCmRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmRejects.setDescription("The value of this object is the number of times the\nCMTS has transmitted an Authorization Reject message to\nthis CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthCmInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCmInvalids.setDescription("The value of this object is the number of times the\nCMTS has transmitted an Authorization Invalid message to\nthis CM.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsAuthRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,2,11,8,3,)).subtype(namedValues=NamedValues(("none", 1), ("timeOfDayNotAcquired", 11), ("unknown", 2), ("unauthorizedCm", 3), ("unauthorizedSaid", 4), ("permanentAuthorizationFailure", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthRejectErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent\nAuthorization Reject message transmitted to the CM.  This has\nthe value unknown(2) if the last Error-Code value was 0 and\nnone(1) if no Authorization Reject message has been\ntransmitted to the CM since entry creation.")
docsBpi2CmtsAuthRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 15), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthRejectErrorString.setDescription("The value of this object is the text string in the\nmost recent Authorization Reject message transmitted to the\nCM.  This is a zero length string if no Authorization\nReject message has been transmitted to the CM since entry\ncreation.")
docsBpi2CmtsAuthInvalidErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 16), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,6,5,3,7,)).subtype(namedValues=NamedValues(("none", 1), ("unknown", 2), ("unauthorizedCm", 3), ("unsolicited", 5), ("invalidKeySequence", 6), ("keyRequestAuthenticationFailure", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthInvalidErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent\nAuthorization Invalid message transmitted to the CM.  This\nhas the value unknown(2) if the last Error-Code value was 0\nand none(1) if no Authorization Invalid message has been\ntransmitted to the CM since entry creation.")
docsBpi2CmtsAuthInvalidErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 17), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthInvalidErrorString.setDescription("The value of this object is the text string in the\nmost recent Authorization Invalid message transmitted to\nthe CM.  This is a zero length string if no Authorization\nInvalid message has been transmitted to the CM since entry\ncreation.")
docsBpi2CmtsAuthPrimarySAId = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 18), DocsSAIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthPrimarySAId.setDescription("The value of this object is the Primary Security\nAssociation identifier.  For BPI mode, the value must be\n\n\n\nany unicast SID.")
docsBpi2CmtsAuthBpkmCmCertValid = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 19), Integer().subtype(subtypeSpec=SingleValueConstraint(5,6,0,3,1,2,4,)).subtype(namedValues=NamedValues(("unknown", 0), ("validCmChained", 1), ("validCmTrusted", 2), ("invalidCmUntrusted", 3), ("invalidCAUntrusted", 4), ("invalidCmOther", 5), ("invalidCAOther", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthBpkmCmCertValid.setDescription("Contains the reason why a CM's certificate is deemed\nvalid or invalid.\nReturn unknown(0) if the CM is running BPI mode.\nValidCmChained(1) means the certificate is valid\n   because it chains to a valid certificate.\nValidCmTrusted(2) means the certificate is valid\n   because it has been provisioned (in the\n   docsBpi2CmtsProvisionedCmCert table) to be trusted.\nInvalidCmUntrusted(3) means the certificate is invalid\n   because it has been provisioned (in the\n   docsBpi2CmtsProvisionedCmCert table) to be untrusted.\nInvalidCAUntrusted(4) means the certificate is invalid\n   because it chains to an untrusted certificate.\nInvalidCmOther(5) and InvalidCAOther(6) refer to\n   errors in parsing, validity periods, etc., which are\n   attributable to the CM certificate or its chain,\n   respectively; additional information may be found\n   in docsBpi2AuthRejectErrorString for these types\n   of errors.")
docsBpi2CmtsAuthBpkmCmCert = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 20), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthBpkmCmCert.setDescription("The X509 CM Certificate sent as part of a BPKM\nAuthorization Request.\nNote: The zero-length OCTET STRING must be returned if the\nEntire certificate is not retained in the CMTS.")
docsBpi2CmtsAuthCACertIndexPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 2, 1, 21), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsAuthCACertIndexPtr.setDescription("A row index into docsBpi2CmtsCACertTable.\nReturns the index in docsBpi2CmtsCACertTable to which\nCA certificate this CM is chained to.  A value of\n0 means it could not be found or not applicable.")
docsBpi2CmtsTEKTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 2, 3))
if mibBuilder.loadTexts: docsBpi2CmtsTEKTable.setDescription("This table describes the attributes of each\nTraffic Encryption Key (TEK) association.  The CMTS\nMaintains one TEK association per SAID on each CMTS MAC\ninterface.")
docsBpi2CmtsTEKEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKSAId"))
if mibBuilder.loadTexts: docsBpi2CmtsTEKEntry.setDescription("Each entry contains objects describing attributes of\none TEK association on a particular CMTS MAC interface.  The\nCMTS MUST create one entry per SAID per MAC interface,\nbased on the receipt of a Key Request message, and MUST not\ndelete the entry before the CM authorization for the SAID\n\n\n\npermanently expires.")
docsBpi2CmtsTEKSAId = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 1), DocsSAId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmtsTEKSAId.setDescription("The value of this object is the DOCSIS Security\nAssociation ID (SAID).")
docsBpi2CmtsTEKSAType = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 2), DocsBpkmSAType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKSAType.setDescription("The value of this object is the type of security\nassociation.  'dynamic' does not apply to CMs running in\nBPI mode.  Unicast BPI TEKs must utilize the 'primary'\nencoding, and multicast BPI TEKs must utilize the 'static'\nencoding.")
docsBpi2CmtsTEKDataEncryptAlg = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 3), DocsBpkmDataEncryptAlg()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKDataEncryptAlg.setDescription("The value of this object is the data encryption\nalgorithm for this SAID.")
docsBpi2CmtsTEKDataAuthentAlg = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 4), DocsBpkmDataAuthentAlg()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKDataAuthentAlg.setDescription("The value of this object is the data authentication\nalgorithm for this SAID.")
docsBpi2CmtsTEKLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 604800))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmtsTEKLifetime.setDescription("The value of this object is the lifetime, in\nseconds, that the CMTS assigns to keys for this TEK\nassociation.")
docsBpi2CmtsTEKKeySequenceNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKKeySequenceNumber.setDescription("The value of this object is the most recent TEK\n\n\n\nkey sequence number for this SAID.")
docsBpi2CmtsTEKExpiresOld = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 7), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKExpiresOld.setDescription("The value of this object is the actual clock time\nfor expiration of the immediate predecessor of the most\nrecent TEK for this FSM.  If this FSM has only one TEK, then\nthe value is the time of activation of this FSM.")
docsBpi2CmtsTEKExpiresNew = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 8), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKExpiresNew.setDescription("The value of this object is the actual clock time\nfor expiration of the most recent TEK for this FSM.")
docsBpi2CmtsTEKReset = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 9), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CmtsTEKReset.setDescription("Setting this object to 'true' causes the CMTS to\ninvalidate all currently active TEKs and to generate new\nTEKs for the associated SAID; the CMTS MAY also generate\nunsolicited TEK Invalid messages, to optimize the TEK\nsynchronization between the CMTS and the CM(s).  Reading\nthis object always returns FALSE.")
docsBpi2CmtsKeyRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsKeyRequests.setDescription("The value of this object is the number of times the\nCMTS has received a Key Request message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsKeyReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsKeyReplies.setDescription("The value of this object is the number of times the\nCMTS has transmitted a Key Reply message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsKeyRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsKeyRejects.setDescription("The value of this object is the number of times the\nCMTS has transmitted a Key Reject message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsTEKInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKInvalids.setDescription("The value of this object is the number of times the\nCMTS has transmitted a TEK Invalid message.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsKeyRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,4,)).subtype(namedValues=NamedValues(("none", 1), ("unknown", 2), ("unauthorizedSaid", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsKeyRejectErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent Key Reject\nmessage sent in response to a Key Request for this SAID.\nThis has the value unknown(2) if the last Error-Code value\nwas 0 and none(1) if no Key Reject message has been\nreceived since registration.")
docsBpi2CmtsKeyRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 15), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsKeyRejectErrorString.setDescription("The value of this object is the text string in\nthe most recent Key Reject message sent in response to a\nKey Request for this SAID.  This is a zero length string if\nno Key Reject message has been received since\nregistration.")
docsBpi2CmtsTEKInvalidErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 16), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,6,)).subtype(namedValues=NamedValues(("none", 1), ("unknown", 2), ("invalidKeySequence", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKInvalidErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent TEK\nInvalid message sent in association with this SAID.  This\nhas the value unknown(2) if the last Error-Code value was 0\nand none(1) if no TEK Invalid message has been received\nsince registration.")
docsBpi2CmtsTEKInvalidErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 3, 1, 17), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsTEKInvalidErrorString.setDescription("The value of this object is the text string in\nthe most recent TEK Invalid message sent in association\nwith this SAID.  This is a zero length string if no TEK\nInvalid message has been received since registration.")
docsBpi2CmtsMulticastObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 1, 2, 4))
docsBpi2CmtsIpMulticastMapTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1))
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastMapTable.setDescription("This table maps multicast IP addresses to SAIDs.\nIf a multicast IP address is mapped by multiple rows\nin the table, the row with the lowest\ndocsBpi2CmtsIpMulticastIndex must be utilized for the\nmapping.")
docsBpi2CmtsIpMulticastMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastIndex"))
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastMapEntry.setDescription("Each entry contains objects describing the mapping of\na set of multicast IP address and the mask to one SAID\nassociated to a CMTS MAC Interface, as well as associated\nmessage counters and error information.")
docsBpi2CmtsIpMulticastIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastIndex.setDescription("The index of this row.  Conceptual rows having the\nvalue 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
docsBpi2CmtsIpMulticastAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 2), InetAddressType().clone('ipv4')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastAddressType.setDescription("The type of Internet address for\ndocsBpi2CmtsIpMulticastAddress\nand docsBpi2CmtsIpMulticastMask.")
docsBpi2CmtsIpMulticastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 3), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastAddress.setDescription("This object represents the IP multicast address\nto be mapped, in conjunction with\ndocsBpi2CmtsIpMulticastMask.  The type of this address is\ndetermined by the value of the object\ndocsBpi2CmtsIpMulticastAddressType.")
docsBpi2CmtsIpMulticastMask = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 4), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastMask.setDescription("This object represents the IP multicast address mask\nfor this row.\nAn IP multicast address matches this row if the logical\nAND of the address with docsBpi2CmtsIpMulticastMask is\nidentical to the logical AND of\ndocsBpi2CmtsIpMulticastAddr with\ndocsBpi2CmtsIpMulticastMask.  The type of this address is\ndetermined by the value of the object\ndocsBpi2CmtsIpMulticastAddressType.\nNote: For IPv6, this object need not represent a\ncontiguous netmask; e.g., to associate a SAID to a\nmulticast group matching 'any' multicast scope.  The TC\n\n\n\nInetAddressPrefixLength is not used, as it only\nrepresents contiguous netmask.")
docsBpi2CmtsIpMulticastSAId = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 5), DocsSAIdOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastSAId.setDescription("This object represents the multicast SAID to be\nused in this IP multicast address mapping entry.")
docsBpi2CmtsIpMulticastSAType = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 6), DocsBpkmSAType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastSAType.setDescription("The value of this object is the type of security\nassociation.  'dynamic' does not apply to CMs running in\nBPI mode.  Unicast BPI TEKs must utilize the 'primary'\nencoding, and multicast BPI TEKs must utilize the 'static'\nencoding.  By default, SNMP created entries set this object\nto 'static' if not set at row creation.")
docsBpi2CmtsIpMulticastDataEncryptAlg = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 7), DocsBpkmDataEncryptAlg().clone('des56CbcMode')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastDataEncryptAlg.setDescription("The value of this object is the data encryption\nalgorithm for this IP.")
docsBpi2CmtsIpMulticastDataAuthentAlg = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 8), DocsBpkmDataAuthentAlg().clone('none')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastDataAuthentAlg.setDescription("The value of this object is the data authentication\n\n\n\nalgorithm for this IP.")
docsBpi2CmtsIpMulticastSAMapRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastSAMapRequests.setDescription("The value of this object is the number of times the\nCMTS has received an SA Map Request message for this IP.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsIpMulticastSAMapReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastSAMapReplies.setDescription("The value of this object is the number of times the\nCMTS has transmitted an SA Map Reply message for this IP.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsIpMulticastSAMapRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastSAMapRejects.setDescription("The value of this object is the number of times the\nCMTS has transmitted an SA Map Reject message for this IP.\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\n\n\n\ntimes as indicated by the value of\nifCounterDiscontinuityTime.")
docsBpi2CmtsIpMulticastSAMapRejectErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,9,10,)).subtype(namedValues=NamedValues(("none", 1), ("dsFlowNotMappedToSA", 10), ("unknown", 2), ("noAuthForRequestedDSFlow", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastSAMapRejectErrorCode.setDescription("The value of this object is the enumerated\ndescription of the Error-Code in the most recent SA Map\nReject message sent in response to an SA Map Request for\nthis IP.  It has the value unknown(2) if the last Error-Code\nValue was 0 and none(1) if no SA MAP Reject message has\nbeen received since entry creation.")
docsBpi2CmtsIpMulticastSAMapRejectErrorString = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 13), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastSAMapRejectErrorString.setDescription("The value of this object is the text string in\nthe most recent SA Map Reject message sent in response to\nan SA Map Request for this IP.  It is a zero length string\nif no SA Map Reject message has been received since entry\ncreation.")
docsBpi2CmtsIpMulticastMapControl = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 14), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastMapControl.setDescription("This object controls and reflects the IP multicast\naddress mapping entry.  There is no restriction on the\nability to change values in this row while the row is\nactive.\nA created row can be set to active only after the\nCorresponding instances of docsBpi2CmtsIpMulticastAddress,\ndocsBpi2CmtsIpMulticastMask, docsBpi2CmtsIpMulticastSAId,\nand docsBpi2CmtsIpMulticastSAType have all been set.")
docsBpi2CmtsIpMulticastMapStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 1, 1, 15), StorageType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsIpMulticastMapStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent' need not allow\nwrite-access to any columnar objects in the row.")
docsBpi2CmtsMulticastAuthTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 2))
if mibBuilder.loadTexts: docsBpi2CmtsMulticastAuthTable.setDescription("This table describes the multicast SAID\nauthorization for each CM on each CMTS MAC interface.")
docsBpi2CmtsMulticastAuthEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmtsMulticastAuthSAId"), (0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmtsMulticastAuthCmMacAddress"))
if mibBuilder.loadTexts: docsBpi2CmtsMulticastAuthEntry.setDescription("Each entry contains objects describing the key\nauthorization of one cable modem for one multicast SAID\nfor one CMTS MAC interface.\nRow entries persist after re-initialization of\nthe managed system.")
docsBpi2CmtsMulticastAuthSAId = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 2, 1, 1), DocsSAId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmtsMulticastAuthSAId.setDescription("This object represents the multicast SAID for\nauthorization.")
docsBpi2CmtsMulticastAuthCmMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 2, 1, 2), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmtsMulticastAuthCmMacAddress.setDescription("This object represents the MAC address of the CM\nto which the multicast SAID authorization applies.")
docsBpi2CmtsMulticastAuthControl = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 4, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsMulticastAuthControl.setDescription("The status of this conceptual row for the\nauthorization of multicast SAIDs to CMs.")
docsBpi2CmtsCertObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 1, 2, 5))
docsBpi2CmtsProvisionedCmCertTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 1))
if mibBuilder.loadTexts: docsBpi2CmtsProvisionedCmCertTable.setDescription("A table of CM certificate trust entries provisioned\nto the CMTS.  The trust object for a certificate in this\ntable has an overriding effect on the validity object of a\ncertificate in the authorization table, as long as the\nentire contents of the two certificates are identical.")
docsBpi2CmtsProvisionedCmCertEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 1, 1)).setIndexNames((0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmtsProvisionedCmCertMacAddress"))
if mibBuilder.loadTexts: docsBpi2CmtsProvisionedCmCertEntry.setDescription("An entry in the CMTS's provisioned CM certificate\ntable.  Row entries persist after re-initialization of\nthe managed system.")
docsBpi2CmtsProvisionedCmCertMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 1, 1, 1), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmtsProvisionedCmCertMacAddress.setDescription("The index of this row.")
docsBpi2CmtsProvisionedCmCertTrust = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("trusted", 1), ("untrusted", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsProvisionedCmCertTrust.setDescription("Trust state for the provisioned CM certificate entry.\nNote: Setting this object need only override the validity\nof CM certificates sent in future authorization requests;\ninstantaneous effect need not occur.")
docsBpi2CmtsProvisionedCmCertSource = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,2,3,)).subtype(namedValues=NamedValues(("snmp", 1), ("configurationFile", 2), ("externalDatabase", 3), ("other", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsProvisionedCmCertSource.setDescription("This object indicates how the certificate reached the\nCMTS.  Other(4) means that it originated from a source not\nidentified above.")
docsBpi2CmtsProvisionedCmCertStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 1, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsProvisionedCmCertStatus.setDescription("The status of this conceptual row.  Values in this row\ncannot be changed while the row is 'active'.")
docsBpi2CmtsProvisionedCmCert = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 1, 1, 5), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsProvisionedCmCert.setDescription("An X509 DER-encoded Certificate Authority\ncertificate.\nNote: The zero-length OCTET STRING must be returned, on\n\n\n\nreads, if the entire certificate is not retained in the\nCMTS.")
docsBpi2CmtsCACertTable = MibTable((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2))
if mibBuilder.loadTexts: docsBpi2CmtsCACertTable.setDescription("The table of known Certificate Authority certificates\nacquired by this device.")
docsBpi2CmtsCACertEntry = MibTableRow((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1)).setIndexNames((0, "DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACertIndex"))
if mibBuilder.loadTexts: docsBpi2CmtsCACertEntry.setDescription("A row in the Certificate Authority certificate\ntable.  Row entries with the trust status 'trusted',\n'untrusted', or 'root' persist after re-initialization\n of the managed system.")
docsBpi2CmtsCACertIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: docsBpi2CmtsCACertIndex.setDescription("The index for this row.")
docsBpi2CmtsCACertSubject = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsCACertSubject.setDescription("The subject name exactly as it is encoded in the\nX509 certificate.\nThe organizationName portion of the certificate's subject\nname must be present.  All other fields are optional.  Any\noptional field present must be prepended with <CR>\n(carriage return, U+000D) <LF> (line feed, U+000A).\nOrdering of fields present must conform to the following:\n\norganizationName <CR> <LF>\ncountryName <CR> <LF>\nstateOrProvinceName <CR> <LF>\nlocalityName <CR> <LF>\norganizationalUnitName <CR> <LF>\norganizationalUnitName=<Manufacturing Location> <CR> <LF>\ncommonName")
docsBpi2CmtsCACertIssuer = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsCACertIssuer.setDescription("The issuer name exactly as it is encoded in the\nX509 certificate.\nThe commonName portion of the certificate's issuer\nname must be present.  All other fields are optional.  Any\noptional field present must be prepended with <CR>\n(carriage return, U+000D) <LF> (line feed, U+000A).\nOrdering of fields present must conform to the following:\n\nCommonName <CR><LF>\ncountryName <CR><LF>\n\n\n\nstateOrProvinceName <CR><LF>\nlocalityName <CR><LF>\norganizationName <CR><LF>\norganizationalUnitName <CR><LF>\norganizationalUnitName=<Manufacturing Location>")
docsBpi2CmtsCACertSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsCACertSerialNumber.setDescription("This CA certificate's serial number, represented as\nan octet string.")
docsBpi2CmtsCACertTrust = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(2,4,3,1,)).subtype(namedValues=NamedValues(("trusted", 1), ("untrusted", 2), ("chained", 3), ("root", 4), )).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsCACertTrust.setDescription("This object controls the trust status of this\ncertificate.  Root certificates must be given root(4)\ntrust; manufacturer certificates must not be given root(4)\ntrust.  Trust on root certificates must not change.\nNote: Setting this object need only affect the validity of\nCM certificates sent in future authorization requests;\ninstantaneous effect need not occur.")
docsBpi2CmtsCACertSource = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,5,6,4,2,)).subtype(namedValues=NamedValues(("snmp", 1), ("configurationFile", 2), ("externalDatabase", 3), ("other", 4), ("authentInfo", 5), ("compiledIntoCode", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsCACertSource.setDescription("This object indicates how the certificate reached\nthe CMTS.  Other(4) means that it originated from a source\nnot identified above.")
docsBpi2CmtsCACertStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsCACertStatus.setDescription("The status of this conceptual row.  An attempt\nto set writable columnar values while this row is active\nbehaves as follows:\n- Sets to the object docsBpi2CmtsCACertTrust are allowed.\n- Sets to the object docsBpi2CmtsCACert will return an\n  error of 'inconsistentValue'.\nA newly created entry cannot be set to active until the\nvalue of docsBpi2CmtsCACert is being set.")
docsBpi2CmtsCACert = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 8), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsBpi2CmtsCACert.setDescription("An X509 DER-encoded Certificate Authority\ncertificate.\nTo help identify certificates, either this object or\ndocsBpi2CmtsCACertThumbprint must be returned by a CMTS for\nself-signed CA certificates.\n\nNote: The zero-length OCTET STRING must be returned, on\nreads, if the entire certificate is not retained in the\nCMTS.")
docsBpi2CmtsCACertThumbprint = MibTableColumn((1, 3, 6, 1, 2, 1, 126, 1, 2, 5, 2, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(20, 20)).setFixedLength(20)).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CmtsCACertThumbprint.setDescription("The SHA-1 hash of a CA certificate.\nTo help identify certificates, either this object or\ndocsBpi2CmtsCACert must be returned by a CMTS for\nself-signed CA certificates.\n\nNote: The zero-length OCTET STRING must be returned, on\nreads, if the CA certificate thumb print is not retained\nin the CMTS.")
docsBpi2CodeDownloadControl = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 1, 4))
docsBpi2CodeDownloadStatusCode = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(5,3,6,2,1,7,4,)).subtype(namedValues=NamedValues(("configFileCvcVerified", 1), ("configFileCvcRejected", 2), ("snmpCvcVerified", 3), ("snmpCvcRejected", 4), ("codeFileVerified", 5), ("codeFileRejected", 6), ("other", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CodeDownloadStatusCode.setDescription("The value indicates the result of the latest config\nfile CVC verification, SNMP CVC verification, or code file\n\n\n\nverification.")
docsBpi2CodeDownloadStatusString = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CodeDownloadStatusString.setDescription("The value of this object indicates the additional\ninformation to the status code.  The value will include\nthe error code and error description, which will be defined\nseparately.")
docsBpi2CodeMfgOrgName = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CodeMfgOrgName.setDescription("The value of this object is the device manufacturer's\norganizationName.")
docsBpi2CodeMfgCodeAccessStart = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 4), DateAndTime().subtype(subtypeSpec=ValueSizeConstraint(11, 11)).setFixedLength(11)).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CodeMfgCodeAccessStart.setDescription("The value of this object is the device manufacturer's\ncurrent codeAccessStart value.  This value will always\nrefer to Greenwich Mean Time (GMT), and the value\nformat must contain TimeZone information (fields 8-10).")
docsBpi2CodeMfgCvcAccessStart = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 5), DateAndTime().subtype(subtypeSpec=ValueSizeConstraint(11, 11)).setFixedLength(11)).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CodeMfgCvcAccessStart.setDescription("The value of this object is the device manufacturer's\ncurrent cvcAccessStart value.  This value will always\nrefer to Greenwich Mean Time (GMT), and the value\nformat must contain TimeZone information (fields 8-10).")
docsBpi2CodeCoSignerOrgName = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 6), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CodeCoSignerOrgName.setDescription("The value of this object is the co-signer's\norganizationName.  The value is a zero length string if\nthe co-signer is not specified.")
docsBpi2CodeCoSignerCodeAccessStart = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 7), DateAndTime().subtype(subtypeSpec=ValueSizeConstraint(11, 11)).setFixedLength(11)).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CodeCoSignerCodeAccessStart.setDescription("The value of this object is the co-signer's current\ncodeAccessStart value.  This value will always refer to\nGreenwich Mean Time (GMT), and the value format must contain\nTimeZone information (fields 8-10).\nIf docsBpi2CodeCoSignerOrgName is a zero\nlength string, the value of this object is meaningless.")
docsBpi2CodeCoSignerCvcAccessStart = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 8), DateAndTime().subtype(subtypeSpec=ValueSizeConstraint(11, 11)).setFixedLength(11)).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsBpi2CodeCoSignerCvcAccessStart.setDescription("The value of this object is the co-signer's current\ncvcAccessStart value.  This value will always refer to\n\n\n\nGreenwich Mean Time (GMT), and the value format must contain\nTimeZone information (fields 8-10).\nIf docsBpi2CodeCoSignerOrgName is a zero\nlength string, the value of this object is meaningless.")
docsBpi2CodeCvcUpdate = MibScalar((1, 3, 6, 1, 2, 1, 126, 1, 4, 9), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsBpi2CodeCvcUpdate.setDescription("Setting a CVC to this object triggers the device\nto verify the CVC and update the cvcAccessStart values.\nThe content of this object is then discarded.\nIf the device is not enabled to upgrade codefiles, or if\nthe CVC verification fails, the CVC will be rejected.\nReading this object always returns the zero-length OCTET\nSTRING.")
docsBpi2Conformance = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 2))
docsBpi2Compliances = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 2, 1))
docsBpi2Groups = MibIdentifier((1, 3, 6, 1, 2, 1, 126, 2, 2))

# Augmentions

# Groups

docsBpi2CmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 126, 2, 2, 1)).setObjects(*(("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKExpiresNew"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthInvalids"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKExpiresOld"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastSAId"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthRequests"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthReset"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthWaitTimeout"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastSAMapRejectErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmCryptoSuiteDataEncryptAlg"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthInvalidErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastSAMapState"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthRejectErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKInvalids"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthExpiresOld"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmPrivacyEnable"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmOpWaitTimeout"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastAddress"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthRejects"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastSAMapRejects"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKState"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmRekeyWaitTimeout"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthGraceTime"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKKeyRejectErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthentInfos"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKKeyRequests"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmReauthWaitTimeout"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKAuthPends"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKDataEncryptAlg"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthKeySequenceNumber"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthReplies"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastSAMapRejectErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKDataAuthentAlg"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKKeyReplies"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKKeySequenceNumber"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKInvalidErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKKeyRejects"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthRejectWaitTimeout"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKSAType"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastAddressType"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthInvalidErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthState"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKInvalidErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmPublicKey"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthRejectErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKGraceTime"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmCryptoSuiteDataAuthentAlg"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmAuthExpiresNew"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmSAMapMaxRetries"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastSAMapReplies"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmSAMapWaitTimeout"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmDeviceCmCert"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmDeviceManufCert"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmTEKKeyRejectErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmIpMulticastSAMapRequests"), ) )
if mibBuilder.loadTexts: docsBpi2CmGroup.setDescription("This collection of objects provides CM BPI+ status\nand control.")
docsBpi2CmtsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 126, 2, 2, 2)).setObjects(*(("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastMask"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKExpiresOld"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsSAMapRejects"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsKeyRejects"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsProvisionedCmCertTrust"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmKeySequenceNumber"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastDataAuthentAlg"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastSAMapReplies"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsProvisionedCmCertSource"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmRejects"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCACertIndexPtr"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmPublicKey"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsProvisionedCmCert"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKInvalids"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthInvalids"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACertIssuer"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACertSource"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastSAMapRequests"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKInvalidErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACertStatus"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmExpiresNew"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsKeyRejectErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthBpkmCmCertValid"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmRequests"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastSAType"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastSAMapRejects"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthRejects"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsDefaultTEKLifetime"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmExpiresOld"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthentInfos"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsKeyRequests"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKExpiresNew"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsProvisionedCmCertStatus"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACertSerialNumber"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthRejectErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmReplies"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthBpkmCmCert"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACertThumbprint"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKReset"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACert"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACertTrust"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastAddressType"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmBpiVersion"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthPrimarySAId"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsKeyRejectErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKSAType"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCheckCertValidityPeriods"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthRejectErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmInfos"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastSAId"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsDefaultAuthLifetime"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsSAMapRequests"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmReset"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKInvalidErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmInvalids"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKDataAuthentAlg"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastSAMapRejectErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthCmLifetime"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthRequests"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastAddress"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastMapControl"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthInvalidErrorCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthReplies"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsSAMapReplies"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsKeyReplies"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastDataEncryptAlg"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKKeySequenceNumber"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsDefaultSelfSignedManufCertTrust"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsAuthInvalidErrorString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsCACertSubject"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKDataEncryptAlg"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsTEKLifetime"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastMapStorageType"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsMulticastAuthControl"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsIpMulticastSAMapRejectErrorCode"), ) )
if mibBuilder.loadTexts: docsBpi2CmtsGroup.setDescription("This collection of objects provides CMTS BPI+ status\nand control.")
docsBpi2CodeDownloadGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 126, 2, 2, 3)).setObjects(*(("DOCS-IETF-BPI2-MIB", "docsBpi2CodeMfgOrgName"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeDownloadStatusCode"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeCoSignerOrgName"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeCvcUpdate"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeDownloadStatusString"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeCoSignerCvcAccessStart"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeMfgCodeAccessStart"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeMfgCvcAccessStart"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeCoSignerCodeAccessStart"), ) )
if mibBuilder.loadTexts: docsBpi2CodeDownloadGroup.setDescription("This collection of objects provides authenticated\nsoftware download support.")

# Compliances

docsBpi2CmCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 126, 2, 1, 1)).setObjects(*(("DOCS-IETF-BPI2-MIB", "docsBpi2CmGroup"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeDownloadGroup"), ) )
if mibBuilder.loadTexts: docsBpi2CmCompliance.setDescription("This is the compliance statement for CMs that\nimplement the DOCSIS Baseline Privacy Interface Plus.")
docsBpi2CmtsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 126, 2, 1, 2)).setObjects(*(("DOCS-IETF-BPI2-MIB", "docsBpi2CodeDownloadGroup"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CmtsGroup"), ) )
if mibBuilder.loadTexts: docsBpi2CmtsCompliance.setDescription("This is the compliance statement for CMTSs that\nimplement the DOCSIS Baseline Privacy Interface Plus.")

# Exports

# Module identity
mibBuilder.exportSymbols("DOCS-IETF-BPI2-MIB", PYSNMP_MODULE_ID=docsBpi2MIB)

# Types
mibBuilder.exportSymbols("DOCS-IETF-BPI2-MIB", DocsBpkmDataAuthentAlg=DocsBpkmDataAuthentAlg, DocsBpkmDataEncryptAlg=DocsBpkmDataEncryptAlg, DocsBpkmSAType=DocsBpkmSAType, DocsSAId=DocsSAId, DocsSAIdOrZero=DocsSAIdOrZero, DocsX509ASN1DEREncodedCertificate=DocsX509ASN1DEREncodedCertificate)

# Objects
mibBuilder.exportSymbols("DOCS-IETF-BPI2-MIB", docsBpi2MIB=docsBpi2MIB, docsBpi2Notification=docsBpi2Notification, docsBpi2MIBObjects=docsBpi2MIBObjects, docsBpi2CmObjects=docsBpi2CmObjects, docsBpi2CmBaseTable=docsBpi2CmBaseTable, docsBpi2CmBaseEntry=docsBpi2CmBaseEntry, docsBpi2CmPrivacyEnable=docsBpi2CmPrivacyEnable, docsBpi2CmPublicKey=docsBpi2CmPublicKey, docsBpi2CmAuthState=docsBpi2CmAuthState, docsBpi2CmAuthKeySequenceNumber=docsBpi2CmAuthKeySequenceNumber, docsBpi2CmAuthExpiresOld=docsBpi2CmAuthExpiresOld, docsBpi2CmAuthExpiresNew=docsBpi2CmAuthExpiresNew, docsBpi2CmAuthReset=docsBpi2CmAuthReset, docsBpi2CmAuthGraceTime=docsBpi2CmAuthGraceTime, docsBpi2CmTEKGraceTime=docsBpi2CmTEKGraceTime, docsBpi2CmAuthWaitTimeout=docsBpi2CmAuthWaitTimeout, docsBpi2CmReauthWaitTimeout=docsBpi2CmReauthWaitTimeout, docsBpi2CmOpWaitTimeout=docsBpi2CmOpWaitTimeout, docsBpi2CmRekeyWaitTimeout=docsBpi2CmRekeyWaitTimeout, docsBpi2CmAuthRejectWaitTimeout=docsBpi2CmAuthRejectWaitTimeout, docsBpi2CmSAMapWaitTimeout=docsBpi2CmSAMapWaitTimeout, docsBpi2CmSAMapMaxRetries=docsBpi2CmSAMapMaxRetries, docsBpi2CmAuthentInfos=docsBpi2CmAuthentInfos, docsBpi2CmAuthRequests=docsBpi2CmAuthRequests, docsBpi2CmAuthReplies=docsBpi2CmAuthReplies, docsBpi2CmAuthRejects=docsBpi2CmAuthRejects, docsBpi2CmAuthInvalids=docsBpi2CmAuthInvalids, docsBpi2CmAuthRejectErrorCode=docsBpi2CmAuthRejectErrorCode, docsBpi2CmAuthRejectErrorString=docsBpi2CmAuthRejectErrorString, docsBpi2CmAuthInvalidErrorCode=docsBpi2CmAuthInvalidErrorCode, docsBpi2CmAuthInvalidErrorString=docsBpi2CmAuthInvalidErrorString, docsBpi2CmTEKTable=docsBpi2CmTEKTable, docsBpi2CmTEKEntry=docsBpi2CmTEKEntry, docsBpi2CmTEKSAId=docsBpi2CmTEKSAId, docsBpi2CmTEKSAType=docsBpi2CmTEKSAType, docsBpi2CmTEKDataEncryptAlg=docsBpi2CmTEKDataEncryptAlg, docsBpi2CmTEKDataAuthentAlg=docsBpi2CmTEKDataAuthentAlg, docsBpi2CmTEKState=docsBpi2CmTEKState, docsBpi2CmTEKKeySequenceNumber=docsBpi2CmTEKKeySequenceNumber, docsBpi2CmTEKExpiresOld=docsBpi2CmTEKExpiresOld, docsBpi2CmTEKExpiresNew=docsBpi2CmTEKExpiresNew, docsBpi2CmTEKKeyRequests=docsBpi2CmTEKKeyRequests, docsBpi2CmTEKKeyReplies=docsBpi2CmTEKKeyReplies, docsBpi2CmTEKKeyRejects=docsBpi2CmTEKKeyRejects, docsBpi2CmTEKInvalids=docsBpi2CmTEKInvalids, docsBpi2CmTEKAuthPends=docsBpi2CmTEKAuthPends, docsBpi2CmTEKKeyRejectErrorCode=docsBpi2CmTEKKeyRejectErrorCode, docsBpi2CmTEKKeyRejectErrorString=docsBpi2CmTEKKeyRejectErrorString, docsBpi2CmTEKInvalidErrorCode=docsBpi2CmTEKInvalidErrorCode, docsBpi2CmTEKInvalidErrorString=docsBpi2CmTEKInvalidErrorString, docsBpi2CmMulticastObjects=docsBpi2CmMulticastObjects, docsBpi2CmIpMulticastMapTable=docsBpi2CmIpMulticastMapTable, docsBpi2CmIpMulticastMapEntry=docsBpi2CmIpMulticastMapEntry, docsBpi2CmIpMulticastIndex=docsBpi2CmIpMulticastIndex, docsBpi2CmIpMulticastAddressType=docsBpi2CmIpMulticastAddressType, docsBpi2CmIpMulticastAddress=docsBpi2CmIpMulticastAddress, docsBpi2CmIpMulticastSAId=docsBpi2CmIpMulticastSAId, docsBpi2CmIpMulticastSAMapState=docsBpi2CmIpMulticastSAMapState, docsBpi2CmIpMulticastSAMapRequests=docsBpi2CmIpMulticastSAMapRequests, docsBpi2CmIpMulticastSAMapReplies=docsBpi2CmIpMulticastSAMapReplies, docsBpi2CmIpMulticastSAMapRejects=docsBpi2CmIpMulticastSAMapRejects, docsBpi2CmIpMulticastSAMapRejectErrorCode=docsBpi2CmIpMulticastSAMapRejectErrorCode, docsBpi2CmIpMulticastSAMapRejectErrorString=docsBpi2CmIpMulticastSAMapRejectErrorString, docsBpi2CmCertObjects=docsBpi2CmCertObjects, docsBpi2CmDeviceCertTable=docsBpi2CmDeviceCertTable, docsBpi2CmDeviceCertEntry=docsBpi2CmDeviceCertEntry, docsBpi2CmDeviceCmCert=docsBpi2CmDeviceCmCert, docsBpi2CmDeviceManufCert=docsBpi2CmDeviceManufCert, docsBpi2CmCryptoSuiteTable=docsBpi2CmCryptoSuiteTable, docsBpi2CmCryptoSuiteEntry=docsBpi2CmCryptoSuiteEntry, docsBpi2CmCryptoSuiteIndex=docsBpi2CmCryptoSuiteIndex, docsBpi2CmCryptoSuiteDataEncryptAlg=docsBpi2CmCryptoSuiteDataEncryptAlg, docsBpi2CmCryptoSuiteDataAuthentAlg=docsBpi2CmCryptoSuiteDataAuthentAlg, docsBpi2CmtsObjects=docsBpi2CmtsObjects, docsBpi2CmtsBaseTable=docsBpi2CmtsBaseTable, docsBpi2CmtsBaseEntry=docsBpi2CmtsBaseEntry, docsBpi2CmtsDefaultAuthLifetime=docsBpi2CmtsDefaultAuthLifetime, docsBpi2CmtsDefaultTEKLifetime=docsBpi2CmtsDefaultTEKLifetime, docsBpi2CmtsDefaultSelfSignedManufCertTrust=docsBpi2CmtsDefaultSelfSignedManufCertTrust, docsBpi2CmtsCheckCertValidityPeriods=docsBpi2CmtsCheckCertValidityPeriods, docsBpi2CmtsAuthentInfos=docsBpi2CmtsAuthentInfos, docsBpi2CmtsAuthRequests=docsBpi2CmtsAuthRequests, docsBpi2CmtsAuthReplies=docsBpi2CmtsAuthReplies, docsBpi2CmtsAuthRejects=docsBpi2CmtsAuthRejects, docsBpi2CmtsAuthInvalids=docsBpi2CmtsAuthInvalids, docsBpi2CmtsSAMapRequests=docsBpi2CmtsSAMapRequests, docsBpi2CmtsSAMapReplies=docsBpi2CmtsSAMapReplies, docsBpi2CmtsSAMapRejects=docsBpi2CmtsSAMapRejects, docsBpi2CmtsAuthTable=docsBpi2CmtsAuthTable, docsBpi2CmtsAuthEntry=docsBpi2CmtsAuthEntry, docsBpi2CmtsAuthCmMacAddress=docsBpi2CmtsAuthCmMacAddress, docsBpi2CmtsAuthCmBpiVersion=docsBpi2CmtsAuthCmBpiVersion, docsBpi2CmtsAuthCmPublicKey=docsBpi2CmtsAuthCmPublicKey, docsBpi2CmtsAuthCmKeySequenceNumber=docsBpi2CmtsAuthCmKeySequenceNumber, docsBpi2CmtsAuthCmExpiresOld=docsBpi2CmtsAuthCmExpiresOld, docsBpi2CmtsAuthCmExpiresNew=docsBpi2CmtsAuthCmExpiresNew, docsBpi2CmtsAuthCmLifetime=docsBpi2CmtsAuthCmLifetime, docsBpi2CmtsAuthCmReset=docsBpi2CmtsAuthCmReset, docsBpi2CmtsAuthCmInfos=docsBpi2CmtsAuthCmInfos, docsBpi2CmtsAuthCmRequests=docsBpi2CmtsAuthCmRequests, docsBpi2CmtsAuthCmReplies=docsBpi2CmtsAuthCmReplies, docsBpi2CmtsAuthCmRejects=docsBpi2CmtsAuthCmRejects, docsBpi2CmtsAuthCmInvalids=docsBpi2CmtsAuthCmInvalids, docsBpi2CmtsAuthRejectErrorCode=docsBpi2CmtsAuthRejectErrorCode, docsBpi2CmtsAuthRejectErrorString=docsBpi2CmtsAuthRejectErrorString, docsBpi2CmtsAuthInvalidErrorCode=docsBpi2CmtsAuthInvalidErrorCode, docsBpi2CmtsAuthInvalidErrorString=docsBpi2CmtsAuthInvalidErrorString, docsBpi2CmtsAuthPrimarySAId=docsBpi2CmtsAuthPrimarySAId, docsBpi2CmtsAuthBpkmCmCertValid=docsBpi2CmtsAuthBpkmCmCertValid, docsBpi2CmtsAuthBpkmCmCert=docsBpi2CmtsAuthBpkmCmCert, docsBpi2CmtsAuthCACertIndexPtr=docsBpi2CmtsAuthCACertIndexPtr, docsBpi2CmtsTEKTable=docsBpi2CmtsTEKTable, docsBpi2CmtsTEKEntry=docsBpi2CmtsTEKEntry, docsBpi2CmtsTEKSAId=docsBpi2CmtsTEKSAId, docsBpi2CmtsTEKSAType=docsBpi2CmtsTEKSAType, docsBpi2CmtsTEKDataEncryptAlg=docsBpi2CmtsTEKDataEncryptAlg, docsBpi2CmtsTEKDataAuthentAlg=docsBpi2CmtsTEKDataAuthentAlg, docsBpi2CmtsTEKLifetime=docsBpi2CmtsTEKLifetime, docsBpi2CmtsTEKKeySequenceNumber=docsBpi2CmtsTEKKeySequenceNumber, docsBpi2CmtsTEKExpiresOld=docsBpi2CmtsTEKExpiresOld, docsBpi2CmtsTEKExpiresNew=docsBpi2CmtsTEKExpiresNew, docsBpi2CmtsTEKReset=docsBpi2CmtsTEKReset, docsBpi2CmtsKeyRequests=docsBpi2CmtsKeyRequests, docsBpi2CmtsKeyReplies=docsBpi2CmtsKeyReplies, docsBpi2CmtsKeyRejects=docsBpi2CmtsKeyRejects, docsBpi2CmtsTEKInvalids=docsBpi2CmtsTEKInvalids)
mibBuilder.exportSymbols("DOCS-IETF-BPI2-MIB", docsBpi2CmtsKeyRejectErrorCode=docsBpi2CmtsKeyRejectErrorCode, docsBpi2CmtsKeyRejectErrorString=docsBpi2CmtsKeyRejectErrorString, docsBpi2CmtsTEKInvalidErrorCode=docsBpi2CmtsTEKInvalidErrorCode, docsBpi2CmtsTEKInvalidErrorString=docsBpi2CmtsTEKInvalidErrorString, docsBpi2CmtsMulticastObjects=docsBpi2CmtsMulticastObjects, docsBpi2CmtsIpMulticastMapTable=docsBpi2CmtsIpMulticastMapTable, docsBpi2CmtsIpMulticastMapEntry=docsBpi2CmtsIpMulticastMapEntry, docsBpi2CmtsIpMulticastIndex=docsBpi2CmtsIpMulticastIndex, docsBpi2CmtsIpMulticastAddressType=docsBpi2CmtsIpMulticastAddressType, docsBpi2CmtsIpMulticastAddress=docsBpi2CmtsIpMulticastAddress, docsBpi2CmtsIpMulticastMask=docsBpi2CmtsIpMulticastMask, docsBpi2CmtsIpMulticastSAId=docsBpi2CmtsIpMulticastSAId, docsBpi2CmtsIpMulticastSAType=docsBpi2CmtsIpMulticastSAType, docsBpi2CmtsIpMulticastDataEncryptAlg=docsBpi2CmtsIpMulticastDataEncryptAlg, docsBpi2CmtsIpMulticastDataAuthentAlg=docsBpi2CmtsIpMulticastDataAuthentAlg, docsBpi2CmtsIpMulticastSAMapRequests=docsBpi2CmtsIpMulticastSAMapRequests, docsBpi2CmtsIpMulticastSAMapReplies=docsBpi2CmtsIpMulticastSAMapReplies, docsBpi2CmtsIpMulticastSAMapRejects=docsBpi2CmtsIpMulticastSAMapRejects, docsBpi2CmtsIpMulticastSAMapRejectErrorCode=docsBpi2CmtsIpMulticastSAMapRejectErrorCode, docsBpi2CmtsIpMulticastSAMapRejectErrorString=docsBpi2CmtsIpMulticastSAMapRejectErrorString, docsBpi2CmtsIpMulticastMapControl=docsBpi2CmtsIpMulticastMapControl, docsBpi2CmtsIpMulticastMapStorageType=docsBpi2CmtsIpMulticastMapStorageType, docsBpi2CmtsMulticastAuthTable=docsBpi2CmtsMulticastAuthTable, docsBpi2CmtsMulticastAuthEntry=docsBpi2CmtsMulticastAuthEntry, docsBpi2CmtsMulticastAuthSAId=docsBpi2CmtsMulticastAuthSAId, docsBpi2CmtsMulticastAuthCmMacAddress=docsBpi2CmtsMulticastAuthCmMacAddress, docsBpi2CmtsMulticastAuthControl=docsBpi2CmtsMulticastAuthControl, docsBpi2CmtsCertObjects=docsBpi2CmtsCertObjects, docsBpi2CmtsProvisionedCmCertTable=docsBpi2CmtsProvisionedCmCertTable, docsBpi2CmtsProvisionedCmCertEntry=docsBpi2CmtsProvisionedCmCertEntry, docsBpi2CmtsProvisionedCmCertMacAddress=docsBpi2CmtsProvisionedCmCertMacAddress, docsBpi2CmtsProvisionedCmCertTrust=docsBpi2CmtsProvisionedCmCertTrust, docsBpi2CmtsProvisionedCmCertSource=docsBpi2CmtsProvisionedCmCertSource, docsBpi2CmtsProvisionedCmCertStatus=docsBpi2CmtsProvisionedCmCertStatus, docsBpi2CmtsProvisionedCmCert=docsBpi2CmtsProvisionedCmCert, docsBpi2CmtsCACertTable=docsBpi2CmtsCACertTable, docsBpi2CmtsCACertEntry=docsBpi2CmtsCACertEntry, docsBpi2CmtsCACertIndex=docsBpi2CmtsCACertIndex, docsBpi2CmtsCACertSubject=docsBpi2CmtsCACertSubject, docsBpi2CmtsCACertIssuer=docsBpi2CmtsCACertIssuer, docsBpi2CmtsCACertSerialNumber=docsBpi2CmtsCACertSerialNumber, docsBpi2CmtsCACertTrust=docsBpi2CmtsCACertTrust, docsBpi2CmtsCACertSource=docsBpi2CmtsCACertSource, docsBpi2CmtsCACertStatus=docsBpi2CmtsCACertStatus, docsBpi2CmtsCACert=docsBpi2CmtsCACert, docsBpi2CmtsCACertThumbprint=docsBpi2CmtsCACertThumbprint, docsBpi2CodeDownloadControl=docsBpi2CodeDownloadControl, docsBpi2CodeDownloadStatusCode=docsBpi2CodeDownloadStatusCode, docsBpi2CodeDownloadStatusString=docsBpi2CodeDownloadStatusString, docsBpi2CodeMfgOrgName=docsBpi2CodeMfgOrgName, docsBpi2CodeMfgCodeAccessStart=docsBpi2CodeMfgCodeAccessStart, docsBpi2CodeMfgCvcAccessStart=docsBpi2CodeMfgCvcAccessStart, docsBpi2CodeCoSignerOrgName=docsBpi2CodeCoSignerOrgName, docsBpi2CodeCoSignerCodeAccessStart=docsBpi2CodeCoSignerCodeAccessStart, docsBpi2CodeCoSignerCvcAccessStart=docsBpi2CodeCoSignerCvcAccessStart, docsBpi2CodeCvcUpdate=docsBpi2CodeCvcUpdate, docsBpi2Conformance=docsBpi2Conformance, docsBpi2Compliances=docsBpi2Compliances, docsBpi2Groups=docsBpi2Groups)

# Groups
mibBuilder.exportSymbols("DOCS-IETF-BPI2-MIB", docsBpi2CmGroup=docsBpi2CmGroup, docsBpi2CmtsGroup=docsBpi2CmtsGroup, docsBpi2CodeDownloadGroup=docsBpi2CodeDownloadGroup)

# Compliances
mibBuilder.exportSymbols("DOCS-IETF-BPI2-MIB", docsBpi2CmCompliance=docsBpi2CmCompliance, docsBpi2CmtsCompliance=docsBpi2CmtsCompliance)
