// Generated by re2zig
// re2zig $INPUT -o $OUTPUT

const std = @import("std");

const none = std.math.maxInt(usize);

const SemVer = struct {
    major: u32,
    minor: u32,
    patch: u32,
};

fn s2n(str: []const u8) u32 { // convert pre-parsed string to a number
    var n: u32 = 0;
    for (str) |c| { n = n * 10 + (c - 48); }
    return n;
}

fn parse(yyinput: [:0]const u8) ?SemVer {
    var yycursor: usize = 0;
    var yymarker: usize = 0;

    // Final tag variables available in semantic action.
    var yytl0: usize = none;var yytl1: usize = none;var yytl2: usize = none;var yytl3: usize = none;var yytr0: usize = none;var yytr1: usize = none;var yytr2: usize = none;var yytr3: usize = none;

    // Intermediate tag variables used by the lexer (must be autogenerated).
    var yyt1: usize = none;var yyt2: usize = none;var yyt3: usize = none;var yyt4: usize = none;var yyt5: usize = none;

    
    var yych: u8 = 0;
    var yystate: u32 = 0;
    yyl: while (true) {
        switch (yystate) {
            0 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x30...0x39 => {
                        yyt1 = yycursor;
                        yycursor += 1;
                        yystate = 3;
                        continue :yyl;
                    },
                    else => {
                        yycursor += 1;
                        yystate = 1;
                        continue :yyl;
                    },
                }
            },
            1 => {
                yystate = 2;
                continue :yyl;
            },
            2 => { return null; },
            3 => {
                yymarker = yycursor;
                yych = yyinput[yycursor];
                switch (yych) {
                    0x2E => {
                        yycursor += 1;
                        yystate = 4;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 6;
                        continue :yyl;
                    },
                    else => {
                        yystate = 2;
                        continue :yyl;
                    },
                }
            },
            4 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x30...0x39 => {
                        yyt2 = yycursor;
                        yycursor += 1;
                        yystate = 7;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            5 => {
                yycursor = yymarker;
                yystate = 2;
                continue :yyl;
            },
            6 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x2E => {
                        yycursor += 1;
                        yystate = 4;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 6;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            7 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x00 => {
                        yyt3 = yycursor;
                        yyt4 = std.math.maxInt(usize);
                        yyt5 = std.math.maxInt(usize);
                        yycursor += 1;
                        yystate = 8;
                        continue :yyl;
                    },
                    0x2E => {
                        yyt3 = yycursor;
                        yyt5 = yycursor;
                        yycursor += 1;
                        yystate = 9;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 7;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            8 => {
                yytl1 = yyt1;
                yytl2 = yyt2;
                yytr2 = yyt3;
                yytl3 = yyt5;
                yytr3 = yyt4;
                yytl0 = yyt1;
                yytr0 = yycursor;
                yytr1 = yyt2;
                yytr1 -= 1;
                
            return SemVer {
                .major = s2n(yyinput[yytl1..yytr1]),
                .minor = s2n(yyinput[yytl2..yytr2]),
                .patch = if (yytl3 == none) 0 else s2n(yyinput[yytl3 + 1..yytr3])
            };

            },
            9 => {
                yych = yyinput[yycursor];
                if (yych <= 0x00) {
                    yystate = 5;
                    continue :yyl;
                }
                yystate = 11;
                continue :yyl;
            },
            10 => {
                yych = yyinput[yycursor];
                yystate = 11;
                continue :yyl;
            },
            11 => {
                switch (yych) {
                    0x00 => {
                        yyt4 = yycursor;
                        yycursor += 1;
                        yystate = 8;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 10;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            else => { @panic("internal lexer error"); },
        }
    }

}

test {
    try std.testing.expectEqual(parse("23.34"), SemVer{.major = 23, .minor = 34, .patch = 0});
    try std.testing.expectEqual(parse("1.2.99999"), SemVer{.major = 1, .minor = 2, .patch = 99999});
    try std.testing.expectEqual(parse("1.a"), null);
}
