/*
 *  This file is part of the WebKit open source project.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#if !defined(__WEBKITDOM_H_INSIDE__) && !defined(BUILDING_WEBKIT)
#error "Only <webkitdom/webkitdom.h> can be included directly."
#endif

#ifndef WebKitDOMNodeList_h
#define WebKitDOMNodeList_h

#include <glib-object.h>
#include <webkitdom/WebKitDOMObject.h>
#include <webkitdom/webkitdomdefines.h>

G_BEGIN_DECLS

#define WEBKIT_DOM_TYPE_NODE_LIST            (webkit_dom_node_list_get_type())
#define WEBKIT_DOM_NODE_LIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), WEBKIT_DOM_TYPE_NODE_LIST, WebKitDOMNodeList))
#define WEBKIT_DOM_NODE_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),  WEBKIT_DOM_TYPE_NODE_LIST, WebKitDOMNodeListClass)
#define WEBKIT_DOM_IS_NODE_LIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), WEBKIT_DOM_TYPE_NODE_LIST))
#define WEBKIT_DOM_IS_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  WEBKIT_DOM_TYPE_NODE_LIST))
#define WEBKIT_DOM_NODE_LIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),  WEBKIT_DOM_TYPE_NODE_LIST, WebKitDOMNodeListClass))

struct _WebKitDOMNodeList {
    WebKitDOMObject parent_instance;
};

struct _WebKitDOMNodeListClass {
    WebKitDOMObjectClass parent_class;
};

WEBKIT_API GType
webkit_dom_node_list_get_type(void);

/**
 * webkit_dom_node_list_item:
 * @self: A #WebKitDOMNodeList
 * @index: A #gulong
 *
 * Returns: (transfer none): A #WebKitDOMNode
**/
WEBKIT_API WebKitDOMNode*
webkit_dom_node_list_item(WebKitDOMNodeList* self, gulong index);

/**
 * webkit_dom_node_list_get_length:
 * @self: A #WebKitDOMNodeList
 *
 * Returns: A #gulong
**/
WEBKIT_API gulong
webkit_dom_node_list_get_length(WebKitDOMNodeList* self);

G_END_DECLS

#endif /* WebKitDOMNodeList_h */
