/* MediaManager.h - Window and menu support
   class to handle disk, cartridge, cassette,
   and executable file management and support 
   functions for the Macintosh OS X SDL port 
   of Atari800
   Mark Grebe <atarimac@cox.net>
   
   Based on the Preferences pane of the
   TextEdit application.

*/

#import <Cocoa/Cocoa.h>

@interface MediaManager : NSObject
{
    IBOutlet id d1DiskField;
    IBOutlet id d1DriveStatusPulldown;
    IBOutlet id d2DiskField;
    IBOutlet id d2DriveStatusPulldown;
    IBOutlet id d3DiskField;
    IBOutlet id d3DriveStatusPulldown;
    IBOutlet id d4DiskField;
    IBOutlet id d4DriveStatusPulldown;
    IBOutlet id d5DiskField;
    IBOutlet id d5DriveStatusPulldown;
    IBOutlet id d6DiskField;
    IBOutlet id d6DriveStatusPulldown;
    IBOutlet id d7DiskField;
    IBOutlet id d7DriveStatusPulldown;
    IBOutlet id d8DiskField;
    IBOutlet id d8DriveStatusPulldown;
    IBOutlet id diskFmtCusBytesPulldown;
    IBOutlet id diskFmtCusSecField;
    IBOutlet id diskFmtDDBytesPulldown;
    IBOutlet id diskFmtInsertDrivePulldown;
    IBOutlet id diskFmtInsertNewButton;
    IBOutlet id diskFmtMatrix;
    IBOutlet id removeMenu;
    IBOutlet id removeD1Item;
    IBOutlet id removeD2Item;
    IBOutlet id removeD3Item;
    IBOutlet id removeD4Item;
    IBOutlet id removeD5Item;
    IBOutlet id removeD6Item;
    IBOutlet id removeD7Item;
    IBOutlet id removeD8Item;
    IBOutlet id removeCartItem;
    IBOutlet id removeCassItem;
    IBOutlet id rewindCassItem;
    IBOutlet id errorButton;
    IBOutlet id errorField;
    IBOutlet id cart8KMatrix;
    IBOutlet id cart16KMatrix;
    IBOutlet id cart32KMatrix;
    IBOutlet id cart40KMatrix;
    IBOutlet id cart64KMatrix;
    IBOutlet id cart128KMatrix;
    IBOutlet id cart256KMatrix;
    IBOutlet id cart512KMatrix;
    IBOutlet id cart1024KMatrix;
}
+ (MediaManager *)sharedInstance;
- (void)displayError:(NSString *)errorMsg;
- (void)updateInfo;
- (NSString *) browseFileInDirectory:(NSString *)directory;
- (NSString *) saveFileInDirectory:(NSString *)directory:(NSString *)type;
- (IBAction)cancelDisk:(id)sender;
- (IBAction)cartInsert:(id)sender;
- (void)cartInsertFile:(NSString *)filename;
- (IBAction)cartRemove:(id)sender;
- (int)cartSelect:(int)cartSize;
- (IBAction)cartSelectOK:(id)sender;
- (IBAction)cartSelectCancel:(id)sender;
- (IBAction)cassInsert:(id)sender;
- (void)cassInsertFile:(NSString *)filename;
- (IBAction)cassRemove:(id)sender;
- (IBAction)cassRewind:(id)sender;
- (IBAction)convertCartRom:(id)sender;
- (IBAction)convertRomCart:(id)sender;
- (IBAction)createDisk:(id)sender;
- (IBAction)diskInsert:(id)sender;
- (IBAction)diskRotate:(id)sender;
- (void)diskInsertFile:(NSString *)filename;
- (IBAction)diskRemove:(id)sender;
- (IBAction)diskInsertKey:(int)diskNum;
- (IBAction)diskSetSave:(id)sender;
- (IBAction)diskSetLoad:(id)sender;
- (IBAction)diskSetLoadFile:(NSString *)filename;
- (IBAction)diskRemoveKey:(int)diskNum;;
- (IBAction)diskRemoveAll:(id)sender;
- (IBAction)driveStatusChange:(id)sender;
- (IBAction)loadExeFile:(id)sender;
- (void)loadExeFileFile:(NSString *)filename;
- (IBAction)miscUpdate:(id)sender;
- (IBAction)ok:(id)sender;
- (IBAction)showCreatePanel:(id)sender;
- (IBAction)showManagementPanel:(id)sender;
- (IBAction)errorOK:(id)sender;
- (void) releaseCmdKeys:(NSString *)character:(int)keyCode;

@end
