/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDriver;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.EditorVisitor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;
import com.google.gwt.editor.client.impl.DelegateMap;
import com.google.gwt.editor.client.impl.DirtCollector;
import com.google.gwt.editor.client.impl.ErrorCollector;
import com.google.gwt.editor.client.impl.Flusher;
import com.google.gwt.editor.client.impl.Initializer;
import com.google.gwt.editor.client.impl.SimpleViolation;
import com.google.gwt.editor.client.testing.EditorHierarchyPrinter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEditorDriver<T, E extends Editor<T>> {
    private AbstractEditorDelegate<T, E> delegate;
    private Map<LeafValueEditor<?>, Object> leafValueMap;
    private E editor;
    private List<EditorError> errors;
    private T object;

    public abstract void accept(EditorVisitor var1);

    public List<EditorError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean isDirty() {
        DirtCollector c = new DirtCollector();
        this.accept(c);
        return c.isDirty() || !((Object)this.leafValueMap).equals(c.getLeafValues());
    }

    public boolean setConstraintViolations(Iterable<ConstraintViolation<?>> violations) {
        return this.doSetViolations(SimpleViolation.iterableFromConstrantViolations(violations));
    }

    public String toString() {
        if (GWT.isProdMode()) {
            return super.toString();
        }
        return this.editor == null ? "Uninitialized" : EditorHierarchyPrinter.toString(this.asEditorDriver());
    }

    protected void configureDelegate(AbstractEditorDelegate<T, E> rootDelegate) {
        rootDelegate.initialize("", this.getEditor());
    }

    protected abstract AbstractEditorDelegate<T, E> createDelegate();

    protected void doEdit(T object) {
        this.checkEditor();
        object = this.delegate.ensureMutable(object);
        this.object = object;
        this.delegate.setObject(object);
        this.accept(new Initializer());
        DirtCollector c = new DirtCollector();
        this.accept(c);
        this.leafValueMap = c.getLeafValues();
    }

    protected void doFlush() {
        this.checkObject();
        this.errors = new ArrayList<EditorError>();
        this.accept(new Flusher());
        this.accept(new ErrorCollector(this.errors));
    }

    protected void doInitialize(E editor) {
        this.editor = editor;
        this.delegate = this.createDelegate();
        this.configureDelegate(this.delegate);
    }

    protected boolean doSetViolations(Iterable<SimpleViolation> violations) {
        this.checkObject();
        SimpleViolation.pushViolations(violations, this.asEditorDriver(), this.getViolationKeyMethod());
        this.errors = new ArrayList<EditorError>();
        this.accept(new ErrorCollector(this.errors));
        return this.hasErrors();
    }

    protected AbstractEditorDelegate<T, E> getDelegate() {
        return this.delegate;
    }

    protected E getEditor() {
        return this.editor;
    }

    protected T getObject() {
        return this.object;
    }

    protected DelegateMap.KeyMethod getViolationKeyMethod() {
        return DelegateMap.IDENTITY;
    }

    private EditorDriver<?> asEditorDriver() {
        return (EditorDriver)((Object)this);
    }

    private void checkEditor() {
        if (this.editor == null) {
            throw new IllegalStateException("Must call initialize() first");
        }
    }

    private void checkObject() {
        if (this.object == null) {
            throw new IllegalStateException("Must call edit() first");
        }
    }
}

