#include "mydef.h"
#include "parser.h"
#include <ctype.h>
#include "getnum.h"
#include "encode.h"

/*	modR/M̂߂̃}N */

#define CAT(flag,reg1,reg2) (((flag)<<6)|((reg1)<<3)|(reg2))

int getEncode(ENCODE *enc,char *src){
	CODE code;
	CODE_MAP *m;
	OPERAND *op1,*op2;
	ADDRESSING *adr2;
	int32 dispNum;
	int isExistBase;
	int adj;			/* SIB݂鎞̈ʒu␳ */
	int len;
	if(analyzeCode(&code,src)==ERR)return ERR;
	if(code.icode.group==NO_MATCH)return ERR;

	/* ϐ̏ */
	op1=&code.ope1;
	op2=&code.ope2;
	enc->seg=0;
	enc->prev[0]=enc->prev[1]=0;
	enc->tail=0;
	enc->disp[0]=NUL;

	m=getCodeProperty(code.icode);
	switch(code.icode.group){
	case MMX_CODE:
		/*	prefix0Fhł̌code,mod2byte */
		enc->prev[0]=0x0F;
		enc->code[0]=m->code;
		if(code.icode.num==0 || code.icode.num==1){	/* emms,femms O */
			enc->codeLen=1;
			return NOERR;
		}
		len=1;
		if(m->mod){
			enc->code[1]=m->mod;
			len++;
		}
		break;
	case _3DNOW_CODE:
		/* prefix0Fh,0FhōŌcode1byte */
		enc->prev[0]=0x0F;
		enc->prev[1]=0x0F;
		enc->tail=m->code;
		len=0;
		break;
	case PREFETCH_CODE:
		/* prefix0Fhcode1byte */
		enc->prev[0]=0x0F;
		enc->code[0]=m->code;
		/* enc->code[1]=m->mod ͉ŗOIɏ */
		len=1;
		break;
	default:
		fprintf(stderr,"This code can't be run in getEncode!\n");
		exit(1);
	}
	/* ܂͊ȒPmodR/M肷 */

	if(op1->type==tMMX){
		if(op2->type==tMMX || op2->type==tR32){
			enc->code[len]=CAT(3,op1->ope.reg,op2->ope.reg);
			len++;
			enc->codeLen=len;
			return NOERR;
		}
		if(op2->type==tIMM8){
			enc->code[len-1] |=op1->ope.reg;
			enc->code[len]=op2->ope.imm;
			len++;
			enc->codeLen=len;
			return NOERR;
		}
	}else if(op1->type==tR32){
		enc->code[len]=CAT(3,op2->ope.reg,op1->ope.reg);
		len++;
		enc->codeLen=len;
		return NOERR;
	}else{
		OPERAND *forswap;
		forswap=op1;
		op1=op2;
		op2=forswap;
	}
	adr2=&op2->ope.adr;

	/* ͂悢AhbVO(Ă₱ ӔCҏoĂ) */

	/* prefetch߂1operandƂȂ */
	if(code.icode.group==PREFETCH_CODE){
		if(code.icode.num==1){	/* prefetchw̗O */
			op1->ope.reg=1;
		}else{
			op1->ope.reg=0;
		}
	}
	/* ZOgvtBNX邩? */
	if(adr2->seg!=-1){
		enc->seg=adr2->seg;
	}

	if(adr2->base==-1 && adr2->index==-1){	/* displacement̎ */
		enc->code[len]=CAT(0,op1->ope.reg,EBP_CODE);
		len++;
		if(getNumber(&dispNum,adr2->disp)==NOERR){
			*(int32 *)&enc->code[len]=dispNum;
			len+=4;
		}else{
			strcpy(enc->disp,adr2->disp);
		}
		enc->codeLen=len;
		return NOERR;
	}

	adj=0;			/* SIB݂1 */
	isExistBase=1;	/* base0 */

	if(adr2->index !=-1 || adr2->base==ESP_CODE){	/* SIB 郂[h */
		enc->code[len]=CAT(0,op1->ope.reg,ESP_CODE);
		len++;
		if(adr2->index==-1){	/* index Ȃ */
			adr2->index=ESP_CODE;
			adr2->scale=0;
		}
		if(adr2->base==-1){	/* baseȂ */
			isExistBase=0;
			adr2->base=EBP_CODE;
		}
		enc->code[len]=CAT(adr2->scale,adr2->index,adr2->base);

		len++;
		adj=1;	/* ̕炷 */
	}else{									/* SIBȂ[h */
		enc->code[len]=CAT(0,op1->ope.reg,adr2->base);
		len++;
	}
	if(!*adr2->disp){		/* disp */
		if( adr2->base != EBP_CODE ){/* ebpbase̎OO(99/10/26) */
			enc->codeLen=len;
			return NOERR;
		}
	}else
	if(getNumber(&dispNum,adr2->disp)==ERR){/* label܂ł̂ŌvZs */
		if(isExistBase){
			enc->code[len-1-adj] |=(2<<6);
		}
		strcpy(enc->disp,adr2->disp);
		enc->codeLen=len;
		return NOERR;
	}
	/* dispvZł */
	if(!dispNum && adr2->base!=EBP_CODE){	/* ꂪ0Ȃ */
		enc->codeLen=len;
		return NOERR;
	}
	if(dispNum<128 && dispNum>=-128 && isExistBase){/* |disp|<256̂Ƃ */
		enc->code[len-1-adj] |=(1<<6);
		enc->code[len]=(byte)dispNum;
		len++;
		enc->codeLen=len;
		return NOERR;
	}
	/* |disp|>=256̂Ƃ */
	if(isExistBase){
		enc->code[len-1-adj] |=(2<<6);
	}
	*((int32 *)&enc->code[len])=dispNum;
	len+=4;
	enc->codeLen=len;
	return NOERR;
}

void putEncode(ENCODE *enc,FILE *fp){
	int i;
	fprintf(fp,"db ");
	if(enc->seg)fprintf(fp,"0%02Xh,",enc->seg);
	if(enc->prev[0])fprintf(fp,"%02Xh,",enc->prev[0]);
	if(enc->prev[1])fprintf(fp,"%02Xh,",enc->prev[1]);
	fprintf(fp,"0%02Xh",enc->code[0]);
	for(i=1;i<enc->codeLen;i++){
		fprintf(fp,",0%02Xh",enc->code[i]);
	}
	if(enc->disp[0]){
		fprintf(fp,"\ndd %s",enc->disp);
		if(enc->tail)fprintf(fp,"\ndb 0%02Xh",enc->tail);
	}else if(enc->tail)fprintf(fp,",0%02Xh",enc->tail);
	fprintf(fp," ;");
}
