/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.config;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.services.auth.identity.cli.common.Utils;
import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientConfigurationProvider {
    private static final Log LOG = LogFactory.getLog(ClientConfigurationProvider.class);
    private static final String PROXY_HOST_KEY = "ClientProxyHost";
    private static final String PROXY_PORT_KEY = "ClientProxyPort";
    private static final String PROXY_USERNAME_KEY = "ClientProxyUsername";
    private static final String PROXY_PASSWORD_KEY = "ClientProxyPassword";

    private void parseProxyFile(String configFile, ClientConfiguration config) {
        try {
            String pass;
            String user;
            String port;
            Properties proxyProps = Utils.readPropertiesFile(new File(configFile));
            String host = proxyProps.getProperty(PROXY_HOST_KEY);
            if (host != null) {
                config.setProxyHost(host);
            }
            if ((port = proxyProps.getProperty(PROXY_PORT_KEY)) != null) {
                config.setProxyPort(Integer.parseInt(port));
            }
            if ((user = proxyProps.getProperty(PROXY_USERNAME_KEY)) != null) {
                config.setProxyUsername(user);
            }
            if ((pass = proxyProps.getProperty(PROXY_PASSWORD_KEY)) != null) {
                config.setProxyPassword(pass);
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"The value specified for ClientProxyPort is not a valid port");
            Utils.exit(1, null, e);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load client configuration file. Make sure that the environment variable CLIENT_CONFIG_FILE or command line argument --client-config-file is set to a file containing your client configurations in the following format. Enter the values below without the < or >");
            LOG.error((Object)"ClientProxyHost=<Write your proxy server name>");
            LOG.error((Object)"ClientProxyPort=<Write your proxy server port number>");
            LOG.error((Object)"ClientProxyUsername=<Write your proxy username> (optional)");
            LOG.error((Object)"ClientProxyPassword=<Write your proxy password> (optional)");
            Utils.exit(1, null, e);
        }
    }

    public final ClientConfiguration getClientConfiguration() {
        return this.getClientConfiguration(System.getenv("CLIENT_CONFIG_FILE"));
    }

    public final ClientConfiguration getClientConfiguration(String configFile) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        if (configFile != null) {
            this.parseProxyFile(configFile, clientConfig);
        }
        return clientConfig;
    }
}

