/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import picard.PicardException;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.IlluminaData;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.IlluminaParser;
import picard.illumina.parser.OutputMapping;

abstract class PerTileCycleParser<ILLUMINA_DATA extends IlluminaData>
implements IlluminaParser<ILLUMINA_DATA> {
    private final File laneDirectory;
    private final int lane;
    private CycleFilesParser<ILLUMINA_DATA> cycleFilesParser;
    final OutputMapping outputMapping;
    protected int currentTile;
    private final CycleIlluminaFileMap cyclesToTileFiles;
    private final TreeSet<Integer> tileOrder;

    PerTileCycleParser(File directory, int lane, CycleIlluminaFileMap cyclesToTileFiles, OutputMapping outputMapping) {
        this.tileOrder = this.getTileOrder(cyclesToTileFiles);
        this.lane = lane;
        this.laneDirectory = new File(directory, IlluminaFileUtil.longLaneStr(this.lane));
        this.cyclesToTileFiles = cyclesToTileFiles;
        this.currentTile = this.tileOrder.first();
        this.outputMapping = outputMapping;
    }

    private TreeSet<Integer> getTileOrder(CycleIlluminaFileMap cyclesToTileFiles) {
        TreeSet<Integer> uniqueTiles = new TreeSet<Integer>();
        for (IlluminaFileMap fileMap : cyclesToTileFiles.values()) {
            uniqueTiles.addAll(fileMap.keySet());
        }
        return uniqueTiles;
    }

    protected abstract CycleFilesParser<ILLUMINA_DATA> makeCycleFileParser(List<File> var1);

    public abstract void initialize();

    @Override
    public void seekToTile(int tile) {
        this.currentTile = tile;
        if (this.cycleFilesParser != null) {
            this.cycleFilesParser.close();
        }
        int totalCycles = 0;
        ArrayList<File> tileFiles = new ArrayList<File>();
        for (Map.Entry entry : this.cyclesToTileFiles.entrySet()) {
            tileFiles.add((File)((IlluminaFileMap)entry.getValue()).get(this.currentTile));
            ++totalCycles;
        }
        this.cycleFilesParser = this.makeCycleFileParser(tileFiles);
        if (totalCycles != this.outputMapping.getTotalOutputCycles()) {
            throw new PicardException("Number of cycle OUTPUT files found (" + totalCycles + ") does not equal the number expected (" + this.outputMapping.getTotalOutputCycles() + ")");
        }
    }

    @Override
    public ILLUMINA_DATA next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("IlluminaData is missing in lane " + this.lane + " at directory location " + this.laneDirectory.getAbsolutePath());
        }
        if (!this.cycleFilesParser.hasNext()) {
            this.seekToTile(this.tileOrder.higher(this.currentTile));
        }
        return (ILLUMINA_DATA)((IlluminaData)this.cycleFilesParser.next());
    }

    @Override
    public boolean hasNext() {
        return this.cycleFilesParser.hasNext() || this.currentTile < this.tileOrder.last();
    }

    @Override
    public int getTileOfNextCluster() {
        if (this.cycleFilesParser.hasNext()) {
            return this.currentTile;
        }
        if (this.currentTile < this.tileOrder.last()) {
            return this.tileOrder.higher(this.currentTile);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void verifyData(List<Integer> tiles, int[] cycles) {
        if (tiles == null) {
            tiles = new ArrayList(this.cyclesToTileFiles.keySet());
        }
        this.cyclesToTileFiles.assertValid(tiles, cycles);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + this.getClass().getName());
    }

    @Override
    public void close() {
        this.cycleFilesParser.close();
    }

    protected static interface CycleFilesParser<ILLUMINA_DATA> {
        public void close();

        public ILLUMINA_DATA next();

        public boolean hasNext();
    }
}

