//
// Copyright (c) 2022, NVIDIA CORPORATION.  All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.
//

#pragma once

#include "cqi.hpp"

#include "nscq/nscq.h"

#include <memory>

namespace nscq::cqi {

struct nvswitch_osfp : public cqi {
    using cqi_t = nvswitch_osfp;
    using id_t = uint8_t;
    using cqi::cqi;
    [[nodiscard]] virtual auto get_id() const -> id_t = 0;

    struct osfp_presence_field : public field<nvswitch_osfp, readable<bool>> {};
    virtual auto get(osfp_presence_field) -> bool = 0;

    struct osfp_lane_mapping_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_lane_mapping_t>> {};
    virtual auto get(osfp_lane_mapping_field) -> nscq_cci_osfp_lane_mapping_t = 0;

    struct osfp_cable_type_field : public field<nvswitch_osfp, readable<uint8_t>> {};
    virtual auto get(osfp_cable_type_field) -> uint8_t = 0;

    struct osfp_module_media_type_field : public field<nvswitch_osfp, readable<uint8_t>> {};
    virtual auto get(osfp_module_media_type_field) -> uint8_t = 0;

    struct osfp_vendor_name_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_str_t>> {};
    virtual auto get(osfp_vendor_name_field) -> nscq_cci_osfp_str_t = 0;

    struct osfp_cable_length_field : public field<nvswitch_osfp, readable<uint16_t>> {};
    virtual auto get(osfp_cable_length_field) -> uint16_t = 0;

    struct osfp_part_number_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_str_t>> {};
    virtual auto get(osfp_part_number_field) -> nscq_cci_osfp_str_t = 0;

    struct osfp_revision_number_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_str_t>> {};
    virtual auto get(osfp_revision_number_field) -> nscq_cci_osfp_str_t = 0;

    struct osfp_serial_number_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_str_t>> {};
    virtual auto get(osfp_serial_number_field) -> nscq_cci_osfp_str_t = 0;

    struct osfp_lane_monitor_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_lane_monitor_t>> {};
    virtual auto get(osfp_lane_monitor_field) -> nscq_cci_osfp_lane_monitor_t = 0;
    virtual auto has(osfp_lane_monitor_field) -> bool = 0;

    struct osfp_module_monitor_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_module_monitor_t>> {};
    virtual auto get(osfp_module_monitor_field) -> nscq_cci_osfp_module_monitor_t = 0;

    struct osfp_module_firmware_version_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_module_firmware_version_t>> {};
    virtual auto get(osfp_module_firmware_version_field) -> nscq_cci_osfp_module_firmware_version_t = 0;

    struct osfp_signal_integrity_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_signal_integrity_t>> {};
    virtual auto get(osfp_signal_integrity_field) -> nscq_cci_osfp_signal_integrity_t = 0;

    struct osfp_data_path_state_field : public field<nvswitch_osfp, readable<nscq_cci_osfp_data_path_state_t>> {};
    virtual auto get(osfp_data_path_state_field) -> nscq_cci_osfp_data_path_state_t = 0;
};
} // namespace nscq::cqi

