/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_SYSTEMBIOSACCESS_H_
#define OPENDRIM_SYSTEMBIOSACCESS_H_

#include "BIOS_Common.h"

#include "OpenDRIM_SystemBIOS.h"
#include "assocOpenDRIM_SystemBIOS.h"

int BIOS_OpenDRIM_SystemBIOS_load(const CMPIBroker* broker, string& errorMessage);

int BIOS_OpenDRIM_SystemBIOS_unload(string& errorMessage);

int BIOS_OpenDRIM_SystemBIOS_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SystemBIOS>& instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_SystemBIOS_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SystemBIOS& instance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_SystemBIOS_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SystemBIOS& newInstance, const OpenDRIM_SystemBIOS& oldInstance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_SystemBIOS_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SystemBIOS& instance, string& errorMessage);

int BIOS_OpenDRIM_SystemBIOS_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SystemBIOS& instance, string& errorMessage);

int BIOS_OpenDRIM_SystemBIOS_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_SystemBIOS_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_SystemBIOS_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_SystemBIOS>& OpenDRIM_SystemBIOS_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_SystemBIOS_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_SystemBIOS>& OpenDRIM_SystemBIOS_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_SystemBIOS_populate(OpenDRIM_SystemBIOS& instance, string& errorMessage);

#endif /*OPENDRIM_SYSTEMBIOSACCESS_H_*/
