/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "cmpiOpenDRIM_AccountIdentity.h"

CMPIObjectPath* Simple_Identity_Management_OpenDRIM_AccountIdentity_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_AccountIdentity& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_AccountIdentity_classnames[0], OpenDRIM_AccountIdentity_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* Simple_Identity_Management_OpenDRIM_AccountIdentity_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_AccountIdentity& instance) {
	_E_;
	Objectpath op(broker, Simple_Identity_Management_OpenDRIM_AccountIdentity_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.CurrentlyAuthenticated_isNULL)
		ci.setProperty("CurrentlyAuthenticated", instance.CurrentlyAuthenticated);

	_L_;
	return ci.getHdl();
}

void Simple_Identity_Management_OpenDRIM_AccountIdentity_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_AccountIdentity& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void Simple_Identity_Management_OpenDRIM_AccountIdentity_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_AccountIdentity& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("CurrentlyAuthenticated", instance.CurrentlyAuthenticated) == OK)
		instance.CurrentlyAuthenticated_isNULL = false;

	_L_;
}

