#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Book of Unwritten Tales + The Critter Chronicles
# send your bug reports to contact@dotslashplay.it
###

script_version=20240404.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='the-book-of-unwritten-tales-1'
GAME_NAME='The Book of Unwritten Tales'

GAME_ID_CRITTER="${GAME_ID}-the-critter-chronicles"
GAME_NAME_CRITTER="${GAME_NAME}: The Critter Chronicles"

# Archives

## The Book of Unwritten Tales (main game)

ARCHIVE_BASE_0_NAME='setup_book_of_unwritten_tales_2.0.0.4.exe'
ARCHIVE_BASE_0_MD5='984e8f16cc04a2a27aea8b0d7ada1c1e'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_book_of_unwritten_tales_2.0.0.4-1.bin'
ARCHIVE_BASE_0_PART1_MD5='4ea0eccb7ca2f77c301e79412ff1e214'
ARCHIVE_BASE_0_PART2_NAME='setup_book_of_unwritten_tales_2.0.0.4-2.bin'
ARCHIVE_BASE_0_PART2_MD5='95e52d38b6c1548ac311284c539a4c52'
ARCHIVE_BASE_0_PART3_NAME='setup_book_of_unwritten_tales_2.0.0.4-3.bin'
ARCHIVE_BASE_0_PART3_MD5='7290d78ecbec866e46401e4c9d3549cf'
ARCHIVE_BASE_0_SIZE='5900000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.4'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_book_of_unwritten_tales'

## The Critter Chronicles

ARCHIVE_BASE_CRITTER_0_NAME='setup_book_of_unwritten_tales_critter_chronicles_2.1.0.10.exe'
ARCHIVE_BASE_CRITTER_0_MD5='eed5cd99d36e5900d0fd5775d0466c22'
ARCHIVE_BASE_CRITTER_0_TYPE='innosetup'
ARCHIVE_BASE_CRITTER_0_SIZE='2800000'
ARCHIVE_BASE_CRITTER_0_VERSION='1.0-gog2.1.0.10'
ARCHIVE_BASE_CRITTER_0_URL='https://www.gog.com/game/the_book_of_unwritten_tales_critter_chronicles'


CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
bout.exe
critterchronicles.exe
alut.dll
cg.dll
libogg.dll
libtheora.dll
libtheoraplayer.dll
libvorbis.dll
libvorbisfile.dll
lua5.1.dll
lua51.dll
ogremain.dll
ois.dll
particleuniverse.dll
plugin_cgprogrammanager.dll
rendersystem_direct3d9.dll
plugins.cfg
resources.cfg'
CONTENT_GAME_L10N_FILES='
kagedata/lang'
CONTENT_GAME_DATA_FILES='
data
kagedata
kapedata
config.xml
exportedfunctions.lua'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/My Documents/Book of Unwritten Tales/savegames'
WINE_PERSISTENT_DIRECTORIES_CRITTER='
users/${USER}/My Documents/Unwritten Tales - Critter Chronicles/savegames'
## Work around some texture display issues.
WINE_WINETRICKS_VERBS="${WINE_WINETRICKS_VERBS:-} d3dcompiler_47"
## The game will not start unless OpenAL32.dll is available.
WINE_WINETRICKS_VERBS="${WINE_WINETRICKS_VERBS:-} openal"

APP_MAIN_EXE='bout.exe'
APP_MAIN_EXE_CRITTER='critterchronicles.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n-en"
PKG_L10N_ID_CRITTER="${GAME_ID_CRITTER}-l10n-en"
PKG_L10N_DESCRIPTION='English localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_CRITTER="${GAME_ID_CRITTER}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ID_CRITTER="$GAME_ID_CRITTER"
PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_L10N_ID $PKG_DATA_ID"
PKG_BIN_DEPS_CRITTER="$PKG_L10N_ID_CRITTER $PKG_DATA_ID_CRITTER"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
