#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2018 BetaRays
set -o errexit

###
# Octodad Dadliest Catch
# send your bug reports to contact@dotslashplay.it
###

script_version=20230625.1

GAME_ID='octodad-dadliest-catch'
GAME_NAME='Octodad Dadliest Catch'

ARCHIVE_BASE_0='OctodadDadliestCatch1.2.19351.tar.gz'
ARCHIVE_BASE_0_MD5='df1ded6c02d856a23c2dba919c3be40a'
ARCHIVE_BASE_0_SIZE='3000000'
ARCHIVE_BASE_0_VERSION='1.2.19351-humble170512'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/octodad-dadliest-catch'

CONTENT_PATH_DEFAULT='Octodad Dadliest Catch'
CONTENT_LIBS_BIN_FILES='
libfmodevent-4.44.30.so
libfmodex-4.44.30.so'
CONTENT_GAME_BIN_FILES='
OctodadDadliestCatch'
CONTENT_GAME_DATA_FILES='
Content
icon_512x512.png'

USER_PERSISTENT_FILES='
*.odad
*.txt
*.xml'

APP_MAIN_EXE='OctodadDadliestCatch'
APP_MAIN_ICON='icon_512x512.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
# shellcheck disable=SC2119
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
# shellcheck disable=SC2119
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
