#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Myst 1
###

script_version=20230921.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='myst-1'
GAME_NAME='Myst'

ARCHIVE_BASE_1_NAME='setup_myst_masterpiece_edition_1.0_svm_update_4_(22598).exe'
ARCHIVE_BASE_1_MD5='e3c62eeb19abd2c9a947aee8300e995d'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_myst_masterpiece_edition_1.0_svm_update_4_(22598)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='4b84a68ec57e55bcc9b522c6333c669c'
ARCHIVE_BASE_1_SIZE='1500000'
ARCHIVE_BASE_1_VERSION='1.0.4-gog22598'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/myst_masterpiece_edition'

ARCHIVE_BASE_0_NAME='setup_myst_masterpiece_2.0.0.22.exe'
ARCHIVE_BASE_0_MD5='e7a979dc6ca044eaec2984877ac032c5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='620000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.22'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_MAIN_FILES='
qtw
channel.dat
credits.dat
dunny.dat
help.dat
intro.dat
mechan.dat
menu.dat
myst.dat
selen.dat
stone.dat'
CONTENT_DOC_MAIN_FILES='
manual.pdf
readme.txt'

APP_MAIN_SCUMMID='mohawk:myst'
APP_MAIN_ICON='app/goggame-1207658818.ico'
APP_MAIN_ICON_0='myst.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
