/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.Lock;

public final class ActiveLock
extends Lock {
    byte wakeUpNow;
    boolean potentiallyGranted;
    protected boolean canSkip;

    protected ActiveLock(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object) {
        super(compatibilitySpace, lockable, object);
    }

    protected boolean setPotentiallyGranted() {
        if (!this.potentiallyGranted) {
            this.potentiallyGranted = true;
            return true;
        }
        return false;
    }

    protected void clearPotentiallyGranted() {
        this.potentiallyGranted = false;
    }

    protected synchronized byte waitForGrant(int n) throws StandardException {
        if (this.wakeUpNow == 0) {
            try {
                if (n == -1) {
                    this.wait();
                } else if (n > 0) {
                    this.wait(n);
                }
            }
            catch (InterruptedException interruptedException) {
                throw StandardException.interrupt(interruptedException);
            }
        }
        byte by = this.wakeUpNow;
        this.wakeUpNow = 0;
        return by;
    }

    protected synchronized void wakeUp(byte by) {
        if (this.wakeUpNow != 2) {
            this.wakeUpNow = by;
        }
        this.notify();
    }
}

