!{\src2tex{textfont=tt}}
!!****f* ABINIT/prtene
!!
!! NAME
!! prtene
!!
!! FUNCTION
!! Print components of total energy in nice format
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR, LBoeri, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=all input variables in this dataset
!!   | berryphase
!!   | occopt
!!   | tphysel="physical" electronic temperature with FD occupations
!!   | tsmear=smearing energy or temperature (if metal)
!!  energies <type(energies_type)>=values of parts of total energy
!!  iout=unit number to which output is written
!!  usepaw= 0 for non paw calculation; =1 for paw calculation
!!
!! OUTPUT
!!  (only writing)
!!
!! PARENTS
!!      gstate
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine prtene(dtset,energies,iout,usepaw)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iout,usepaw
 type(dataset_type),intent(in) :: dtset
 type(energies_type),intent(in) :: energies

!Local variables-------------------------------
! Do not modify the length of this string
!scalars
 integer :: mu,optdc
 real(dp) :: eent,eintern,einterndc,enevalue,etotal,etotaldc
 character(len=22) :: eneName
 character(len=500) :: message

! *************************************************************************

 optdc=-1
 if (abs(energies%e_localpsp)>1.d-15.and.abs(energies%e_xcdc)<1.d-15) optdc=0
 if (abs(energies%e_localpsp)<1.d-15.and.abs(energies%e_xcdc)>1.d-15) optdc=1
 if (abs(energies%e_localpsp)>1.d-15.and.abs(energies%e_xcdc)>1.d-15) optdc=2

! ============= Evaluate some parts of the energy ===========

!Here, treat the case of metals
!In re-smeared case the free energy is defined with tphysel
 if(dtset%occopt>=3 .and. dtset%occopt<=7)then
  if (abs(dtset%tphysel) < tol10) then
   eent=-dtset%tsmear * energies%entropy
  else
   eent=-dtset%tphysel * energies%entropy
  end if
 else
  eent=zero
 end if

 if (optdc==0.or.optdc==2) then
  etotal = energies%e_kinetic + energies%e_hartree + energies%e_xc + &
         & energies%e_localpsp + energies%e_corepsp + eent
  if (dtset%usewvl == 1) etotal = etotal - energies%e_vxc
  if (usepaw==0) etotal = etotal + energies%e_nonlocalpsp
  if (usepaw==1) etotal = etotal + energies%e_paw
  if (dtset%berryopt==4) etotal=etotal+energies%e_elecfield
  if (dtset%icoultrtmt == 0) then
    etotal = etotal + energies%e_ewald
  else
    etotal = etotal + energies%e_ionion
  end if
 end if
 if (optdc>=1) then
  etotaldc = energies%e_eigenvalues - energies%e_hartree + energies%e_xc - &
           & energies%e_xcdc + energies%e_corepsp + eent
  if (usepaw==1) etotaldc = etotaldc + energies%e_pawdc
  if (dtset%berryopt==4) etotaldc = etotaldc + energies%e_elecfield
  if (dtset%icoultrtmt == 0) then
    etotaldc = etotaldc + energies%e_ewald
  else
    etotaldc = etotaldc + energies%e_ionion
  end if
 end if

 write(message,'(a,80a)') ch10,('-',mu=1,80)
 call wrtout(iout,message,'COLL')

! ============= Old version of printing (for tests) ===========

!XG030503 Back to the old version
 if(.false.)then     ! XG030503
  if(dtset%occopt>=3 .and. dtset%occopt<=7)then
   write(message, '(a,a)' ) ch10,&
&   ' Eight components of total free energy (hartree) are '
  else
   write(message, '(a,a)' ) ch10,&
&   ' Seven components of total energy (hartree) are '
  end if
  call wrtout(iout,message,'COLL')
  write(message, '(a,1p,e21.14,a,e21.14)' ) &
&  ' kinetic=',energies%e_kinetic,' Hartree=',energies%e_hartree
  call wrtout(iout,message,'COLL')
  write(message, '(a,1p,e21.14,a,e21.14)' ) &
&  '      xc=',energies%e_xc,' loc psp=',energies%e_localpsp
  call wrtout(iout,message,'COLL')
  write(message, '(a,1p,e21.14,a,e21.14)' ) &
&  ' nl psp =',energies%e_nonlocalpsp,' pspcore=',energies%e_corepsp
  call wrtout(iout,message,'COLL')
! Here, treat the case of metals
  if(dtset%occopt>=3 .and. dtset%occopt<=7)then
!  Redefine etotal as the total free energy
!  in re-smeared case the free energy is defined with tphysel
   if ( abs(dtset%tphysel) < tol10) then
    write(message, '(a,1p,e21.14,a,e21.14,a)' ) &
&    ' -kT*entropy =',-dtset%tsmear*energies%entropy,' (internal energy=',eintern,' )'
   else
     write(message, '(a,1p,e21.14,a,e21.14,a)' ) &
&   ' -kT*entropy =',-dtset%tphysel*energies%entropy,' (internal energy=',eintern,' )'
   end if
   call wrtout(iout,message,'COLL')
  end if
  write(message, '(a,1p,e21.14,a,e21.14,a)' ) &
&  ' Ewald  =',energies%e_ewald,' resulting in Etotal=',etotal,' hartree'
  call wrtout(iout,message,'COLL')
  if(abs(energies%e_pulay) >=1.0d-12)then
   write(message, '(a,1p,e21.14,a)' ) &
&   ' with Pulay finite basis set correction,    Etotal=',&
&   etotal+energies%e_pulay,' hartree'
   call wrtout(iout,message,'COLL')
  end if
  write(message,'(a,1p,e22.14,a,e18.10,a)' ) &
&   ' Also Etotal=',etotal*Ha_eV,' eV ; Eeig (band energy)=',energies%e_eigenvalues,' Ha'
  call wrtout(iout,message,'COLL')
 end if ! XG030503

! ============= Printing of Etotal by direct scheme ===========

  if (dtset%icoultrtmt == 1) then
    write(eneName, "(A)") "    Ion-ion energy  = "
    enevalue = energies%e_ionion
  else
    write(eneName, "(A)") "    Ewald energy    = "
    enevalue = energies%e_ewald
  end if

 if (optdc==0.or.optdc==2) then

  write(message, '(2a)' ) &
&  ' Components of total free energy (in Hartree) :',ch10
  call wrtout(iout,message,'COLL')
  write(message, '(5(a,es21.14,a),a,es21.14)' ) &
&  '    Kinetic energy  = ',energies%e_kinetic,ch10,&
&  '    Hartree energy  = ',energies%e_hartree,ch10,&
&  '    XC energy       = ',energies%e_xc,ch10,&
&  eneName,                 enevalue,ch10,&
&  '    PspCore energy  = ',energies%e_corepsp,ch10,&
&  '    Loc. psp. energy= ',energies%e_localpsp
  call wrtout(iout,message,'COLL')
  if (dtset%berryopt == 4) then
   write(message, '(a,es21.14)' ) &
&   '    Electric field  = ',energies%e_elecfield
   call wrtout(iout,message,'COLL')
  end if
  if (usepaw==0) then
   write(message, '(a,es21.14)' ) &
&   '    NL   psp  energy= ',energies%e_nonlocalpsp
  else
   write(message, '(a,es21.14)' ) &
&   '    Spherical terms = ',energies%e_paw
  end if
  call wrtout(iout,message,'COLL')
  if (dtset%usewvl == 1) then
     write(message, '(a,es21.14)' ) &
          &   '    XC pot. energy  = ', energies%e_vxc
     call wrtout(iout,message,'COLL')
  end if
  if(dtset%occopt>=3 .and. dtset%occopt<=7) then
   write(message, '(a,es21.14,a,a,a,es21.14)' ) &
&   '    >>>>> Internal E= ',etotal-eent,ch10,ch10,&
&   '    -kT*entropy     = ',eent
   call wrtout(iout,message,'COLL')
  end if
  write(message, '(a,es21.14)' ) &
&  '    >>>>>>>>> Etotal= ',etotal
  call wrtout(iout,message,'COLL')
  if (abs(energies%e_pulay) >=1.0d-12) then
   write(message, '(a,a,es21.14,a,a,es21.14)' ) ch10,&
&  '    Pulay correction= ',energies%e_pulay,ch10,&
&  '    >Etot with Pulay= ',etotal+energies%e_pulay
   call wrtout(iout,message,'COLL')
  end if
 end if

! ============= Printing of Etotal by double-counting scheme ===========

 if (optdc>=1) then

  write(message, '(a,a,a,3(a,es21.14,a),a,es21.14)' ) ch10,&
&   ' "Double-counting" decomposition of free energy:',ch10,&
&   '    Band energy     = ',energies%e_eigenvalues,ch10,&
&   eneName,                 enevalue,ch10,&
&   '    PspCore energy  = ',energies%e_corepsp,ch10,&
&   '    Dble-C XC-energy= ',-energies%e_hartree+energies%e_xc-energies%e_xcdc
  call wrtout(iout,message,'COLL')
  if (dtset%berryopt == 4) then
   write(message, '(a,es21.14)' ) &
&   '    Electric field  = ',energies%e_elecfield
   call wrtout(iout,message,'COLL')
  end if
  if (usepaw==1) then
   write(message, '(a,es21.14)' ) &
&   '    Spherical terms = ',energies%e_pawdc
   call wrtout(iout,message,'COLL')
  end if
  if(dtset%occopt>=3 .and. dtset%occopt<=7) then
   write(message, '(a,es21.14,a,a,a,es21.14)' ) &
&   '    >>>>> Internal E= ',etotaldc-eent,ch10,ch10,&
&   '    -kT*entropy     = ',eent
   call wrtout(iout,message,'COLL')
  end if
  write(message, '(a,es21.14)' ) &
&   '    >>>> Etotal (DC)= ',etotaldc
  call wrtout(iout,message,'COLL')
  if (abs(energies%e_pulay) >=1.0d-12) then
   write(message, '(a,a,es21.14,a,a,es21.14)' ) ch10,&
&  '    Pulay correction= ',energies%e_pulay,ch10,&
&  '    >EDC with Pulay= ',etotaldc+energies%e_pulay
   call wrtout(iout,message,'COLL')
  end if
 end if

! ======= Additional printing for compatibility  ==========

 if (usepaw==0.and.optdc==0) then
  write(message, '(a,a,a,a,es21.14,a,es18.10)' ) ch10,&
&  ' Other information on the energy :',ch10,&
&  '    Total energy(eV)= ',etotal*Ha_eV,' ; Band energy (Ha)= ',energies%e_eigenvalues
  call wrtout(iout,message,'COLL')
 end if

 if (usepaw==1) then
  if (optdc==0.or.optdc==2) then
   write(message, '(a,a,es21.14)' ) ch10,&
&   '  >Total energy in eV           = ',etotal*Ha_eV
   call wrtout(iout,message,'COLL')
  end if
  if (optdc>=1) then
   if (optdc==1) write(message, '(a)') ch10
   if (optdc==2) message=""
   write(message, '(a,a,es21.14)' ) trim(message),&
&   '  >Total DC energy in eV        = ',etotaldc*Ha_eV
   call wrtout(iout,message,'COLL')
  end if
 end if

! =============
 write(message,'(a,80a)')('-',mu=1,80)
 call wrtout(iout,message,'COLL')

end subroutine prtene
!!***
