!{\src2tex{textfont=tt}}
!!****f* ABINIT/ccgradvnl
!! NAME
!! ccgradvnl
!!
!! FUNCTION
!! Compute the (grad_K+grad_K') Vnl(K,K')
!! (three reciprocal lattice units components)
!! Needed for chi0(q=0)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  gvec(3,npwwfn)=integer coordinates of each plane wave in reciprocal space
!!  kibz(3,nkibz)=coordinates of all k points in the irreducible Brillouin zone
!!  mpsang=1+maximum angular momentum for nonlocal pseudopotentials
!!  natom=number of atoms
!!  nkibz=number of k points in the irreducible Brillouin zone
!!  npwwfn=number of planewaves for wavefunctions
!!  ntypat=number of types of atoms
!!  typat(natom)=type of each atom
!!  vkb(npwwfn,ntypat,mpsang,nkibz)=KB projector function
!!  vkbd(npwwfn,ntypat,mpsang,nkibz)=derivative of the KB projector function in reciprocal space
!!  vkbsign(mpsang,ntypat)=sign of each KB dyadic product
!!  xcart(3,natom)=cartesian coordinates of nuclei
!!
!! OUTPUT
!!  gradvnl =(grad_K + grad_K') Vnl(K,K') in reciprocal lattice units
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      printcm
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine ccgradvnl(npwwfn,nkibz,b1,b2,b3,gvec,kibz,ntypat,natom,&
&                     mpsang,typat,xcart,vkbsign,vkb,vkbd,gradvnl)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => ccgradvnl
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer :: mpsang,natom,nkibz,npwwfn,ntypat
!arrays
 integer :: gvec(3,npwwfn),typat(natom)
 real(dp) :: b1(3),b2(3),b3(3),kibz(3,nkibz),vkb(npwwfn,ntypat,mpsang,nkibz)
 real(dp) :: vkbd(npwwfn,ntypat,mpsang,nkibz),vkbsign(mpsang,ntypat)
 real(dp) :: xcart(3,natom)
 complex :: gradvnl(3,npwwfn,npwwfn,nkibz)

!Local variables ------------------------------
!scalars
 integer :: i,ia,ig,igd1,igd2,igd3,igp,ik,il,is,lmax
 real(dp) :: mkg,mkg2,mkgkgp,mkgp,mkgp2,rgdx,rgdy,rgdz,taugd,x,x2,x3,x4,x5,x6
 real(dp) :: x7,xcostheta
 complex :: cs,ct
 logical,parameter :: DEBUG=.false.
 character(len=500) :: message
!arrays
 complex :: sfac(ntypat)
!no_abirules
!legendre polynomials and their first derivatives
!s p d f g h i j  so up to PL_7 = pl(8)
 integer,parameter :: nlx=8
 real(dp) :: pl(nlx),pld(nlx)
!kg = k + G, kgp = k + G', moduli and various products (')
 real(dp) :: kg(3),kgp(3)

! *************************************************************************
 !legendre polynomials and their derivatives
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: scpdt
#endif
!End of the abilint section

 pl(1) = 1.0
 pld(1) = 0.0
 !pl(2) = costheta
 pld(2) = 1.0
 !pl(3) = 1/2 ( 3 costheta**2 - 1 )
 !pld(3) = 3 costheta

 write(message,'(a)')' limit q->0, including term <n,k|[Vnl,iqr]|n"k>'
 call wrtout(06,message,'COLL')

 if(DEBUG) then
  print *, 'npwwfn ', npwwfn
  print *, 'nkibz ', nkibz
  print *, 'mpsang ',  mpsang
  print *, 'ntypat ', ntypat, 'natom ', natom
  print *, 'typat ', typat
  print *, 'b ', b1, b2, b3
  print *, 'gvec ', gvec(:,1), gvec(:,npwwfn)
  print *, 'vkbsign ', vkbsign
  print *, 'vkb(1:3,1,1,1) ', vkb(1:3,1,1,1)
  print *, 'vkbd(1:3,1,1,1) ', vkbd(1:3,1,1,1)
  print *, 'xcart ', xcart
 end if

 lmax = mpsang
 if(mpsang>nlx) then
  print *, 'warning: number of angular momentum components'
  print *, '         bigger than programmed.'
  print *, '         taken into account only s p d f g h i j'
  lmax = nlx
 end if

 gradvnl(:,:,:,:) = (0.0,0.0)

 do ik = 1, nkibz

  do ig = 1, npwwfn
   kg(:) = kibz(:,ik) + real(gvec(:,ig))
   mkg2 = scpdt(kg,kg,b1,b2,b3)
   mkg = sqrt(mkg2)
   !the next to solve the problem with k=Gamma (may be)
   if(mkg < 0.0001) cycle
   do igp = 1, npwwfn
    kgp(:) = kibz(:,ik) + real(gvec(:,igp))
    mkgp2 = scpdt(kgp,kgp,b1,b2,b3)
    mkgp = sqrt(mkgp2)
    !the next to solve the problem with k=Gamma (may be)
    if(mkgp < 0.0001) cycle

    mkgkgp = mkg*mkgp
    xcostheta = scpdt(kg,kgp,b1,b2,b3) / mkgkgp
    x = xcostheta
    x2 = x * x
    x3 = x2 * x
    x4 = x3 * x
    x5 = x4 * x
    x6 = x5 * x
    x7 = x6 * x

    !calculate legendre polynomial PL_0 = pl(1)
    pl(2) = x
    pl(3) = (3.0/2.0) * x2 - (1.0/2.0)
    pl(4) = (5.0/2.0) * x3 - (3.0/2.0) * x
    pl(5) = (35.0/8.0) * x4 - (30.0/8.0) * x2 + (3.0/8.0)
    pl(6) = (63.0/8.0) * x5 - (70.0/8.0) * x3 + (15.0/8.0) * x
    pl(7) = (231.0/16.0) * x6 - (315.0/16.0) * x4 + &
&           (105.0/16.0) * x2 - (5.0/16.0)
    pl(8) = (429.0/16.0) * x7 - (693.0/16.0) * x5 + &
&           (315.0/16.0) * x3 - (35.0/16.0) * x
    !calculate legendre polynomial derivative
    pld(3) = 3.0 * x
    pld(4) = (15.0/2.0) * x2 - (3.0/2.0)
    pld(5) = (35.0/2.0) * x3 - (15.0/2.0) * x
    pld(6) = (315.0/8.0) * x4 - (210.0/8.0) * x2 + (15.0/8.0)
    pld(7) = (693.0/8.0) * x5 - (315.0/4.0) * x3 + (105.0/8.0) * x
    pld(8) = (3003.0/16.0) * x6 - (3465.0/16.0) * x4 + &
&            (945.0/16.0) * x2 - (35.0/16.0)

    igd1 = gvec(1,ig)-gvec(1,igp)
    igd2 = gvec(2,ig)-gvec(2,igp)
    igd3 = gvec(3,ig)-gvec(3,igp)
    rgdx = igd1*b1(1)+igd2*b2(1)+igd3*b3(1)
    rgdy = igd1*b1(2)+igd2*b2(2)+igd3*b3(2)
    rgdz = igd1*b1(3)+igd2*b2(3)+igd3*b3(3)
    do is = 1, ntypat
     sfac(is) = (0.0,0.0)
     do ia = 1, natom
      if(typat(ia)/=is) cycle
      taugd = rgdx*xcart(1,ia)+rgdy*xcart(2,ia)+ &
&             rgdz*xcart(3,ia)
      sfac(is) = sfac(is) + cmplx(cos(taugd),-sin(taugd))
     end do
    end do

    do i = 1, 3
     gradvnl(i,ig,igp,ik) = 0.0
     do is = 1, ntypat
      do il = 1, lmax
       ct =( kg(i)*(1/mkgkgp - xcostheta/mkg2 ) + &
&            kgp(i)*(1/mkgkgp - xcostheta/mkgp2 ) ) * &
&            pld(il) * vkbsign(il,is) * vkb(ig,is,il,ik) * vkb(igp,is,il,ik)
           
       cs = pl(il) * vkbsign(il,is) * &
&           ( kg(i)/mkg * vkbd(ig,is,il,ik) * vkb(igp,is,il,ik) + &
&             kgp(i)/mkgp * vkb(ig,is,il,ik) * vkbd(igp,is,il,ik) )
             
       gradvnl(i,ig,igp,ik) = gradvnl(i,ig,igp,ik) + sfac(is) * (ct + cs)
      end do !il
     end do !is
    end do !i

   end do !igp
  end do !ig
 end do !ik

 if(DEBUG) then
  print *, 'gradvnl '
  call printcm(gradvnl(1,:,:,1),npwwfn,npwwfn)
  call printcm(gradvnl(2,:,:,1),npwwfn,npwwfn)
  call printcm(gradvnl(3,:,:,1),npwwfn,npwwfn)
 end if

end subroutine ccgradvnl
!!***
