# ---------------------------------------------------------------------------
# - NET0007.als                                                             -
# - afnix:net module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2012 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   tcp option test unit
# @author amaury darsch

# get the modules
interp:library "afnix-net"
interp:library "afnix-sys"

# check socket enumerated item
assert "DONT-ROUTE"          (afnix:net:Socket:DONT-ROUTE:to-string)
assert "KEEP-ALIVE"          (afnix:net:Socket:KEEP-ALIVE:to-string)
assert "LINGER"              (afnix:net:Socket:LINGER:to-string)
assert "RCV-SIZE"            (afnix:net:Socket:RCV-SIZE:to-string)
assert "SND-SIZE"            (afnix:net:Socket:SND-SIZE:to-string)
assert "HOP-LIMIT"           (afnix:net:Socket:HOP-LIMIT:to-string)
assert "MULTICAST-LOOPBACK"  (afnix:net:Socket:MULTICAST-LOOPBACK:to-string)
assert "MULTICAST-HOP-LIMIT" (afnix:net:Socket:MULTICAST-HOP-LIMIT:to-string)
assert "MAX-SEGMENT-SIZE"    (afnix:net:Socket:MAX-SEGMENT-SIZE:to-string)
assert "NO-DELAY"            (afnix:net:Socket:NO-DELAY:to-string)


# create a tcp socket object
const tcp (afnix:net:TcpSocket)

# set some options
assert true (tcp:set-option afnix:net:Socket:REUSE-ADDRESS true)
assert true (tcp:set-option afnix:net:Socket:DONT-ROUTE    true)
assert true (tcp:set-option afnix:net:Socket:KEEP-ALIVE    true)
assert true (tcp:set-option afnix:net:Socket:LINGER        true 10)
assert true (tcp:set-option afnix:net:Socket:RCV-SIZE      1024)
assert true (tcp:set-option afnix:net:Socket:SND-SIZE      2084)
assert true (tcp:set-option afnix:net:Socket:HOP-LIMIT     10)
assert true (tcp:set-option afnix:net:Socket:NO-DELAY      true)

# create a udp socket
const udp (afnix:net:UdpSocket)

# set some options
assert true (udp:set-option afnix:net:Socket:REUSE-ADDRESS  true)
assert true (udp:set-option afnix:net:Socket:DONT-ROUTE     true)
assert true (udp:set-option afnix:net:Socket:RCV-SIZE       1024)
assert true (udp:set-option afnix:net:Socket:SND-SIZE       2084)
assert true (tcp:set-option afnix:net:Socket:HOP-LIMIT      10)

# check special options
if (udp:broadcast-p) {
  assert true (udp:set-option afnix:net:Socket:BROADCAST      true)
}
