(* Html *)
(* $Id$ *)

val char_array_to_char_table : (char * string) array -> string option array
val iso_8859_1_array : (char * string) array
val iso_8859_1_table : string option array
val iso_8859_1_table_sans_guillements : string option array
type html_document = { head : html_head; body : html_element; }
and html_head = {
  title : string;
  author : string;
  charset : html_charset;
  style_sheet : string option
}
and html_charset = ASCII | ISO_8859_1 | UTF8
and html_method = GET | POST
and html_element =
    I_button of string * string
  | I_hidden of string * string
  | I_text of string * string * int option * int option
  | I_text_area of string * int * int * string
  | I_checkbox of string * string * bool
  | I_radio of string * string * bool
  | I_select of string * bool * int * (string * string * bool) list
  | I_reset of string
  | Form of html_method * string * html_element
  | Anchor of url * html_element
  | Seq of html_element list
  | UL of html_element list
  | P of html_element
  | H of int * html_element
  | T of string
  | BT of string
  | IT of string
  | TT of string
  | Pre of string
  | HR
  | Table of html_table_row list
  | Nop
  | BR
  | Div of string * html_element list
  | Span of string * html_element
and html_table_row = html_table_cell list
and html_table_cell =
    C_contents of html_element
  | C_halign of html_table_cell_halign * html_table_cell
  | C_valign of html_table_cell_valign * html_table_cell
  | C_rowspan of int * html_table_cell
  | C_colspan of int * html_table_cell
  | C_header of html_table_cell
  | C_color of Rgb.t * html_table_cell
and html_table_cell_halign =
    Cha_left
  | Cha_center
  | Cha_right
  | Cha_justify
  | Cha_char of char
and html_table_cell_valign = Cva_top | Cva_middle | Cva_bottom | Cva_baseline
and url = string
val output : (string -> unit) -> (char -> unit) -> html_document -> unit
val output_to_channel : out_channel -> html_document -> unit
val output_to_buffer : Buffer.t -> html_document -> unit
val default_head : html_head
