/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Replace
extends SystemFunction {
    private Pattern regexp;

    public Expression simplify() throws XPathException {
        Expression expression = this.simplifyArguments(true);
        if (!(expression instanceof Value)) {
            this.regexp = Matches.tryToCompile(this.argument, 1, 3);
            if (this.regexp != null && this.regexp.matcher("").matches()) {
                throw new XPathException.Static("The regular expression must not be one that matches a zero-length string");
            }
        }
        return expression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Object object;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return StringValue.EMPTY_STRING;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
        String string = atomicValue2.getStringValue();
        this.checkReplacement(string);
        Pattern pattern = this.regexp;
        if (pattern == null) {
            Object object2;
            String string2;
            object = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            if (this.getNumberOfArguments() == 3) {
                string2 = "";
            } else {
                object2 = (AtomicValue)this.argument[3].evaluateItem(xPathContext);
                string2 = object2.getStringValue();
            }
            try {
                object2 = RegexTranslator.translate(object.getStringValue(), true);
                pattern = Pattern.compile((String)object2, Matches.setFlags(string2));
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                throw new XPathException.Dynamic(regexSyntaxException);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XPathException.Dynamic(patternSyntaxException);
            }
            if (pattern.matcher("").matches()) {
                throw new XPathException.Dynamic("The regular expression must not be one that matches a zero-length string");
            }
        }
        object = pattern.matcher(atomicValue.getStringValue()).replaceAll(atomicValue2.getStringValue());
        return new StringValue((CharSequence)object);
    }

    private void checkReplacement(String string) throws XPathException {
        int n = 0;
        while (n < string.length()) {
            char c;
            char c2 = string.charAt(n);
            if (c2 == '$') {
                if (n + 1 < string.length()) {
                    if ((c = string.charAt(++n)) < '0' || c > '9') {
                        this.dynamicError("Invalid replacement string in replace(): $ sign must be followed by digit 0-9");
                    }
                } else {
                    this.dynamicError("Invalid replacement string in replace(): $ sign at end of string");
                }
            } else if (c2 == '\\') {
                if (n + 1 < string.length()) {
                    if ((c = string.charAt(++n)) != '\\' && c != '$') {
                        this.dynamicError("Invalid replacement string in replace(): \\ character must be followed by \\ or $");
                    }
                } else {
                    this.dynamicError("Invalid replacement string in replace(): \\ character at end of string");
                }
            }
            ++n;
        }
    }
}

