/*
 * avrdude - A Downloader/Uploader for AVR device programmers
 * Copyright (C) 2022, Stefan Rueger <stefan.rueger@urclocks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/* $Id$ */

#ifndef urclock_hash_h__
#define urclock_hash_h__

    // Selected hashes from https://github.com/MCUdude/optiboot_flash
    {  512, 0, 0x2afe013b, 0x5775955f }, // optiboot_flash_atmega169_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x2afe013b, 0xd5de2de6 }, // optiboot_flash_atmega169_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x7de5e119, 0xecba44da }, // optiboot_flash_atmega169_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x2afe013b, 0x0ebf1682 }, // optiboot_flash_atmega169_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x2afe013b, 0xee9f5b33 }, // optiboot_flash_atmega169_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0x5790d602, 0x728c740e }, // optiboot_flash_at90can64_UART1_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x5419d99f }, // optiboot_flash_at90can64_UART1_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x9ff3235b }, // optiboot_flash_at90can64_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0xd1e8d0b9 }, // optiboot_flash_at90can64_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x74b9c238, 0xc76f76e5 }, // optiboot_flash_at90can64_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x74b9c238, 0xeafeb59b }, // optiboot_flash_at90can64_UART1_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x4ad22f5b }, // optiboot_flash_at90can64_UART1_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0xb495f1ea }, // optiboot_flash_at90can64_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x246dbc35 }, // optiboot_flash_at90can64_UART1_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0xd92f11b5 }, // optiboot_flash_at90can64_UART0_115200_16000000L_B5_BIGBOOT.hex
    {  512, 0, 0xb83f0d83, 0x3d3da465 }, // optiboot_flash_atmega32_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x8790003e, 0x9f82a66b }, // optiboot_flash_atmega32_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x8790003e, 0x65d86300 }, // optiboot_flash_atmega32_UART0_38400_8000000L_B0.hex
    {  512, 0, 0xb83f0d83, 0x87ac0178 }, // optiboot_flash_atmega32_UART0_38400_8000000L_B7.hex
    {  512, 0, 0xb83f0d83, 0xfae2fc26 }, // optiboot_flash_atmega32_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x8790003e, 0x333e86ec }, // optiboot_flash_atmega32_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x8790003e, 0xc286cdc8 }, // optiboot_flash_atmega32_UART0_115200_20000000L_B0.hex
    {  512, 0, 0xb83f0d83, 0x3330e675 }, // optiboot_flash_atmega32_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x8790003e, 0x55b98295 }, // optiboot_flash_atmega32_UART0_115200_16000000L_B0.hex
    {  512, 0, 0xb83f0d83, 0xde792fb2 }, // optiboot_flash_atmega32_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x9e762fa8, 0xe2724ea2 }, // optiboot_flash_atmega3250p_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x9e762fa8, 0xb21ddc89 }, // optiboot_flash_atmega3250p_UART0_38400_8000000L_B7.hex
    {  512, 0, 0xdaa198fa, 0x70fcc8e9 }, // optiboot_flash_atmega3250p_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x9e762fa8, 0xca6c9014 }, // optiboot_flash_atmega3250p_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x9e762fa8, 0x680e4729 }, // optiboot_flash_atmega3250p_UART0_115200_16000000L_B7.hex
    { 1024, 1, 0xae42ebb8, 0xe11ad957 }, // optiboot_flash_atmega644a_UART1_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xdc558cfc }, // optiboot_flash_atmega644a_UART1_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xc4b9120d }, // optiboot_flash_atmega644a_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x1327cc64 }, // optiboot_flash_atmega644a_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x93195537 }, // optiboot_flash_atmega644a_UART0_57600_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x1224da19 }, // optiboot_flash_atmega644a_UART0_38400_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x1ec7bc40 }, // optiboot_flash_atmega644a_UART1_38400_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xe9d90a4f }, // optiboot_flash_atmega644a_UART1_57600_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x9d361c4e }, // optiboot_flash_atmega644a_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x1e9a5d21 }, // optiboot_flash_atmega644a_UART1_9600_1000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x3b651e15 }, // optiboot_flash_atmega644a_UART1_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xea8fe774 }, // optiboot_flash_atmega644a_UART0_9600_1000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xb49eaa1f }, // optiboot_flash_atmega644a_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xbdbcaa5b }, // optiboot_flash_atmega644a_UART1_115200_20000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x8298e287 }, // optiboot_flash_atmega644a_UART1_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x50418be4 }, // optiboot_flash_atmega644a_UART0_115200_20000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xf9f61eb2 }, // optiboot_flash_atmega644a_UART0_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x7b6e9bb9 }, // optiboot_flash_atmega644a_UART1_115200_16000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xe27428c7 }, // optiboot_flash_atmega644a_UART1_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xdab405bd }, // optiboot_flash_atmega644a_UART0_115200_16000000L_B0_BIGBOOT.hex
    {  512, 0, 0x281edc46, 0xf013cd1b }, // optiboot_flash_atmega8_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x281edc46, 0x8cc6362a }, // optiboot_flash_atmega8_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x281edc46, 0x1d7084ea }, // optiboot_flash_atmega8_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x281edc46, 0xe35b8b8e }, // optiboot_flash_atmega8_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x281edc46, 0xa6eeec00 }, // optiboot_flash_atmega8_UART0_115200_20000000L_B5
    {  512, 0, 0x281edc46, 0x3f821234 }, // optiboot_flash_atmega8_UART0_115200_16000000L_B5.hex
    {  512, 0, 0x281edc46, 0x8f39129c }, // optiboot_flash_atmega8_UART0_115200_16000000L_B5
    {  512, 0, 0x6e02926f, 0x95dee889 }, // optiboot_flash_atmega168_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x6e02926f, 0x35af7f90 }, // optiboot_flash_atmega168_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x6d0b2063, 0x275726b6 }, // optiboot_flash_atmega168_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x6e02926f, 0xd5185017 }, // optiboot_flash_atmega168_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x6e02926f, 0x7cc1e494 }, // optiboot_flash_atmega168_UART0_115200_16000000L_B5.hex
    {  512, 0, 0x5e0e0dd4, 0x35d5431e }, // optiboot_flash_atmega165p_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x5e0e0dd4, 0xe668d759 }, // optiboot_flash_atmega165p_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x43900a31, 0xd9660e09 }, // optiboot_flash_atmega165p_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x5e0e0dd4, 0xdce1048b }, // optiboot_flash_atmega165p_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x5e0e0dd4, 0xa53600f9 }, // optiboot_flash_atmega165p_UART0_115200_16000000L_B5.hex
    {  512, 0, 0x7b09aae5, 0x69bf5c8e }, // optiboot_flash_atmega324p_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x6b6a18c2, 0xf5a5eb3c }, // optiboot_flash_atmega324p_UART1_38400_8000000L_B7.hex
    {  512, 0, 0x7b09aae5, 0xb615bceb }, // optiboot_flash_atmega324p_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x6b6a18c2, 0x0289d638 }, // optiboot_flash_atmega324p_UART1_38400_8000000L_B0.hex
    {  512, 0, 0x7b09aae5, 0x8a733497 }, // optiboot_flash_atmega324p_UART0_38400_8000000L_B7.hex
    {  512, 0, 0x6b6a18c2, 0x6eeef491 }, // optiboot_flash_atmega324p_UART1_57600_8000000L_B0.hex
    {  512, 0, 0x7b09aae5, 0x9a762e7d }, // optiboot_flash_atmega324p_UART0_38400_8000000L_B0.hex
    {  512, 0, 0x6b6a18c2, 0x80502860 }, // optiboot_flash_atmega324p_UART1_57600_8000000L_B7.hex
    {  512, 0, 0xc0548728, 0xbace9eb0 }, // optiboot_flash_atmega324p_UART0_9600_1000000L_B0.hex
    {  512, 0, 0xc0548728, 0xcaee2c76 }, // optiboot_flash_atmega324p_UART0_9600_1000000L_B7.hex
    {  512, 0, 0xd93615c8, 0x43a30b2c }, // optiboot_flash_atmega324p_UART1_9600_1000000L_B0.hex
    {  512, 0, 0xd93615c8, 0x97447ea4 }, // optiboot_flash_atmega324p_UART1_9600_1000000L_B7.hex
    {  512, 0, 0x6b6a18c2, 0x38bfc4ae }, // optiboot_flash_atmega324p_UART1_115200_20000000L_B0.hex
    {  512, 0, 0x6b6a18c2, 0x9b8dfb02 }, // optiboot_flash_atmega324p_UART1_115200_20000000L_B7.hex
    {  512, 0, 0x7b09aae5, 0x6abeaf7f }, // optiboot_flash_atmega324p_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x7b09aae5, 0x3cf239db }, // optiboot_flash_atmega324p_UART0_115200_20000000L_B0.hex
    {  512, 0, 0x7b09aae5, 0x4b40506a }, // optiboot_flash_atmega324p_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x7b09aae5, 0xe75b8b91 }, // optiboot_flash_atmega324p_UART0_115200_16000000L_B0.hex
    {  512, 0, 0x6b6a18c2, 0xba7b95c0 }, // optiboot_flash_atmega324p_UART1_115200_16000000L_B0.hex
    {  512, 0, 0x6b6a18c2, 0x35013504 }, // optiboot_flash_atmega324p_UART1_115200_16000000L_B7.hex
    { 1024, 1, 0xae42ebb8, 0x72e304c8 }, // optiboot_flash_atmega645_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xfbb2c79a }, // optiboot_flash_atmega645_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x6a60f73b }, // optiboot_flash_atmega645_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x84ab943f }, // optiboot_flash_atmega645_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x7c2c24f9 }, // optiboot_flash_atmega645_UART0_115200_16000000L_B5_BIGBOOT.hex
    {  512, 0, 0x3efcbf6f, 0xae9b86b1 }, // optiboot_flash_atmega88pb_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x3efcbf6f, 0xa82da96e }, // optiboot_flash_atmega88pb_UART0_57600_8000000L_B5.hex
    {  512, 0, 0xc65332c3, 0x74825a27 }, // optiboot_flash_atmega88pb_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x3efcbf6f, 0x58548b06 }, // optiboot_flash_atmega88pb_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x3efcbf6f, 0x44f778e5 }, // optiboot_flash_atmega88pb_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0x60bc143e, 0x20e29e43 }, // optiboot_flash_atmega2561_UART1_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x955eba65 }, // optiboot_flash_atmega2561_UART1_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x765d7928 }, // optiboot_flash_atmega2561_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x4080ee21 }, // optiboot_flash_atmega2561_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x679ba32b, 0x490d324b }, // optiboot_flash_atmega2561_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x679ba32b, 0x79f90273 }, // optiboot_flash_atmega2561_UART1_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x33759a79 }, // optiboot_flash_atmega2561_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0xa920ec6f }, // optiboot_flash_atmega2561_UART1_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x50c46e8f }, // optiboot_flash_atmega2561_UART0_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x3c27b00b }, // optiboot_flash_atmega2561_UART1_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xd85f6d82 }, // optiboot_flash_atmega1284p_UART0_57600_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x1fbd2028 }, // optiboot_flash_atmega1284p_UART0_38400_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xed72231d }, // optiboot_flash_atmega1284p_UART1_38400_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x7f4a01a9 }, // optiboot_flash_atmega1284p_UART1_57600_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xb0f7a5b8 }, // optiboot_flash_atmega1284p_UART1_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xc20575ef }, // optiboot_flash_atmega1284p_UART1_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x88e15790 }, // optiboot_flash_atmega1284p_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x55370f29 }, // optiboot_flash_atmega1284p_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x96d5dbb4 }, // optiboot_flash_atmega1284p_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x658f1f52 }, // optiboot_flash_atmega1284p_UART1_9600_1000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0xbee18fbd }, // optiboot_flash_atmega1284p_UART1_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x1fc522fc }, // optiboot_flash_atmega1284p_UART0_9600_1000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x10b83310 }, // optiboot_flash_atmega1284p_UART1_115200_20000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x39e2135a }, // optiboot_flash_atmega1284p_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x3fc0adef }, // optiboot_flash_atmega1284p_UART0_115200_20000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xa19ba944 }, // optiboot_flash_atmega1284p_UART1_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x5bc6b3f2 }, // optiboot_flash_atmega1284p_UART1_115200_16000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x7ee4239d }, // optiboot_flash_atmega1284p_UART0_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x246eaa1b }, // optiboot_flash_atmega1284p_UART0_115200_16000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xc9469042 }, // optiboot_flash_atmega1284p_UART1_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x685e324a }, // optiboot_flash_at90can128_UART1_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x40460a3e }, // optiboot_flash_at90can128_UART1_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x31358fa6 }, // optiboot_flash_at90can128_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0xad844b43 }, // optiboot_flash_at90can128_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x74b9c238, 0x80d4a95f }, // optiboot_flash_at90can128_UART1_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x74b9c238, 0xbdb2e58f }, // optiboot_flash_at90can128_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x8f1246d8 }, // optiboot_flash_at90can128_UART1_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x45af5fee }, // optiboot_flash_at90can128_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0xd9678677 }, // optiboot_flash_at90can128_UART1_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x9aa1fd94 }, // optiboot_flash_at90can128_UART0_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x9bcc1a0e }, // optiboot_flash_atmega2560_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x629de678 }, // optiboot_flash_atmega2560_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x30007b05 }, // optiboot_flash_atmega2560_UART1_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x90b8b8bc }, // optiboot_flash_atmega2560_UART1_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0xd2c7eafc }, // optiboot_flash_atmega2560_UART2_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x08f9d27e }, // optiboot_flash_atmega2560_UART2_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0xefb8f92a }, // optiboot_flash_atmega2560_UART3_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0xe386a2c9 }, // optiboot_flash_atmega2560_UART3_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x679ba32b, 0x4b945002 }, // optiboot_flash_atmega2560_UART2_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x679ba32b, 0x3c39f01e }, // optiboot_flash_atmega2560_UART1_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x679ba32b, 0xd4735023 }, // optiboot_flash_atmega2560_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x679ba32b, 0x0efd4181 }, // optiboot_flash_atmega2560_UART3_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x91c04fe3 }, // optiboot_flash_atmega2560_UART2_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0xbefc45da }, // optiboot_flash_atmega2560_UART1_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x3dd17c66 }, // optiboot_flash_atmega2560_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x08806ff2 }, // optiboot_flash_atmega2560_UART3_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x9846ce79 }, // optiboot_flash_atmega2560_UART1_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0xfb06ea82 }, // optiboot_flash_atmega2560_UART2_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x2c48547d }, // optiboot_flash_atmega2560_UART3_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x60bc143e, 0x332b8fbd }, // optiboot_flash_atmega2560_UART0_115200_16000000L_B7_BIGBOOT.hex
    {  512, 0, 0xf9a539c1, 0x1eb31a77 }, // optiboot_flash_atmega168pb_UART0_57600_8000000L_B5.hex
    {  512, 0, 0xf9a539c1, 0xc8abf849 }, // optiboot_flash_atmega168pb_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x41fc44ac, 0xfa99a078 }, // optiboot_flash_atmega168pb_UART0_9600_1000000L_B5.hex
    {  512, 0, 0xf9a539c1, 0x39b85e77 }, // optiboot_flash_atmega168pb_UART0_115200_20000000L_B5.hex
    {  512, 0, 0xf9a539c1, 0x671dbf66 }, // optiboot_flash_atmega168pb_UART0_115200_16000000L_B5.hex
    {  512, 0, 0xd2abed82, 0xb7ca9aa0 }, // optiboot_flash_atmega329p_UART0_57600_8000000L_B5.hex
    {  512, 0, 0xd2abed82, 0x591c05db }, // optiboot_flash_atmega329p_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x0367a176, 0x8379176b }, // optiboot_flash_atmega329p_UART0_9600_1000000L_B5.hex
    {  512, 0, 0xd2abed82, 0xe9039cee }, // optiboot_flash_atmega329p_UART0_115200_20000000L_B5.hex
    {  512, 0, 0xd2abed82, 0xa42a31ae }, // optiboot_flash_atmega329p_UART0_115200_16000000L_B5.hex
    {  512, 0, 0x109d28fd, 0x944d7982 }, // optiboot_flash_atmega328pb_UART1_38400_8000000L_B5.hex
    {  512, 0, 0xaaca6333, 0x7527e2c3 }, // optiboot_flash_atmega328pb_UART0_57600_8000000L_B5.hex
    {  512, 0, 0xaaca6333, 0xe99f2951 }, // optiboot_flash_atmega328pb_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x109d28fd, 0xbcd6db5f }, // optiboot_flash_atmega328pb_UART1_57600_8000000L_B5.hex
    {  512, 0, 0x43d06d19, 0xec3eecdc }, // optiboot_flash_atmega328pb_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x04f203a3, 0xb005f0fa }, // optiboot_flash_atmega328pb_UART1_9600_1000000L_B5.hex
    {  512, 0, 0xaaca6333, 0xeb9f0236 }, // optiboot_flash_atmega328pb_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x109d28fd, 0x7ef5c1ec }, // optiboot_flash_atmega328pb_UART1_115200_20000000L_B5.hex
    {  512, 0, 0x109d28fd, 0x06c4c2ee }, // optiboot_flash_atmega328pb_UART1_115200_16000000L_B5.hex
    {  512, 0, 0xaaca6333, 0xfcb4d5b7 }, // optiboot_flash_atmega328pb_UART0_115200_16000000L_B5.hex
    {  512, 0, 0x9e762fa8, 0xb21ddc89 }, // optiboot_flash_atmega3250_UART0_38400_8000000L_B7.hex
    {  512, 0, 0x9e762fa8, 0xe2724ea2 }, // optiboot_flash_atmega3250_UART0_57600_8000000L_B7.hex
    {  512, 0, 0xdaa198fa, 0x70fcc8e9 }, // optiboot_flash_atmega3250_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x9e762fa8, 0xca6c9014 }, // optiboot_flash_atmega3250_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x9e762fa8, 0x680e4729 }, // optiboot_flash_atmega3250_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x3145df66, 0xc272ddc7 }, // optiboot_flash_atmega324pa_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x071af385, 0x46471318 }, // optiboot_flash_atmega324pa_UART1_38400_8000000L_B7.hex
    {  512, 0, 0x3145df66, 0xe5b50fbd }, // optiboot_flash_atmega324pa_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x071af385, 0x85b4a0de }, // optiboot_flash_atmega324pa_UART1_38400_8000000L_B0.hex
    {  512, 0, 0x3145df66, 0x72ff2709 }, // optiboot_flash_atmega324pa_UART0_38400_8000000L_B7.hex
    {  512, 0, 0x071af385, 0x60508357 }, // optiboot_flash_atmega324pa_UART1_57600_8000000L_B0.hex
    {  512, 0, 0x3145df66, 0xcbaa0339 }, // optiboot_flash_atmega324pa_UART0_38400_8000000L_B0.hex
    {  512, 0, 0x071af385, 0x8ef6048f }, // optiboot_flash_atmega324pa_UART1_57600_8000000L_B7.hex
    {  512, 0, 0x81d8a7ee, 0xcd519875 }, // optiboot_flash_atmega324pa_UART1_9600_1000000L_B7.hex
    {  512, 0, 0x81d8a7ee, 0x111d249a }, // optiboot_flash_atmega324pa_UART1_9600_1000000L_B0.hex
    {  512, 0, 0x06a9ef74, 0x6b5d6b2a }, // optiboot_flash_atmega324pa_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x06a9ef74, 0x34087c9f }, // optiboot_flash_atmega324pa_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x3145df66, 0xd5787c2f }, // optiboot_flash_atmega324pa_UART0_115200_20000000L_B0.hex
    {  512, 0, 0x3145df66, 0xc4f81beb }, // optiboot_flash_atmega324pa_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x071af385, 0xdb04426f }, // optiboot_flash_atmega324pa_UART1_115200_20000000L_B7.hex
    {  512, 0, 0x071af385, 0xd4a6a12d }, // optiboot_flash_atmega324pa_UART1_115200_20000000L_B0.hex
    {  512, 0, 0x071af385, 0x2823c21c }, // optiboot_flash_atmega324pa_UART1_115200_16000000L_B7.hex
    {  512, 0, 0x071af385, 0x1c41a6ff }, // optiboot_flash_atmega324pa_UART1_115200_16000000L_B0.hex
    {  512, 0, 0x3145df66, 0xe7173071 }, // optiboot_flash_atmega324pa_UART0_115200_16000000L_B0.hex
    {  512, 0, 0x3145df66, 0xccd80acb }, // optiboot_flash_atmega324pa_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x5f64e566, 0x21e29c66 }, // optiboot_flash_atmega8535_UART0_38400_8000000L_B0.hex
    {  512, 0, 0xdc6b58da, 0x559f4e01 }, // optiboot_flash_atmega8535_UART0_38400_8000000L_B7.hex
    {  512, 0, 0xdc6b58da, 0xf3221cb1 }, // optiboot_flash_atmega8535_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x5f64e566, 0x308a27e4 }, // optiboot_flash_atmega8535_UART0_57600_8000000L_B0.hex
    {  512, 0, 0xdc6b58da, 0x36dda6dd }, // optiboot_flash_atmega8535_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x5f64e566, 0x4168537d }, // optiboot_flash_atmega8535_UART0_9600_1000000L_B0.hex
    {  512, 0, 0xdc6b58da, 0x4abee68c }, // optiboot_flash_atmega8535_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x5f64e566, 0xf520104b }, // optiboot_flash_atmega8535_UART0_115200_20000000L_B0.hex
    {  512, 0, 0xdc6b58da, 0x82613346 }, // optiboot_flash_atmega8535_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x5f64e566, 0x24b5ffd9 }, // optiboot_flash_atmega8535_UART0_115200_16000000L_B0.hex
    {  512, 0, 0x19c64b08, 0x70ae9c0a }, // optiboot_flash_atmega88_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x19c64b08, 0x4270dce3 }, // optiboot_flash_atmega88_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x25ddbfca, 0x039961cd }, // optiboot_flash_atmega88_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x19c64b08, 0x9bf7763b }, // optiboot_flash_atmega88_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x19c64b08, 0x6159afd6 }, // optiboot_flash_atmega88_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0xae42ebb8, 0x4ec4df61 }, // optiboot_flash_atmega6490_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x6f542d9f }, // optiboot_flash_atmega6490_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x66724b13 }, // optiboot_flash_atmega6490_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x987e5f86 }, // optiboot_flash_atmega6490_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x4b132863 }, // optiboot_flash_atmega6490_UART0_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x72e304c8 }, // optiboot_flash_atmega645p_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xfbb2c79a }, // optiboot_flash_atmega645p_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x6a60f73b }, // optiboot_flash_atmega645p_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x84ab943f }, // optiboot_flash_atmega645p_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x7c2c24f9 }, // optiboot_flash_atmega645p_UART0_115200_16000000L_B5_BIGBOOT.hex
    {  512, 0, 0x35e2b5b6, 0xe3f2c268 }, // optiboot_flash_atmega164a_UART0_38400_8000000L_B0.hex
    {  512, 0, 0x46954df9, 0xc307e815 }, // optiboot_flash_atmega164a_UART1_57600_8000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0xc38c7647 }, // optiboot_flash_atmega164a_UART0_38400_8000000L_B7.hex
    {  512, 0, 0x46954df9, 0xe5e526c7 }, // optiboot_flash_atmega164a_UART1_57600_8000000L_B0.hex
    {  512, 0, 0x35e2b5b6, 0x390f2ade }, // optiboot_flash_atmega164a_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x46954df9, 0xe3a119bb }, // optiboot_flash_atmega164a_UART1_38400_8000000L_B0.hex
    {  512, 0, 0x35e2b5b6, 0xe5235996 }, // optiboot_flash_atmega164a_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x46954df9, 0x54a100b1 }, // optiboot_flash_atmega164a_UART1_38400_8000000L_B7.hex
    {  512, 0, 0x74d076c7, 0xe8287590 }, // optiboot_flash_atmega164a_UART1_9600_1000000L_B0.hex
    {  512, 0, 0x74d076c7, 0xe8bed4e0 }, // optiboot_flash_atmega164a_UART1_9600_1000000L_B7.hex
    {  512, 0, 0x59f8865b, 0xdf955279 }, // optiboot_flash_atmega164a_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x59f8865b, 0x0082b42c }, // optiboot_flash_atmega164a_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0x404b2202 }, // optiboot_flash_atmega164a_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0x65c16403 }, // optiboot_flash_atmega164a_UART0_115200_20000000L_B0.hex
    {  512, 0, 0x46954df9, 0xb062bbd4 }, // optiboot_flash_atmega164a_UART1_115200_20000000L_B0.hex
    {  512, 0, 0x46954df9, 0x8d570578 }, // optiboot_flash_atmega164a_UART1_115200_20000000L_B7.hex
    {  512, 0, 0x46954df9, 0xe4472d82 }, // optiboot_flash_atmega164a_UART1_115200_16000000L_B0.hex
    {  512, 0, 0x46954df9, 0x6660ce56 }, // optiboot_flash_atmega164a_UART1_115200_16000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0x3e909f95 }, // optiboot_flash_atmega164a_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0x98798052 }, // optiboot_flash_atmega164a_UART0_115200_16000000L_B0.hex
    {  512, 0, 0xc188885a, 0xce4f7081 }, // optiboot_flash_atmega325_UART0_57600_8000000L_B5.hex
    {  512, 0, 0xc188885a, 0xe63cf120 }, // optiboot_flash_atmega325_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x058e72b8, 0x284da256 }, // optiboot_flash_atmega325_UART0_9600_1000000L_B5.hex
    {  512, 0, 0xc188885a, 0xc4ec9a85 }, // optiboot_flash_atmega325_UART0_115200_20000000L_B5.hex
    {  512, 0, 0xc188885a, 0x13d2f0ef }, // optiboot_flash_atmega325_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0xee6789c2, 0xde984e88 }, // optiboot_flash_atmega128_UART1_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xee6789c2, 0x047fffc9 }, // optiboot_flash_atmega128_UART1_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xd562886c, 0x6a2952aa }, // optiboot_flash_atmega128_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xd562886c, 0xa77e0c20 }, // optiboot_flash_atmega128_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xee6789c2, 0x09a5c098 }, // optiboot_flash_atmega128_UART1_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xd562886c, 0x604e9f9a }, // optiboot_flash_atmega128_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xee6789c2, 0xfc7070b2 }, // optiboot_flash_atmega128_UART1_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xd562886c, 0xb11bf9e2 }, // optiboot_flash_atmega128_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xee6789c2, 0xc9701422 }, // optiboot_flash_atmega128_UART1_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xd562886c, 0xc2be4e0f }, // optiboot_flash_atmega128_UART0_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x4ec4df61 }, // optiboot_flash_atmega6490p_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x6f542d9f }, // optiboot_flash_atmega6490p_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x66724b13 }, // optiboot_flash_atmega6490p_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x987e5f86 }, // optiboot_flash_atmega6490p_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x4b132863 }, // optiboot_flash_atmega6490p_UART0_115200_16000000L_B7_BIGBOOT.hex
    {  512, 0, 0xb90059d5, 0x6e225cd3 }, // optiboot_flash_atmega168p_UART0_38400_8000000L_B5.hex
    {  512, 0, 0xb90059d5, 0x8a4282f1 }, // optiboot_flash_atmega168p_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x87a200aa, 0x902a90c9 }, // optiboot_flash_atmega168p_UART0_9600_1000000L_B5.hex
    {  512, 0, 0xb90059d5, 0x19ff1b96 }, // optiboot_flash_atmega168p_UART0_115200_20000000L_B5.hex
    {  512, 0, 0xb90059d5, 0x995224d3 }, // optiboot_flash_atmega168p_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0x70394fcf, 0x98fdf349 }, // optiboot_flash_atmega1284_UART1_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xd48d3fb8 }, // optiboot_flash_atmega1284_UART1_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xd4f39919 }, // optiboot_flash_atmega1284_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x8be783b2 }, // optiboot_flash_atmega1284_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x0c66f86d }, // optiboot_flash_atmega1284_UART0_38400_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xc3c1fa0a }, // optiboot_flash_atmega1284_UART0_57600_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x8ce72fce }, // optiboot_flash_atmega1284_UART1_57600_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x2607dc62 }, // optiboot_flash_atmega1284_UART1_38400_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x3163b91d }, // optiboot_flash_atmega1284_UART1_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x3ef3abf3 }, // optiboot_flash_atmega1284_UART0_9600_1000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x31a00898 }, // optiboot_flash_atmega1284_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x09e6912d }, // optiboot_flash_atmega1284_UART1_9600_1000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xa1de91d9 }, // optiboot_flash_atmega1284_UART1_115200_20000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x433d6e94 }, // optiboot_flash_atmega1284_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x1e70b8cf }, // optiboot_flash_atmega1284_UART0_115200_20000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xa3cd737c }, // optiboot_flash_atmega1284_UART1_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x18bb2f99 }, // optiboot_flash_atmega1284_UART1_115200_16000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xb135ab3c }, // optiboot_flash_atmega1284_UART0_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xf4675d8b }, // optiboot_flash_atmega1284_UART0_115200_16000000L_B0_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xd96949e5 }, // optiboot_flash_atmega1284_UART1_115200_16000000L_B7_BIGBOOT.hex
    {  512, 0, 0x8c6fdab4, 0x8e5d9c95 }, // optiboot_flash_atmega16_UART0_38400_8000000L_B0.hex
    {  512, 0, 0x47fd9a23, 0x5c54fb4a }, // optiboot_flash_atmega16_UART0_38400_8000000L_B7.hex
    {  512, 0, 0x47fd9a23, 0xf8f086f5 }, // optiboot_flash_atmega16_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x8c6fdab4, 0x57b69579 }, // optiboot_flash_atmega16_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x8c6fdab4, 0xf7dabebc }, // optiboot_flash_atmega16_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x47fd9a23, 0x4d2b24be }, // optiboot_flash_atmega16_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x8c6fdab4, 0xfb8d3b56 }, // optiboot_flash_atmega16_UART0_115200_20000000L_B0.hex
    {  512, 0, 0x47fd9a23, 0xf417591b }, // optiboot_flash_atmega16_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x8c6fdab4, 0xfc0d86b5 }, // optiboot_flash_atmega16_UART0_115200_16000000L_B0.hex
    {  512, 0, 0x47fd9a23, 0x9bdeeb3c }, // optiboot_flash_atmega16_UART0_115200_16000000L_B7.hex
    { 1024, 1, 0xae42ebb8, 0x270bdd64 }, // optiboot_flash_atmega64_UART1_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x4c3d0b81 }, // optiboot_flash_atmega64_UART1_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x94b2a13c }, // optiboot_flash_atmega64_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x4cf8b9ab }, // optiboot_flash_atmega64_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x204dbfa5 }, // optiboot_flash_atmega64_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x0774388e }, // optiboot_flash_atmega64_UART1_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xbd6f5121 }, // optiboot_flash_atmega64_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x67960f85 }, // optiboot_flash_atmega64_UART1_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x583a87ca }, // optiboot_flash_atmega64_UART0_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x1462de41 }, // optiboot_flash_atmega64_UART1_115200_16000000L_B5_BIGBOOT.hex
    {  512, 0, 0x4abf9198, 0xda79c706 }, // optiboot_flash_atmega8515_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x4abf9198, 0x82098a14 }, // optiboot_flash_atmega8515_UART0_38400_8000000L_B0.hex
    {  512, 0, 0x4abf9198, 0x3b291035 }, // optiboot_flash_atmega8515_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x4abf9198, 0xd57f0c10 }, // optiboot_flash_atmega8515_UART0_115200_20000000L_B0.hex
    {  512, 0, 0x4abf9198, 0x0f838688 }, // optiboot_flash_atmega8515_UART0_115200_16000000L_B0.hex
    {  512, 0, 0xaa622fda, 0x4f06239c }, // optiboot_flash_atmega3290p_UART0_38400_8000000L_B7.hex
    {  512, 0, 0xaa622fda, 0x294107c3 }, // optiboot_flash_atmega3290p_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x0626ce58, 0x211cae4c }, // optiboot_flash_atmega3290p_UART0_9600_1000000L_B7.hex
    {  512, 0, 0xaa622fda, 0x21a0acf6 }, // optiboot_flash_atmega3290p_UART0_115200_20000000L_B7.hex
    {  512, 0, 0xaa622fda, 0x71720261 }, // optiboot_flash_atmega3290p_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x2afe013b, 0xd5de2de6 }, // optiboot_flash_atmega169p_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x2afe013b, 0x5775955f }, // optiboot_flash_atmega169p_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x7de5e119, 0xecba44da }, // optiboot_flash_atmega169p_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x2afe013b, 0x0ebf1682 }, // optiboot_flash_atmega169p_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x2afe013b, 0xee9f5b33 }, // optiboot_flash_atmega169p_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0xae42ebb8, 0x97ab29d7 }, // optiboot_flash_atmega644p_UART1_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x4023218f }, // optiboot_flash_atmega644p_UART1_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x94298c9c }, // optiboot_flash_atmega644p_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x27bbf745 }, // optiboot_flash_atmega644p_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x26ced1dc }, // optiboot_flash_atmega644p_UART0_38400_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x1094e6b3 }, // optiboot_flash_atmega644p_UART0_57600_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x6d886955 }, // optiboot_flash_atmega644p_UART1_57600_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xc69f1084 }, // optiboot_flash_atmega644p_UART1_38400_8000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x796847db }, // optiboot_flash_atmega644p_UART1_9600_1000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x767ff663 }, // optiboot_flash_atmega644p_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x0599449e }, // optiboot_flash_atmega644p_UART0_9600_1000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x56979720 }, // optiboot_flash_atmega644p_UART1_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x83ea01e1 }, // optiboot_flash_atmega644p_UART1_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x66c88213 }, // optiboot_flash_atmega644p_UART0_115200_20000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x6897b483 }, // optiboot_flash_atmega644p_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x2eb98629 }, // optiboot_flash_atmega644p_UART1_115200_20000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x28a87902 }, // optiboot_flash_atmega644p_UART1_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x0b89845e }, // optiboot_flash_atmega644p_UART0_115200_16000000L_B0_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x4d7e38df }, // optiboot_flash_atmega644p_UART0_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xc9f335c4 }, // optiboot_flash_atmega644p_UART1_115200_16000000L_B0_BIGBOOT.hex
    {  512, 0, 0x2afe013b, 0xd5de2de6 }, // optiboot_flash_atmega165_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x2afe013b, 0x5775955f }, // optiboot_flash_atmega165_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x7de5e119, 0xecba44da }, // optiboot_flash_atmega165_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x2afe013b, 0x0ebf1682 }, // optiboot_flash_atmega165_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x2afe013b, 0xee9f5b33 }, // optiboot_flash_atmega165_UART0_115200_16000000L_B5.hex
    {  512, 0, 0x7426b344, 0x8785ab7e }, // optiboot_flash_atmega162_UART1_57600_8000000L_B0.hex
    {  512, 0, 0xda8d468f, 0xe903fd84 }, // optiboot_flash_atmega162_UART0_38400_8000000L_B0.hex
    {  512, 0, 0xda8d468f, 0x9859287c }, // optiboot_flash_atmega162_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x7426b344, 0x7f9312a9 }, // optiboot_flash_atmega162_UART1_38400_8000000L_B0.hex
    {  512, 0, 0x3d2a281f, 0x1cc1dd8c }, // optiboot_flash_atmega162_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x132fb9cf, 0xb4c6e662 }, // optiboot_flash_atmega162_UART1_9600_1000000L_B0.hex
    {  512, 0, 0x7426b344, 0xceb4839a }, // optiboot_flash_atmega162_UART1_115200_20000000L_B0.hex
    {  512, 0, 0xda8d468f, 0x747f258c }, // optiboot_flash_atmega162_UART0_115200_20000000L_B0.hex
    {  512, 0, 0xda8d468f, 0x9859287c }, // optiboot_flash_atmega162_UART0_115200_16000000L_B0.hex
    {  512, 0, 0x7426b344, 0x8785ab7e }, // optiboot_flash_atmega162_UART1_115200_16000000L_B0.hex
    { 1024, 1, 0x5790d602, 0x3870ca19 }, // optiboot_flash_at90can32_UART1_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x09092111 }, // optiboot_flash_at90can32_UART1_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x675f40ab }, // optiboot_flash_at90can32_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x650469af }, // optiboot_flash_at90can32_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x74b9c238, 0x20e0c28b }, // optiboot_flash_at90can32_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x74b9c238, 0x4d1375ab }, // optiboot_flash_at90can32_UART1_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x141f9dd1 }, // optiboot_flash_at90can32_UART1_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x1584a240 }, // optiboot_flash_at90can32_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0x12c681d4 }, // optiboot_flash_at90can32_UART1_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x5790d602, 0xa23efbfe }, // optiboot_flash_at90can32_UART0_115200_16000000L_B5_BIGBOOT.hex
    {  512, 0, 0x2d9a8617, 0x9576f026 }, // optiboot_flash_atmega324a_UART1_57600_8000000L_B7.hex
    {  512, 0, 0xeebb98c4, 0x1c644fb2 }, // optiboot_flash_atmega324a_UART0_38400_8000000L_B0.hex
    {  512, 0, 0x2d9a8617, 0xb73769d1 }, // optiboot_flash_atmega324a_UART1_57600_8000000L_B0.hex
    {  512, 0, 0xeebb98c4, 0x497e8ac5 }, // optiboot_flash_atmega324a_UART0_38400_8000000L_B7.hex
    {  512, 0, 0x2d9a8617, 0x5e488620 }, // optiboot_flash_atmega324a_UART1_38400_8000000L_B0.hex
    {  512, 0, 0xeebb98c4, 0x1e7ff2f9 }, // optiboot_flash_atmega324a_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x2d9a8617, 0xccd64c5b }, // optiboot_flash_atmega324a_UART1_38400_8000000L_B7.hex
    {  512, 0, 0xeebb98c4, 0x0fb6694e }, // optiboot_flash_atmega324a_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x24de513c, 0xba0c877d }, // optiboot_flash_atmega324a_UART1_9600_1000000L_B0.hex
    {  512, 0, 0x24de513c, 0x14cea2eb }, // optiboot_flash_atmega324a_UART1_9600_1000000L_B7.hex
    {  512, 0, 0x6eb4e9a6, 0x7934547f }, // optiboot_flash_atmega324a_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x6eb4e9a6, 0x795931d0 }, // optiboot_flash_atmega324a_UART0_9600_1000000L_B7.hex
    {  512, 0, 0xeebb98c4, 0xa22a39b9 }, // optiboot_flash_atmega324a_UART0_115200_20000000L_B7.hex
    {  512, 0, 0xeebb98c4, 0xf23c1c01 }, // optiboot_flash_atmega324a_UART0_115200_20000000L_B0.hex
    {  512, 0, 0x2d9a8617, 0x79726fb0 }, // optiboot_flash_atmega324a_UART1_115200_20000000L_B0.hex
    {  512, 0, 0x2d9a8617, 0xbab08ccb }, // optiboot_flash_atmega324a_UART1_115200_20000000L_B7.hex
    {  512, 0, 0x2d9a8617, 0x6f998a26 }, // optiboot_flash_atmega324a_UART1_115200_16000000L_B0.hex
    {  512, 0, 0x2d9a8617, 0x379b94b7 }, // optiboot_flash_atmega324a_UART1_115200_16000000L_B7.hex
    {  512, 0, 0xeebb98c4, 0xb7798c1d }, // optiboot_flash_atmega324a_UART0_115200_16000000L_B7.hex
    {  512, 0, 0xeebb98c4, 0xa3ba96e7 }, // optiboot_flash_atmega324a_UART0_115200_16000000L_B0.hex
    {  512, 0, 0x5ccf35cb, 0x898afdb0 }, // optiboot_flash_atmega88p_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x5ccf35cb, 0xf0399a23 }, // optiboot_flash_atmega88p_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x42f48861, 0x8cfdfcb8 }, // optiboot_flash_atmega88p_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x5ccf35cb, 0x8990a68e }, // optiboot_flash_atmega88p_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x5ccf35cb, 0xa35ca98a }, // optiboot_flash_atmega88p_UART0_115200_16000000L_B5.hex
    {  512, 0, 0xc0e0c9aa, 0x2fcb09d8 }, // optiboot_flash_atmega328p_UART0_38400_8000000L_B5.hex
    {  512, 0, 0xc0e0c9aa, 0xb15524df }, // optiboot_flash_atmega328p_UART0_57600_8000000L_B5.hex
    {  512, 0, 0xe15a32cd, 0x32d973ec }, // optiboot_flash_atmega328p_UART0_9600_1000000L_B5.hex
    {  512, 0, 0xc0e0c9aa, 0x0127527c }, // optiboot_flash_atmega328p_UART0_115200_20000000L_B5.hex
    {  512, 0, 0xc0e0c9aa, 0x2cbe3881 }, // optiboot_flash_atmega328p_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0xae42ebb8, 0x0976c9ef }, // optiboot_flash_atmega649_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xa498f3ed }, // optiboot_flash_atmega649_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x064c9396 }, // optiboot_flash_atmega649_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xc42e67a3 }, // optiboot_flash_atmega649_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xb7ca22b5 }, // optiboot_flash_atmega649_UART0_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xc7d736d6 }, // optiboot_flash_atmega640_UART3_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xf1c8ea31 }, // optiboot_flash_atmega640_UART3_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x7e45b263 }, // optiboot_flash_atmega640_UART2_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xe2f5ab2b }, // optiboot_flash_atmega640_UART2_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xe279ccd5 }, // optiboot_flash_atmega640_UART1_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x7da86a27 }, // optiboot_flash_atmega640_UART1_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xa8c13596 }, // optiboot_flash_atmega640_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xcdd9bb83 }, // optiboot_flash_atmega640_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x781c56b2 }, // optiboot_flash_atmega640_UART2_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x5c86eb3f }, // optiboot_flash_atmega640_UART1_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x6abacc22 }, // optiboot_flash_atmega640_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x55c95f39 }, // optiboot_flash_atmega640_UART3_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x5df0eb9e }, // optiboot_flash_atmega640_UART1_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xa35dcc84 }, // optiboot_flash_atmega640_UART2_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x49ef04b1 }, // optiboot_flash_atmega640_UART3_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x817efbcf }, // optiboot_flash_atmega640_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x9c06346f }, // optiboot_flash_atmega640_UART2_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x507dd91e }, // optiboot_flash_atmega640_UART1_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x615a09e4 }, // optiboot_flash_atmega640_UART0_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x21b86ab9 }, // optiboot_flash_atmega640_UART3_115200_16000000L_B7_BIGBOOT.hex
    {  512, 0, 0xaa622fda, 0x294107c3 }, // optiboot_flash_atmega3290_UART0_57600_8000000L_B7.hex
    {  512, 0, 0xaa622fda, 0x4f06239c }, // optiboot_flash_atmega3290_UART0_38400_8000000L_B7.hex
    {  512, 0, 0x0626ce58, 0x211cae4c }, // optiboot_flash_atmega3290_UART0_9600_1000000L_B7.hex
    {  512, 0, 0xaa622fda, 0x21a0acf6 }, // optiboot_flash_atmega3290_UART0_115200_20000000L_B7.hex
    {  512, 0, 0xaa622fda, 0x71720261 }, // optiboot_flash_atmega3290_UART0_115200_16000000L_B7.hex
    {  512, 0, 0xc188885a, 0xe63cf120 }, // optiboot_flash_atmega325p_UART0_38400_8000000L_B5.hex
    {  512, 0, 0xc188885a, 0xce4f7081 }, // optiboot_flash_atmega325p_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x058e72b8, 0x284da256 }, // optiboot_flash_atmega325p_UART0_9600_1000000L_B5.hex
    {  512, 0, 0xc188885a, 0xc4ec9a85 }, // optiboot_flash_atmega325p_UART0_115200_20000000L_B5.hex
    {  512, 0, 0xc188885a, 0x13d2f0ef }, // optiboot_flash_atmega325p_UART0_115200_16000000L_B5.hex
    {  512, 0, 0xe70524cd, 0x76b1e5e7 }, // optiboot_flash_atmega324pb_UART1_57600_8000000L_B7.hex
    {  512, 0, 0x0cf7e212, 0x02724086 }, // optiboot_flash_atmega324pb_UART0_38400_8000000L_B0.hex
    {  512, 0, 0x119c8746, 0xc5b68c97 }, // optiboot_flash_atmega324pb_UART2_38400_8000000L_B7.hex
    {  512, 0, 0xe70524cd, 0x7d44fb76 }, // optiboot_flash_atmega324pb_UART1_57600_8000000L_B0.hex
    {  512, 0, 0x119c8746, 0x515f6cc8 }, // optiboot_flash_atmega324pb_UART2_38400_8000000L_B0.hex
    {  512, 0, 0x0cf7e212, 0x9fd0954e }, // optiboot_flash_atmega324pb_UART0_38400_8000000L_B7.hex
    {  512, 0, 0xe70524cd, 0x7b7220cf }, // optiboot_flash_atmega324pb_UART1_38400_8000000L_B0.hex
    {  512, 0, 0x119c8746, 0xfa254553 }, // optiboot_flash_atmega324pb_UART2_57600_8000000L_B0.hex
    {  512, 0, 0x0cf7e212, 0x1cc4a79d }, // optiboot_flash_atmega324pb_UART0_57600_8000000L_B7.hex
    {  512, 0, 0xe70524cd, 0x73288ce3 }, // optiboot_flash_atmega324pb_UART1_38400_8000000L_B7.hex
    {  512, 0, 0x0cf7e212, 0x1cba5cf5 }, // optiboot_flash_atmega324pb_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x119c8746, 0x1bc2e50d }, // optiboot_flash_atmega324pb_UART2_57600_8000000L_B7.hex
    {  512, 0, 0x23882f25, 0xf4e3bedc }, // optiboot_flash_atmega324pb_UART2_9600_1000000L_B7.hex
    {  512, 0, 0x23882f25, 0x309c6619 }, // optiboot_flash_atmega324pb_UART2_9600_1000000L_B0.hex
    {  512, 0, 0x4eda2f7e, 0xe23050d8 }, // optiboot_flash_atmega324pb_UART1_9600_1000000L_B0.hex
    {  512, 0, 0x4eda2f7e, 0xe571fa99 }, // optiboot_flash_atmega324pb_UART1_9600_1000000L_B7.hex
    {  512, 0, 0x25d48eb2, 0xe5bbf4cb }, // optiboot_flash_atmega324pb_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x25d48eb2, 0x367e2797 }, // optiboot_flash_atmega324pb_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x119c8746, 0x7a7b4a0e }, // optiboot_flash_atmega324pb_UART2_115200_20000000L_B7.hex
    {  512, 0, 0x119c8746, 0x46dce88c }, // optiboot_flash_atmega324pb_UART2_115200_20000000L_B0.hex
    {  512, 0, 0xe70524cd, 0xd64392cc }, // optiboot_flash_atmega324pb_UART1_115200_20000000L_B0.hex
    {  512, 0, 0xe70524cd, 0x2c53ef72 }, // optiboot_flash_atmega324pb_UART1_115200_20000000L_B7.hex
    {  512, 0, 0x0cf7e212, 0x151316da }, // optiboot_flash_atmega324pb_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x0cf7e212, 0x7d599f19 }, // optiboot_flash_atmega324pb_UART0_115200_20000000L_B0.hex
    {  512, 0, 0x0cf7e212, 0x5d9ee2b8 }, // optiboot_flash_atmega324pb_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x0cf7e212, 0xd67c7167 }, // optiboot_flash_atmega324pb_UART0_115200_16000000L_B0.hex
    {  512, 0, 0x119c8746, 0x722ccc92 }, // optiboot_flash_atmega324pb_UART2_115200_16000000L_B7.hex
    {  512, 0, 0x119c8746, 0x929de9d1 }, // optiboot_flash_atmega324pb_UART2_115200_16000000L_B0.hex
    {  512, 0, 0xe70524cd, 0x566a2f82 }, // optiboot_flash_atmega324pb_UART1_115200_16000000L_B0.hex
    {  512, 0, 0xe70524cd, 0x5fdf497d }, // optiboot_flash_atmega324pb_UART1_115200_16000000L_B7.hex
    {  512, 0, 0x76291c3d, 0xb99fa55c }, // optiboot_flash_atmega328_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x76291c3d, 0xca16f284 }, // optiboot_flash_atmega328_UART0_57600_8000000L_B5.hex
    {  512, 0, 0xe6d3ec9c, 0xf39cd12f }, // optiboot_flash_atmega328_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x76291c3d, 0xd4685bd8 }, // optiboot_flash_atmega328_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x76291c3d, 0xf983b103 }, // optiboot_flash_atmega328_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0x2f29a5a8, 0x7f45706b }, // optiboot_flash_atmega1281_UART1_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x2f29a5a8, 0xc5174f64 }, // optiboot_flash_atmega1281_UART1_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x2f29a5a8, 0xd272f5d9 }, // optiboot_flash_atmega1281_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x2f29a5a8, 0xe19b2f1b }, // optiboot_flash_atmega1281_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xe9fba810, 0xc4eebbbc }, // optiboot_flash_atmega1281_UART1_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xe9fba810, 0xb9923382 }, // optiboot_flash_atmega1281_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x2f29a5a8, 0x422c3281 }, // optiboot_flash_atmega1281_UART1_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x2f29a5a8, 0xcfee8326 }, // optiboot_flash_atmega1281_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x2f29a5a8, 0x24ae0a4a }, // optiboot_flash_atmega1281_UART1_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0x2f29a5a8, 0xcfc68538 }, // optiboot_flash_atmega1281_UART0_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x82288400 }, // optiboot_flash_atmega6450p_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xe8704cb1 }, // optiboot_flash_atmega6450p_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xb80318bc }, // optiboot_flash_atmega6450p_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x31550abd }, // optiboot_flash_atmega6450p_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x28381b17 }, // optiboot_flash_atmega6450p_UART0_115200_16000000L_B7_BIGBOOT.hex
    {  512, 0, 0x46954df9, 0x54a100b1 }, // optiboot_flash_atmega164p_UART1_38400_8000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0xe5235996 }, // optiboot_flash_atmega164p_UART0_57600_8000000L_B0.hex
    {  512, 0, 0x46954df9, 0xe3a119bb }, // optiboot_flash_atmega164p_UART1_38400_8000000L_B0.hex
    {  512, 0, 0x35e2b5b6, 0x390f2ade }, // optiboot_flash_atmega164p_UART0_57600_8000000L_B7.hex
    {  512, 0, 0x46954df9, 0xe5e526c7 }, // optiboot_flash_atmega164p_UART1_57600_8000000L_B0.hex
    {  512, 0, 0x35e2b5b6, 0xc38c7647 }, // optiboot_flash_atmega164p_UART0_38400_8000000L_B7.hex
    {  512, 0, 0x46954df9, 0xc307e815 }, // optiboot_flash_atmega164p_UART1_57600_8000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0xe3f2c268 }, // optiboot_flash_atmega164p_UART0_38400_8000000L_B0.hex
    {  512, 0, 0x59f8865b, 0xdf955279 }, // optiboot_flash_atmega164p_UART0_9600_1000000L_B0.hex
    {  512, 0, 0x59f8865b, 0x0082b42c }, // optiboot_flash_atmega164p_UART0_9600_1000000L_B7.hex
    {  512, 0, 0x74d076c7, 0xe8287590 }, // optiboot_flash_atmega164p_UART1_9600_1000000L_B0.hex
    {  512, 0, 0x74d076c7, 0xe8bed4e0 }, // optiboot_flash_atmega164p_UART1_9600_1000000L_B7.hex
    {  512, 0, 0x46954df9, 0xb062bbd4 }, // optiboot_flash_atmega164p_UART1_115200_20000000L_B0.hex
    {  512, 0, 0x46954df9, 0x8d570578 }, // optiboot_flash_atmega164p_UART1_115200_20000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0x404b2202 }, // optiboot_flash_atmega164p_UART0_115200_20000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0x65c16403 }, // optiboot_flash_atmega164p_UART0_115200_20000000L_B0.hex
    {  512, 0, 0x35e2b5b6, 0x3e909f95 }, // optiboot_flash_atmega164p_UART0_115200_16000000L_B7.hex
    {  512, 0, 0x35e2b5b6, 0x98798052 }, // optiboot_flash_atmega164p_UART0_115200_16000000L_B0.hex
    {  512, 0, 0x46954df9, 0xe4472d82 }, // optiboot_flash_atmega164p_UART1_115200_16000000L_B0.hex
    {  512, 0, 0x46954df9, 0x6660ce56 }, // optiboot_flash_atmega164p_UART1_115200_16000000L_B7.hex
    { 1024, 1, 0x70394fcf, 0x990b0718 }, // optiboot_flash_atmega1280_UART2_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xedc43871 }, // optiboot_flash_atmega1280_UART2_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xc8c6b978 }, // optiboot_flash_atmega1280_UART3_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x46efca2b }, // optiboot_flash_atmega1280_UART3_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x48da213b }, // optiboot_flash_atmega1280_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x83e33e5a }, // optiboot_flash_atmega1280_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xe8fba5b2 }, // optiboot_flash_atmega1280_UART1_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x32c02cce }, // optiboot_flash_atmega1280_UART1_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x9fb7469b }, // optiboot_flash_atmega1280_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x72d58ca6 }, // optiboot_flash_atmega1280_UART3_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0xe8d4fd48 }, // optiboot_flash_atmega1280_UART2_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x6f4a2030, 0x7e7f2a4f }, // optiboot_flash_atmega1280_UART1_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x5a177a62 }, // optiboot_flash_atmega1280_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x9f55ef91 }, // optiboot_flash_atmega1280_UART3_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x69c6037a }, // optiboot_flash_atmega1280_UART2_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x131b5a3c }, // optiboot_flash_atmega1280_UART1_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x9c8cdeb7 }, // optiboot_flash_atmega1280_UART3_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x337c346c }, // optiboot_flash_atmega1280_UART0_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0x517bae1c }, // optiboot_flash_atmega1280_UART1_115200_16000000L_B7_BIGBOOT.hex
    { 1024, 1, 0x70394fcf, 0xf25fb27c }, // optiboot_flash_atmega1280_UART2_115200_16000000L_B7_BIGBOOT.hex
    {  512, 0, 0x58b9d0f6, 0x0ac150c9 }, // optiboot_flash_atmega329_UART0_38400_8000000L_B5.hex
    {  512, 0, 0x58b9d0f6, 0x27eeb558 }, // optiboot_flash_atmega329_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x203e2338, 0x7a9110b5 }, // optiboot_flash_atmega329_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x58b9d0f6, 0x8d2698e6 }, // optiboot_flash_atmega329_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x58b9d0f6, 0xc77803d4 }, // optiboot_flash_atmega329_UART0_115200_16000000L_B5.hex
    { 1024, 1, 0xae42ebb8, 0xed657349 }, // optiboot_flash_atmega649p_UART0_38400_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xb8d02007 }, // optiboot_flash_atmega649p_UART0_57600_8000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x4f40d9a6 }, // optiboot_flash_atmega649p_UART0_9600_1000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x28f40c94 }, // optiboot_flash_atmega649p_UART0_115200_20000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xe55392cf }, // optiboot_flash_atmega649p_UART0_115200_16000000L_B5_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x82288400 }, // optiboot_flash_atmega6450_UART0_38400_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xe8704cb1 }, // optiboot_flash_atmega6450_UART0_57600_8000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0xb80318bc }, // optiboot_flash_atmega6450_UART0_9600_1000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x31550abd }, // optiboot_flash_atmega6450_UART0_115200_20000000L_B7_BIGBOOT.hex
    { 1024, 1, 0xae42ebb8, 0x28381b17 }, // optiboot_flash_atmega6450_UART0_115200_16000000L_B7_BIGBOOT.hex
    {  512, 0, 0x540e745c, 0x3eacc51c }, // optiboot_flash_atmega165a_UART0_57600_8000000L_B5.hex
    {  512, 0, 0x540e745c, 0x7fd86c1f }, // optiboot_flash_atmega165a_UART0_38400_8000000L_B5.hex
    {  512, 0, 0xfe267731, 0xe57f0c05 }, // optiboot_flash_atmega165a_UART0_9600_1000000L_B5.hex
    {  512, 0, 0x540e745c, 0x68a49c5a }, // optiboot_flash_atmega165a_UART0_115200_20000000L_B5.hex
    {  512, 0, 0x540e745c, 0xd3efd1b5 }, // optiboot_flash_atmega165a_UART0_115200_16000000L_B5.hex

#endif
