/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2.compress;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import yuku.snappy.codec.Snappy;

public class SnappyOutputStream
extends FilterOutputStream {
    public final String TAG = SnappyOutputStream.class.getSimpleName();
    private final Snappy snappy;
    private final int block_size;
    private byte[] uncompressed_buf;
    private byte[] compressed_buf;
    private int uncompressed_offset;
    private int[] compressed_block_sizes = new int[100];
    private int compressed_block_sizes_length = 0;

    public SnappyOutputStream(OutputStream out, int block_size) {
        super(out);
        this.snappy = new Snappy.Factory().newInstance();
        this.block_size = block_size;
        this.uncompressed_buf = new byte[block_size];
        this.compressed_buf = new byte[this.snappy.maxCompressedLength(this.uncompressed_buf.length)];
    }

    @Override
    public void write(int b) throws IOException {
        if (this.uncompressed_offset >= this.block_size) {
            this.dump();
        }
        this.uncompressed_buf[this.uncompressed_offset++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int will_write;
        int src_off = off;
        for (int remaining = len; remaining > 0; remaining -= will_write) {
            int can_write = this.block_size - this.uncompressed_offset;
            will_write = Math.min(remaining, can_write);
            System.arraycopy(b, src_off, this.uncompressed_buf, this.uncompressed_offset, will_write);
            this.uncompressed_offset += will_write;
            src_off += will_write;
            if (this.uncompressed_offset < this.block_size) continue;
            this.dump();
        }
        assert (src_off == off + len);
    }

    private void dump() throws IOException {
        if (this.uncompressed_offset > 0) {
            int compressed_len = this.snappy.compress(this.uncompressed_buf, 0, this.compressed_buf, 0, this.uncompressed_offset);
            this.out.write(this.compressed_buf, 0, compressed_len);
            while (this.compressed_block_sizes_length >= this.compressed_block_sizes.length) {
                int[] newArray = new int[this.compressed_block_sizes.length << 1];
                System.arraycopy(this.compressed_block_sizes, 0, newArray, 0, this.compressed_block_sizes_length);
                this.compressed_block_sizes = newArray;
            }
            this.compressed_block_sizes[this.compressed_block_sizes_length] = compressed_len;
            ++this.compressed_block_sizes_length;
            this.uncompressed_offset = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.dump();
        this.out.flush();
    }

    public int[] getCompressedBlockSizes() {
        int[] res = new int[this.compressed_block_sizes_length];
        System.arraycopy(this.compressed_block_sizes, 0, res, 0, this.compressed_block_sizes_length);
        return res;
    }
}

