/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.dff;

import com.kreative.dff.DFFResource;
import com.kreative.dff.DFFResourceAlreadyExistsException;
import com.kreative.dff.DFFResourceProvider;
import com.kreative.dff.DFFResourceTooBigException;
import com.kreative.ksfl.KSFLUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DFFResourceCollection
extends DFFResourceProvider
implements Map<Long, Map<Integer, DFFResource>> {
    private Map<Long, Map<Integer, DFFResource>> map = new HashMap<Long, Map<Integer, DFFResource>>();

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public synchronized boolean add(DFFResource r) throws DFFResourceAlreadyExistsException {
        if (this.map.containsKey(r.type) && this.map.get(r.type).containsKey(r.id)) {
            throw new DFFResourceAlreadyExistsException();
        }
        if (this.map.containsKey(r.type)) {
            this.map.get(r.type).put(r.id, r.deepCopy());
        } else {
            HashMap<Integer, DFFResource> nmap = new HashMap<Integer, DFFResource>();
            nmap.put(r.id, r.deepCopy());
            this.map.put(r.type, nmap);
        }
        return true;
    }

    @Override
    public synchronized boolean contains(long type, int id) {
        return this.map.containsKey(type) && this.map.get(type).containsKey(id);
    }

    @Override
    public synchronized boolean contains(long type, String name) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private DFFResource find(long type, int id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get(type).get(id);
        }
        return null;
    }

    private DFFResource find(long type, String name) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return r;
            }
        }
        return null;
    }

    @Override
    public synchronized DFFResource get(long type, int id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get(type).get(id).deepCopy();
        }
        return null;
    }

    @Override
    public synchronized DFFResource get(long type, String name) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return r.deepCopy();
            }
        }
        return null;
    }

    @Override
    public synchronized DFFResource getAttributes(long type, int id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            DFFResource r = this.map.get(type).get(id);
            return new DFFResource(r.type, r.id, r.datatype, r.getAttributes(), r.name, new byte[0]);
        }
        return null;
    }

    @Override
    public synchronized DFFResource getAttributes(long type, String name) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return new DFFResource(r.type, r.id, r.datatype, r.getAttributes(), r.name, new byte[0]);
            }
        }
        return null;
    }

    @Override
    public synchronized long getLength(long type, int id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get((Object)Long.valueOf((long)type)).get((Object)Integer.valueOf((int)id)).data.length;
        }
        return 0L;
    }

    @Override
    public synchronized long getLength(long type, String name) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return r.data.length;
            }
        }
        return 0L;
    }

    @Override
    public synchronized byte[] getData(long type, int id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return KSFLUtilities.copy(this.map.get((Object)Long.valueOf((long)type)).get((Object)Integer.valueOf((int)id)).data);
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(long type, String name) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return KSFLUtilities.copy(r.data);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int read(long type, int id, long doffset, byte[] data, int off, int len) {
        written = 0;
        try {
            r = this.find(type, id);
            if (r == null) {
                return 0;
            }
            d = r.data;
            if (d == null) {
                return 0;
            }
            while (written < len && off < data.length && doffset < (long)d.length) {
                data[off] = d[(int)doffset];
                ++off;
                ++doffset;
                ++written;
            }
            if (true) ** GOTO lbl23
        }
        catch (Exception var10_9) {
            // empty catch block
        }
        return written;
        do {
            data[off] = 0;
            ++off;
            ++written;
lbl23:
            // 2 sources

            if (written >= len) return written;
        } while (off < data.length);
        return written;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int read(long type, String name, long doffset, byte[] data, int off, int len) {
        written = 0;
        try {
            r = this.find(type, name);
            if (r == null) {
                return 0;
            }
            d = r.data;
            if (d == null) {
                return 0;
            }
            while (written < len && off < data.length && doffset < (long)d.length) {
                data[off] = d[(int)doffset];
                ++off;
                ++doffset;
                ++written;
            }
            if (true) ** GOTO lbl23
        }
        catch (Exception var10_9) {
            // empty catch block
        }
        return written;
        do {
            data[off] = 0;
            ++off;
            ++written;
lbl23:
            // 2 sources

            if (written >= len) return written;
        } while (off < data.length);
        return written;
    }

    @Override
    public synchronized boolean remove(long type, int id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            this.map.get(type).remove(id);
            if (this.map.get(type).isEmpty()) {
                this.map.remove(type);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(long type, String name) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                this.map.get(type).remove(r);
                if (this.map.get(type).isEmpty()) {
                    this.map.remove(type);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean set(long type, int id, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        DFFResource o = this.find(type, id);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new DFFResourceAlreadyExistsException();
        }
        return this.remove(type, id) && this.add(r);
    }

    @Override
    public synchronized boolean set(long type, String name, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (!this.contains(type, name)) {
            return false;
        }
        DFFResource o = this.find(type, name);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new DFFResourceAlreadyExistsException();
        }
        return this.remove(type, name) && this.add(r);
    }

    @Override
    public synchronized boolean setAttributes(long type, int id, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        DFFResource o = this.find(type, id);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new DFFResourceAlreadyExistsException();
        }
        r = r.deepCopy();
        r.data = o.data;
        return this.remove(type, id) && this.add(r);
    }

    @Override
    public synchronized boolean setAttributes(long type, String name, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (!this.contains(type, name)) {
            return false;
        }
        DFFResource o = this.find(type, name);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new DFFResourceAlreadyExistsException();
        }
        r = r.deepCopy();
        r.data = o.data;
        return this.remove(type, name) && this.add(r);
    }

    @Override
    public synchronized boolean setLength(long type, int id, long len) {
        if (len > Integer.MAX_VALUE) {
            throw new DFFResourceTooBigException();
        }
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            DFFResource r = this.map.get(type).get(id);
            r.data = KSFLUtilities.resize(r.data, (int)len);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean setLength(long type, String name, long len) {
        if (len > Integer.MAX_VALUE) {
            throw new DFFResourceTooBigException();
        }
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                r.data = KSFLUtilities.resize(r.data, (int)len);
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setData(long type, int id, byte[] data) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            this.map.get((Object)Long.valueOf((long)type)).get((Object)Integer.valueOf((int)id)).data = KSFLUtilities.copy(data);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean setData(long type, String name, byte[] data) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                r.data = KSFLUtilities.copy(data);
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int write(long type, int id, long doffset, byte[] data, int off, int len) {
        if (doffset + (long)len > Integer.MAX_VALUE) {
            throw new DFFResourceTooBigException();
        }
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            DFFResource r = this.map.get(type).get(id);
            int written = 0;
            try {
                if (doffset + (long)len > (long)r.data.length) {
                    r.data = KSFLUtilities.resize(r.data, (int)(doffset + (long)len));
                }
                while (written < len && off < data.length && doffset < (long)r.data.length) {
                    r.data[(int)doffset] = data[off];
                    ++off;
                    ++doffset;
                    ++written;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return written;
        }
        return 0;
    }

    @Override
    public synchronized int write(long type, String name, long doffset, byte[] data, int off, int len) {
        if (doffset + (long)len > Integer.MAX_VALUE) {
            throw new DFFResourceTooBigException();
        }
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                int written = 0;
                try {
                    if (doffset + (long)len > (long)r.data.length) {
                        r.data = KSFLUtilities.resize(r.data, (int)(doffset + (long)len));
                    }
                    while (written < len && off < data.length && doffset < (long)r.data.length) {
                        r.data[(int)doffset] = data[off];
                        ++off;
                        ++doffset;
                        ++written;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return written;
            }
        }
        return 0;
    }

    @Override
    public synchronized int getTypeCount() {
        return this.map.size();
    }

    @Override
    public synchronized long getType(int index) {
        return this.map.keySet().toArray(new Long[0])[index];
    }

    @Override
    public synchronized long[] getTypes() {
        Long[] types = this.map.keySet().toArray(new Long[0]);
        long[] types2 = new long[types.length];
        int i = 0;
        while (i < types.length) {
            types2[i] = types[i];
            ++i;
        }
        return types2;
    }

    @Override
    public synchronized int getResourceCount(long type) {
        if (this.map.containsKey(type)) {
            return this.map.get(type).size();
        }
        return 0;
    }

    @Override
    public synchronized int getID(long type, int index) {
        if (this.map.containsKey(type)) {
            return this.map.get(type).keySet().toArray(new Integer[0])[index];
        }
        return 0;
    }

    @Override
    public synchronized int[] getIDs(long type) {
        if (this.map.containsKey(type)) {
            Integer[] ids = this.map.get(type).keySet().toArray(new Integer[0]);
            int[] ids2 = new int[ids.length];
            int i = 0;
            while (i < ids.length) {
                ids2[i] = ids[i];
                ++i;
            }
            return ids2;
        }
        return new int[0];
    }

    @Override
    public synchronized String getName(long type, int index) {
        if (this.map.containsKey(type)) {
            int id = this.map.get(type).keySet().toArray(new Integer[0])[index];
            return this.getNameFromID(type, id);
        }
        return "";
    }

    @Override
    public synchronized String[] getNames(long type) {
        if (this.map.containsKey(type)) {
            Integer[] ids = this.map.get(type).keySet().toArray(new Integer[0]);
            String[] names = new String[ids.length];
            int i = 0;
            while (i < ids.length) {
                names[i] = this.getNameFromID(type, ids[i]);
                ++i;
            }
            return names;
        }
        return new String[0];
    }

    @Override
    public synchronized int getNextAvailableID(long type, int start) {
        if (this.map.containsKey(type)) {
            while (this.map.get(type).containsKey(start)) {
                ++start;
            }
        }
        return start;
    }

    @Override
    public synchronized String getNameFromID(long type, int id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get((Object)Long.valueOf((long)type)).get((Object)Integer.valueOf((int)id)).name;
        }
        return "";
    }

    @Override
    public synchronized int getIDFromName(long type, String name) {
        if (this.map.containsKey(type)) {
            for (DFFResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return r.id;
            }
        }
        return 0;
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public synchronized Set<Map.Entry<Long, Map<Integer, DFFResource>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public synchronized Map<Integer, DFFResource> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized Set<Long> keySet() {
        return this.map.keySet();
    }

    @Override
    public synchronized Map<Integer, DFFResource> put(Long key, Map<Integer, DFFResource> value) {
        return this.map.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Long, ? extends Map<Integer, DFFResource>> t) {
        this.map.putAll(t);
    }

    @Override
    public synchronized Map<Integer, DFFResource> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized Collection<Map<Integer, DFFResource>> values() {
        return this.map.values();
    }
}

