//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Model/RealTreeModel.h
//! @brief     Defines class RealTreeModel
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_MODEL_REALTREEMODEL_H
#define BORNAGAIN_GUI_MODEL_MODEL_REALTREEMODEL_H

#include <QAbstractItemModel>
#include <QSet>

class RealModel;
class RealItem;

//! Tree model for real data item selection. Used for the tree in the import view.
class RealTreeModel : public QAbstractItemModel {
    Q_OBJECT
public:
    explicit RealTreeModel(QObject* parent, RealModel* model);
    void setVisibleRanks(QSet<int> visibleRanks);

    QModelIndex index(int row, int column,
                      const QModelIndex& parent = QModelIndex()) const override;

    QModelIndex parent(const QModelIndex& index) const override;
    int columnCount(const QModelIndex& parent = QModelIndex()) const override;
    int rowCount(const QModelIndex& parent = QModelIndex()) const override;
    QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const override;
    Qt::ItemFlags flags(const QModelIndex& index) const override;
    bool setData(const QModelIndex& index, const QVariant& value, int role) override;
    RealItem* itemForIndex(const QModelIndex& index) const;
    QModelIndex indexForItem(RealItem* item) const;

    void refreshAfterModelChange();

    void removeDataItem(RealItem* item);
    RealItem* injectDataItem(int rank);

    //! The topmost visible item. Can be null of course.
    RealItem* topMostItem() const;

    QModelIndex indexOfHeadline(int rank) const;
    bool isHeadline(const QModelIndex& index) const;

private:
    void updateSubscriptions();
    void onContentsProcessed(RealItem* item);

private:
    RealModel* m_model = nullptr;
    QVector<RealItem*> m_items[2]; //< Items borrowed from realModel. Never delete the ptrs!
    QSet<int> m_visibleRanks;
};

#endif // BORNAGAIN_GUI_MODEL_MODEL_REALTREEMODEL_H
