//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/ParticleItem.h
//! @brief     Defines class ParticleItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_PARTICLEITEM_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_PARTICLEITEM_H

#include "GUI/Model/Descriptor/SelectionProperty.h"
#include "GUI/Model/Sample/FormFactorItemCatalog.h"
#include "GUI/Model/Sample/FormFactorItems.h"
#include "GUI/Model/Sample/ItemWithMaterial.h"
#include "GUI/Model/Sample/ItemWithParticles.h"
#include <memory>

class Particle;

class ParticleItem : public ItemWithMaterial, public ItemWithParticles {
public:
    ParticleItem(const MaterialModel* materials);

    void writeTo(QXmlStreamWriter* w) const override;
    void readFrom(QXmlStreamReader* r) override;

    std::unique_ptr<Particle> createParticle() const;

    template <typename T>
    T* setFormFactorItemType();
    void setFormFactor(FormFactorItem* p);
    FormFactorItem* formFactorItem() const;
    QVector<ItemWithParticles*> containedItemsWithParticles() const override;

    bool isExpandParticle() const { return m_expandParticle; }
    void setExpandParticle(bool b) { m_expandParticle = b; }

private:
    SelectionProperty<FormFactorItemCatalog> m_formFactor;
    bool m_expandParticle = true;
};

template <typename T>
T* ParticleItem::setFormFactorItemType()
{
    T* p = new T();
    setFormFactor(p);
    return p;
}

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_PARTICLEITEM_H
