//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Project/PyImportAssistant.h
//! @brief     Implements class PyImportAssistant
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PROJECT_PYIMPORTASSISTANT_H
#define BORNAGAIN_GUI_VIEW_PROJECT_PYIMPORTASSISTANT_H

#ifdef BORNAGAIN_PYTHON

#include <memory>

class SampleItem;
class MultiLayer;

//! Assists in importing Python object to GUI models.

namespace PyImportAssistant {

//! Show select-file dialog, try to import via python, return created sample.
//!
//! If sth. went wrong, a dialog has presented already and nullptr is returned.
std::unique_ptr<MultiLayer> importMultiLayer();

//! Populates GUI sample with domain sample.
SampleItem* itemizeSample(const MultiLayer& sample);

} // namespace PyImportAssistant

#endif // BORNAGAIN_PYTHON

#endif // BORNAGAIN_GUI_VIEW_PROJECT_PYIMPORTASSISTANT_H
