/* bzflag
 * Copyright (c) 1993-2025 Tim Riker
 *
 * This package is free software;  you can redistribute it and/or
 * modify it under the terms of the license found in the file
 * named COPYING that should have accompanied this file.
 *
 * THIS PACKAGE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* BaseBuilding:
 *  Encapsulates a base in the game environment
 */

#ifndef BZF_BASE_BUILDING_H
#define BZF_BASE_BUILDING_H

#include "BoxBuilding.h"

class BaseBuilding : public BoxBuilding
{

    friend class ObstacleModifier;

public:
    BaseBuilding();
    BaseBuilding(const float *pos, float rotation,
                 const float *size, int _team, bool ricochet);
    ~BaseBuilding();

    Obstacle*   copyWithTransform(const MeshTransform&) const;

    const char*     getType() const;
    static const char*  getClassName(); // const

    bool        inCylinder(const float* p, float radius, float height) const;
    bool        inMovingBox(const float* oldP, float oldAngle,
                            const float *newP, float newAngle,
                            float halfWidth, float halfBreadth, float height) const;
    bool        isCrossing(const float* p, float angle,
                           float halfWidth, float halfBreadth, float height,
                           float* plane) const;

    int         getTeam() const;

    int packSize() const;
    void *pack(void*) const;
    const void *unpack(const void*);

    void print(std::ostream& out, const std::string& indent) const;
    void printOBJ(std::ostream& out, const std::string& indent) const;

    std::string     userTextures[2];

private:
    static const char*  typeName;
    int team;
};

#endif

// Local Variables: ***
// mode: C++ ***
// tab-width: 4 ***
// c-basic-offset: 4 ***
// indent-tabs-mode: nil ***
// End: ***
// ex: shiftwidth=4 tabstop=4
